<?php
/** Adminer - Compact database management
* @link https://www.adminer.org/
* @author Jakub Vrana, https://www.vrana.cz/
* @copyright 2007 Jakub Vrana
* @license https://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
* @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License, version 2 (one or other)
* @version 5.4.0
*/namespace
Adminer;const
VERSION="5.4.0";error_reporting(24575);set_error_handler(function($rc,$tc){return!!preg_match('~^Undefined (array key|offset|index)~',$tc);},E_WARNING|E_NOTICE);$Nc=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($Nc||ini_get("filter.default_flags")){foreach(array('_GET','_POST','_COOKIE','_SERVER')as$X){$vi=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($vi)$$X=$vi;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");function
connection($g=null){return($g?:Db::$instance);}function
adminer(){return
Adminer::$instance;}function
driver(){return
Driver::$instance;}function
connect(){$wb=adminer()->credentials();$L=Driver::connect($wb[0],$wb[1],$wb[2]);return(is_object($L)?$L:null);}function
idf_unescape($v){if(!preg_match('~^[`\'"[]~',$v))return$v;$me=substr($v,-1);return
str_replace($me.$me,$me,substr($v,1,-1));}function
q($zh){return
connection()->quote($zh);}function
escape_string($X){return
substr(q($X),1,-1);}function
idx($ta,$y,$k=null){return($ta&&array_key_exists($y,$ta)?$ta[$y]:$k);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes(array$sg,$Nc=false){if(function_exists("get_magic_quotes_gpc")&&get_magic_quotes_gpc()){while(list($y,$X)=each($sg)){foreach($X
as$ee=>$W){unset($sg[$y][$ee]);if(is_array($W)){$sg[$y][stripslashes($ee)]=$W;$sg[]=&$sg[$y][stripslashes($ee)];}else$sg[$y][stripslashes($ee)]=($Nc?$W:stripslashes($W));}}}}function
bracket_escape($v,$Aa=false){static$ii=array(':'=>':1',']'=>':2','['=>':3','"'=>':4');return
strtr($v,($Aa?array_flip($ii):$ii));}function
min_version($Ji,$_e="",$g=null){$g=connection($g);$eh=$g->server_info;if($_e&&preg_match('~([\d.]+)-MariaDB~',$eh,$B)){$eh=$B[1];$Ji=$_e;}return$Ji&&version_compare($eh,$Ji)>=0;}function
charset(Db$f){return(min_version("5.5.3",0,$f)?"utf8mb4":"utf8");}function
ini_bool($Nd){$X=ini_get($Nd);return(preg_match('~^(on|true|yes)$~i',$X)||(int)$X);}function
sid(){static$L;if($L===null)$L=(SID&&!($_COOKIE&&ini_bool("session.use_cookies")));return$L;}function
set_password($Ii,$P,$V,$H){$_SESSION["pwds"][$Ii][$P][$V]=($_COOKIE["adminer_key"]&&is_string($H)?array(encrypt_string($H,$_COOKIE["adminer_key"])):$H);}function
get_password(){$L=get_session("pwds");if(is_array($L))$L=($_COOKIE["adminer_key"]?decrypt_string($L[0],$_COOKIE["adminer_key"]):false);return$L;}function
get_val($J,$m=0,$mb=null){$mb=connection($mb);$K=$mb->query($J);if(!is_object($K))return
false;$M=$K->fetch_row();return($M?$M[$m]:false);}function
get_vals($J,$c=0){$L=array();$K=connection()->query($J);if(is_object($K)){while($M=$K->fetch_row())$L[]=$M[$c];}return$L;}function
get_key_vals($J,$g=null,$hh=true){$g=connection($g);$L=array();$K=$g->query($J);if(is_object($K)){while($M=$K->fetch_row()){if($hh)$L[$M[0]]=$M[1];else$L[]=$M[0];}}return$L;}function
get_rows($J,$g=null,$l="<p class='error'>"){$mb=connection($g);$L=array();$K=$mb->query($J);if(is_object($K)){while($M=$K->fetch_assoc())$L[]=$M;}elseif(!$K&&!$g&&$l&&(defined('Adminer\PAGE_HEADER')||$l=="-- "))echo$l.error()."\n";return$L;}function
unique_array($M,array$x){foreach($x
as$w){if(preg_match("~PRIMARY|UNIQUE~",$w["type"])){$L=array();foreach($w["columns"]as$y){if(!isset($M[$y]))continue
2;$L[$y]=$M[$y];}return$L;}}}function
escape_key($y){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$y,$B))return$B[1].idf_escape(idf_unescape($B[2])).$B[3];return
idf_escape($y);}function
where(array$Z,array$n=array()){$L=array();foreach((array)$Z["where"]as$y=>$X){$y=bracket_escape($y,true);$c=escape_key($y);$m=idx($n,$y,array());$Kc=$m["type"];$L[]=$c.(JUSH=="sql"&&$Kc=="json"?" = CAST(".q($X)." AS JSON)":(JUSH=="pgsql"&&preg_match('~^json~',$Kc)?"::jsonb = ".q($X)."::jsonb":(JUSH=="sql"&&is_numeric($X)&&preg_match('~\.~',$X)?" LIKE ".q($X):(JUSH=="mssql"&&strpos($Kc,"datetime")===false?" LIKE ".q(preg_replace('~[_%[]~','[\0]',$X)):" = ".unconvert_field($m,q($X))))));if(JUSH=="sql"&&preg_match('~char|text~',$Kc)&&preg_match("~[^ -@]~",$X))$L[]="$c = ".q($X)." COLLATE ".charset(connection())."_bin";}foreach((array)$Z["null"]as$y)$L[]=escape_key($y)." IS NULL";return
implode(" AND ",$L);}function
where_check($X,array$n=array()){parse_str($X,$Sa);remove_slashes(array(&$Sa));return
where($Sa,$n);}function
where_link($t,$c,$Y,$uf="="){return"&where%5B$t%5D%5Bcol%5D=".urlencode($c)."&where%5B$t%5D%5Bop%5D=".urlencode(($Y!==null?$uf:"IS NULL"))."&where%5B$t%5D%5Bval%5D=".urlencode($Y);}function
convert_fields(array$d,array$n,array$O=array()){$L="";foreach($d
as$y=>$X){if($O&&!in_array(idf_escape($y),$O))continue;$ua=convert_field($n[$y]);if($ua)$L
.=", $ua AS ".idf_escape($y);}return$L;}function
cookie($D,$Y,$ue=2592000){header("Set-Cookie: $D=".urlencode($Y).($ue?"; expires=".gmdate("D, d M Y H:i:s",time()+$ue)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).(HTTPS?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
get_settings($sb){parse_str($_COOKIE[$sb],$ih);return$ih;}function
get_setting($y,$sb="adminer_settings",$k=null){return
idx(get_settings($sb),$y,$k);}function
save_settings(array$ih,$sb="adminer_settings"){$Y=http_build_query($ih+get_settings($sb));cookie($sb,$Y);$_COOKIE[$sb]=$Y;}function
restart_session(){if(!ini_bool("session.use_cookies")&&(!function_exists('session_status')||session_status()==1))session_start();}function
stop_session($Sc=false){$Ci=ini_bool("session.use_cookies");if(!$Ci||$Sc){session_write_close();if($Ci&&@ini_set("session.use_cookies",'0')===false)session_start();}}function&get_session($y){return$_SESSION[$y][DRIVER][SERVER][$_GET["username"]];}function
set_session($y,$X){$_SESSION[$y][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($Ii,$P,$V,$j=null){$zi=remove_from_uri(implode("|",array_keys(SqlDriver::$drivers))."|username|ext|".($j!==null?"db|":"").($Ii=='mssql'||$Ii=='pgsql'?"":"ns|").session_name());preg_match('~([^?]*)\??(.*)~',$zi,$B);return"$B[1]?".(sid()?SID."&":"").($Ii!="server"||$P!=""?urlencode($Ii)."=".urlencode($P)."&":"").($_GET["ext"]?"ext=".urlencode($_GET["ext"])."&":"")."username=".urlencode($V).($j!=""?"&db=".urlencode($j):"").($B[2]?"&$B[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
redirect($A,$C=null){if($C!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($A!==null?$A:$_SERVER["REQUEST_URI"]))][]=$C;}if($A!==null){if($A=="")$A=".";header("Location: $A");exit;}}function
query_redirect($J,$A,$C,$_g=true,$yc=true,$Gc=false,$Vh=""){if($yc){$vh=microtime(true);$Gc=!connection()->query($J);$Vh=format_time($vh);}$qh=($J?adminer()->messageQuery($J,$Vh,$Gc):"");if($Gc){adminer()->error
.=error().$qh.script("messagesPrint();")."<br>";return
false;}if($_g)redirect($A,$C.$qh);return
true;}class
Queries{static$queries=array();static$start=0;}function
queries($J){if(!Queries::$start)Queries::$start=microtime(true);Queries::$queries[]=(preg_match('~;$~',$J)?"DELIMITER ;;\n$J;\nDELIMITER ":$J).";";return
connection()->query($J);}function
apply_queries($J,array$T,$uc='Adminer\table'){foreach($T
as$R){if(!queries("$J ".$uc($R)))return
false;}return
true;}function
queries_redirect($A,$C,$_g){$vg=implode("\n",Queries::$queries);$Vh=format_time(Queries::$start);return
query_redirect($vg,$A,$C,$_g,false,!$_g,$Vh);}function
format_time($vh){return
lang(0,max(0,microtime(true)-$vh));}function
relative_uri(){return
str_replace(":","%3a",preg_replace('~^[^?]*/([^?]*)~','\1',$_SERVER["REQUEST_URI"]));}function
remove_from_uri($Nf=""){return
substr(preg_replace("~(?<=[?&])($Nf".(SID?"":"|".session_name()).")=[^&]*&~",'',relative_uri()."&"),0,-1);}function
get_file($y,$Hb=false,$Nb=""){$Mc=$_FILES[$y];if(!$Mc)return
null;foreach($Mc
as$y=>$X)$Mc[$y]=(array)$X;$L='';foreach($Mc["error"]as$y=>$l){if($l)return$l;$D=$Mc["name"][$y];$di=$Mc["tmp_name"][$y];$ob=file_get_contents($Hb&&preg_match('~\.gz$~',$D)?"compress.zlib://$di":$di);if($Hb){$vh=substr($ob,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$vh))$ob=iconv("utf-16","utf-8",$ob);elseif($vh=="\xEF\xBB\xBF")$ob=substr($ob,3);}$L
.=$ob;if($Nb)$L
.=(preg_match("($Nb\\s*\$)",$ob)?"":$Nb)."\n\n";}return$L;}function
upload_error($l){$Ie=($l==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($l?lang(1).($Ie?" ".lang(2,$Ie):""):lang(3));}function
repeat_pattern($Zf,$se){return
str_repeat("$Zf{0,65535}",$se/65535)."$Zf{0,".($se%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
format_number($X){return
strtr(number_format($X,0,".",lang(4)),preg_split('~~u',lang(5),-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~\W~i','-',$X);}function
table_status1($R,$Hc=false){$L=table_status($R,$Hc);return($L?reset($L):array("Name"=>$R));}function
column_foreign_keys($R){$L=array();foreach(adminer()->foreignKeys($R)as$p){foreach($p["source"]as$X)$L[$X][]=$p;}return$L;}function
fields_from_edit(){$L=array();foreach((array)$_POST["field_keys"]as$y=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$y];$_POST["fields"][$X]=$_POST["field_vals"][$y];}}foreach((array)$_POST["fields"]as$y=>$X){$D=bracket_escape($y,true);$L[$D]=array("field"=>$D,"privileges"=>array("insert"=>1,"update"=>1,"where"=>1,"order"=>1),"null"=>1,"auto_increment"=>($y==driver()->primary),);}return$L;}function
dump_headers($zd,$We=false){$L=adminer()->dumpHeaders($zd,$We);$Kf=$_POST["output"];if($Kf!="text")header("Content-Disposition: attachment; filename=".adminer()->dumpFilename($zd).".$L".($Kf!="file"&&preg_match('~^[0-9a-z]+$~',$Kf)?".$Kf":""));session_write_close();if(!ob_get_level())ob_start(null,4096);ob_flush();flush();return$L;}function
dump_csv(array$M){foreach($M
as$y=>$X){if(preg_match('~["\n,;\t]|^0|\.\d*0$~',$X)||$X==="")$M[$y]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$M)."\r\n";}function
apply_sql_function($r,$c){return($r?($r=="unixepoch"?"DATETIME($c, '$r')":($r=="count distinct"?"COUNT(DISTINCT ":strtoupper("$r("))."$c)"):$c);}function
get_temp_dir(){$L=ini_get("upload_tmp_dir");if(!$L){if(function_exists('sys_get_temp_dir'))$L=sys_get_temp_dir();else{$o=@tempnam("","");if(!$o)return'';$L=dirname($o);unlink($o);}}return$L;}function
file_open_lock($o){if(is_link($o))return;$q=@fopen($o,"c+");if(!$q)return;@chmod($o,0660);if(!flock($q,LOCK_EX)){fclose($q);return;}return$q;}function
file_write_unlock($q,$Bb){rewind($q);fwrite($q,$Bb);ftruncate($q,strlen($Bb));file_unlock($q);}function
file_unlock($q){flock($q,LOCK_UN);fclose($q);}function
first(array$ta){return
reset($ta);}function
password_file($h){$o=get_temp_dir()."/adminer.key";if(!$h&&!file_exists($o))return'';$q=file_open_lock($o);if(!$q)return'';$L=stream_get_contents($q);if(!$L){$L=rand_string();file_write_unlock($q,$L);}else
file_unlock($q);return$L;}function
rand_string(){return
md5(uniqid(strval(mt_rand()),true));}function
select_value($X,$_,array$m,$Uh){if(is_array($X)){$L="";foreach($X
as$ee=>$W)$L
.="<tr>".($X!=array_values($X)?"<th>".h($ee):"")."<td>".select_value($W,$_,$m,$Uh);return"<table>$L</table>";}if(!$_)$_=adminer()->selectLink($X,$m);if($_===null){if(is_mail($X))$_="mailto:$X";if(is_url($X))$_=$X;}$L=adminer()->editVal($X,$m);if($L!==null){if(!is_utf8($L))$L="\0";elseif($Uh!=""&&is_shortable($m))$L=shorten_utf8($L,max(0,+$Uh));else$L=h($L);}return
adminer()->selectVal($L,$_,$m,$X);}function
is_blob(array$m){return
preg_match('~blob|bytea|raw|file~',$m["type"])&&!in_array($m["type"],idx(driver()->structuredTypes(),lang(6),array()));}function
is_mail($hc){$va='[-a-z0-9!#$%&\'*+/=?^_`{|}~]';$Wb='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';$Zf="$va+(\\.$va+)*@($Wb?\\.)+$Wb";return
is_string($hc)&&preg_match("(^$Zf(,\\s*$Zf)*\$)i",$hc);}function
is_url($zh){$Wb='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';return
preg_match("~^(https?)://($Wb?\\.)+$Wb(:\\d+)?(/.*)?(\\?.*)?(#.*)?\$~i",$zh);}function
is_shortable(array$m){return
preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea|hstore~',$m["type"]);}function
host_port($P){return(preg_match('~^(\[(.+)]|([^:]+)):([^:]+)$~',$P,$B)?array($B[2].$B[3],$B[4]):array($P,''));}function
count_rows($R,array$Z,$Xd,array$s){$J=" FROM ".table($R).($Z?" WHERE ".implode(" AND ",$Z):"");return($Xd&&(JUSH=="sql"||count($s)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$s).")$J":"SELECT COUNT(*)".($Xd?" FROM (SELECT 1$J GROUP BY ".implode(", ",$s).") x":$J));}function
slow_query($J){$j=adminer()->database();$Wh=adminer()->queryTimeout();$mh=driver()->slowQuery($J,$Wh);$g=null;if(!$mh&&support("kill")){$g=connect();if($g&&($j==""||$g->select_db($j))){$ge=get_val(connection_id(),0,$g);echo
script("const timeout = setTimeout(() => { ajax('".js_escape(ME)."script=kill', function () {}, 'kill=$ge&token=".get_token()."'); }, 1000 * $Wh);");}}ob_flush();flush();$L=@get_key_vals(($mh?:$J),$g,false);if($g){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$L;}function
get_token(){$yg=rand(1,1e6);return($yg^$_SESSION["token"]).":$yg";}function
verify_token(){list($ei,$yg)=explode(":",$_POST["token"]);return($yg^$_SESSION["token"])==$ei;}function
lzw_decompress($Ga){$Sb=256;$Ha=8;$ab=array();$Jg=0;$Kg=0;for($t=0;$t<strlen($Ga);$t++){$Jg=($Jg<<8)+ord($Ga[$t]);$Kg+=8;if($Kg>=$Ha){$Kg-=$Ha;$ab[]=$Jg>>$Kg;$Jg&=(1<<$Kg)-1;$Sb++;if($Sb>>$Ha)$Ha++;}}$Rb=range("\0","\xFF");$L="";$Si="";foreach($ab
as$t=>$Za){$gc=$Rb[$Za];if(!isset($gc))$gc=$Si.$Si[0];$L
.=$gc;if($t)$Rb[]=$Si.$gc[0];$Si=$gc;}return$L;}function
script($oh,$hi="\n"){return"<script".nonce().">$oh</script>$hi";}function
script_src($_i,$Kb=false){return"<script src='".h($_i)."'".nonce().($Kb?" defer":"")."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
input_hidden($D,$Y=""){return"<input type='hidden' name='".h($D)."' value='".h($Y)."'>\n";}function
input_token(){return
input_hidden("token",get_token());}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($zh){return
str_replace("\0","&#0;",htmlspecialchars($zh,ENT_QUOTES,'utf-8'));}function
nl_br($zh){return
str_replace("\n","<br>",$zh);}function
checkbox($D,$Y,$Ua,$ie="",$tf="",$Ya="",$ke=""){$L="<input type='checkbox' name='$D' value='".h($Y)."'".($Ua?" checked":"").($ke?" aria-labelledby='$ke'":"").">".($tf?script("qsl('input').onclick = function () { $tf };",""):"");return($ie!=""||$Ya?"<label".($Ya?" class='$Ya'":"").">$L".h($ie)."</label>":$L);}function
optionlist($xf,$Zg=null,$Di=false){$L="";foreach($xf
as$ee=>$W){$yf=array($ee=>$W);if(is_array($W)){$L
.='<optgroup label="'.h($ee).'">';$yf=$W;}foreach($yf
as$y=>$X)$L
.='<option'.($Di||is_string($y)?' value="'.h($y).'"':'').($Zg!==null&&($Di||is_string($y)?(string)$y:$X)===$Zg?' selected':'').'>'.h($X);if(is_array($W))$L
.='</optgroup>';}return$L;}function
html_select($D,array$xf,$Y="",$sf="",$ke=""){static$ie=0;$je="";if(!$ke&&substr($xf[""],0,1)=="("){$ie++;$ke="label-$ie";$je="<option value='' id='$ke'>".h($xf[""]);unset($xf[""]);}return"<select name='".h($D)."'".($ke?" aria-labelledby='$ke'":"").">".$je.optionlist($xf,$Y)."</select>".($sf?script("qsl('select').onchange = function () { $sf };",""):"");}function
html_radios($D,array$xf,$Y="",$dh=""){$L="";foreach($xf
as$y=>$X)$L
.="<label><input type='radio' name='".h($D)."' value='".h($y)."'".($y==$Y?" checked":"").">".h($X)."</label>$dh";return$L;}function
confirm($C="",$ah="qsl('input')"){return
script("$ah.onclick = () => confirm('".($C?js_escape($C):lang(7))."');","");}function
print_fieldset($u,$re,$Mi=false){echo"<fieldset><legend>","<a href='#fieldset-$u'>$re</a>",script("qsl('a').onclick = partial(toggle, 'fieldset-$u');",""),"</legend>","<div id='fieldset-$u'".($Mi?"":" class='hidden'").">\n";}function
bold($Ja,$Ya=""){return($Ja?" class='active $Ya'":($Ya?" class='$Ya'":""));}function
js_escape($zh){return
addcslashes($zh,"\r\n'\\/");}function
pagination($F,$zb){return" ".($F==$zb?$F+1:'<a href="'.h(remove_from_uri("page").($F?"&page=$F".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($F+1)."</a>");}function
hidden_fields(array$sg,array$Bd=array(),$lg=''){$L=false;foreach($sg
as$y=>$X){if(!in_array($y,$Bd)){if(is_array($X))hidden_fields($X,array(),$y);else{$L=true;echo
input_hidden(($lg?$lg."[$y]":$y),$X);}}}return$L;}function
hidden_fields_get(){echo(sid()?input_hidden(session_name(),session_id()):''),(SERVER!==null?input_hidden(DRIVER,SERVER):""),input_hidden("username",$_GET["username"]);}function
enum_input($U,$wa,array$m,$Y,$kc=""){preg_match_all("~'((?:[^']|'')*)'~",$m["length"],$Be);$lg=($m["type"]=="enum"?"val-":"");$Ua=(is_array($Y)?in_array("null",$Y):$Y===null);$L=($m["null"]&&$lg?"<label><input type='$U'$wa value='null'".($Ua?" checked":"")."><i>$kc</i></label>":"");foreach($Be[1]as$X){$X=stripcslashes(str_replace("''","'",$X));$Ua=(is_array($Y)?in_array($lg.$X,$Y):$Y===$X);$L
.=" <label><input type='$U'$wa value='".h($lg.$X)."'".($Ua?' checked':'').'>'.h(adminer()->editVal($X,$m)).'</label>';}return$L;}function
input(array$m,$Y,$r,$_a=false){$D=h(bracket_escape($m["field"]));echo"<td class='function'>";if(is_array($Y)&&!$r){$Y=json_encode($Y,128|64|256);$r="json";}$Ig=(JUSH=="mssql"&&$m["auto_increment"]);if($Ig&&!$_POST["save"])$r=null;$bd=(isset($_GET["select"])||$Ig?array("orig"=>lang(8)):array())+adminer()->editFunctions($m);$qc=driver()->enumLength($m);if($qc){$m["type"]="enum";$m["length"]=$qc;}$Tb=stripos($m["default"],"GENERATED ALWAYS AS ")===0?" disabled=''":"";$wa=" name='fields[$D]".($m["type"]=="enum"||$m["type"]=="set"?"[]":"")."'$Tb".($_a?" autofocus":"");echo
driver()->unconvertFunction($m)." ";$R=$_GET["edit"]?:$_GET["select"];if($m["type"]=="enum")echo
h($bd[""])."<td>".adminer()->editInput($R,$m,$wa,$Y);else{$nd=(in_array($r,$bd)||isset($bd[$r]));echo(count($bd)>1?"<select name='function[$D]'$Tb>".optionlist($bd,$r===null||$nd?$r:"")."</select>".on_help("event.target.value.replace(/^SQL\$/, '')",1).script("qsl('select').onchange = functionChange;",""):h(reset($bd))).'<td>';$Pd=adminer()->editInput($R,$m,$wa,$Y);if($Pd!="")echo$Pd;elseif(preg_match('~bool~',$m["type"]))echo"<input type='hidden'$wa value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$wa value='1'>";elseif($m["type"]=="set")echo
enum_input("checkbox",$wa,$m,(is_string($Y)?explode(",",$Y):$Y));elseif(is_blob($m)&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$D'>";elseif($r=="json"||preg_match('~^jsonb?$~',$m["type"]))echo"<textarea$wa cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';elseif(($Th=preg_match('~text|lob|memo~i',$m["type"]))||preg_match("~\n~",$Y)){if($Th&&JUSH!="sqlite")$wa
.=" cols='50' rows='12'";else{$N=min(12,substr_count($Y,"\n")+1);$wa
.=" cols='30' rows='$N'";}echo"<textarea$wa>".h($Y).'</textarea>';}else{$qi=driver()->types();$Ke=(!preg_match('~int~',$m["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$m["length"],$B)?((preg_match("~binary~",$m["type"])?2:1)*$B[1]+($B[3]?1:0)+($B[2]&&!$m["unsigned"]?1:0)):($qi[$m["type"]]?$qi[$m["type"]]+($m["unsigned"]?0:1):0));if(JUSH=='sql'&&min_version(5.6)&&preg_match('~time~',$m["type"]))$Ke+=7;echo"<input".((!$nd||$r==="")&&preg_match('~(?<!o)int(?!er)~',$m["type"])&&!preg_match('~\[\]~',$m["full_type"])?" type='number'":"")." value='".h($Y)."'".($Ke?" data-maxlength='$Ke'":"").(preg_match('~char|binary~',$m["type"])&&$Ke>20?" size='".($Ke>99?60:40)."'":"")."$wa>";}echo
adminer()->editHint($R,$m,$Y);$Oc=0;foreach($bd
as$y=>$X){if($y===""||!$X)break;$Oc++;}if($Oc&&count($bd)>1)echo
script("qsl('td').oninput = partial(skipOriginal, $Oc);");}}function
process_input(array$m){if(stripos($m["default"],"GENERATED ALWAYS AS ")===0)return;$v=bracket_escape($m["field"]);$r=idx($_POST["function"],$v);$Y=idx($_POST["fields"],$v);if($m["type"]=="enum"||driver()->enumLength($m)){$Y=$Y[0];if($Y=="orig")return
false;if($Y=="null")return"NULL";$Y=substr($Y,4);}if($m["auto_increment"]&&$Y=="")return
null;if($r=="orig")return(preg_match('~^CURRENT_TIMESTAMP~i',$m["on_update"])?idf_escape($m["field"]):false);if($r=="NULL")return"NULL";if($m["type"]=="set")$Y=implode(",",(array)$Y);if($r=="json"){$r="";$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(is_blob($m)&&ini_bool("file_uploads")){$Mc=get_file("fields-$v");if(!is_string($Mc))return
false;return
driver()->quoteBinary($Mc);}return
adminer()->processInput($m,$Y,$r);}function
search_tables(){$_GET["where"][0]["val"]=$_POST["query"];$ch="<ul>\n";foreach(table_status('',true)as$R=>$S){$D=adminer()->tableName($S);if(isset($S["Engine"])&&$D!=""&&(!$_POST["tables"]||in_array($R,$_POST["tables"]))){$K=connection()->query("SELECT".limit("1 FROM ".table($R)," WHERE ".implode(" AND ",adminer()->selectSearchProcess(fields($R),array())),1));if(!$K||$K->fetch_row()){$og="<a href='".h(ME."select=".urlencode($R)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]))."'>$D</a>";echo"$ch<li>".($K?$og:"<p class='error'>$og: ".error())."\n";$ch="";}}}echo($ch?"<p class='message'>".lang(9):"</ul>")."\n";}function
on_help($fb,$kh=0){return
script("mixin(qsl('select, input'), {onmouseover: function (event) { helpMouseover.call(this, event, $fb, $kh) }, onmouseout: helpMouseout});","");}function
edit_form($R,array$n,$M,$yi,$l=''){$Hh=adminer()->tableName(table_status1($R,true));page_header(($yi?lang(10):lang(11)),$l,array("select"=>array($R,$Hh)),$Hh);adminer()->editRowPrint($R,$n,$M,$yi);if($M===false){echo"<p class='error'>".lang(12)."\n";return;}echo"<form action='' method='post' enctype='multipart/form-data' id='form'>\n";if(!$n)echo"<p class='error'>".lang(13)."\n";else{echo"<table class='layout'>".script("qsl('table').onkeydown = editingKeydown;");$_a=!$_POST;foreach($n
as$D=>$m){echo"<tr><th>".adminer()->fieldName($m);$k=idx($_GET["set"],bracket_escape($D));if($k===null){$k=$m["default"];if($m["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$k,$Gg))$k=$Gg[1];if(JUSH=="sql"&&preg_match('~binary~',$m["type"]))$k=bin2hex($k);}$Y=($M!==null?($M[$D]!=""&&JUSH=="sql"&&preg_match("~enum|set~",$m["type"])&&is_array($M[$D])?implode(",",$M[$D]):(is_bool($M[$D])?+$M[$D]:$M[$D])):(!$yi&&$m["auto_increment"]?"":(isset($_GET["select"])?false:$k)));if(!$_POST["save"]&&is_string($Y))$Y=adminer()->editVal($Y,$m);$r=($_POST["save"]?idx($_POST["function"],$D,""):($yi&&preg_match('~^CURRENT_TIMESTAMP~i',$m["on_update"])?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(!$_POST&&!$yi&&$Y==$m["default"]&&preg_match('~^[\w.]+\(~',$Y))$r="SQL";if(preg_match("~time~",$m["type"])&&preg_match('~^CURRENT_TIMESTAMP~i',$Y)){$Y="";$r="now";}if($m["type"]=="uuid"&&$Y=="uuid()"){$Y="";$r="uuid";}if($_a!==false)$_a=($m["auto_increment"]||$r=="now"||$r=="uuid"?null:true);input($m,$Y,$r,$_a);if($_a)$_a=false;echo"\n";}if(!support("table")&&!fields($R))echo"<tr>"."<th><input name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",adminer()->editFunctions(array("null"=>isset($_GET["select"]))))."<td><input name='field_vals[]'>"."\n";echo"</table>\n";}echo"<p>\n";if($n){echo"<input type='submit' value='".lang(14)."'>\n";if(!isset($_GET["select"]))echo"<input type='submit' name='insert' value='".($yi?lang(15):lang(16))."' title='Ctrl+Shift+Enter'>\n",($yi?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".lang(17)."…', this); };"):"");}echo($yi?"<input type='submit' name='delete' value='".lang(18)."'>".confirm()."\n":"");if(isset($_GET["select"]))hidden_fields(array("check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]));echo
input_hidden("referer",(isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"])),input_hidden("save",1),input_token(),"</form>\n";}function
shorten_utf8($zh,$se=80,$Ch=""){if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$se).")($)?)u",$zh,$B))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$se).")($)?)",$zh,$B);return
h($B[1]).$Ch.(isset($B[2])?"":"<i>…</i>");}function
icon($yd,$D,$xd,$Yh){return"<button type='submit' name='$D' title='".h($Yh)."' class='icon icon-$yd'><span>$xd</span></button>";}if(isset($_GET["file"])){if(substr(VERSION,-4)!='-dev'){if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){header("HTTP/1.1 304 Not Modified");exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");}@ini_set("zlib.output_compression",'1');if($_GET["file"]=="default.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("h:Mhgб\"PimcQCa	2ód<fa:;NBqR;1Lf9u7&)l;3J/CQXr2Mai0)e:LuÝh-923li7mZw4њ<-̴!U,Févt2S,a҇FVXaNq)-ǜh:n59Y;j-_9krٓ;.tTqo0{y\rHnGSZh;i^uxWΒC@k=b/A0+(l\\x:\rb8\00!\0F\nB͎(3\r\\Ȅa'I|(i\n\r4Og@4C@@!QB	°c¯q,\r1Eh&2PZiGH9G\"v4rDR\npJ-A|/.cDu:,=R]U5mVkLLQ@-\\@9%SrMPDIa\r(YY\\@Xp:plLC O,\r2]7?m06pTaҥC;_˗yȴd>bnnܣ3X8\r[ˀ-)i>V[Yy&L3#X|	X\\ù`C#H22.#Z`<sÒ\0uh־M_\niZeO/CӒ_`31>=k3R/;/d\0ڵm7/AXq.sL :\$Fw8߾~Hj\"Գ7gSFLίQ_O'W]c=51X~7;i\r*\nJS1ZctAV86fdy;Y]zIpc3Y]}@\$.+1'>ZcpdGL#k8PzYAuv]s9_Aq:\nKhB;XbAHq,CI`jS[ˌ1Vr;pB)#鐉;4H/*<3L;lf\ns\$K`}Ք7jx`d%j]4YHbYJ`GG.KfI)2MfָXRC̱V,~g\0g6:[j1H:AlIqu3\"q|8<9s'Q]J|\0`pjfObq\$1J>RH(ǔq\n#r@e(yVJ0Q҈6P[C:G伞4^PZ\\(\n)~9R%Sj{70_s	z|8H	\"@#9DVL\$H5WJ@zaJ ^	)2\nQv]j (ABB056b˰][kAwvkgƴ+k[jmzc}MyDZi\$5eʷ	ACY%.Wb*뮼.q/%}BXZV337ʻawW[LQ޲_2`1Ii,曣Mf&(s-Aİ*DwTNɻjX\$x+;F93JkS;qR{>l;B1AIb)(6r\r\rڇZR^SOy/M#9{kv\"KCJrEo\0\\,|fa͚hI/o4k^p1H^phǡVvox@`g&(;~Ǎz68*5EpӘ3ņgrDL)4g{峩L&>脻Z7\0̊@ffRVh֝Iۈrw)=x^,k2ݓjbl0u\"fp1RIz[]wpN6dIzn.7X{;3-I	7pjÝR#,_-[>3\\WqqJ֘uhFbLKyVľѕVf{K}SޝM̀.M\\ixb1+α?<3~H\$\\2\$ e6tÖ\$sxxCnSkV=z6'æNaָhR噣8gw:_ҒIRKÝ.nkVU+dwj%`#,{醳Y(oվ.c0gDXOk7Klhx;؏ ݃L\$09*9 hNrM.>\0rP9\$g	\0\$\\F*d'L:b429@Hnb-E #ĜrPY t \n5.\$oplX\n@`\r	\r  	 	@@\n  	\0j@Q@1\r@ 	\$p	 V\0``\n\0\n \n@'\n\0`\r	\r\0r	\0`	{	,\"^P0\n4\n0.0p\rp\rppqQ0%1Q8\n \0kȼ\0^\0`@>\no1w,Y	h*=P:іVи.q\r\rp1Q	1 `/17\r^\"y`\n #\0	 p\n\n` r Qb13\n##1\$q\$ѱ%0%q%&&q &'1\rR}16	 @b\r``\r	d	j\n``\n`dcсP,1R\$rIO 	Q	Y32b1&01  f\0\0f\0j\nf`	 \n`@\$n=`\0v nI\$P(d'g6--C7R 	4-1&2t\r\"\n 	H*@	`\n  	l2,z\r~ \rFthmz~\0]GF\\I\\}ItC\nT}IEJ\rx>MpIH~fht.bxYEiKoj\nLtr.~dH2U4G\\A4uPt谐L/P	\"G!RMtO-<#APuIR\$cDƊ-GO`Pv^W@tH;QRę\$gKF<\rR*\$4'[IUmh:+5@/lI2^\0OD\rR'\rTЭ[ĪMCMZ4E B\"`euN,䙬]t\r`@h*\r.V%!MBlPF\"&/@v\\C:mMgni8I2\rpvj+Z mTuefv>fИ`DU[ZTVCT\rUvk^Lb/KSev2ubvOVDIm\$%X?ud!W|,\r+cnUeZʖ-~XBGd\$iMv!t#L3oUIOu?ZweRcw.`ȡi\rb%bH\"\"\"h_\$b@z\0f\"rW*B|\$\$Bנ\"@r(\r` C(0&.`Nk9B\n&#(@䂯d^ @`I-{0\nB{4sG{;zb{ {bׯ){BxKŇ5=cڪy&JPrI/ \0V\r׉=N\\ئ=K}XVxإˋxdՊی*H'δ{X==\08\0[ɫJtOeɋ\rDXŇ}z)y''яI([l(5`f\\`e.lY(=zה!Y%hO+`ٙ\"e ėKߚ#SEIY.HJtG`HJ55~ 6ChXDz\nxyshFKczjZY8(%|yIߑ؃eYXu i]cM;ȧ>ǡQT [~W~c݂zz\r:  \0rYx)!ɡK+z!ӀC+ٮï:ݎZg~z4f	:sӪ+x%=GIf3?+Yq@GyoѴp\r~{W[y:\0\\;eۡYI\"zdkZ|[uu+׹9qnR ˮBׁz|\rᤄk^[1%.pA2<=ء\$;5)m!XXYx5vT\\Q%:>ɛ;e|/yWxנ|gC\\<9z\\#.FV;8NX7\"8&d5P4Gj?\0?\"=HER");}elseif($_GET["file"]=="dark.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("h:Mhgh0LЁd91S!	F!\"-6NbdGg:;Nr)c7\r(Hb81s9k\rc)m8OVAc1c34Of*-P1r416d2ցo#3Bf#	g9Φ،fc\rIb6EC&,bum7aVs#m!hrv\\3\rL:SAdk5naF3e6fSyr!L-K,3L@J˲*J쵣	bc99@H8\\6>`Ŏ;A<T'p&qqE4\rlh<5#pR #I%fBIܲ>ʫ29<Cj27j8jc(n?(a\0@5*3:δ60-AlLP4@ɰ\$H4n311t0͙9WO!rH9Q96F<7\r-xC\n @:\$iضm4Kid{\n6\rxhˋ#^'4V@a<#h0S-c9+pa2cyhBO\$9wiXɔVY9*rHtm	@b|@/l\$z+%p2l.7;&{mXC<l96x9m7R0\\4P)AoxqO#f[;6~P\raTGT0uޟ\n3\\ \\ʎJudCGPZ>d8ҨC?VdLL.(ti>,֜R+9iޞC\$#\"AChVb\n6T2ew\nf6m	!1'c;*eLRn\rG\$2S\$0a'l6&~Ad\$J\$s ȃB4j.RC̔Qj\"7\nXs!6=BȀ}");}elseif($_GET["file"]=="functions.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("':̢i11	4Q6a&:OAIe:NFD|!Cym2\"r<̱/C#:DbqSeJ˦Cܺ\n\nǱS\rZH\$RAܞS+XKvtdg:6EvXŞjmҩej2MB&ʮLC3Q0L-x\nDyNaPn:s͐(cL/(5{Qy4g-i4ڃf(bUko7&ä*ACb`.\r\nCh<\r)`إ`7CʒZX<Q1X@0dp9EQfF\r!(h)\np'#ČH(i*r&<#7K~# A:N6l,\rJP3!@2>CrhN](a0M326UE2'!<#3R<XCH7#n+a\$!2P0.wdr:YE!]<j@\\pl_\rZғTͩZs3\"~9jP)QYbݕDYc`zcѨ'#tBOh*2<ŒOfg-Z#8a^+r2b\\~0Wnp!#`Z612@ky9\rB3pޅ6<!pG9no6s#F3bA69Z#6%?s\"|؂)bJc\rNsih8ݟ:;HތuI5@1APaH^\$Hv@ÛL~b9'S?P-0C\nRm4ȓ:Ը24h(k\njI6\"EY#Wr\rG8@tXԓBS\nc0kC I\rʰ<u`A!)2C\0= P1ӢK!!pIs,6di1+k<^	\n20Fԉ_\$)f\0C8E^/3W!א)u*&\$2Y\n]EkDV\$JxTse!RY R`=Lޫ\nl_.!V!\r\nHk\$א`{1	|i<jRrPTG|w4b\r4d,E6<h[Nq@Oi>'ѩ\r;]#}0ASIJdA/Q⸵@t\rUG_G<<y-Iz򄤝\"PB\0q`vAa̡JRʮ)JB.TLyCpp\0(7cYYaM1em4crS)opC!ISb0m(dEH߳X/PyX85\$+֖gdyϝJ lEur,dCX}em]2̽(-zZ;I\\) ,\n>)\rVS\njx*w`ⴷSFid,ZJFM}Њ \\ZP`zZE]dɟOcmԁ] %\"w4\n\$zVSQD:6GwMS0B-s)Zc|^RE8kMsdka)h%\"P0nn/#;g\rd8F<3\$,P);<4`<2\n@w-͗A0LrYhXCa>tL2yto;2Qtfrm:AAN\\\"k5oVɃ=t7r1pAv\\+9{^(if=rut]yޅCgivf+Ø|;]~|\re쿓݂'	\0+Wcow6wd Suj3@0!\n .wm[8x<cM\n9'a1>[dux<\"YcB!iw}5Uk]{IךR=f W~](bea'ubm>)\$P-6R*IGu#ƕUKAXt(`_\"p &UI]YG6P]Ar!b *ЙJoӯv*!~_4B_~RBiK`&J\0N\0\$CK SjZ0pvMJbN`Le/`RO.0P82`	d GxbP-(@ɸ@4H%<&Zp%\0pЄ		/\"J\ns_\rg`!kpX	:v6p\$'RUeZd\$\nLB.dntm>vj)	M\r\0.ʊH\"5*!eZJf(dc(xjg\0\\ Z@|`^r)<()@Ykml3Qyс@ѐfPnTNmRqVmvN֍|ШZȆ(Yp\"4Ǩ&%lP`ĀXx bbdr0Fr5<Cz6he!\rdzK;t\n͠HƋQ\$QEnnn\r#T\$ˈ(ȟѩ|c,-#\rJ{dE\n\$BriT+2PEDBe}&%Rf\n^CZZ RVA,;<\0O1c^\r%\r `n\0y1.\rĂK1M3H\r\"0\0NkXPr{3 }	\nSdڗx.ZRTwS;53 .s4sO3F2S~YFpZs'@ّOqR4\n6q6@Dh67vEl\"^;-(&b**.! \r!#x'G\"͆w\" 2!\"R(vX|\"Dv)@,zmAwT@  \nЫhдIDP\$m>\r&`>4A#*#<w\$T{\$4@dӴRem6-#Dd%EDT\\\$)@WC(t\"M#@TF\r,g\rP8~֣JcĹƂ ʎ\"LZ\r+P4=STA)0\"CDhM\n%Fp|fLNlFtDmH5=H\nļ4\$K6\rbZ\r\"pEQ%wJV0M%l\"hPFAA㌮/G6h6]5\$fSCLiRT?RCHUZYbF/.Z\"\"^y6RG n܌\$\\&O(v^ KUѮam(\r\$_%+KTt.ٖ36\nc:@6 jPAQF/Sk\"<4AgAaU\$'fQO\"k~S;.:k9e]`n-7;+V8W2HUYlBv⯎Ԇ	plm\04B)X\0QqFSq4nFx+pESovGW7owKRW\r4`|cqe7,19uucq\"LCth)\rJ\\W@	|D#S\r%5l!%++^k^ʙ`/7(z*񘋀E{S(W-Xė0V0=a	~fB˕2Qru mCtr(\0Q!K;xNW?b<@`X,`0eƂN'&~tu\"| i B 7R lSu8AdF%(?3@A-oQź@|~K^@xb~D@سTNZC	Wix<\0P|\n\0\n`\"&?st|ïw%mduN^8[t9B\$'\">U~98ÔFf u/)9\0Az\"FWAx\$'jG(\" s%THe,	M7b ǅa ˓ƃ&wYφ3 /\rϖ{\"ݜp{%4b`팤~nE3	93XdՏZ9'@lfQbP*Go`8AB|z	@	bZn_h'ѢF\$f`HdDdH%4\rsAjLR'f9g I,R\\>\nH[\"\rӁL,%FLl8gzL<0ko\$k`KPv@d'V:VM%@6<\rTLENԀS#.[x4a̭LL\n@\0۫tٲ\n^F5` R7lLu(d \rBf/uCf4cҞ B_nL\0 \$aYƦ~Ukve˥˲\0ZaZXأ|Cq/<}سú Z*w\nOz`518cIQ2YsK\n\\\" ðc*B.R1<3+*S[4m쭛:RhITdevIH-Zw\\%n56\nWi\$ōow+r&Jq+}Djd?U%BBe/MNm=τUb\$HRfwb|x d2NiSg@q@>Sv|krx\0{R=F#r8	Zv8*ʳ{2S+;SӨ+yL\$\"_B8\"E%\npp''pwUҪ\"8бI\\ @ʾ LnR#MDqLN\n\\̎\$`~@`\0u~^@l-{5,@bruo[}/y. {6qRp\$+13+O!D)\nu<,=Jd+}d#0ɞc3U3EY\rtj5ҥ7ewׄǡ^q߂9<\$}kRI-+'_Ne?SRhd*X4c}\"@vi>;5>Dn \r)bNuP@YG<6i#PB2A-0d0+gK?nddOci<0\0\\gꡖNTi';imj܈uJ+V~'ol`\",F	{CT aNEۃQp p+?\n>'l* tKάp(YC\n-q̔0\"*ɕ,#7\"%+qB=i.@x7:%GcYI0*Ðkۈ\\Q_{#\r{H[p >7chn.S|&JMǾ8mOh	qJ&aݢ'.bOp\$D@CHB	&ݡ|\$Ԭ-6++ pଡAC\rɓ/0MiZnE͢j*>!Ңu%g0@5}r+3%-mG<T;0DVdg9'lMH F@PuntFB%Mt'G2@2<e;`=LX2X}oc.L+xӎ&DaɫF2\ngLE.\\xSLx;lwD=0_QV,a 5+L+|\$ijZ\nDE,Bt\\'H0R~(\\\":n*(o1wQrEteF\$Sђ]\rLyF\\Bihhd&ᚇh;foB-y`0JlPxao\$Xq,(C*	:/HG\"cCQ\nFԄ#8F:У\0OkD])ϚtT8L𒨔n`|HJ  \"6{?=I<HGc ŤF@,C @j\$L(nEʑPjbnΑW \rLqsPHꉝz\\V\$kҏtr5,l<'\0^S020f -5\"ac\"3Up\"ܘ%\0'Zt\"969_ @Z{0IDZE@Nh`\"`\0ɹ(GHCh If`@ZD\$)K;Z\0/CT>r_R@O`1rTҨIb\0*8h\$_pRĕ\$Ni^ʪP/O).ŹT6\\ٔ@Trą`)T=n\02e+9ʢ\\@>PH1	y#r<aeK/cM@_.\09ˈB0ia\ndea%|S2#nD\$/+Ed_2P\$s,ok#<	Ađr{BA-Q4Ҥ\n\ry!b䱎O@ɬk \"r*݇Y/ȑ a0%.gE~& 89#@M_ 7K䃸J`X)B\$(	:gn*|M6PZHtJtqCx[ڼl=\nU3f\\̔JP	,:}TASYH(\nIٲ!t(2U\"\\X^s	a!\nPr`X3fnbJ&zzQSf t!T?9%(QB}6BkP\0>g&~fhUr, p5HipqɚgVVOgWEJ80Gak@N NMUUxȪSx		K@c1yVlϠC2Q^rP6|I^M,j%d`ܫF\\#%|C7싢GTNiHQOCyB\$%T*>z\rMM Kp J7O۷4%\$p4͂EҪ\"T\0O\0@>	rO]x}^I@ źqn0BbȵI(M/;}RN\nC<bPԵu?=PeCL^'S?}4)S-1\r5SOESFAOR+ޙ+v5&C)ِKSDB߳N|E\rcUYʾV?H)実+sFkLPW-,U:&t{VoJl'We74Xn GF'`Cc%Ilju6vUZ\0*Nԟ#(n-;|4]Xy';Z) s9%R+\$	Q(\"_kX\nM#\"!p~:*\$3O6+\nB{1|HK<[`3#F@ǐ! |؊\0>[nrMM+mO_2Ȇ\0e^	7Z&BJ褓h7QO%rfp΁֞mبÇ4El+ViN SZWt2W[;v\"%\$^-(I\$S@R-&Tzk(	%R8uY\0[9-()E8=^G5#)1Vb\r]Ne;&Y`rIPݱֲ\0@P70H؍Rx\0000C|n=`TT\rEhON'&tcK ܕU5P3\\2\"\0y5V]6>U!@hu(\"E%07B6dHNij';@eMzlSfjKY֍-uhHsmL@\"rjj'l7	(uuEea@+K:ӕ%nzV;[_Vz_E8<Sb6g:c7\n%Q K7ܮBwu50֚yncnKT8ʙsW=+=K\n_[pGC5'D\"M<\":|Mq4fsx	qlͰQPaOYE=6nT떒BthC\0p@nD(aP\"'ZN۬\rLNXg<!w[B))~cxvi¦qa@K7sEQdýk?\"3-\"U||21D>߳]­&\\hTƳ5\0`Tzs -N\"fNLU]n(D(&%\"e\\ONInۿ\0ƕ@V|RMYCTbUHp)Ss qi`Z5vt坉*OO\n(F58!ax@{^P?eh}\\j^2L,6.N	K%uip!?l -5wK\"V\\Is2!\$45v\ngrN};W%D(pWa\0v'6Vƿ0WE4EUl8LDE<kOHDU	`vSL!DTMbnWVCd)Ze蟀:2d8Kބ4-Gb;wQW30\rf\0,`Qhl֍0P0h@\\r8T⛜1`&wX>F?|P*MqZѯ}0k`#իc'[ֱˍ|sIJ\r<OaƼ@WuT:E^!ka\$>5u_KcCQr-ъ'\riC@8SPS_Xgl%	n1r.<w_aɺĳGh4\nWZaBn,\\\0DU\nbbZ'72r¢}Y>/w\\Y`^7JjSS.o%Jg\0GD,>7R036%i\0S^LA\riO<a phv[{\0E^xܼgYzWyGa:(>Ce\0])3yts_a7+BCeTfoP2ECv>wlz*pYqQp\nv[|qҨE[Xi=z(	Mn]7F\rCs4|-} Ŀ(NU?,څq	pq~ F%88靦\$ް[ro!3(gץpJ!qZv?cL76\$mq8l!5C;Q,dsF-OfÈ\$6%UCf\"e(j\rMtFRx;nB\$SSx'G陊M	4ͬ'k~#9eY~뭈;f+jK9pM'X/rt\0\\J%QR\rвO3|寚ϱ4xFs5EԐ;ԒWRJXʶJ\$wzO&ǵzkS\n\nNUP.0bdkP	G6+Bz1ΎhQ>sHvQ٠EpM)\n\\ўPz.s g)a~ȥ!(!Ghr[*բ`~\"!O5G3Ş*qkgB,\$**1c.n	8\$dVSneMiZ7žgA5\n`,2aүmMkʻɯ/-6@?#`)Ԁha)Vc]_=Rz\\VR=ط(-ot\$ܥ\ndSmyfөN\rm(t;Dp2ݶZRl)9M̛,/Yixkя).2@S^ud6!>VB x<Kt06@\nGAP(NbDK\n\"cN\ră.p'2Ldꟲ\\LyA=	Dm3%@8qbSP\"ޢƮ/DzC&O\0007fD^1X/,\nvWx%f)' DdQ@I(ҋ7Y|AQDڠe 8ׇ7k)_ @\"\"%}	(11؍\re?-ɵH&\rL'eۮ0T]C!emNz	UzɈSܜaf7M^CD(_#\"dr5981hfȭa_×tZX\0U{2nn];FR!}>sHiy#?\"Ť>{/?7FY?Aj.U!5`H\$r\0'\n\":.dԂٙƪqRխoh>{1+>tk%-D=9}C@8cmHrWn\0Ď<(RR8YV`pp.Ue_`^쵛n^_R|r΅p7/!M5|\n&FVVzOA~ш|ƛ4NȒՔgyh-\nN\"r\"GcsD'Xo٧O{{Y{E=TeZ{\";HXztw*-Uw-\"<A^OT ]D?:<pq[,)&`{xKII``c0Dy8qCY]W7uECWư5ya`7=f9sv[N?uj'׏ߋʜ̲~\nQ`\n]< WhG\0R*-AF- xDz;y\$wUG\0ڄq^{#AȠ͘&Bx)m)cXzSz8Ѧ+KSK?#	ޝm7ujThOZ{Wޮ:Kd[/W7e\$̥K?,b㳐A\r>R\\0\0i5&&1'8.\n\$\"Rvo y\$ذN#M\ro,8Y\"J7FB*bDcS.J׿ٟYFBk\"H˻K9!\nIl2G@8!)Ď7#d,5A1PƉݫONz\r\0m6'4	O?c=ْ@LY3\"iuޭ:KBe;\0w\">FA˫'B@@zoP\0]\0rOjo~ulQ|u7,?h0\0b/!˄/V_&cwp9\"&gߐА\0LyS6H`O\00 O-?'g@/\0_w6%|PN*>Q\"*\"k\0S0wO6cDDGp	3`Ai2>Bi2\0f/6@qȿP3*\$P*O:o@\\\r0dP!hM txI  ?D\nw<P-~Caˀ¸)E4+Eb>d\$<`o>h?8bn/.oIV,Ac3Xa o*xi\"椌\0U:DOY}\n\r\0,OrYb[Jp2ДjBO\$|Ca4`\\*4bAߤ_X\$@6\n\0\$~ˣ`Jb݅ UpXR\"ێlgt' +x̐N51e`Aq\"O- 	C!Қmɵ*f@6ZЛ9ZRǁ	HZL eN29| T n?X\$0\0002	y!e :\$QssAnxKw\n*'Nz!p'Fn6>-\n )\$k\n@QB&4\0u\n`B*e.BB{ȩ@	0uCy\"*0d PszU|61A(ǞA-3e>/\"(mF' ");}elseif($_GET["file"]=="jush.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("v0F==FS	_6MƳr:ECIo:CXc\r؄J(:=Ea28x?'iSANNxsNBVl0S	Ul(D|҄P>E㩶yHch-3Eb bpEp9.~\n?Kbiw|`d.x8EN!23\rYy6GFmY8o7\n\r0<d4E'\n#\r.C!^t(bqH.s2Nq٤9#{c3nӸ2r:<+9CȨ\n<\r`/b\\!H2SڙF#8ЈI78K*ں!鎑+:+&2|:9:A,Iv4ǢꆌP-\nҸ%>(c(P74c8X`X:\r3 KIAHHs\"N8R0HY5GDW(3Ut  P9MVd?4\rCPbؼ2*b3T`nVMsb0]pG%n\\E]8ߋh7E`@PIjVTz\rC+R8\r\0aRؾ70l_2dYAxPZA@yART o^CK~c⊰{}cZ.~!`@C.ޒ.y\nl9wt\\C\$pըp8/媤eyn_H!fwZ%hc5~[H{\$\n\r!4nn6͊cHJ.6|`ӛ;.ް[pWݪ>\\hWZO7PxApUW)!/pi[~X\nR\$8?BEy!cPC5.\nH]=y*\$st`57a\r\05j-g\0ͤ#oA\"p;\nH<m!dÙK>+d=p)pP	#|<)70-(ek9HE9.N䔒J hL>e<ۿC`KxVA aPA9WIy4WjpWdER2ip#)CD?ruxs|ϸAX+?l<H&T#|РQb -\$}Ah:t0PD9!9SmHi\ro}ƪP_Eaxfu{Ӳv<)/#QC*ܪ\0rNirtGNow>MӼ DJCv``Na@](U S5{=9N8z3^<		Xc\n=@s3&ꚠdAj%\ry\\{<#	UgR`^K4l!t{\0W&|-U/7yUCXR6uHVu|IV\nq<鼇*p)&Nq/Rل\nV	83<;}_ph\r ӊpt9#%<2id3Rs\nkOf9pA\n9  IYCc,U2^\00\$NqsJ+d*@1:ukΆ!4;@zZ&d\n3\$ݠC]QBVwp.K\\άԌ\$9i<2Zp:a`US3|T!&P,c=0=Nd뛭6nZyiTTJweSu'nm틸In\r;ݔ*)Ai1yQ\r_8?՞76l1ǽ{cvr{\\.,ۼevkۛe~L^7\n@.s8t}ɘ8C-ѻ-4IdO{sջ8[˵f;}Qs^ݹQ2[(@\nL\n)(Aa\" 	&P@O\n師0(M&}'! 0{6}kʘ@;px6zg|+D+ϤyJL#}~*/}4|Aw<wOX\0~\rڏޏZ*\nϧ\0v0 */hD?O\rnBPFo0\\`0fkrOHphxpq֐PTbOPį8揢POo.0·\0\r	PEK͙\rP)\roTv \rDܯoMA(XhCL&\"h\r,N^qKkb\"	}qy\"R`\0n+\rnqHHL\0V%F: ؎\$\rf鬶јjBmQmG\\蕱nk%\"Vdk@ !2+6% ~Ğ% r.R[ 2?\"̹#\0Ԁw\$U%#!%)\$	\$LmA-W{@ܷ#_&x]\$S'\0\rg@m0`df`G&L\0':xjx*оDL(q,&lNt*\n	 %f(оkZ	%in\".Ļ氮~\0U@d4'r\rn#`2H g6&v'\rrS^\$@Xf>΃k6r7`\\	5V'W5\rdTb@E2`P( B'0/w␑s&r.SVsє9JJx&8v!`z4\$k\0x7pI өA9;\r~4>~'\nPs0PQA+/7`WOG1Fp暴\n|\0PGGtI\"TiGO@FV~G荔2\$%96,7LLSoLhP5ʼУ\0P\r\$=%nUjXUkϋN\0\r)F*h@kB5\$56Lbs|Mo8+8\":G4ONS5#j\"NncJtT%(DUS]Mj\$TK`5o@rYSNR1ER\rEXrNJ7bgTUxM5*0r:3		2i1QkF0YZstec\n:oHFExu#4S#	 	\$t?E(p(R\"|eBX8	4>\r/<\0E,^D.E{5a܆*\rZg|~\r:moc9Jv*B7rT&nlHPV6mDw)m\rCVw\$uSwS`ADLS6qk)Jkl'LhB9h Jimn<\0  <\0[:\0K(~s\0K̒Y'ʈgaO(]v:&!`PxV^wnĹ7\0&g|B\0(*,ľ²d7⛬tzwz\nE\",\0\"fb\$B(h(4ժ5b?΍wq|@Ƙ+؁޶&Ɋ~NⴎחN6<uFxWQ^^;P.#/|Wȃ8k./7K/wQl8~Qψ\\1\\&\"ئWR/)|A5reE@k\0OwK&f\"'Lml@ۄPZ7\r#ox`]b̄NzZ@0NR,x[Pc8zX\r?Ǎ?92x}LF'LPyzð\\ƙǌT ŤiNǀTx%xaucw#l,\"Pb*g#Zud,5\$D3]؛?h~0\nyN7bz\0a5qkpvQ,D[A\\EyKyP#UZk&)E9q\"7![QMd۔uQJ#\$o]jۥgO\nXD6꣢eXZ:E:OUbz]7sDc0`?\\S{ySihzEiij&׫e'kXy f6V-ZWewŊ;G\${SK7	1n>@izzw9{x;\0\nIyk[7{޻8-~w,[lȌ@ϷVԘ+Ӌؿjcؤ\\qǊY'zYݻ˜?aA:Q٭(} \ny#Sy\0[?/]My{ˣ9=PϫOLs\\sWDػ˱|7jN-E˕+`uƼ\rM}~I~iڴ|lv}YL1l>\r9,oY9}Sgg銼:u)ÈCR%~|~w0]|\\yϙy\\ج7йe,mu7(T],wθfU=TRW6<Kֽg;||1\0Qy\"9vb\$5mwΆo\r\0xbkH|ɚ Z\rhWʜ\\Ա.3U\r˽ؘ\r>?2)᩟/=50@ƅH~<нx_/˾3~I+~l~HY{Y^]^ae^h^r+>CbB,2/LR#mRKIK'픕EW1]Fz_]T%4̔\0V=4;\$T 枍{?לּԞ3n\rz X?cp\n?#adX\n:z-^X!`:\0y,DlJ`A)hU+5+~_+<b]<m5~']')ެܺ/Pr4o{_ngHFpBsH1)bb?톼\"[C<U~<0y:G@}脬z޺w)}[ꖞ<8&X\"`BWw{kU.E;=pQɢR)t\0;Լ*JC^ d,+d-~*xpn@A?Qh{䄳'A5P{dX`H+sSkX/E(3=!004\rjłZa>m4?og3xƕJW\$EQ^&\nQEhjqCNƠ,yHβ\$'@\n;\0\\]ϛв(\n6arǩuP/;P#q1\nPB.6`\nFٰ͒W3dbZU֜=xa@=fZ;Bk謀mJNg^prٲ(Ilcp*AOU7\\D<Tf+THϠ`RZq[`of\\\"πx|EfŰP/S\"_8-CF]\"jhF29!Eb[E*Mx\0`9DU_tюq^(j!tX'E_ػMQd^b|,{4\\MXFf-kN`7,BJG5&*1L4	#-`'\nL?\0)|r	X|e\nJ9@ʬȥ6qX\"qE	Pm¢NҖ7}	<I\nA͌juL+F'CZd&RncIl\$\")|74hCvcs}sG0~#feB.rO!<]/d[A\$)JP\0Y%F`&BvMIIP*7֐2&lXo.\0KZBq&<Jp	ei;\r0PBHMLİ=TXc1&y-I6fN|&yRn0r	%VRKRdH AY\n<JĺL'~V \"l!d'`q>Iit3:Lɲ\\s%ͪE@HC\nf\"@ 11 ln͆/X\\DK ^-n|\"\n8@{)P(P(s f y0M@\0&bQX]3	8<#11<.bf*p'<4)1\0)n~cȁTStI11(\0P,d\"=@6\0w\\fzYLn(O}5	W=2Y͖e@Ol܀7INmX\0N:nB\0k|,p>Nxnxh5Θ	Gd'3MS\$H1iN0݀8Mvĝ\0P\\NH\0|9@\0!dHNɥL\nS؞؀*MQu@&7i8򓖜)1\0#Ljr3\\9HKd?hg:	OzvsO|\0F4>ϾpS|<*LBw)<?9@	3+7ϲes\0@Ђy\$\n(#B'Rӫ5CiР4:C о}4D(i<jPQ\0ADf%>L4T@IOXX (&l')}\$eIfN_% 4i\\UhC=Du'@v8dB-%(T%7㖨f\nX\0m@C0I\rɽw<QhS09@I,t')˦\0J7\r\0!ƷW1\0~_\r2\nf܊@QK9\r\rXi{/~2Z_2'*o	Uس\0{e(\$iM4T44}6)mV}A3Q\0l/=@QZ:kN|Q&4JR*iSP5\nt@_)QIMXoޠk19B7=\0ɷ̆l|[aa.Ԩ\n\049Βv@GPO'ZHX'VZ@Tng7>l3cDXZfjY_mX)ʀzG\"P2|\0NjX{\00dTl \nq;߁:bShfy)Q+jSCQyS0Hq`	`FlpT+yrjZKcWmA:y5\0P&zWZ)D	TvDV3VFȭRj֭pv5)'X&@.C@`pTlSw_	#:!/5rrr;F&M@\\C\0\"\$(TX+\$t+r84XfId#&cIPZḻ(lZ6^3|s\\=Er3w+(, c^|:`h[UahtZԶO;qyv\\A^x!j2VդմEd0رְ4HYHz 0+Rjf_kAJj[,U\\jXX=ZDw5uˤ՟n	%'}&p& )qX\0+_9C)Iۊ)R짇`ĵ@/!+UAf\0R=A%r3{\0`%z0\$>Ѹ=h]/64\0i_2Ue;:JNuV|@	GhU=Qh'(T>,n?#tsf=cVvu`U'X)MQpp7פ!aJl0@ZFE=ClJduAJtȪp0WUwƁFa\niݻXJ*o*6k8N[*/uMCUMaJ޲V!U!+Ŭpxh<@B] ;  u_2RL:߈	4.f1@b%\0!{=Mۿ|`x	\nтo!p)_tȾ#pai\\3D.񶕁Y2xFg넞8'(0BJ@bZn	p\"Ee9J0X3b\r; S1[y=(73	Ñ2*l0!VlrZ@<TKmXiF\nU?fT\$i8GS)L\$8BiD!\\B#<4aT+@-7\\x6p?\rN/黰%L+`ht<W>{~(@R06ǞP+{Esö\$*b	&#[X̯&bnSUl,0G~}cUf'dCs<m\r;<*4~ǉoam4]/02cFxwH;Rqﵾ&	kX?AIƠ\">x?,Pbiū)c<\\++^n3ő|N'!+PGN5TBK!1\":2bP,Fy*NÓ<a[&3t閇7\$\\qߔ 2ecInTy2c_	@\nup x+XUq<A.Kʕʎ!2?8fr˗8\r8(p^!!Y=q>\rv-πٗ	1gf,[,e'ZX:2\\Hy<1)[α;D|#H@LS3>;]2Xvj.GEBi+d%,Qr%Ц¶*I5`t-sb8E۾e\0=2/Yq9-eZ1\\^U`&gWJYhK]8W@;p##Bynqĕ\$uY!\$)(rX@/+L8O^ʔp6,Ѱw<%MSS=Z%W\r\nHy/2+e1Eɣ\\Uw	(p\n-ISEZiI@1	`\$448>\0iMӈ4QjYyp#x`m'Zڂ6zaSi&ʒR>z\n{TiP:jZjTtR@:ޭ5hj{\rfr\"x|cx?rkp.r>tqC	k5ha\nU:yxW8k)3!ҋk^t}-x5^B(q@Qd]ƴCr\"kw[&usW:ꕝN@d=+Z9N@m{-%>HR0*7K/<~,jsnP\09.͵Sj\n74ݱ,\$;E-m\0*Ȼv7c;u&vֲ37ءy(tn;JAG4hfR@5)V{[Ymb61pJ6;[.Ŋ[rb9V0\rw݀CwVT&=,hzH)8EsIt<@e+0ynjTƮw~dJσ@)c+h,ث8pL K:QAog1o?IZ.?=~nkF!n%/Et0'̔P<ƵGqP䴓FxAq⃫vn`,cW{9K߇{|+s<4Z+צ6PPL(L=ծjfh>)A혠qpK̆Ҡ~6d0Y#y}tORCS_燜|bHwsO%UwpN򈍜Y]U\"rMt\0jxoWD[[M yT8@9h!̋r`\\/4u{d8Sǡsb\" i;jiǿkj}vi74߽J9=՗540'?(7qg t	_[zӌ\\w_>s_g\0V|\$p-BsX܇.;3gPCDGy1j\0y=M˞;Fm(oD7ykbo=!:.%C%t߿Xm\$6&PbjTu*Tx\nd5Νt^d(S|-q\0(tXYQ!HFk0t4H|oNoN%\\w\"0Bq\$[玙f|q7~EyXqר>| Ob*\nImcEЮe6ev˟LnɩKxx~aǜf)9˟]F!sIiNh~ӔR.GF8/zdCf6-#g|t;4TV)kV/yC907h@).HqEN}K+Yr\nb3@K1 )lA˧=#HiLʄ5oAB>Y@\n1H!+ȣs0GH~^7ـQrI8\0Ì`\nw=0Ay[Q8HOg m#ʮukHB#oufoݐk^!p{}4Iv?x{CY-ICמȒ>0l\r\0|Q15L/j3;Lﴷ^{Un(}bW١+>'{WsC~qM;PRv̢Ɗ:pQG 7a;_z)|:g\0Y*/kė\n>U0xH@-=\"0H^UE+x+#;1kyTh:G&-!qs3^|xW-l!׸FXt]BXY;QL0cIojAQLGG%\$(wҹEhXKaob5sAt/\rݒ`w7<MP*yYh>Pr=zjW01gdliD/}^V\"b>XRnr.0̙9@ ۮȷ;&^2hYXh(b\0؀/\0l:0܂?t%> CG4@@E< h	O0K\0@r[\")AoX4z NR̃`jkP ]Ol2\n*b5Dn2(\$<)Hac:ϋ/8i:n6:0;<1LP\$ أY\$:0jIP\nrL!wN\0>~/`4+\0<^RXU6:\0bN莌*.Npxp_ 8\0XoKb蘖|l\0Ɩ)\0P:<pl\n@ASPPƚ\\ A03\0006 (.pv}9z@N\$ņ?5ㅟi+Av8`y \n;  Vp߀\"jE=x0d\$PV	xXg\\?\0ePaAJ/`pSLЙ	(PYBqОA!.bVs\$	|Pf%gzTAk0l%.l5I+8I+BH*pQ\nG^B	rLPUBqhBnB,b4Y`	|#`.B.B\$6!*s\$#<B%Q*e	NrL\0N1!i+\0Ѥ\"60bCgaN\rPUCq/P\$BNIB,%#-\r+eh&pº/d+PC-BD;DC}<BB:0Ï\rPCPBi1r	'c[\r?P*?³+pA,1Q\0L@qDh.YP`0@6Qb\n\rޕ0\r\$1@=ĺB֔ -tXBC1,+BI%	ֳ(KT\0F@/7X\nD``[ΕpDLDQ\0\0N`3^\n@%	9\0[ 	LMA믤Q2Q8)HWGDb%\np	S(#tDHQq[f]\\'(B@^(CCvV[Ř`(^EZc!7ÑE*Y1mEuY_E\\`Ec,[1e]`E\"䆬86 zq]hŀx@OE\$O6}Qq=!\nŐ<b:QcO'b\nT(|QqFR`&E*1R!L^f``ņc\0^H!yg|F\rbFl<ƐcqeFipFhϖ\0]Qhqbƨ4O #\$=\$gFkFp.<\0k`nƦO(J [qFj1F4\\(3\\TgD-TCA+ \r7Mx	\0Z	R\0005p\r1E\nVI(;R~[>`36rp	%-Ж\0	dCñ(9Ax@2!*`\0002ǲ~8S	PAڏ/ #揩-81nt*\0#O0=0	'\0d	( xG  \$\0H(2\n3fn 7\ñ`7GF@>H.5 >?B><z\$`>0RtY+ FQ΃ l@>\0̅10\$VƴK&\0@0 H>4o\0006q81P=9\n17\0D*<#H\"1|#!K3=~=nmH,#,{I#t~) ֓\r b6I!1gE/r\$)\06̎'0v3g@\\@\0! 3!4HdLf_9r,[xebf HHhpf1~D%,a)0֥%<Nc>& K!K0-;H0&܏ଛ.|#.@3!K\0002\0!07ʿeJ9h\\=dT\\\0QDId\r(II 8DrZ~(;bJ8CU!RH\r 3Iė_AN#321@{@J+#=R}2-~H.!`:T^!K)Jл(\\-\"#L0	tʃ)d/!r]8ы.SKҐ\0H\\wG:)Gʘ5+N	N\rJt0&(\na!Is!!d10D	2:53)WJ%:0˂#Z*H-k״\rR<-|Z2L\0dxKAty2vLA8\0K3+\\{e뼠!ֲ\$gI.O#򝂵)>\$g!P؀6KF#q\nWP2NzS{)|/'(kfQ*JdJ>!02\00Rbr4yJ\r <^H@SdWlT\\TTF;q!MCx!\$9_Ay?z2|I|.2)*cBR+2ԭ`K2\\R˛+B0˙L43d)(G,\"̈Ғ3xS?L3<SAM.t2. !+%8!JH@K%4A3N*d,M4/ſZcO1\r\0\0(M</Q5̭38J75S_=5ܩA-0:)~HRQt͑\0\rsdGsdL.[6@562M̒-/	\0cLΦMe7xq\0003b44`1.j@H46\$W6\0\ri\ny\08h;>Q_<40?RH10G(LfQ5/xXsbL`<8{rSɭ9@B8x6'N\nRQf`8|\n'ԟ6T(2^A*/'0Et*xɇ#dgHRH(BU#`\n\$c\0(#92\r>\n`CrKHP eP7\$8҆6Y6|ThRЄ,4sǊ* K)DsJVԟ5\nMH?/|\0006@.Lh˨>KvL\"!K(\nIOv)I v6Ü3>d!Of/KLv0	T\nؑ,,ܹ6M|Od!'U=C/Jd*ǭF<Ӹ!H;ڂ;љA~^<aSe2֘=O1 9L{9,:9,7-\0`\0` u:1| e1VL#A	Ap\r`7)@,dġ{+5\0b`LhU\nЦe\nSΖ}\0JA!2\0A,u\0006PKQ|3O	PS68\0%@0ɦ\nL5.ə \0',<)@?(P5JgI\rd9\0T̒)BLA\$cb)\rXCO(\$NJqHV `\"M8t\r;03|QC7XLu1}3X:bO4]UMaE?T=%0␂C!TLH`*P8K/\\K6{SY+͐KQ6@6V͑<eIP6CSzO\0Pf>80a\"gI,gmFᙔrId|FR\$ ȋH!2FܦP HR		8a5Ih.QL(@;\rZ3%\0=)@B*H?T\0#I\rJpLJU%eR_I&@:R%&ԪRq+*RY?R\"J*R3JiԬ\",F5&j6.'KE+ԣ&u)TRML)TLD~ԹRESK	ԤK1!L7DcK-34DA/x%T@SVIS^= `\r\n5#0	R2Q8TI#%Swނ|R7Ӝ/E\0~0A/\$ӿ@82L!dtYO|7<a(ʮ64d@\rO;tA?QiIᏐ|&,<w-C\$0ۀ+B1P\"*#\0HEJO5\0\r]O첈^\rxz:^	_(6M'%[-i]F#ғN\0ĕLN4f#i:SX@4%[ʙ =&#eHc\08f  p4\0ag/eD,Aڀ@bE	\$PJj2\0*: .24ࣨ-P@u=)\n=x )\0򔂀=\n`+H()\0#x&=:ki&)H+>UՇChi\0OZ~@+x	\".F?B	BmAC[DmQuFjR/4TuK%TMDcW!B\0EГ`ɏ=&L=cϏB(\n̨[0U\n Oό1EUTu]\rU\\D[\rG`1'XdUT?CHsV3WEcuu!Xu\$,B}e5~UP1.'A:>p èi\nSSE\n1\"T@@#lN1[(ñ:PQUl4D[%lЄ%[XuD5b	kHbDpqW]p@9\0[R8Ŋ(-RN..UpTW%\\*U̦)\\Ⴡ@CtU͟j\"\0<WRc}uuu]v3Qs!]}WX]w.mu<I\\ 5׹rdh^usM+ 9Eu\njWy^UW[_E{҄H>WA~U_:k]xٵ\0b(\\B\$89\\dX4UمaH8W#es^A?+=u\0`ĵ|\0z)upQu)`]xOu@6ew`q9? W@hv#	@m\$X+ <~(f\"jDe1X_=rA=W9\\ 5c=E@l1X̐: ^\0\$=bMsخFVb\$Y	b8WCTs6%Y @(-)Tb/DؑdH؜L`@d	VG=eUvX\neZWF{MMY9eMѲu2GN(-(+b	K_fX#f9dcvnRb%4'-\"\n9\$(JW%fՙ6j@7gvr4d/1g׀[e}Ӈc%cNJ\$aa٬N	Y2dSbQ`\0ŠW\rr,H\rhrQ\"i\nFKK;iP+Viupc3]֚Z`8j\0-Ei+d]\"ىh	VLϼŕf}1j67dM\"XYjW@١A\re%\0jbtY:Zev(ծ6dAZk\riEK6l*<J]hu 6[#lb;bճvdtt7JtAو8A\nlxҖZ&!~Ҙ[OmHմ~<\0mZm,[Gdui-DqZL66[nE ۇej1[l6ޗJ}s/[me#mJvF7n?Jt[R\\6YoLc`5ovmX-6acZsl%C@[Wa [W[Mog\\/\0o \"sbM9dģ58<v#4m,}نV|MlS\\im;ᆞ+YQrEȷ%rj7ۯa}ZMrW\"ܝs3؊(B4q76qCo*+qhsv<oՔW-r7?ܧt\r صt->tH)rJ7\"@w]Ŭ7IYpmҷ7XYt\nG]\rp\rQ\n8\n2ѰTezP\0=vNE#ܽu̗Eiu-Ns^.}Cܕd˂2]1f.gr04x>WvE7.]jU\\k4q!twIF]pwq5w)\0qp\0\"\0_az]^7v][-ܗ<vޖL7c]a7?\$-7;^w5v]=vagv	k\$w;Z!Vql@;V0l\\[v-`X xW_\"n <^uw^ew=ӷ]rup*urZ[]G>é5C̻(0*ɒV0W	(\nՂ[z`)^Zkɱ'#\n\n^()BiW \n\nݦ 7<'@	^:3\0*@\nЏJ&h\n| z\0)_\n=젠_D=h\n5_Z`*\03.(\n'!h'(`«>< -\0{zi /L8`/:IUv@Z]<_{0~=`m{,7E{=+c~l}5W_X&\$Jk1m7O{%8hx`\"'{}7^袍Ѐt@\$z\nVi߱{i&JW|\n	UZw_NW(:_RR3}`&\niAh0\0	|ES_%_2֠7߶8|{8%_Y}pc\0}k_k_s}_~Ώ?`	׻{Lpf8;\0^8\0_E`\"b<wߍ~@	_-Jߣ̀_-:fW_~Mia1~~w=&_?ZouU7|XJaUrbdpZ	ը<wЙ0f#U{~@&_	*Ԁ{zw_3`#\$(0gUPX?Rk`>+\$.8gÆxlIa8[{X8aI\n\rc~aͅWx?\r8&L>!^|ڏt=a`=؍߫ %d	M}x\nW+|- Ux	iaCWa-s߯'f(Z'}צ\"^'b\nxkb=5hdCݏz=6\$C؀&+~%8\0W`'`v&Y\n&0<cͨ<	 !M\0,8bɊ\$ď?EXc\nU&Aha108VF2عeNIbq3>\0V..؀Wɗb#a=BϨ[P*=	*踂`7q+H 	`\$U5k^=Z	b=}Xc.(d_3)_3Cb\nF1O,Qyc.#c	.A`>5LF9:<+uߋ\"V[(=>X%Ҍ=H\nS9axIvE a[ &2dh=PZVU]U#d^\n7FG\"&T&F?\0&Hy)bK9)w;P\n\$d#bˉ&JgvK#=nLX㍓H*ا^ۀ *'Kቍn,`::\0V	)&!|PزVO-ԧ}{b	PEe#OcgP+Zrt(O{rByLN22(&U	\0X぀kMf5]VXUU\\<paH#\0=ZXvW	,R`)f6Ucᄝ0,bըf'`%ᛔe݀^8\0^.\nX__P\0).B@dva9)'NO+~++XA-	j3	MaX]\"f)ـ>y:L\nŅ4VX_p0=-@§zUYb\0ȸx\n&jX&*ɋ_r{R7Ki+q3kw8f9{6]aVlb>jyfy<)(\nkfjԫ@X \0Q~@F8CL0@*\0`^~rxgD6tT|x# >u	e)YϪǝuJky2&eU{M;iUL=u#gX*t+0׾ȁ	 'UY^)5VՓ*X-Ua\"ǆ8`}aוU{gdn-8\0t9<Ldh ,=I0h8\":8	ԣc3h1\0iz86cd81hiֆ'X9|̏_aK)߯Xn9Z05\0ƈx\0<\nX.UWic::	Q&\nZ\r<Yփ9VgR踶bZb*IGkc.rmP\03Y\0\"'2UjIiI9]W`+L>-c<|\0Z煥\0e{󀉎NH=h+&@1dS^hy=fWUa3~XN;B+FOva\"Mwg턆cȀG'Gib)@XCf<\0``ڴ:c<p6<ƊcaX^Yc=-axCRKZ<ƛcf%?n,نg種>h/xH筑VyeYWVZ}l\0-jO8_[0\nY\\Q~#nZ>wy৪Y_[X\r궚ޫ|egUj:Սsˢa\nZ&ȭ\r`.I`{.n冭\nqƖWd.)a`>gX}8򸋀(\n.͛v{T7,3dg~0ؔ	<{<}3\$ϔ)8@R34:䵥]~6U!<@jZ ֺS^ӈB~ 5ɳ,S,(M9p 3X/Zu':Fp\\)|ƣX\r<Y8Xt脕!`6 4.6+ZP۰n<0&bw0>Sr<@6d\nzlOFRlO;H5ڝ*L^x0>g6s/qYe\0@<z=\$Cئ\n`+'S9X8_/ij	h75Y\0&cwa֡EɟXyfub{5ͳvGjgnXd\n{lǫ͙~V	?3W}R	Ch0>R= 79x>S\"ӂ4zҴ0f\"`1:愸x:x;Zd֔eK;@gTML7N3RkN(iF;)Orn:Ӷ\">^#e;n!Q\0/ԆfU\0\"@Rp6Bm0	!Yr/Tt1VeOQzBr9,@9m!t11;\"cmMu,S<ŮW\"yvK)VmV,bk\"1hxF&9t?܄Iq\0g5MK!,?!PSQGe@a:bHd@(: DdFJ1Ḣ 8w&@⍅'iVmL E/[RR˻ZnfՏٴ_GhlbŇl.3%I[c6 3k,IDX%JSoxvKBq[iDanO@۱m/|iK2RjfVrZEJng\0_H;PHDn-iQa))PgL6%lk:sk1SmNFo(SJIe:ԺJ=lF)ﲋ\$xͣ>Æ9Xo<'mHf!D;\0fSAr/;Vl<eػ2JA\$kUY 	d\0׻|pP!fZ\r@O'_x6;\\4%Z6[6tKŰ#u1|2XOo&6~DqO<<:Ӷ|p%%ֳR&\r*oʡx\0C[ʸ#:lpw\$KL;sh`aRnz;ϔ;|8L=OEǥH* )-T/⛲_H._%H7THSD5>S_cr~yE\0*^,͎FS=\0#>@cEMA7o\rRq{Sմ1''m{p0f2/<m:-HƸ%N'[Pwdf\n5<t	<n5F3+b*qedƫ0@S;鞒d:;=>؁=#NR2`Fd\"wQݵUNRutvӡ\r'K#O\0ɰ씑r'rH.|;OK.8L܄HT|sr̃IMr/4<䏦<rƖ05nln,l?Nࢃafܠ!fo~|@2/<%|1~iL	_1 5'}r!16Eo2s. \rr7<2<sn;r5*OlLDF@l[͜;]ͦHaGw75Y̚5H\$A\\<t|ARQD!D\\Iqv@}_lh(SKi)|iwTμO>,a>T4|sd`#y\nu,\rη@As8=tdYw&		NBhR2t %q,TwM[!O=xNHJ@C6F~a\n.Gq\"'(q\r8CvhJ`9\0/|t&w@&+\0]<bt?DqO:</aX!8YEUEl7G=aLt@1^><ЇQX܀	\0}?CwԜ]=EW\rNR+N#]?1oG}.wG}%6Q#@.h;N <P䐠18t⡼uπIM!]tU֨D7q&0ܛTz\0qH؇tI|`6lIeRM^.5ue^M_\"7_'o+0sQ?FH݋uXR+J̢O\\\r7`N|EtHwY_ݻOa#b@GkN0 SUh7=\$_0cx7e2qtDp0umbر*]^蝍%7N?l/PZwO=gnVŝ veթwn1a^]]<p\\ޜ&AzX4#ݯ7د_=k`Ћ}!E^Kطt2_Cط\\IX3طѝ:%՝w/PQ.ęGݬA?[ݓ'wd\n9p)Ƀr7vj[@!w^R1ڤ7[e;qm[wkش/5٢r, ?b']r[\r/5ݰׯr.%UZv-l6~BCGhS ougMp,O?Ddmw?]u! R4V_!xIw^H9_=>}0ނ)=HO_=dء펝 d 3]_6:xDx7BӼ\0]/=vIJ<AX΁,Me;G\0002x|&\ntSc4u}pv]\"9x_Ob'SK(KaDXSmǍ煇3_<;TMM\rHo*_-ޘR'NU:׬Hڪ%\05g-t\rik5\n`Hsͯis~qOo\r^m>\rO/f&?w	r3*}t󵉏<wO\\eV&d%}!.{Jfם&Fx8+R:,x\r^2uV]qOs]x=#CI}e1bҚotJIwP\$v<Fp<yN\\\0=+5Pl\nSȳӾ\\6탿vi9q4g#|ԤvzK޽t//5j_Io%!7ItQk\nMwLMpu!0K\n/W]ڐ[﮴jz)}\\X)O>}S8@\01G{?yUaG//K~K-O_7}*Oa{z%/,Ե\0#S=`7aZL{H^>p7EO\"/{=TN뽏]G.ԠW?]O߿vLVFʝ{JTmio@xO?z/0OY|.Pb|+ۏ\nJaW/+!?\\V_W|=Oʆ\\FhaboC@Oq|\nzO2j=EQIv074͈ͮ7=z2M=)M7[!jJ	}^wmhzx9{ݶMA|>o)0\"Bx}40K(\rmݹykߧ1|OnPt謔{Cqۏ\\d1ҟa.u]t7cnYDEVd5(}	g׽u\r<T\\\$cԫ*T֜;[q{]U}ն	_t5udkmq_޾7K>+y{&a?>N,5Q^}ѡ.}aEr>+̧@n?ce|X}'oce_vo{}-x~S_=wn\0;=|'8']{CÏn?[uIֱ4)~=uM=1]>F\$sRO\rMw{/I]?5N6uRyJ tZ\"ptV_ȩfsۇozfɹ7̫fVAY\$|z[nP;[\0[/eCҝO)wUBVW\\pT]_	G#_v}5^M/\nDdK\0B\$Qzj MD)5đ4;");}elseif($_GET["file"]=="logo.png"){header("Content-Type: image/png");echo"PNG\r\n\n\0\0\0\rIHDR\0\0\09\0\0\09\0\0\0~6\0\0\0000PLTE\0\0\0+NvYtssuIJ/.C\0\0\0tRNS\0@f\0\0\0	pHYs\0\0\0\0\0\0\0IDAT8ՔN@El϶p6G.\$=>	w5r}z7>P#\$Kj7ݶ?4mt&~3!00^Af0\",*4oEX(*Y	6	PcOW܊mr0~/L\rXj#mjC]Gm\0}ߑuA9X\n8VY+D#iqnKQ8J1Q6Y0`PbQ\\h~>:pSɀGEQ=I{*327\neLB~/R(\$) HQni6J	<-.wɪjVmm?SHvƩ\0^q)]U92,;Ǎ'p!X˃LD.tæ/wR	wdr2Ƥ4[=E5S+c\0\0\0\0IENDB`";}exit;}if($_GET["script"]=="version"){$o=get_temp_dir()."/adminer.version";@unlink($o);$q=file_open_lock($o);if($q)file_write_unlock($q,serialize(array("signature"=>$_POST["signature"],"version"=>$_POST["version"])));exit;}if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];define('Adminer\HTTPS',($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure"));@ini_set("session.use_trans_sid",'0');if(!defined("SID")){session_cache_limiter("");session_name("adminer_sid");session_set_cookie_params(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",HTTPS,true);session_start();}remove_slashes(array(&$_GET,&$_POST,&$_COOKIE),$Nc);if(function_exists("get_magic_quotes_runtime")&&get_magic_quotes_runtime())set_magic_quotes_runtime(false);@set_time_limit(0);@ini_set("precision",'15');function
lang($v,$E=null){if(is_string($v)){$gg=array_search($v,get_translations("en"));if($gg!==false)$v=$gg;}$sa=func_get_args();$sa[0]=Lang::$translations[$v]?:$v;return
call_user_func_array('Adminer\lang_format',$sa);}function
lang_format($ji,$E=null){if(is_array($ji)){$gg=($E==1?0:(LANG=='cs'||LANG=='sk'?($E&&$E<5?1:2):(LANG=='fr'?(!$E?0:1):(LANG=='pl'?($E%10>1&&$E%10<5&&$E/10%10!=1?1:2):(LANG=='sl'?($E%100==1?0:($E%100==2?1:($E%100==3||$E%100==4?2:3))):(LANG=='lt'?($E%10==1&&$E%100!=11?0:($E%10>1&&$E/10%10!=1?1:2)):(LANG=='lv'?($E%10==1&&$E%100!=11?0:($E?1:2)):(in_array(LANG,array('bs','ru','sr','uk'))?($E%10==1&&$E%100!=11?0:($E%10>1&&$E%10<5&&$E/10%10!=1?1:2)):1))))))));$ji=$ji[$gg];}$ji=str_replace("'",'’',$ji);$sa=func_get_args();array_shift($sa);$Wc=str_replace("%d","%s",$ji);if($Wc!=$ji)$sa[0]=format_number($E);return
vsprintf($Wc,$sa);}function
langs(){return
array('en'=>'English','ar'=>'العربية','bg'=>'Български','bn'=>'বাংলা','bs'=>'Bosanski','ca'=>'Català','cs'=>'Čeština','da'=>'Dansk','de'=>'Deutsch','el'=>'Ελληνικά','es'=>'Español','et'=>'Eesti','fa'=>'فارسی','fi'=>'Suomi','fr'=>'Français','gl'=>'Galego','he'=>'עברית','hi'=>'हिन्दी','hu'=>'Magyar','id'=>'Bahasa Indonesia','it'=>'Italiano','ja'=>'日本語','ka'=>'ქართული','ko'=>'한국어','lt'=>'Lietuvių','lv'=>'Latviešu','ms'=>'Bahasa Melayu','nl'=>'Nederlands','no'=>'Norsk','pl'=>'Polski','pt'=>'Português','pt-br'=>'Português (Brazil)','ro'=>'Limba Română','ru'=>'Русский','sk'=>'Slovenčina','sl'=>'Slovenski','sr'=>'Српски','sv'=>'Svenska','ta'=>'த‌மிழ்','th'=>'ภาษาไทย','tr'=>'Türkçe','uk'=>'Українська','uz'=>'Oʻzbekcha','vi'=>'Tiếng Việt','zh'=>'简体中文','zh-tw'=>'繁體中文',);}function
switch_lang(){echo"<form action='' method='post'>\n<div id='lang'>","<label>".lang(19).": ".html_select("lang",langs(),LANG,"this.form.submit();")."</label>"," <input type='submit' value='".lang(20)."' class='hidden'>\n",input_token(),"</div>\n</form>\n";}if(isset($_POST["lang"])&&verify_token()){cookie("adminer_lang",$_POST["lang"]);$_SESSION["lang"]=$_POST["lang"];redirect(remove_from_uri());}$ba="en";if(idx(langs(),$_COOKIE["adminer_lang"])){cookie("adminer_lang",$_COOKIE["adminer_lang"]);$ba=$_COOKIE["adminer_lang"];}elseif(idx(langs(),$_SESSION["lang"]))$ba=$_SESSION["lang"];else{$ga=array();preg_match_all('~([-a-z]+)(;q=([0-9.]+))?~',str_replace("_","-",strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"])),$Be,PREG_SET_ORDER);foreach($Be
as$B)$ga[$B[1]]=(isset($B[3])?$B[3]:1);arsort($ga);foreach($ga
as$y=>$I){if(idx(langs(),$y)){$ba=$y;break;}$y=preg_replace('~-.*~','',$y);if(!isset($ga[$y])&&idx(langs(),$y)){$ba=$y;break;}}}define('Adminer\LANG',$ba);class
Lang{static$translations;}Lang::$translations=(array)$_SESSION["translations"];if($_SESSION["translations_version"]!=LANG.
1008019312){Lang::$translations=array();$_SESSION["translations_version"]=LANG.
1008019312;}if(!Lang::$translations){Lang::$translations=get_translations(LANG);$_SESSION["translations"]=Lang::$translations;}function
get_translations($le){switch($le){case"en":$e="%(n0Q :\r	@a0p(a<MSl\\;bѨ\\zNb)̅#FCyfn7Y	h5\r1rNQ<ΰC|~\n7&sL \n'CΐY:E2NIrD#y\n,؄	@-Giў}\rL0hCnXOeistXo7-Xd\"DꭦpQ΂qaUus]\0n-)e6jH6\ni2qsfoE\n2!& ڶx˨\n戎J0c|9hO@;CB	/c\0x\r\nC@:tt\";~-#8_\0LC ^&ڴ#p̴͓`|Ҹ(ơ3kS 9#c:.hT7A,;@<\0P0\n΁4 AC3(7#*+ME6-:17H/B07KK`#8ίlU\04N`;\n[	C\"}56⣁@;>֭cSncR(_L9ޭCNΊ*פrY/!9o\0N0	~&ʫG pV6((6,\0\"\ną!uj\$j4T0ɪ費b.#̱-#\\GK\\סɢf舙4zp@hEǙ\0C:'\$UچUlAZj2\n!-\0(+\0\r06A3`P7<=5O?\rSQQ8<#cr|+W!(=ҶtoDk'_\rZg)0\rQK^\r6rqtaFq7+}}Wn.=*ȊH)*pr;a#ԐE p3wQz1Fhv^I	\"5lZMcQ4ƬS5VÓ@?`Y&f86fh#Y\$]n@IY0`ۮsF\rkJ0\n6\\MW f}\$J\0P	AN_\0(&Ca# ߫WLi2,fLA\$Ģ\nܪA4R{&d`9d,tN\"X|Xlе(byƒOJS\nACXqe*@bI\"\$76TdمhBfQ*䅡ڨ &t\$2XA\0C#@L'3BJ	`18g\nF2(BxS\nlPJIkݫh|Kfo\\䯡y+\"dU\r*.A'J4\0#k\$Q\r?'	@jwQ\$P*PW\0D0\"U'\nW>emdG\0VDl)'\\Qc*f31 a\"U0YU>ELVP91R3<5c>ag\r=?Tfc`_kGշ%YCh>!\\+7x6D^ol'dJw	O,]8<ھn+L\$-v!x_E]en\rd7	]Xt5Ԯ>vRnMgSyXC8=S@BHw7\$1\$3Ln(\0 wQ\$[0PmKΜs\"@ʻ(ݜ3!y/ܔ31r:֌͙%ǒEF]ZhfUcP>*~O#NIn\"F'	%ƫ:\r\\s\r+\"\n-is򗊚xI3;:vqȓl`YWvgw7^<f7=]o*M\nMw.>\0l{qנPAŃ\nTJh-N,%?\n]-cƷ=٣sW)Be\r\"\nBj	޷XLx2Z	eg`׬ZBb;,bݐpbqǭӂNJQ\\3gXXA	0Ͼ]s˔WЍW綬Wꯙ^o-jplme*Ѣ6tz8Fs3X!;ٓOo]\\lmhe1-I=OaD7ejYkA	<Ge}ZNI=4D2268P_ʬn<.e/N6%\0/`5*Ρ92B|<cP#dʰ@o0Lnʰ+4V#\"@+ePfvC\$\r,ֺv<8K\0.Đ\0\nN;\nLń0xNŰP±\nlP<\rZq4\n	)##G\0&@=>0N74\rj-	#b(2f2\"qQF!-Q(Om\nm߭.O8Lj\r,<b0<r / r'\n(j\0\npk#^/#	ʖʍ,/.\0j:fFn>.V6\"/\"q\r1CC~֥Ѵ8:)(DBZEN/n.+<Lf\\O\"@ر22!J]Mnr1%<]d@`ʠ`\$	VKbRˆR&F92\0@	X)쀨¿KdѢHZ`_H+2£M#1j^L5\0˸.UX\"-8m";break;case"ar":$e="%)l*C(Xl\"qd+aN.6d^\"(<elV&,lS\nA#RNd|X\nFC1l7`jR[-sa_Nvf~C(BKrT򧈪J4G\"#3T2ΊTr<Pߣ)cSIdu'c(oFe3Nbp2Nӡӻ:L[y&\\d\\ZuJ-t6YG'˨k(4k)\nbƢ*[^;\09Cx䟯p+<*˖i3\0#\n\$	b(2dбAT(BЕI\n\$.rrj\\|\r	L# a\07Mp: K1C39C֎K-9p4C(C@:t28^2x;#I|6k3Ak4px!~&lƈDl(Z[=hTW!CWz2	d1ZV	rϖBHx+#3(ȈB^B̢h/Y(8E:0t޼Y	*0)\rh1REkFq>ЖOjExŮ\"RuB̈ 9M1#sL)\"f<喘S\\FZQN\$ϲl[Ȥ`kngɣFY^b1]߇k y|lcYlK0bL!Y	3o'\0:rQP#qM0M9#_Xxuh4݇vI\0-oSACwR23U0\"41ZW:KWD8Ȧ.\rz?p[Ab?:iB53`ؕaH-WI\0PT\rU2f`o9a<ꏈu8`9*=5g!*\nn@r	rOȕSP*\rBujR1a*WzV)D>O !{v\$\rRD3qVĤAŒ``BlE\$@SqÊJl9p\r*2P!E(Ԃ*P9)e0|Q\rmS=9uA5d\\jz&EGBHQfĎ\"`h5:*@Cc?Fh(08ai.I;	)h%8Sy8 a@1IXC>!\"QA%K	\nq<U\0('Qn@Q2E x!,8fQ6UΗ#7f0ΐ?W%%R]rElF*g\nT55687t\\0:ֈ)?EdtY\0FTF7hIU<o2\\hO}(#'DI %\$WRNHηb`L6?LAIb-DJY6nȮlHI&+E䴗xn'ݨh 46idk	p7󎝍͚#%!pO\naP:[#ҙUi!Ԉ6-b.)WXykoRDdFRSMsx˕OMA*jLL.\\sSxr5<pQl\$찜A<'\0 A\n!PB`EmZ:]EUD*\"̒Y!HL=ʫp-n|H//K]qu@}sMq]8[.2`F߫ڥ_kBTFCj+%iW\nO휞FJ+ c\"[ekn=ee}Dk\n6W~&'Fz].*l&,m՜{Hzao_æ)&`oR4ذAC4%&\$sPֲąfB/:)oGy؎0e/&e/!\0Y`ZGK4RH\$Xϫc\rd!]kb,YQD2{y\$.Uc7\nΔ2ⱈB~%76}B\n,hdBH]\0R)mdIB*A9z,[f¸E=~!\0004\n!2	l+wX3FC\nK*\$yr,4g#7o9;(зDDK٫ɏ7~-9)ۀݾsҡ_򅍤].XK K-T\$DC,#CO!J%bB&nL)AVFb%2 DlDcd}\"F&dJH<\$m(f0XZl\"@'crX=pxp|#it/	N8,8s\ni,ʍHqdN\$e^+Z694!l(xj&D:ѤhO&X~k:>0<6B0-0B..0^E+>b\0\rA\r\0a {\"q0˄NH	Pd\r6n:щgC\$dGbTDdH\rLm\"^m(oyQ]1hƤ	OԶbpOD=l;%vЂr2vnH1Bǂn1W'Mp}> !\0D\09ffO\"._#bn	@1*P/E\";X<Ъj0(Fb[#N\n\\  Jk#\"NSD|\\FE)=\nZl1 3kG,,>Wjq>BqZ1,а=gLr#/)/#\nqͲsdf.F6gbDŞ:c\"0b\\3Xh%/4#04!5U/\"\\S51Cr23eS\rfq6`?pt5\$ܮmA \rӓ9cT7iS`:99\$.9N1[3D34ptH,S-]>6?R/?>}/Cr#ѳڱBb/>QDDs-Bd4j/5(Ʀ&lՓgkfE#&2^	\0000̳Mp, [,^j1F#3kųNZ/S%\"uFnk\r3`88\r\r ̃\$\0V*y\npzK8J0gK4]e|!DF[P	KO(Wqo!Sjb\0E*2LR\rST\$\rHP\$9-T>b\"b+.G-P0dT/UЪ6%tn}1#3fY`z#v5CY9Ӵ\r lp/X'Pv\"E.6ruY}DJ\$1I˶f,WIe.UJb\0L@:C\$flj2fp;Qc5;c&#KUL\$2+h%\0`F`(ck\n;][	\0t	@\n`";break;case"bg":$e="%)h-Z(6Q\rA| P\rAtX4P)	EVLh.du\r4eܞ/-O!AH#8:ʥ4lcZ2͠.(\nY(\$\$1`(`1ƃQp9\$+JlYhmrF @#e2;*}BWoXc)ˆ9^PS'iVՎ=ruZt7F/KZ[;J#<aoJb%2KԶ,A%\r\r!/v=͡lq*o\$BNM\$ Ĭ&H4\$ﱭ\0\np7\r7J(s&#o*\nhϵ1ލI`*hii\rvBkB6#tZx9@M1c300c(@;#7@8P`@O@2D49Ax^;p1̱h]x7IRxDlaCL4`6H7x+󤏶.*iY(\$쑠PD޲Ox*J:X,kIq⵷MҎbz5L*((B9\r\nؗ+(a{`Jjz%N\";+̧4-F٤I5[k{<kJ\"Z20H|\"⊦;m[RHz p(-jo0)-M30+5Z,7.Jzo˒;\\{'ڗSw1׆.)\"b0;v\"V wzN\rĥyI-Үݑe}nwNoo͂1#KLKl\\>_v	}j3|CʇB`5aC~=Wcʤ\0PMqI2huiL+6O VJ&p490iD2|Vbe\"栃bad4<Ef8s+?bNNgPԢ9r:Lla&S\\46@ǉC0挗\$\nngI.D0*hƂp\"l~<*E,SdC3`:Za@әuKob0N~,HC3!BC#)kHĭ#9LFI=%贓RnNv=bN\$'*b@'@\"fJX1:\niN)@\"UU*īÒV`4`豕\"b	m1=HJs\$I^;FJ/_ĔP*Q0ÞQ%@K6TTjSW8UrVJC(\nB(lƐc4(r[GUz;l]Mk+45Յǉ/\ra1bw\nO(jP6@0pEh6VC4>a:t\r3¥PоƂ\0Ʀ@n6D#uʥxM B뜣eJVQhi92Ȭ\0qAf,̚@\n\n),9^E\rɘ1\rhCzA;X@rN6&aQM:R1\nRO1fI`&Ԃx`jR*L90Hc\r\"*hc0(22L\$%LEy[8SFF\\T̗j(Uca.DG*p\$1o`jkuͫ&1yzH캂ŒSi^6&TGba#dR.j?o.lZNǏ5/V(bżߞȶGғG@=g| q΍p61SG*'D`%IMyK\\Lg39Od@rM<ǼVm9{1ha#v=]X9\n\"\0#KNh\$t󴽣\rۤ^FtatRZWi̺ǔ>IR8a;Kq-O'f2Ԟӂ:N\\kt9x^c^ajѿF'y\$bLYP,[U/ZJo 1\"<ğ!xpuލ]u%;\n[Qئ\"+2|ulta@@Un5h\\m\n~2'+WL+d#CYX,;8c{!w=\$<]:ڎED%yvkL2lב_t(6*Pz-e缗th{rA6nَf\0M()-j` Se\0P4k,)/0\n\nO *4j0*o(Ld+5ډj.cd~1kFvL \n`\0Z\r\$O6MM(NDH\"&Z\nTvZ.b^\0bbf??lp)J-\rCy(@ϰJlr8B&-Z)p:<t;c_qiJpfba\rǬ0LϏJѱ?趱.BAB6'.6%ȤmFk%ͱEB\$f%H)цL\no8(tdrݱH!z\"1n0opH)pnd.1\"*<,C揆6jFo-B70l\$mC)00a+4{IL(R'f2E%Hm\nJT8(+Nchr`\"2dp(Lr*]J*Cc Pz?+n R^\0Freqkf쮬ĝr8^P42.IZ`h{Rj{xu.cpBO/0a΢<F+c~ `Q >*K`@Q*\0F[*O\0r(I?7Oӂ6R8'&df79r\$.sξ.)Qv<:3<B3Fz!:=\0\$9=b>\$\\{\$\r@1*eH-\0ҩ9)nn;E;3+1DDóEEN~Dfefjn.ܖt\$9<).Z7FlI'>ԊC;2oRz'rAJ8;xմ2)7Һ38BwHub.G\0MK2`CooTg>W<(-U@Y8L=&Tjcc,e;mro*dmET@ӌɑ|mU3J@~MV&W8U0mSiKVDn=U}W'~5 1XY(\$(F0hrJt\$1@F7Ih\"n7G,UowUA]U uUjHu\0SQ23]&@}[N_UYP}TdjaGYqv^6#0/.\"]	\$\riP>Vd/6Tر\\%VQVWfEqdL(L#r\"/<5U'imƉW2(8u,IM^kcv&%-\$ꈦ8ՐgW# ֟>\$D2)\$oKug^jl7kwlr<85d/̕j/CAolq@wQ^\nFs7c\$,Dqnd1qFjs[utL|'vl1UQ'Ӎ7yTY\$kB)Unh\rV-f#bG.Fy2c]IVl1,lJR \0\npH#fZKu|~-πCzSRxnh}Nmwn\"ht*Cv://atp̞'pPmyc\$<'bن6NʷlĸH➭%#<l[PH8\"Ÿ++dR&ÁdM2|\nn+NzV*rr{I!*c){VtE(;Y\rIB2N6Cw3\$ny#YjTTX[FGf0o9wrx1&@k/V/]XyUZet.2>6XGVp`oQG&!̰+ty#1AR5	эq	 hJo獸ni^.omȬ=+7KEz\rE _A\"%\\6VUnGuVLZ";break;case"bn":$e="%)Ut<d sNb\nda\n 6#k:jKMŐD)RA%4}O&S+&e<Jаy#Fj4IjhjV\0B`ULcqؽ2`S4C- dOTSTLZ(JyBHWβt|,G8rgu\$)k2:4DZut*#w=vpylkuNkAAU2rǨݯ^ҙ^q*je6:KLWo@M \\\n\"=koں(XСPE1G\"26JB@6e6+eΔdȊOHXĚ6شz|/oOK(#ZɐF\nV)2ܙo1IPE4Ȏ{A\0P	%\$\nq'kE9]@+B0E14;.i&QPOV8HE1/NtR;--ڸ# 4()(=W4IYZ2֏F\\.4(r=p\r`X@4C(C@:t6Ugx3(9K0|ɲSX0x9 nBtEV1A(1\n,״<ZkO+/9s0ѓN:KKRQDfZ;OXZ=')Fa9۞N>}ڋCЯ(u:&\\L9%DkOo;-QX*?4.96jHB7WSD-t\n2uo.ސs\"eLT.@,,y5O@tI֍'@CFHv/,|TktKdN)\"`Z¾2X ¤SeEhQL2erk&NrMO(YgP+2e\\S>Ǚq9:ϨT2pEtʕҚTvNcT'H\$Ȯ{}ghPOSPF)l١yt♜\0]ѩ\\|#\"3#3OI:\ncA[-0q96tlɧX	\"(sFrxAݣiO^I\\)nr&L)yzٺrO\"KWxă;̝L,8KhY8jM'Mt\0YCɔ\r9PwExs^zW+שP]L*<+fS5n}š6	r2{V	qzRBc_lt>MVCgSjF<AyN|UjϡAD'+<DlDxP2_+~+a,-ӆ Ę7M]dX\$~G^0eRPi4>R.W\\uH#q讋tֵ)NkݒNIKuq-O>(GI[URB*F뽔=:^U5*C;c]Ez\0`L0c,EV.CtbΰvC%b@D'L,6%G/`^2UL++`@5!.Jy*9zl	W+A#I)kubo\n\\Kuf5_႐9	B\\W{D^1;LEx{G^8S]PYMZJ.u:82UlFh|X;¤%x)P˕#yRU\nuU[e(J6iWe	z0R[\"I\noJ#1b:-	8P)\0C\naH#S].q8+H3?~T	dq:c9x)	nd^T@\$yWmJjfM˘TS\$#mM}:f*Dg9u 5+VR0{:z'N9lSG[(}FE-]⋐L\"Ĳ\$0ɂ&]kuѨ0T6jM]a'?u@ܩ-V&W'ez+SKlITKe4ޫM+<ͭڷ)\$o	CһC9VPu\0.mAjG{\\=1R#FNDg//us'UdQ2wXu&F2)1A5=r#zNIjf8`5sj;d%xmjpBwI!9f<2%v\0YhL\n0*8ąC^ʢ6oJeEoxSM9J*^EJw\\o'D-,4_2:oXA\0Ḧ́.N'H7@=x0O4N8*%pK\\M߮օ;ʮV7ޟ-@\\ǥ<OFEGAd'FRJ:<Rd=	n=p'\\o(C#o37qj%zSNlRixHTK^0'o篐ChjCIPv0@dN	 \r\r+n )شT#+.̲Oi3j\r@\n 	*LiLDM2Alψ=m5E!AD~n.10ïzn^k&Oo\nLOpCBp'}'UG;daJ-%\n1|rINi^6h@Ƃ7#\0Tr.,1CֿOLRg2@A%Nby%o_&\"\"RhN&\"б&!6gg}n*τNp\n@_4Bt-:R|'&ZE*jjC'L.pޔ2o#HtZI\0L;0jا'HBɂ\nEI4H~f>Ƈ3e:fNPp0P9Z\rFQÞ<DRrlPSibor\"h+8hO)o<-;39hG9B;9kOҟ\"F)tRoC\"@Ne(6\nTM/B2T05.>xtH\"lm4+B*G*Do xPL3*,V5CJ%øpD'(:vj<fO,72;tψ+tֲlGD-A@ow&hsPS>kB)@N\0DҪ:4S9>^oc\"{uR\0JA#E\"KFiUUHc?U4%V5w@*OS>,puY51lTR4AUNgUZ7QU@B3gQ|GnmTrօFzp*:	P\\\"CH+fڣ! -^QKW]Lΐ\rH^ͣ-܂xέ`BbLͮ9B:R\"KHF\r?FsS^3*S7ƫRh9:R[թ\\55hMANS*Oi΅5\\j.6hGRxiZvj!lL1C3tyIum5GSVعkvn,˦mAHIn-ChBVj62OJ\n`mr\\kgD592pel>uSjvKuvF;tv%!vh@ֿRYVXutNg5Roi7PH0EN1/u+gXJyw\0tמwI}qWbg5\"q\nُHxqMGvR~oxKB9|'nx\06R)7gWÙ3#j]jV=&ThyWskWR;{~ԗSXP>8Cv֑0*V]Zqi\0rjUwaؐuTnk6;M8Btyůnu-O-5\nEE3`'W:<uCfwAI'Xw4}Xij2o7N2W>M.a!kgs:D\"Xx5DVkp\0iUDMYsW\npcg\$ȷB@p\"s+KWSaXXpx̓sY6YXY#yƋK@p.p2fz>Lx!+&#zlsո@p@xA#S{cN2rɊc^4LREc@\"NnQ*OR+g=>+6&#uBŞўo-Qyfι6\0\"68UuYiiOtBMSsP]9jGǩƐP+Ϸ`e#8#gpBuypVB_;KCL'LYc'm;56f0@\"{M;*.Y#bBzo'w\$عjF5;G/BuL9'QhZנZLMɺo0NtSwBWԜDȾ.";break;case"bs":$e="%(l0FQt7aNg).&0M磱7JdKia20%9IH)7C@iCf4(o9Nqi :igcH* A\"PCIrVlA0	'l\\MSC9L\$Y7D@n7ag2s:,XS@S0͎Ty7Kgɒ8_q4\$s/n3f+Cm%`&m*z@2C߬Hڃ@	(+jFmHɁBbV(=%*[n0\"54*Irբ( j9%MN9\01mt:0Krǰ9\0R43#0z\r8a^H\\0)\0,8^ǅㄧ*C ^(ڰ!̰\rx7^0T8ì-PۢTD&)|5KM;Q5*TRC;\\2\$,RȮ0\"\n\0đMaX\r`cR ΁P:N>\$AbdRI(26Gl4\0ë10ڥK2HCJ<%@Fp:(L\"\"nt^5\"5(0B#h2dõ0&j/cZHܔեMXXcE!MS2BTCTf)A%:JIȈo=3nρORX#VV![}(#+|WHEQ>t@̺<|q)H9kt-H<\"CtDus!;Dz*d#+\rP2;Wd4U72h~\n{SB33]k3N2FK|2\nI\0U#a& \n%D i<H-4\ncL4t֛QpI:bZTB{CDH*آ@F`k!	aACZ5ԔDviQ+96.P\"fM	6AnNnǻ>	,-k\r\nLٸ@QOǇHX{Oؓ·_`HBh!b)H5C4XG/-IRGĦIJ\"L fd-_%H}C\nhx@Pm\nM9%E4ڐ@CqIeHTXkMyRHPe@o񈐆S:3m\"yDfNYV nTn|'xc43U/Hc#AE,) TcDE0ᩕԐ0\nP!PE%TMe\$cM%LRN	\$<=Ia`vfCu6(3  \01Yv6̓3YO\naQILʣ\$ 6Y.%Հ@&yqD79WQPLP	ܘD\$ޛ3HM>a)Rm3ˋ=IڷI䂍䗱A?hSE!؅ZeyBxNT(@( 2\\,3(0vA\0D0\"yթ.^D50ZkTKE%Ã%<Jjxz9HΠ0^fjbR-7Pl@\$6b4M_Hޜ=7i-Y46N р9TMRո_i(SI\n_\$ :u-?sE6&ћRU/9!1z b N޳5\nm]2!/DޅmyX,:˒\ne\rEh1ɠzE2|4'(\$n=UE\\UI8<Ux71j\nCSXgLL\0(DfH-}yf!ٹ6ERz,A9\$p!h/j[)\r\"@@ +=C;ܤBQͭIʍc@<Y`b,2fBj%e	\rD7yG!r/X<unO7<wrBj9.;κ3F؆LuY<mJ!~ͭ霟u6yWd1'>\0[Bbh;Ru9<C:LJLb\r3 6QH)q96ˆPP&\nBQZ]JK~9GKvrjaPK\$yA?nvFx !\\ri1&DIAPf{ u_Xmc/ȄjJClfb:<\r`E&K!0<+4-\"@@tgf:<xխvHno1Z2FBi7\$sw@/B,Q4iO+\n5`BcV	ld.hO\np/P/&F-ؽoS.NbXBg\",mcNfo\nM\n.jq*k	18q<&ZQ~)#__ZXOP4F\n-*\"-\$'1bZS'\"b'0!	\"~Q~)٭SM\n-ͼQdTofc\rCqVq2~\0\n\0l\\&8&U/B~9O2nmU!\$Q\"`&(DU3Ou6RI84Fq꿃=&&?!pcl'1=\"e`~\"Y%R5`H0Sȣ(FI(r))TL4xxͮ4dC!0#Ȝ4d0/谟,JڎEخJ5.M1M |q\rQD(D8!eHR(٭1a2MBn+>rf\"A4BqA'\"@B3F2{@ђz2vcfЪk)p-*l\ržM&b>')38 (e\0Sj2&\n8W.i9 c\nHs,=m:\rVSHPQVﰧ`qdz0`Z`=@*R7cD8l\0T/'Cn.tjTc\r`R)dA\n,4N\r#4C9S)ҁ-=Ъƃ#HdJ@Z;2dziEo\0^#e1KgYjbFi=#5\nMtMM\r-#\rlK`cԓE<EpcpMhL E&C 6GZwO@@!f\"b3qݦC >#+̏I,W%NGv<IDv %oBB9Qx";break;case"ca":$e="%(m8g3IeLa9t<NBQ0 6Lsk\r@x4d	s#q2T\0Bc@n7Ʀ3xCf4(i8hTC`uADZs2Χ!(r4&	N\r\"Da8\"Sad`ʬxqx?#U3Bɼ0\0v4|DprX^e&TA^^,\nx<Nwarg	^\r7́ES>zMƺ܍C\ncJ2BDB6kp0\0P7Ð¼\r4!ChH(7\r#ғ\"ne1j#s:BȔH*ߡ#0ch7芆0@;C]%; X8D49Ax^;΁r% \$Ar3^8K\02\r d^0\"62ɣL0I&C4-D:cT<ԉ;&}]ŉ;p3LC_KθE\n\0<MeY.6k-T,k61:\\n3,;06ȬU Id!Lx+ؼz86\r}'o5rt뉆Zǂd0UVJt*x 1e1p@)\"b13TKVVM_\\RGNn\\T:oІ\$49ꏒ鮧(Z1iQ\n\rrPr0t8&P7ET\"2\$:ˬZ@<%T2T9?#\0#%J\$Br<3|L`ْ4f|uSƆ_#6*;LbS\n&\r<!0v2ەV\rֵ 779)GUK4*\re'&3(y3Q\"vK= .@\n)}tL@*`@cOBQdp@rLpT2LbhMI7'vGđz\r0B  }uĐ\"R\rH_IEtL!\$	l\0Bx1L@\\42Mi7S<OA>'UL⚈s&-,JkQi' C05^\\%Pȁx \"\"W7\$p1	+ɲ!2wB.,HÇ*C	64&LRht-?9PH\n	4@\n\n0)(h&_<pn*pġ\$R\"xw2ff7Cpv%U\\ΐ2Rj'#Xn-2Q@bh%6,!F\r*/x7#RZ\n\nߣ\$0FZ2sHq<PK(<8މ[̃0kZɟrG@@gT#	By1cb%\0naD(\"1?ȅuj \nSyuI^1Q0ueq40gLl&:VF5ȒRFx RqL\\!H\"l2<@aLP*Vos E	PlZʂ8.mJٸp_fqbw<G]P>TUlOShtihPTeMFsOTP\$/E1|>DMf1eJx96m/!@(+lޕ<\nĊj;\0t&Hbj3v@b8gF[pZ%K8?V.>|kٴ*8CB\"aS>OI&&|ڂu> P<4#eق|pC4řřOC\"(a4ZkEh\01h2G4:1j0ASpZW0A\\2T\"L{fW\rKQ6,,ֺ3z \\s#Sy-q#G%C`(Mo]@BHS6ptx,]ig@{5Ag,䵂eIL.B\$c\"1پFW\0R\r<\$!9ߗ(#FF[bfS\"g.38kL1l]sy2j)=cRw_L}S	kRfCWcI]*	Ƹ\$JpF'92{|NSÒ=st&	;n*rKJ@]F0kNahޣ!JCɌ#QK\n>9R-QM!\$D]#{ZE4S{e},F?8f[<{~\nQ+V#tٜ #\"QF7tM\\h#bL)`X\nG<Q.PH6ҡZ<[\",'C@ \0[kľ\"J>A:NDfj#RLH&TkLL8iNphͧ\0	F0RrNOⰈ\\>j<(Pvhð@-PP]RCP\npm\r_\r 	aŪzD\"/DeLH3̒- LdZ}.dKhW20pCV7\$CƋ4x'\"3T~m\nq0Br7Jq1%o8kWh;\rPtjQLpPlJo)\rQѾ?\nQq5<m3FXfG.Aj~qh\${1 feƜbv31\"n&\"c,od,ՠ60g hRֲX0ݍY&%	z֍]*N\rr@q!ҕ)%)Mu!Pj2R<sAA.qҒj\"ި\0rۃ!2-r6:m,@xfPJVHş\"\0:sDI!Q^^\"/-1)1l\$rEGl:Bk@T@jE\$kE \"\$vrLˠ\npwg3ppК5sIӞIS	#H!f/2\r&#f2Bp#>?#*ل#\$,72# ­%dKRQ&t8#5@=\02%h6CB\rPpNڂ!z7g3	aN@48tP8T#4?F),81e'&#%,&^C˴nv1@``8TB/Ͱ4dXdp6dhT/e7<Ʈ8ZH/fƂE\nz0>c4k3B4]J'>O6|%Gf Do3E\0e	BE\\BSdx	\0@	t\n`";break;case"cs":$e="%(e8̆*dl7qraNCyo9D	m\r5hv7e6MflTLJs!Ht	PeONY0cAn8Ua:Nf@t< ya;Q%jS{[mk<Ȋk\n+D,l.CCq	QѓL:N3k:V\\We]݈Z&-iq|hA61T2وāE3ihǓ^`b穦@1¥)6c(䛎K6ۧ\0P2h\"-b2=P#CPn@X#/f# 4RJZ\0#64=D(6!`@9H3:x3mAAr@39\0J8|;%'1^0nށB=0\rmʅ\r׍CzƱAQTB6h3l.0Y,h5MaX͍`V追h8*. P7 P\"\"H1C-72ⱆ^\nY(CpJQ#pA\\C=38XR`P2r;A(lD#\\MBbNk-#ŞWW:(K`QcT2X&H\$Y[@U2.\r.(T5`RpB=;%Y\\Qaj#FEK\$T:[R<@A/C5A#ZosâȔ\$.\"h(spU0ԃࣄh9r;.7ZUsC|')3\r#8=|rh9BROn#Z`6w%lfςF!B0܍;0:5\0)ڹQ29W8n{h#0̜)\$3}\nrx\rD\0_D4s7`b{ݢF	d&@ØE\n/Hё\n@\\,ABỗDFBQ'<\\DDEDg\"cAÔBCB^hꕒQ])q/&ę2hMQԐ o\"E'|Hsb:ȩ6]5(dQ6.,'D\$vwȞ/Xb\"\n	P:/bzR%!)=YD]T],Ǵ\ncL;֎d(rN	\0nOd̕vNUQұmx\"	24!+-YԔ/\\&(T ɒhua2BA\0RHמ)eD]62V/QL'訁[Hh\rAc>y+ldK1Eѣ\0\0)ty\ne !!^]1.0HG&ė5iHDd\nJJ0\"ǲKd\"s:%jQ=.D.vKU[a3) 0e<D(P塠 Cc5a#I9*^uQkh	-9識{/APo[и&Q<JV7zW=ge4=L&<\0£`@`-.dK/CupWJ,;bp[ \nl̎^}zwT[ZRNp HiKZ_I&^A38gL NlN\n2SKg]S,|\\ iRi 3	#oUj7G|25m_\$RIlI66w\rDg;WqZ=2PP=6>Yb89b.Bԗc \nDQHo+I\0̺le_Gpq9'dK\r	b)\"޵sRRHZ_+UwdZ\\k=,s0*#h=P\npJ3dӞR&%ͪ#Z3t8Sn @eH(#(l<Αq'\"8T L>wX*@ANt݃Kn0@+4ȓzRYcvX C\n#aM#hԴ>\r!Vq\$~T1`ӻxDT*--3Ɓ~܋؄,t]`=w	8~yc!y]S7#}mi?~އ~Qû\$aR+V7&r)ɐ>ǲU@DT2>\0>^RS*Y,BI\"7gC9:3&.9z@VÔl؄fnu#r@fhXr\\&Æ&pfaP9MSmTސpI\nE		DGf\$8vN7C&]n&.9/T-'*!P@^.m*\"c`хH*T ثZ,`en ̖Tl%zP	\n΀l1YmT\rELYg#\"riQw	p6`wG>m_C=DLCg6q\nq&1\n\"0Wq./WEƖ|RLdƋt90	Ca zBfw f-Ô ZL.^bP|-*<&Vl\".\0J*eS%JBɥ:+\$)]6aX*ܫj)^bS!Rbǆ_.LC&Zƈa\0ܖHП!m, 1}\"nkFoorPg.o,Ror.\"'Ή0B َ:b6R2tP>G%	gxopTuM^c^#n/a5Qaf6s\rr6nE:j\r55EU17;ieT'8-T-3.C6rWpr0]7\"SH3;TE.XGQ;2=K>Q6[sw=.W>9eM?DG{1A'5,d1;%AC?w@ЭSm@xc8wBicRD\$bw\0FFIگ)8`T`\"4x5im5-8\$@\"HrfX<z9F\";+G-K&T~LTQe6\rV<tb6'dS1D\0s'1@)P&It:biǃb\nZM>N\nMLS 7u!LHOC(SU P!B! \"I~R'fU=3\07E8	u-6k.Ғ\0J-HrvEjfO[%&N+bBfW'P{]far,CpT(H.^qăvXU`v=sF)F=bTa8&RD2:pƽB@\0a55\r\"p'Ra-fIo(%\nbF'{Gg Bz3bx%*i@\"!cl>0N\0l(-ƒ8l^uicUa6EhdF\r0Il{mf3%";break;case"da":$e="%(u7I:\r	f4is4N2l\"ц9Ü,r	Nd(2e7Lo7C\0(`1ƃQp9GS<y8MDYCQi3M`(nN7Kd9K 9bG(m0/Lg4`c`tbI-	6G2A[! 3[^C7{j\rت7,m徬ࢩn73~PS<ѷE9ZMgctދ- \"4Bc@Bn!CsP/2\r2\r(=\r@戎L1p@4t\n1@X4@:@8@\0\0y\r	CC<8a^\\(S(zǃ}\0t\rr8#0\rpx!6+1Cc~2@P5d3VֶI	C5X4'-CrB9\rː΂ @1R(Pu*\n%`\n\0:Pbp7ƙ;265:sM;B2@\r3k0֣u:SPc@cxЦㄱXc^A)iX(ih̌e=h6̽∘w4!P*]\rcQ\"B{2XBG)G\roܚbCT&0IU\"#3*EI@%1̴Ɉ<7!bڌ˲>nL/(-<%YݫbrFPp ^94)x1TqsdxdPbocx3_R77*\r <DGEC5B 3;TJaO^(*P荊C2𼪛#ڐ\"ĆH\$%d(JRlKsMip#g/8sR@:_| ^Hs,0T\n8\$\n3Ii5'mR@S\nc	-\nA;<>pՓI5,j\nj3*A\"&ee׸O\036Ŕvhс%|i^	AFhԒZ4HH4@F˹yw!G\$L{5@ՓrZK@\$\0Z줩3gS\nI)AQd8v]TM)Bi0dl*p+Af#J{!t)93=GQpChj%GI;6g@jS\nAP`[ *(P!	\$iC13[:Y2.2P Y'R@Na&QdVcY|>fm9\nc\"dBxWh\n<)D\\^o=@`2)'|L@:/\"I`L	A\r--ࠠB6DH&i4=`i\$-*nUw7ϩGa`G.9Kup \n@\"Y\r&[Nr()я	ufCn14ո\$  A;jen@&1숎*{i:V4d((2ފcAEYMۺvKځT~ptެ\$J,++vj.PˡkSPN9'*4hvCHzVmo`D;B-0a\\xVnE\0捌ah5b%DԋS8t٘B[4ġXɬF.AF2xjF..\rc#yCZ-l0	%sg#YT#-Am	<L#Yh!df1\"iAa S<B \r0OC(j44JAjPdE1JT\\2]u!,C		{I666כ(jK1uIڱV[컷^,kAdzhPɨ;܂K^1qHź2H.,OCT}LP(D%SFO{jk!\0|q\rVU238E\r)K/]2QKXH|Ն6NG֠y8gw>R~=dې\\{7/fMG:a*-ȶ[V\"Al@2߼+}gN :?WlEx+QmXǡ\\(^Nr6H53Nxw1xfteS;k\n*Md6gP[}zZS2;/f~/G7+P?bݑh_ϊ/ʂÜab~\n8;\n4dH'c̉,^j`M\"H#\"\\Ì%pcJ^(0\09fcdl^Oe\"\no	R诌R\nNlgT0o-.f}*l5d#Q\rA(#	8\n8кPoB.\n	Qf\"*0fFwDR,~0Ehd\0P C1X\"\0^2Yp{`l#o<i\nQgeoq.pB7\$q΂:C/m?1.#qѷl@B17`2Ib\r`rP;6̍p-!g\"	e\\bJbR8Rٯ-\$pԼ`O`_#LȜQ ηH'\$δ@p?<#m-)O*#&j)RNb&jJC-[&Ob!R_jO#\nlVg:&b&M&HS(Pz(kˑ2r),53nqsF;4>5\$0_xeb3k0 *!5	F-`Vo2i:/j\nB^F<fE7(ʺ\"0DxWA3#C Lf7>E*?T,J&%h @.*:\$d";break;case"de":$e="%(o1\r! ;C	i9	MQ4x4L&:Xg904@i9S\nI5eLn4NA\0(`1ƃQp9S]\r3jPpv >9M(rڥ`\\\\m0d:Ib0FEk\r>l5%\$\rpן#(@dduMgCM9cWԻ,SBywŎBVG'G(VnBh:6k9qx||#H !K71CX7>p@##lh䣢pk\\;%\n@P0p9SCX&\r:ETX:/, j:҂ͬCp4:m_xÄ<R;jz:69#0z\r8a^\\HL<'z9xDj6#pC҉!^0У*0I:cɺ*5@:p+)^RV/ 'Ўh\n곡*!(eb,	Z,-Ã7Sȿ ѣ[oE;4BU) B3l<~3(Ί߯21&	LKU:77pl6V~_S#\r;WPc5cxƮBvT\r0PBDX!Ц%Ur:\\T6M725JnE#(\$.\"(E-1ljZ9kn!Wl957L͌cZ:\rԵ0rC}ɽL2AHJ\$;o˲:k~w	sZԷ	2u}فBPi :\0/ˈ<D8n\rݯ>(H TPؒމx.(`o7@#`BW`-(Loa<Oz	BA--D6HM@OijHAWAg&>ZukMr\nt,oņFgC|m%\n#jm˺'<DYB5n\ndSRlM9'D{I?B\$XL`kg8Pega)GI\rنDJ-\n9LzÐ-K>CSQ3ҚjoN):tc.O2:eḰPFݸCC΋(FƟHRH2fP	@2=2MqۜnQGwaH`ҡ\0nųbUfnŚ#(QM0GOt*fy!v^S5S\"\\wxMl򞔝:TCAD\$pj-'DFg9iwS%qP*N\"H9~*PʹrW P*O޹cF@mx*I^k'H0@FP7ƫu!j3Y%{]*6ZNRQ*S&Q=2XAҸͲ`	#N9\$\n:\"sm1eui6r# #XƣY&! )ỷ\$@'0W.yMVN;NI=w9Gy\$I`壷-!SVOPA[]h`\rT(!x,F޼X7%	 F\\ᑮxCb1 A\n\"@.K9kZ򵞃(r	I)C,Q=t'P4\\slO ȳ\$M!d0kCs;R<pW?#KPA\"zՙ\r&'E0EP\nj׃yE)-iCJԡ\rײ3qD/2[:)hOs2ϫ|bN1-ʍRDRVjlkOrEn73t7U4-aCYF\0!xUR3\rU\0B#l4q\\w.y%18ajd\\p_5E1md@BHrp](TSdP!)YUh,˪4ˤO 3tvVK)}M(~BDiYfJ:bAqTHY߀,EࣇsEhu3ۼz\nCW.=3Zdl]z5˭ɱxJFD7,1f)b{#,X@72?fwȊpL'Mt\\wL(S!a\rP|*L4O@i\0G8-OFp]BZ#\0000e0ݦn'4g\$QFh;p0g9RnEԏecqg Ѝ/RMzw)G׬0^K#XM;`Q\0Z[#V2C,EpdPZn@\"Cp׭iM08>\nF3ItPA\0\r\"ƓP50H\0\$. l\$K4/BX1OF1&l-/\\Dh4@\rx\$7BY9GQh1W1zqm#o8`W.Nʂ\rn5\"z{&i -0lE'0ЮPc|{+M(8be7B1!Q1~-̦c\"=,VOV9P:\$4VS\$AFmnCFm&q]&QRg'bߥe&(2XT0>@f(Rw\0o^c\rQ'd\$KiG+K\$ײWM\$Ҋ602F2(Lb̊΅%\r[&hr\0s=dX#;#M&a2q	'\"2oDAtТH\"nr92a4>;rV[>;r6JA{c(2 A+w\$n~,Rq,Dn\$2`E,x\niF@ZҪ#\ȑH.D(3=& Z\nXlE;r\$5Y`9@T@`372y.ZkZi\np5ǜΠ3\r\0PnDD2tPoK*`П\"|#B82 #d׆\na'kA9B|mAH5BBbHmE@ڰ!%1pGX ;Nr(L\r\"\nG`PTCd*3FG\0@rd\0P&Mf<\$HPJi5\$pѪJZ&'ȑPTcDbpBzF;UnQd94oku.-\$f/@Cm6EȈFt5\"RÂW#A\$Oab⩋T@[u\nKzjm7!c,I#>Ę{wmꄎ5(e*`";break;case"el":$e="%)g-Vrg/x\"ZАzgcLK=[QeDXŢJr͜F1z#@Cf+Y.SD,ZO.DS\nlΜ/*	D+9YXfad3\rFqnFWBWPckx2V'\\Is4ATYt	qPe<]bꈂn>Z< Tu'a+^qU)qu+4%Yi?gmL]c\\3ddv9ӣ=_9\"ʡ]\0#-RN \$\r.Z,1\n;K*&-2ߣZA Bh{8뒟HF)ziEs9\nJZC2]r4lr%\0P7\rcp;\09Cx䳔lC0[46Z\$j#;Cml7ӒeQ>Ar,\0IzMj0ZN)t3M2\rH3 2a: 8MU1uW\0X#1#H4\r|h;C X890z\r8a^\\0ՕtMC8^2}9v^,5Yp5\rH7^0%frx_;cI\"gY>jP1P\"(Oi\09zfIDofO	RNPڜI7X(J2:Nu1=Jr7gG̖_ī(U*8E\$d2c	|*Q&sul\\hn6D3>JM<N(;[h&&s{%ұO4P٪^s>}?Ϊp1%ȩ)KKqXA\0(7?Fȝ#?~gQq(نy٬L9%>tݫ&GDYtx@=FݣD2gvqFn\$dy\\{%]G*EYt8a!fx!9E`:V+RA<&(Ms\r`eU]ID\r!eşRf\r;X(xka\0思y>	rɕ!OH4)1\"H' eh؅bR#'N`tDI󢑌)(rIU~fqhĈvD%>#Njih<gU93F\"dL1b\0qP\rx3Ff&6VH`..)MIwΕMb6MA*t\"4.%N@m\\\"O3=X#bDLiK0JsN#g\0jI|&P4XXr=bVUxr[CȬ \\ksֻWzz=FA>87xYļB|סy	gy[ǛT\\uj8˟Z73g\r8!,[1)0ye:\$p.%ȹB]x/%P_k@9X+H|k?mبCi' D&CQk(L;}cF47J֞\n\0ț5To\\2yjEܥRLBWy-\0cYY3ӐZar0f6֊MgKắ!\"RN~by/fH\rG@:nY-dV6#˲;+\n (\0PYKy\$<A\$ [hxc՗Hv3߅crV&;œP\"extnMŠM;	V9#~8-erk4\"lg]7ޜ bxe,AE؋LKO0!0pMԙ%JK\$&		I0.P(\r3rsRqvB\$Mk@c\\RjNg	M*rom~,\nQ9ǫgؖP晰2g#ZG\\CmHe>E-*':sh \n<)MR'\$Ѯt@m2\\w	n80d\"S[8ƧىI+\\\nJ6ʩ\"4X&E>zZL'W-<@=iaC^7Jzz7:ؗo>\"8KTKØ!Hbq#!EȐz%h gVt&\\=!x@Q5Ǜ\${0|n\\r'H{x@њ\"H?د;t=?Wࡳl]8n93*h*Y/&UV7O,9~E%:(4!㦆6:jV:oiXI\0t&B(.C?*vǢljSP8J%p>snxK\rȪOLi'E@\$-\$x:Zͨ.	^\0l\"erqIk)Ceq/`hp9fIph\r\0\r.+Agp1gBNQ\"Fe/\r-V5afP&OzA`:/fnxnVx-4@ \rb\neY%#Jdq*GMdpw0ZLkNpg4LP-dL*âGv&Di6䇈PF( \n`\0\r%hXVWWezJ)->J68f@f:'ƽ (S\\JiGՆ2NVH,!4%.t.A!)*HbFE\"\"K##@.D&0o\$(tb+ʓ&m#R{q`kc&r3&#L+rk;iM.Rn\nU&yN@%(2'\0PnB:5M.-P\n嚏1\$}\r#\n,\\I\$pZn\rP4n\"عԞ·4Z\0C.SG5R.jߩ.lXz3\$qlƑ,\"@1gLˊҡgn-+\$\$P.k+&>3,&)کȆ:PRU?/#\n>dIekEpTi \$\"&ɢvDseA·d6?6/H~AH4:wþq9T[Db2(8goB`\r)¤4P R(*izԢE4r\rj'\$1gpq!.\$B)tP}EdSB&LA`Z@^\n/GQZJ>.DE/Ƒ~|%'E@S4g)FG ~EOTU7JB}+Ω#jزv)=Ar!)VaW49Wr+Hr(Ճ\$8X҄ҭRbdB>\"t>iCAuȈlGDZ\"3I\\N5?A#]5\"^53BFJFoVO,O5cZ*rmrc=c)CSb,-BF1#ܮjc\"8xMl]a&R*\$bV7e91,du\\O\0#GNgOf2Hdd\0&V\rGU^V5U/eu']+Udm6T}T:b>6ofTrZ*H[:?u(,B#:!^T]Uqs&c	o\rmU{JAr[*ptj'9r\\\$ 6	>@|2fܰ1uynOCk>p(UrrV(?WW5M9mzz֍o`;rp^Ԫ~n*v8Osq\$~u&,BIF~h9Ewct×~8\\#-ddbDG֩EEV4IjV,E=XXRk`8\\QY(;1rEmknneqnB/3E7>6m1CuG}7M}uQ~/i1br-wKvUt7^O4'\\{V\"MuDOV&1FWe}WsP_U#<s%lz=gR6Ԕ:(U,bqQg|t5R8G.,G>duup!Nh.B1sԔiZ\$Ҹ@Ǚ#XRY*YJd#Jid\rV`;!Pt<c2ؠ(sz(v5e9'\$\nZlQ!2Tȇ9BU! ::%BtkfӗVeq0|aGmwvANz,lk=o{أM)R%==9TCkvCyyK5\n,M3~j0\"RV'v.%0&&3dFsY\0UK(&VwC\$+GLCw<Qb\rp}B\ry`=VowSMK){ϱ2Ihb\$t.mt\rh2\"q\\fnt#크p-f<:!IFSH\"\rN@(RǹoRQO1.\"-VfgnrS\"A%G<z^lh\$Do0yg/;8Pڸs[)?\rLoM	\"/=mTVBmi^%<gWܑy6pOdj";break;case"es":$e="%(oNbi1gBMi;,la6XkA<M\$N;abS\nFE9͎Q 2NgC,@\nFC1l7AECL653MƓ\$:o9FS,i7K_2Χ#xh4FdJx#&̆T\n W2x*]\n*̦Ai)%\"n6OQTa㑓;ˋs'ts!999\nsx'[S0Fy'ۃ˒rfNΈ\rȑL	@11Ȝ\$A(2O˵.bn9BXP#0&\r9\nT5@7;x0csy\n(1|#{1x43c0z\r8a^\\0+8-8^Ѕ9@I|+HN6\"Cx!F+\r+k#0;ڱJ4|l&ʣ,dLèʜK+\";CLA+X1*`cBvJ\r`6JںģkBDbH1vӮ#.(rbVe>ˈҌYG:!փW&g&b{г,op\r*df0MY	)I._4chol.)\"`6賵5]XE/, PCllAꁨ%2F>MpKW[x61bƂ#l\$-RUb4uMbnbjC3px)-29/#`G)CDr½E0	'3\\hסhGL(}Ӊumpb0ʏ7дEbFu݈!?2,Na]5Mc\\ⷍ@c\nF!Ý\nѸQxZ2'H\"1\$hm0p@XR8g9*I\$aP43B2-+䄇!Դ @rgM)6ӚuHa<t{	F% }nLӢN0\$|P\n\\@(VV\rؐ0c>J(,Bt\nRlM9'H?\r7Olлzp\"K:7JB,0tC!TC|\n#lbYK,HaIq&CHjxk%_\"g͟չ(b6Q5*JHZ5faFAqw#cML7Jb@P  sBA<\$\n\"Hice~vGb<etYH(8I62Yq#D%^B^~4āܡ|(\$Q_n'sSm|̹^-l*S\nAKkY[g>\r	#.XD^Fr\r.DCN2p1.Fbvq]Ū\"*܍ 	i\\R--BU%\n\ncŜ!DP9Io\r6a@'015\rEbMcb=RII+!i:d۲\$MM9HlOv[B,Ff0Y_\"a*N)wZPr(̇C.id	!h #1qO\nAJ`VMj{~P_DD7u('*3\\Ȭ\n䀢q\nIXÐEZ.Z-'\$mRO2SFqbVCHXViXٶ\$ABoo<\0u	CτN|`|}t8'<ceHLԇdK3.o\nb3{̸cHo\nIL@\0R3qL1CDtKx4i0mCF7:#/cS,`M\n8mTeJPZ<iŤ]'Ca9-QhaNLI n&I*{Թe0&.0\"ڼLq!t*K+Gn̒ \$!K,mNM`/)1P޲g\rWgL1]p8\$@'Ce扎'\r\0%gAbF\n\nX`S-h)R[_Egxc]	n\\\"ۅܢ9ܡ.Hes.ЕAzࡓh-!LfֈAｗHk;+a	K<\$+m^IXf\\\"Rd\n4b\0HS%TFxs<t	΂y1MU]\"_R+&n;'Bb͜)K0_/	uC2@W`|E+Z^=Jd͚Trd\$Տ=\r0\0\r\rD ,<6`CFhL!l`ϐ,\\!c6(lV0,ϖp=/\"*\0KRΌ4@H.@Hj.rV4aD|J6p-7gI	%)PꥢBC\0:\n.#<ʞ&m\r&23v\"1PUG&Z	m\r@B7L89\r1	<ܻMx+gmh~3rS0\r.8зRoqd8&-%dlJOm`A(ilaFǢ[eD-\0nB\$(1\$8\"Fh>jAA# _I\"ȱ=QmOB'F^oJ쨮V1A,**|#̲8%	<S2FzԊ242^-1&r\\`\ra'Nu'0٭u(M2j\"\$.-.pҫ\$z0fQƐ&2 \n*EA`\\4\$45AQ.4j1c%\0mRDdUvr#(c6pĆql`Z~尒5!b\"\$/j7/n	Zn2P;64-JƼJҭ%\0NbEdhN\"^MFE&BW.,G.)Rp!h+\$^e߄6C1>㪍	Bt\r*mfY?\n\$'I>5b~fEt -`p41OhiME;EZ\$cӋ5IZl.ShnBBp482D4HT'MJpiAC.\r,\0;VBf,̜4N\$P#";break;case"et":$e="%(a4\r\"e9&!i7D|<@vabQ\\\n&Mg92 3B!G3u92	apIdCf4(a&	\r1Lj:e2\rq!?F<b&l&+u\nBQ(ԉDa'8k&m:rɼ 4Nѣq7s;BLx:0Hы^rFsoMЂa!jt1;i֙\\/Mz⍎%mJ n5NrI9Ciĉh74p2r,4B#S2?	z2(%9.+rC{ZҎ#bQ1hXft`@:@2D49Ax^;́r(r3(l9xD#26H7x\$&p	J8	֣&Ѐ: -L.l*3H\"L8źX5DB'<h(J(_\nS\rk7+P,:\rhM(:ۨH:B[2ë:%J4B}3CEVJ>Ѓ\$У,ջC*]#X֜/-]Ŏ^#`܌H1lH&<u\$Xq:Ɋ71O MS\rF԰MJhX\roPd雬bz-b@17Gd)'\nd\$*_ijX!X4'nk)3ĮO' B<<tͯ |'(`Jrv9w(\rׯèۚbw6.MKr\$0x-.!.ְ2/UD4γ472>bnk&\\Se`PiIQ@\0AvKנּJ9/@Cn#'\0p	Y0wD\0HrJAAJe-ԾSeL9&Sz1hA`}	u(%Y^E)'ؼAu5)v=@a'%'Мx+1ZKy0&\$40M)\$&׆2vO\08s?7^|F(2\"h܍SDڋ:0!8Lc#%FrO&4@fF LIX3uM2NJB0f&y8rA&\rY5ꬮp@@PocNYedp5fI4H,7r5k.I]K戣\$'>h)DS6p7y6 1]䷙i3sx\n(!0>qd15]{bCd	.)A\$< F0Lpt6)s VrMa'\n<)@ZdP+кVEq|?W/|#78ڎa)`j*O%DºD@PV\$\$qZ\\(A5`N4P*Uw E	ܕgqB(L0Z{cLqERu~/qHidq`ζ\$\"X0@ʠa/+N.PjvdKjW\\HBVC1_+Bp5Q9A+A`sy )*2q;1L`\n\rCv/J}K\"yqYCE@S'J!\$BPWXN/ԆP%\$\\ץZ51Xl=!-GDPيKI.j,൹Zy+i_DM\rpЉ9/yP9J`ᰅ&maP)(RoYEv%`\\O-Qfl	j+A@BHĹZ\"6oX&^xE(-%\r2I,ы'o,A,@Y3M'\$5#S\n8.Xf[ḵO6Rx@yF;R~0IzU~iY);'ȱDHTEaC'8>vVG)szq]U	\\SB5qj<{#1?Ll%*\\;ŹvOPZ6zO4\\K(F8r^t<ez3/-+ \\\\P{Ws\$gp~.I\\_ٳŏ+#h#5,6۟_IźWΥYLIu(\r\0k )\"fݬ@,Lh.p0/bsyd^2Ejυҙ8Dj%H!o>/4N&B&yƘ5\$-.\r<IH'CMd֢tŰk4^\nMh.pS\nX	6ZzXKF>ܓN/V1f.iT8墾)Ll+x!JP;zdpB̑í	H;BM<5\"0>P5\n0TZ\\>QETme\\V\0S\r/O}	#EZUcS\nquR@p~h%SqrV#n00TZnxn11 C{'1q' Po&\ndBB	( C\n9E)MB!tlm	C&ț2[#Ё#1Z(^o-BR/\$`^J*mތ0@7/Fm~4/j7))2Mx,[^1.%2S,r}mj6o~j\r-0&2-m.@Pڍ\rBǳq=:#pK28Tc\rNAs#Tcn`P	`@VRM'h,+')5tlwr71	pX\rŠnJB.h07ElW5,ܯx: T@`\$<z'qdj/B\0Zv*<bN(X((LA^h@bP\ngyCϨf,[,+;\"#FOB4Hlf\"`C`Nj!<DLc)(}\rIFpЄW\nL^k2_N}/X!T{3b\r8۰Hj\n)It5B4r>X.cy&&π͂8R_ljgɦ[rueV2OUQCnyD \nNF&	LB\0PeD#jHYX%biHL446NVl13JeJ\r0DO%INj+`»f/\0	\0t	@\n`";break;case"fa":$e="%)l)\n@T6PD&چ,\"0@@c\$}\rl,\nB\\\n	Nd(z	m*[\nl=NCMK(~B%	2ID6MB\0Sm`ێ,k6ѶmkvᶹBhHA9!d+anپ<W-l'0;qVBҧU!K(RV\\eKxlvRUBgͅvGh)I\rȫrZʟ3v%quuMkEpZNPQF)NƓq6XH.++ŰR9D8*X7p@2C9:K#F@D+T*3k8FIHoj!.Qk4@bC°CB6@2\r(Ac:''#%o28:#9\04@:ʁ\01c&2\0y.3:xC\"p_7sI|6s+3Bcl4px!%m,T=(/hHSzU#lĔV\$D\$\$խID2=^\n7KH(J2=Tv\rV#+V-MZũl͊ͯ;hׂ^7QPܵ{ۄ6\r0Ȕ^VjCb{r9Jƿ9h?k\\\0YN=M@)\"b⊨x%-b:s[1E'e3WUm]pWuWWYzPR㧪)!+@znl.2Df(V\"޴*lP!`Un\nI@6;S:kCS)X9J3\r#?`2c%:^\"\r#6L4'%}0<Ru\\]{ZѕFEZ\niu|R\r@<3ahLChafuÐt\rZDH	!M0f\0HtK2#U	\$/,,7#˄\"F *F9uB,2Dq+\r(:h	C\$2K	H#(\\B2Ay=ĥK h(%%\0JZ		\" C\r!#'p@S}OAUJ49(\"CI }\"Ux,0\rܦ #\neaq(示48vYsFᮙ8_a1nÙaK%`UnjvO	>'\0\"Q\n*6\0\\{ot7=wG\r׊T)mk,Q}C|J\rFKą=m\neJ-R`` I8!C*!pRXքJgM 4WD\0cOQ7H뙳Cr{{\"Q->^&N.@P6<gL\"`TL5\"cpPM\rѸ1ȳIznA\0DSrSy	-&(:?+! 괊Iit9M%8&ܜr[4;O)2 ]He%) ZZt*=rkSeXs(&&\\/w?(PǗ,	\$<`oIɐ7-Az!%\$̄lkIG%\$-7M@|䬫({#[`\rd#ZzU!܇LBHt(	ZLӝ:\"kԣa\r)F\n*#EUo4A\\S*Mv\"`D	Q	PO	*\0BE9\"Ps!D-r\nlz%D*2Hr֖{.I.L\r}O^j|Ot(ib\"vڶ\\}hpڔCD88-G	u_6lWɆ\n³l_jtkU@+,ҝXҼGiڸ͙*^Mʍ<tqqSǂĊBr4&MͬΊnfleX6ZM\"!?\"ޢp\r֐MPPe{ɨ:+LS6Z<yBHn:F[y/5{*\\Ь~^bk \r=%g/Qalg*놜rV+b(\0S-J@:;2\rlih\r\nT!\$JJK޴\ryfr|n	\rY\r\\С06<'7fG\"y2=MNjt0Xn.Og\"0Ʋ8kvћ89SS:_\\		Le<aT,r0tJVϕ&\rnzj(LbU(|x/lie|k\"DXYXn84eD#8N#:\r]l+(9&[l߆H800uN9s0P=;a\$<;:Z/܃)8` B@x~ރz}ZZ,r\"(+\n/ЮrvqP|\n躐Bto\0\rBd\r\0G|`XEJБ\$ƲRЎ\r)cAlA1DEؐiR.0Dj(B? olt\$mupt&/H+ %uhl\"-q^E,Ɓ9aRG4tn2[;QlΘ*Is]h*3C\nqƂ\\b \$gʼ\$SldP)?EZ@^~B;2@pHd<ZQ]\$\\r`<ko&8G_&='G҄VEh?\r&b6%dT&p.P@1|o&Pv2?&q'c;(é9\rf%-%g5.c8n\nb%N\rhLkH@JW1sIjJ^\$134Ϊ{)j*3m:N5i,w61@%2A,6W(}7}ll}@/0S3x_#l^7{i\\	Nm肪}=!t;d-T/W\"E*//!QE=Ì!o8:_\"{G@HsT\nó&D_j@k)\n\"_r9\np̝aQF;;&tM{!rZRCJ9/qs޺'3fk*tðClH(D#lv/EH~]+IjbNpBE]O04`f9L%RPԂӔpu!oEMRR,-!0>8ii\\W&mUE\$(ILb#.z9e	aւ?o^nFНJ熭JUJSUIރ9-\$Wf~	/oNm=g\"m*p)UR5s4tc\rB\0?gB8aÍI,br";break;case"fi":$e="%(i2\r3 2Dcy6bHyl;MlegSnGgC@tB\\ 72	aR,#!j6 [\rHyWUy8N|=NF5NSz^e7(u5e\$Ӭa0zK65\$/Fb#|i5NHj:ezg,\"TOoqy۔n͒~?#ʩ+MQ vMXP2\$D^eʇSqt5#D%+Ð2ˊB*꾰ܒ\r)R>0o3~!{0:\$#<c\\Bĵo2\"cF,XEp'3ʘ\r#bC(2!`@ǎ~MH4C(CBh8a^\\G\\7C8^9J|+cl|9H\"'>\r@5.1ZEUXr50;RB9R#*t;MaX-JJ7p-]&`>*Vk)\\RR>#>Zp782xD\r>ǵ>艃\$T>\nX~2ש`r2SZ}a0Ϡ@6+H>(j{ȣz5DLMQJ|&1\r\r8cPcXՍ)zԕb	?=55FàX&tR044ʚIV;G%3!#03/_ȎiK!<ac#%Q,\rm[V|(iH\\.0@0\r#R|h#6_^%#ȗ24P-\03A(ZJPRDQ\"l!l\rP2\n	WTV|qfs+RR,ctxܙy0dK}-Gt P0h\nOH%ڡ0O\n:#/8(@_U!'Hm GIԗESx	3&bnN	:{\r22jAI\0y)	/04J!60-`RCHҤ#\0lC-EΚSZmM;4wBzO<fゆ\ni%!)Bb\n\"ZRHL\r)<	\rW2Q/!d}3Ԙ6'&Q+j]Z}4Dlg	W8Idnޫ3KT%H\0-#,\n3AC2pDWz(,Z&TԚCHhra<B#N(bt́7AYM2A@<YQ4\$Ql}٨h''fC\$afR*j7!0k\n#. \\a^?iCS\$!&F -d	I\"M/櫐	\$U9BR+d`X#򮙡ȥ+J ;bvբ%0b|]ExS\nKYH_LleFsD>OCsqqN2Wt-KNGL[-H\0:Q	TZfEP`M\"HHp/qݞZ^@BD!P\"P@(Lq)L,A'za<R\0PPLX S6jP\"TCmS>r \\d8P?5!EbgU T7(ȶY1WJQɩ-d0D\rQz3FXn.'T	JfB\nfK@˱\$q׹d%\$r&fC3\ne04/q;\nVLWidFK 3+Ce_2V	-89vKPC?^ˮ\0ca<e0~U썪uh`vA1c3ɱL0D8eT!\$2pJe%t\\H%)sbX,p^3Acsk'yS_\"<6S|ЀyG9%\$2-O4s|JV?1OnNr\"cʨw:+}HɅx`bJͶn!\$'cA;ut,\\	I4 Rigÿ'|%m.<\nވ7L|\$B.۝H(`\0V>5iy9f<ǋa2\r~!f\\x4+dzf]} EQ	[SáM3kEQo0d,P^%ǰ\\2B(-l	..B\$\$--p2^90 _\r`89Jl\rͰ-EZ@\r0k`bX K(/P̏:8K1\n&{	cVjJ·%n&\$'\r\rĮ\rKпC0ZСD1&8t'嚀8,F!fv^j\r(q>Y\"%hrbj\$ @\"CĬxMjId6,NQF~`Hq@Ÿ́؉A\0e	\ngн̫1V&.\r	q˱Q/ͪXF(mRl\$ry ?%B]\r#P驮16j%2C\0cT]h\0bϼ\\2F&b&ZD.Fh`ı`@tZ\"%-),)h_*2**A+`mpS,-ޭ#ߧx&H1-dq%f\$m.i 0-0 ww =ѣgDt.r[(ѓ//dPւ#PBe@ңڵnrEhkG!J]'#dygw%6CX&vH\$h,c&Y9i& @c|MN9,2O 9Qt\n\0p#'G5vH?p鄍8B)b\$j.\"fgX\\CS#Ac2\n4%AY0j;kn&#>0#>XjJ[Ŧ.n}30&%t,ϬS?\0&j+;GF^HCQoBppbC-dPR>ds@\r`B8blf Rtb\nR,L\nSV\"\"	\$*7m&ɠ7gO<DOG*H)ṼQLүkHv#\$JwH̫'vw}dd2\0\\";break;case"fr":$e="%(m8g3IeAt2c4c\"Q0 :M&xcC);fSF %9ȄzA\"Oqo:0,X\nFC1l7AECj :%f0u9hZvMqM0Pe਱L'S\$y6Mtu6JNB@nNSЀaCJy6)ҝajTB)?9=SAa2 ^0Wsg3s>A*7{z^00kL70*Cb̈>)7< <&PB2ٮ\\-,J'lc(!7\\2<cs:KH224X(\\ǩ2\rcǠnܶ#&<jv-ۆ7Ų`2\0xCC8a^H\\0ʒ|xDÀ:h3\"s7x\$<#71\\Gؓ#:.(3NȡU˩D;ABrٍAR636hH(J2xƌMr*\n!ds,0x\rTϳCJTA:\r08Be#M423}\"BȌ\n %\"ʐ#9B\"1re9)\0V T}0b(FBcለ0cȦ1PePFY6aYx(\".2;VS+fV)<Q/7V%i0 iFj|m6u\n(fW४J(dH1\nˮ3\"1ΊTc[jP'8G0<5ZIaQҙi @U\\?4-i(7{ U6L\n\"E.{70esAYG9`t jKTpEɆ1hΡcL`T)A *	<RM9AiTDY6]iU\\aoB`u|xbrM|5UI5Uϗ	ca5eHb	Na4#I'ʟ\nPDuLzJEI&H-H!顨\\<BVCͩxl\r\$Qԡ\0ڝ\"	&*NtAEBQAH@ܤR@!M)@#鑲N`dE0F\r/\$y2b*dH[\$Ɠrvd s¼9`F14Q7jгE}i0qdL4@PK)lDA@0&`BCq\r:dY C.8EɊix')I}\n|=H)f5O\nbJ;\$%ja/p9PQ)0ml7Պ\nOI\n5\0@R,7\$MVD͢ET}Ԓ_8dP	_'gd*gl\r3PgD(cQG=Ip5r:D^&@'0J! d,=@MF&իO[,BZkIEf*GL躐Xk	6iy(h	\n&F\nL+vH#<2۫xk`Th<BUV\n	8PT@.2}SUݗ*9%hg̋6\$gS\0S*yunHbyk. PA2i7Tf[ʯ4JYRlVw2{(Klh84Y:3;57or;v	agI[Eʫ*\0XsF+\$/X OpP쐾bIՙ@))jh&\\(-8׹21-}ҵ}HhWr)a۶_aAu3T>FbL4\rնXlS8!9{%)XMg\r@<4~+}̽rHxne(KgY){7o0yس\$%o쳤v\\ZJ@A\"?\"*o:J^OmK]`\0փ9]K?gi3֓+ZbLMMR=wq=\n;&ҝv*2g x\"H\nc[n]}o寧yOdB,[EeQǤ\\3]\$E2FO=-{]ѫWni(bp]C dpoĢs@I4mAP&.#(cF#P	vX@m\nsˢbNfIZbNRmТ,8`0:.nb6ZR>-\nhj⨪<;@吕pdO9kXPPeǰpY)N>anX`bE\nmЋNc\n-M>P[̠0ac!B<4H^lTN \nH\0^>\r^Dɂ}<cLѧm0-*	PRF\nаM-	:qQ~\$@sR O#o\r\"{Qo1hn>,B%q#d7pĦ94e36,jN.\n<n'ft6mv\$J8P,%efj6FtjNJiVF%sNG\0NC^Q_'\$Ŗ k~c0nZ	p?qpxͱ6\r{%jb!(PZ'FK\0\r	2+9R,Rt\r,wSrY\0003-*_.,%dQ0 y<Br13,14y2qf/2\$)Rm:cN>j\\˲_*JSO5*qri!ƤxFN\rh7݉bblS&7A839Z5#`'<5+*\"FQ<f+fS4X2oSN]\"=J\nPPtRْE#+)E)St*SC@.3(dܣӱSg46`\\(jì6<c2]hn`RڀG'E-\0LGpS=b\rV&<k#3j#8%F˅\"2溲G<2\np/3retyPB.ϔ0rEw\r454LWp(2A\"8A8@NT\n^ǊrS\$fV	/'*f2.8L5TBB5J,\rƷ&ՕGU&n̯=Z0th([UwB0}ZUM\"D4pvBJ}\nom*v' LeFTZMEQJ`ㄛi#ڥ캯631P>ΤdA\"n\n1@&D83+g3(Y.,Wl@`k%(n_Q20\".A\0	N`)gbK27RN\\";break;case"gl":$e="%(o7js4Q9'!@f4SI.iXjZ<dH\$RI44r6N\$z 2U:c@59\0(`1ƃQp9\r0  7Q!y<u9cfx(Ys~\n73Sq2AW312)M9!a'#- մ;bs[70ΗaVrLjPG4J9a\$lhE]^DPӣg_=k0,I@L @*Z;)L9%Ҭh)ʊ9?h@\"k!.x+\n	[i@1S`#\"+Z*:Ą#:3H0Q\n(;C@:lB9H,450z\r8a^\\0O:~1#8^ȅ.xDk\r3h@x!2cƾ1\r#l6:L+&t93S#MV7.R7)1(+k\$ @1*bK[ƭ+\\07.ЍYl,,[	BĮ/+K\r\0:ۣIY`P3<K!\nKH<?b{ȴ		Zbv2K_W#*=\"2s5hE(TB\nURBD)D-e#:؆</X p*\n)K<CZ󷈣{	(B(#4V9؈!M%L?jX@6B5䄾2h4}\"rc}\$#YRI@T,j\$qg(9MM %6\"Μ1H(1K豗[04g-RcrQNCH|PWpjm?,I(UV!+1@\\_y-~%\\ߺ5|E_@W\nh\n:*JgHK!BreP	mQDp@Q?L8d-4ڛӈwNi'䞓E147( }u!EHi}Qv®HHФ\\JD-6Mu`/P\\Se6&9A	=WxhP85FAq-7ofF%؟Z	@A-`o(>t/	L#l`T\$9`KguP:VH a[(Lt{8q?+ʔC9g<(-@\$\0d`Ls!ļ8BC2DpnHgk::ڐRl\r5ɺdTaAs2U|`(r:OŁ*3XEKl&7ĊIyÂXKI/KHfAcIE<\$5FP\"N(n6G_zbL.g13Щ\"~LI5Ṕlrx\0(.`aZLYַ4k'eQ`W<(-VMCNb'ϦYYj۝uja<)B#`ŉGéǭN%)PTCT]\nĒb;kԂxGLlM\\Lc2*Ocވe\$@䄌L\\2Nb~cH(x\rsp?`E\nW*!*PHZ!J}P*\\IPB	H)a<+ E	6٦ZKS[Fɛ\$a N	HpgQ~)T7hȊ5(N*;4\r'6Jz63e,rfIBM-E;TZ#s7)N3bDv眦mzID˨;_Ѻ'frϵ05x;4Rg)kB4f~v3X\0jif\r *8R\n./C81(VC9`=LxV4I~3XRt]/@(Jc2t?a[j\n)BD6#N!Y9Y[RI)1Aዾyj'C[rX0A\\5(ߙ +Kd<mȧ%=tPFQugG&GP*`Gn\$\"[/lhy3\nY,:R\$ǧ]]cHy^\0gS81(\rqǯvn|쨄S*t976JgG5om?Q];g`5%W\n9FR[yJ<M]y\\̩y`yrBГ}Ծuı	ߢ\nڣ4CP28S}nABC_f)t\"&IM3rN|U!\$Wr^oiUԖn&5\n2l_;pPį\0jU<e\0&lljfD(]Bnk0\$uCb2\$'#0PH)ZV`2WS^'w(.f4Zlz3b_ؿC b\n.d~bjӃSGp\nLˬKn*h!-V\"u\rFiKy\rN2ZB0 mάn0)NV8(w\0p\$1*q.2\0,C'Z%q.-*ܖ&#Zb!'	m-mH	QV`EtlLnhicA>%U^leD\r-\r?	W\rV5oQg#5WRD6!qD9nҋP&^[	*Eh04SL\r\0Ey QE O&U!_'Ñ%S\"^#R#M&(-Bl\0]eW#^Cb@ȾDT\rrb1ɒP+	b+\$fI&,7' rs..&o..pݧ^RL\n-\$!\"\rO0q92,z;3b%\0D\"FM9&(rΣ&Zp(cb검bb64\$J#C}G8o\\N\"N~d6\rVciJn#ҟ䴔(3)˪\"z8FT\nZ,\"3n*B!ؠ(qMo'VR<<B8><V!+K*#faBfy\nNZR5mZFFf>Wϼ'r)A\r\$\0-\$24GtI0#H(.AJtT&kcIb-zF98m\r(ǐFilcd,m/|Bnޠn.zC'AKt0#LJ\$(\$=Rp)GhpFC,Jp̚'I	&.-; HoJ{B\r";break;case"he":$e="%)kƺAAvUkb*m(]'mu]2וC!ɘ2\nAB)̅E\"ш6\\׎%b1I|:\nh5\r4-\$L#@'b0T#LIR4TK6~#qNbʨ4*MZ#\r~Űt!MDa̂XVC\nǲ	\nR\"[ŒšgOxl{EF%kE*.tOlD(n5spr9B~UݖsIN&8Kk2o\"jk^`P2\rH 2a: 8=Q 1q\0\r\0#1#H4\rT;C X90z\r8a^\\0=C8^2|9H^'Gp\r7^0d긮l(,H8,tz͵\$B*/)y09R\n7F(J2-\$6= RBHZJR	}(R\$ZP3%p_\nj^Q9e|\$ǫm\nZnJВ0,s\$+([NtcY^I (bڈ\nb}@ͳK-\0Ps\$Z%T3?9V^/C\$N(,J2v]Y*\"T:5D\"'jh9Ēl(O<003\0kC|!σ03.'5 9dw=O0ݾ4EA%Ina4n^\"H%T\"J[>^!F?6-=萒\"JBڎ->R^,fcQ<_Z@	m\"VٖCLB(b^=dClc},kƓAOJ)M*twK@䙓@/C:'!-LN2[O%F@͍sN;!VHH\n%䴕Q\$;@VK	i.%ZeLĸ`q|P(rZ(ۙ'- pU66\n1.wACb.\"w\n9Q`zB;EpU>#` H8theU38ê,E:;wG#v\$H i@2&*CcgTslEV\0\0('׮wzrpT7# r\r!?P\"\")nȅ)\0xRfРK\$feǃΝQ\n3i'pn		\"\$d`w\r1ҬGs1T%4\r-YE&E~H\rc̑,tV.U`?BYln8(hՆ԰@Z\"N<E!%U_e(QaR[%PTDH!L467uL,H0aQIcE˯\rZm`.	)<|`!>&Pi\0\\ju FT6hK6՟GY%Q`IU>|#jQ!}<EhXBJB4ӲB\$b7S?JKD!8KA⟛wTC ̍B+΀oJtD\$b9r.	`\nj=w9y7ZKiq^KiAMr\npQwY^s>1^FzjVhQSz`6Y3Psa\$\0^ۑ@ZfPtD!~G	@ṵJmÖܗ)rYvZ\\jc\rd!jeGN6Kx̴\0,AàUػ4/F*c9,~F~a` @BHWsmeFS~G{=\"EͼsKxD44*DNw\$嗔#fa7]k\$/KG\r^k`җG\nUÌAsQ\$FIVVQEEPm\re~\"U0	7j~pVb3|Bhrm5\09ӬD_otahQ!X1f\"M9Ft2C#hɖ\\ܶKJTRHO-*,\"D\n87RC7@w|6*@nY6GW_X6sԏFVm6p\nAkhoC.ػkw/:\n?7wY#N	YyiJ(3.G\$p	-6	sCf}t|_DW,8}mV?u\nn9e-Ηmeyl%'/uZxO­jnrL>⚽K*iz:LB\"̢L-\0Bdhxo\$.|Dbb8D\$\"J/'%K\n|h\$\0kn˅n%	ADwŘR\$.2\n6bb\$g\"RwN;YڹP9[δR&*][,>\"p`pe\"&fV\$EYb,:2L\rhG*M:\n\0IPɳ7\$C߇Er]bKuаHeORm1^ТKLrm>R3Sq쐤oq\r/pޯ6ʞ-wBlY_l#ñnY[`tqjgE#IIdECA=_l%\"Z{@H@pOO#6&[iժ\nR]Ȳe^UكB=b@t!4ެ !C `F@)V#sx ě.:!E~,XrZ.,nE|ftȃadA.oZ[Z-z~^Qk1\"3 KYōx[d(xbpxFX쀊B%,H+̺>Z3Zeo-\r< bIzsebd";break;case"hi":$e="%pRX*\n\nAUpUYAX*\n\"baTBtA4!RO_IQ@q*`j:\n	Nd(O)!\"5)RW	|`Rő*?RTDyKR!\nDJ\"cU|\nԳu%g\$I-=a<fHQHAԴ%[M._bQR\"#IrpGvIW栧Rȹ:utn0cv2mp\"\n!(+=Jסi>玲Tp[&~.OxH<((/kͪ4;l\04dEkLZ4#\rdC EA<>	R9c[ʽ, \"zzRD<6H#n3]&QHZ4RMTL<_>J}BK{	CnTET2rRRPK#R&\\a;)LO\"HJ4TG\0UR6V2JW\\CB4X@4C(C@:t# 4(\rp^8#; ^+A\n΋Ko^0uIE#xm4m%+IKӟɹrDPD?`fu\\IVziy&}:j\0NzR5BA^'F'w**m)RtixmO|;ucveZoűjWqU.krڧ8G\$;qqS}*cc9Zmkc6սPcC5+@)\"d!ܽniQLRw	fv{h/}O]\$҃89a ܳ39=G8I6&CMp4x C`[ʚ5.);fe=\\J<6՝vȻ=iRBU?\0UjNA	>bZ,U\n\$B&.sjș#dim\"]10D+f XE\0|VCfIѠRZz'AkƸZ#r5i6x`{\\_ hm>\\:#9\n!KCDE~	~rf3hy j'\rA:(LGHz6U&ThUP'.FR !y)\"al*b4r@\\.v,l7Ch\\yqظ&M4Uy9C)*D5)	\n2WjUPvjjZ%̈́yc2	hJ]x5_6\nH/7icbԧJ;Ea3h%ԁnz_ɄیY\"\r3mSU[#i0az?*K51E>Lӥ?E\0=38zlҜJwhy1]WFr^K{/`	0f(x\$93\"8T\\\\\\NU=Q:qw+tjnh}hBv;dKE@֚VӉS:?EjkdFR#H掛&5'D[P\$r֠:wĂnb&9W@@P}n^AZ6EFgWRVjA6)Y\r_!\nrT\r8Bk&.:ga)rx]kq`EˁO'8v&7EnoH9X*ħܘ{#\0C\naH#=FILk1\n'[ͪ#NHM)r)&q%>qJy90G&%Q?,[-8/!3BF#|HF['*Mbd)bR@'0AV/:-KRCF~<{c\$@*{(͓B\nMews&?7{b^/ɉY8H[`9CUdrH,l+*͝95c\neڇzNV]Mv\"\\o5]{>LJ6ps7zT	JΓcJ'=[}AjAc#a-B+yk,H}ʡ-4bIF`ZZVt~\0%s/ᄫ)IǷ6)/jvO̿I:nvcscbOZr4xZÁM&ry<Ʋ\n.ݙsͤ[CLqt72[\nM=7\$vswp[YdӮw5o5ݢO>f\"].E,?Cw72_gHzզt,~8tnxhqP۩Ɔrki8bC<\r`@Ҳf@(V<!ojG/@5·Q&o=֔9\0*hsRJ\$flnufEtOFO\"kALhrCFk\rm)	cdor\nLN(i\r\r\$y)H0	@P>03jo	NDz#@Xj=\n-~ND<\rM`=Wq!\rkw0p=:fq?q^;bQdioV\r+Nzg&#PFeaʍ\0\\,F-Ap\0W*:TOO\"H̾C+R˚fO鐼[Oh\$F?jzA\rCDgMƨ;S%)\r0R	Qj禞MS𘒢-An0A!&E&R2%v)KzLAfe2B2؆Ihi.e,N-202*HnL:qNfx'8D8B\n18NF[qHtd804sTm1\\Pl(i3-k!^P\"lTB(\$s3*\$fjEL=R9(TNjXNvζ}c3rk0;7;[NZA0fLr(fN/s>=+}*s\"0'49	I1R+MC((oh.B+s\r/)-<g8GC1d\nP`4xB?	2Vэ@Tj4tGtFІ;lH4p\nm\0h@S=nTx0H館\nI+_J̳QjZD8B.\nζn;h)-KfLQ>-XTLj >_H˩:4o\"tPAtIoďG+>4%>rԫ5>hg)#@.(3TV/܄/QFITyWĻX ͣHwI@UWt7ԅVYRL4&xiAeH&d/ܬGR&m)MCʋ-T].>t?[UUdʋZi>T\r[G+65[=	e\rc!\$Qm7Edv1Ura	aLMfuE`U_ajy?3	T'hw6~t5@tG<)j01jvjm?5gjmHvlv`֡e#o֑\\D5ZDʘʚtp1]7a6gaHQ'p@hw	pAqqVW6SkS66ehG4?(ěO80ï]FToTVQc7fj06R62kPuP*r0N4Jch업!pTԎ%j~ij\rWxuUв<# \npih=/.C<+nDWX;QD7z7x3vLQZ80P E&7c\n/rF7^R9SoXŸ-M|,(ʊmpchl}oWdԣK6~wygrN@?NS\$n㶃m#G\rƠ{xp68=h\n&oK{ǃӞyR{#+.{U'	g)w6Egl֗p.h	'hrhimIUtCDn=q2xOJ=19\r.ObeFhr18F|7ndf:HoB4ثSyF30Z	Y0\0'&G4rHz6'c#MNQO:\nC";break;case"hu":$e="%k\rBs7SN2DC3MF6e7DjD!iMNlNFSK5!Je@n\r5Iz4B\0Pb2ar\n#FQis'jbRa<4&812k2N醺9`SijHjӡxH/Iɸ*,΢G7#Ildb{aDHedMänMi[.?+ْ͇\"s0؃.j/\\daࢤt䥺xP,@*X7sT9Cx8ă*66,k*Ιe%#OT 0C\0B(\0002H0ڕ\"n('1#3rC,4,`@\$Bv3:x=Bx2I|6ͻ3Bk4px!T*#6\"P:C֎3K1H\$Rm!ci[<IM\rH\rPP/N:6ږd52bzRF:@3, ,:*+z\"0:a\00	mV\0cLR5c8ΝCς/CCSBHԸ0\r@5YBɱ<.+b7y\rc00&LLL\"9;YW˵\"KkI`I\0U.<l59,\n\r}\0HHb\rӑ#\"5P6,#*Nc{~\"Y~a~-G'h	i	(04:u|!#03t'ɫB\"h8HA5Cw~V2\np+S#Hb\"\"Oh2e٩l?bbh,.8ʋFɱ6jۆH%L#ʖ5ԦC2)AԪ#張L9TX \rf#s\r&P9AD~0\n57:l684{?\\ nY/2\\R	)Q8a{jiDzÚfMvrkM19'D|O+E\nJ590p#PtxHΦ]Ii	\$tAʃ ULRC9~)hdFs\$'@bFKrZ!3G`3&<iNQ=t9tK\0|Fh\$C\rG8S=HLcԘu!˪t@\$	t=IS\r\"h%snѿ8+EͼjAB1<!&9t*БRA P ,1Ӝ՝3}[K鈩5 \0F\$aL,HKb6E{uc%%ęjR\"\0Nfմ3r-:yHdYISjNËd3!R%4=HH1Grb*|˴\"P	L*42j̬9'.c#SmR9\0*UD\$qU\"~K!\0-\"_`CB&nUKLQVrE` ֿ/쀫JMg:̑lKx=.MxT1crBC9XL80tG#B##(\0aQ 5K2լI2*39L7%2K[tOJ&иbxiql@+eb`dZ!*Cu.\nm8\"O q1\$6*TƆhrE5\rKF'd9&NA\$-|C*q+Cq7g\$^<6Z̭HFB9zb&U'oqA3LYpdTݾbD0nv/ۍ\\kCy@3\\,jg(9܋bA2T\n!AhuQjo7K7\"K'\0005&LvIZ-bŢlk-1O=Xmn/˞0e9:):U}WzӣeIK'κ<c=`t\"CGJ_ݷ-GMiϗuc9'%YTIBܸbnIHGUR(~_WA7pŪcL`r5\$+Pw}=(HO.\$芵cX2Y![Q\r7Τk\\X={\0%	;O8J1M#KmYA+o_gsTY\0%bWh_\0V,Κְ,R@1HlTB43v': b\0By\"\nB^S'.&1œD\r,L,50v2L@G؉rjL#g<gX-B\rx\rj*g @L	z%kF,\0m1\0O̲kg銙̢9#p++cB34d\npEBF!Zκ.n=,Q:.*7.m8+i\0^eMIRqa-gAB;Bjize\rAA\\b2)IMBIRhB±p	>]MCGC':,6 h\"UP=,&L,'V!Bp%0Wqw\"y\r\n(WR7p\"\"tLG55J.R/%re\$P(`&*1f'g'rPW\0)O#@224N5\0*U1#j2mHBRq'|= \r-3-a2N.2.)::Eb\r6ȚT!i2`#2dK2X܋(B>2F!\0H+6h{'16Gmm7-˲Wh{/f](RXfDE6Hf,3u&:E3~'s%Dԭ-r?Idd1G0Z(<lčʺ1ni?,]?H@?-\$b:/BE	NæDŬT;.EYCU\0k[KpS\$_6PRBLTkFG\nZ?BUVr-IJ\"eJq?J-JZ\"\$\",\"L`\$iD\$|! G@\nJ0vOp@Ӹ&KN=m<1%1RR8mT	6Z% 'd~OĮC8]VT)%xm;BK@Zsd4ɈOV\r=f&\"_s;^zj6n/\n\rZ1cEilbX`цDi l	2mp؆p&hdRp*̄ĕ`ARr>R\"3	CV\rW]jVWQfDa3ǧ0\rBv`a\r:HF\"}cP/lt\r";break;case"id":$e="%(i2MbItL9(g0#)a9D#)rc1M'I>na&ȀJs!H\0Na2)b2ar\n%D2ÄL7ADt&[\nRa\rHΌ4cp\")Ũ@QNi8M𛍘'ȋ&a;Dxr4&)KFʝNHhY7_udA<7zZ&psvwQ p:HQKEYP8-iJmr' QB`̖\"X,Bj@:`T9:62\r:\r(A1B`8KNC@9X4C(C@:t㼌'P܎Xaz9^'I87x\$B64P\0&Mz:P :6<s׳o7NJ6P\n\nT	cx7\n\"-	)sQ\$P:Sz:0c@#\";1al@)z6\":0M\$hz@R^3(ւ+W5>ͺ:ϨЦ(P,NChQ3S7OI5bF:X>e63LN\nMkX#(b\$^Iqo\"dX@P^I\"p\$<̳:Ea1J+!|&D\"+k9X@̖ugC(ҍDƐh>[ڧ;J\"#5FP2ә0VƤ3l	s\n{+7-CZ6xΚq<(Ƴ҈j݌@HnErB%P!\0BCh1D'1w\"O&R|2Lut+B½LxĭƞfZx4)P[S7G!#Tn>H		\"\$`K=9(țnagUlIUXX@ EH(9:&X&	c{\r!Ↄ\$y3m܎CGDd:Tۺuq(ӔhA	pҮE\\msRj=ЅE\090?a\0POIF.4ܒ4Y:T-`!rrw 3?I&\r(Ar DӥvF0sP\$՚'xFQQ@ЖLmtFpDi4u!\$h?tCi<#IԢky\\왓RoNFL0M\n	\$<bd',xԣ⮏p Ǫi<i8jmBL[[@(r'䔒cZx[)\0cJr#Qkj\rJC~b'Mr	*G4\\0T2D!S\$JCpcQJSxxNT(@(\n \"Pk\n	фe9^.hаrA-R0\$Nigа؃-sbuU'3V1ߙbciWMby\n\n!?(\0S\nv\$&\n\\QͶX2û ut\$	L{oMzWm<׻g\$L:\\NW1l8ah\r@8[o3A;EnvA#'Bf@k)y\r0֌PG:4DpFxP!/R>D1]Ɗ5RU|Cyb8CHmeJɀ\\ӑ]\"瀱@BHy\"dTCHrM; /6rAx ,*tf	Hr;SiR#	Q2\\'n'~s͹dc~	Y\$Hzs	^䁳7E	x䕓=}92FJ.>r]\r7^ \"3OծvɧX(6n'daH4\\\rkd#J;,~A\$JDLiyδ&'ix\rptxi!!䊽&d\"JEvx!dNQZkr\0Ĉw5Xa;a+W`Klmmn؎:X16֧ހ]ȹԉyG+6{.C:1de4U\nlX{\\3|wO50A(X+9*Ed\\t?!o,)08тcIaB%5{.&LM47'\r'Su>>\$A)~_#Û\$牂o'=qq'8/t71oNDd\0	h\$\":ӣ&O -k/bE\0N8cJ\0*#GN\"\0.	 O%?`NSRF0<LRVX#&!T+P	g~%0W̰!p	\$K\n`V&OƯ\rcΆ`\riPQd<Q?chU\"pj٭r\\UP\rvn-\rVp!dƨnW#Ls?`vT\$@ҡ(k \nplj\$L1b6c\$Lnόd5Ff	&8ORD;.Ȃg6!cz\"R\"xQBjߋܨĶG. #/'@H!CP>W-		6.tdfqB\$,*=%@\r(B\nf\",RHd1I~`p,&lHDŲΫtC&Ep0C9Ln%p/+S24nC])b.2ܒ6 >`v`oE\0oQ\0&o>";break;case"it":$e="%(a9Lfit7S`i6DyA	:fL0č0qL'9t%F#L5@Js!I1Xf7e3M&FC1l7AECI7!li((\n:Qg4tDa1E#2biiDi\"4ԣ42kxa 8c=z9F'ZUAv1ü6o\"ty:{Ljsrtp7lE6J;eN{)层qcQMofVqjh(&cP0	 HsIxܶz5#eP2\rT#̨8.Ͱ1l\"à!R8@82\0x\rC@:t㼤1\$L9˰|xG ^'aA3.ɔ*!^009/\"Pc#;0=*`~°JR0T[!IKJ7p7Ȋ(BC|E%0\0<MQUUR77b!>P15D+,˲4ьTB?73-j2\"ZسV!U86kh`S!ȜBİ@B6D =Oʚ9Q#Y\"\")\"`0lTm+>FR[{?bcByQAH2\"޵D7GN\"HK9D2߈#6~jB:HC#<0p<SM!̵܋'Ý##	\"SFcoZjNꆡ0VVS^;O#ɷ,kV3Ka<MPAZrsf3]ӈCU(H+4;_mDK|[M༧O\$RF0<{d\nےlGP1'\0 H\$\$RQ+!ty(r:\$Os(U-A \"Xr{E}TJ\rB=A2^\002C0\\`F-&Ҭ\n-[\rɍ2FUm91C}vjrBE8Mdthcx<%hV ?ǸaO;z\"AB<A<,*6Sd96+\n\"LO-%2\r, \n (?VPa\$R\"MB-Yl-\"LKC4+J49^Rl\"-H6bL+l&iF\$&*C\0C\naH#N¢xRҒBY(i61LO\n3:|!i>N>h6ݒ@)6xB\0:a;0xS\nfvUA3qhIST9{gɶ(#MJ8!J n\"d0Pa\$#A*LUCA!\n>Y\$0Cf[N)_<'\0 A\nY@(LF2nGϝl\"#\nf;ET#*[)/\"V+c\$iI*.])''\\P*dXƏ87\0A	FD)ŎcqQ0)?XJӣCo[Fwf1[`ŜCXxOcKND^:<J[ê ظpår䤙09]YG4~c%6BQúݥo46up*6\${8yDe֙Xi7tJjUnYǄ<22_\0t-2-thAa .RR\0s#:{#NYSiSh*Ur.VXPdԺX<\03\$H_n|k}I^Ig%\$Y/&M&U8I&N=Ow,E#u^5;1^i9RHb,FR}fGI@},'Mš[p'Q*\"!C} TA@:!سQ)/ƎE1 3kAwda,|rN>_Hi6|I	5[a̺ F~@d x&ZJe7y\\IPxlؒY-Az[s՞G^y}w%9.+߃tǋVJtdĲxm^3`'ߜHHc+:̯o^˼=D%7o/{+\$ߓ*I	j׆{8dL=<K?'R6r8bF&̘!HO|Bn0&,6&p#e\rIlWBo~,nPlp9LdOjLfgNTvPtU	gTF.eB	D1j	[\"*`hkx˚foꯚDr0\rcw\n<Ů0GbF(`\"pxQKs##R̍l\rh\$&eT Y\"̱,30* I?/q4ND:T`ͣZ5N..ހp!oTyp0Qx?rqnteήC\0QrT\n&11Q@&eA0B,:1E_DdDU1ܐ.P\\%jV^} /2Ȃ1b*1jJ%>Xǚ(c0r/!_!\$-4\n\";\0`<,cMFq~gU\"B#B']k<\npOx\"Vh-9~\r@ZL<0i)@2ik{%c=d\"ϲVQ\\\"2P\"<LF-Cc!\"V.R'!-\nniHb70I#E 	00)1/(4 /{1s-0K\r#1/>`8JPe3#E.@EF<B2b0bC:^FD_K+0'ͦDF\r1	]5frmK7EPKtf9S-kDۯde<g3&SŌ2 \"))\rpoD#";break;case"ja":$e="%:\$\nqҮ4(b*JqTl}!Mn4N I*ADq\$]HU)̄ )dt'*0N*\$1)AJ堡`(`1ƃQp9 b:W&K<^\n2&(z?B(k\r-((b+_SANuқCKы*J\nfYz(2\nAǲلI̛Z9L1T*])fCW)s~][S9ɟRkQʊP{=B3]\$I锍P@Q<JpFHbA+DDE8(arsqPb}nqi8') F\$\\TAň\\('(IfsPrKb6#p9)AҜ%\$-L)I@GjBNG)^_83ܐA@x0@2D49Ax^;Ձp5ͳx\\7C8^2x0cZxDARY`|ɑA~N9F2ztjM\"i㖋VAA%s]	{tzV![ZםiLr\$PDro_(JADtJIy.Q\\g)4!EAI,Qĩ`45BeنdQ<evs}^2F%Rroy/\\P0\$Y*r&۩BVQ@P(OKHn\$l!Ps2tW3q/7)Isk2Ű>,Z:N28Z1jAcvuc8jM3յ8s\"YU`Wv!B4⾄fYԉzkf-J?#p |\n\"X+CB\nSB,A\0 G0ZaR`(ۈ>P\n&&\0 \0ȅ(\$5QZ%qC	T d\$1A	LLN!hݎq-0\"6Co%&gvIf-]f#(Cp0hUQ#V060g,h\"1W\n\\5&!@T2fc\$2 L}h! ?M>UTU_'V@t\r3=a?o	@.C&ޓ>tăPDΕ|\"F@8\ndxZ=: }StN!䩓\$M)zTT*XrZurCtWi0bBA|\"K 6H]`7(p%')|\no20 \"p.HO0\$#4j'ܔ+[O33qCdReJ]b+A  iTS>vPP	ACWjD!1 a\$cRN;*ARq.]A	x\nK(YʢRr\\r=Vl!d1X(Lrd)%6Bb?S8Bst9{	F{97\$>{qnM( O5oXEPC\naH#FP\$3A1,i\\TdmSTkM{DBC8L:lm`D\\U@'U1d2CmX'9E\0HRZכl]LKW#c\n<)D\$<ǺSr'A, E2R)YrbCTn09k.\no8'J1\$p1	4GVl7)Jf4puq\$41q3äAJG%P*P\0D0\"VBXHI,4  {?-m5\050	(P2<79e\"ᕷNyۗo'.[.:I+M`38#!()(YĖh(tX `XJ,BUTyk۶JZכN֡>K9u\"8Kz2ƶ+P*(%/DA&YyNq8/BIcEż<|o\";(\"5ֻQ	uhX&Ȼfx)R7+rkĆ4zRVIӨ&]E0BKj\rHZ@j,܉}?2.=R!/Z}v\n	!4&HHb&M80\"6`E\$nTxŭO1k@|1I\n\0R \\?c#x `\$حO0</\0D0J͋c.c+:jpCG)1\n6Bpg\n6*|&\"*ιOt\rSxF*\r3}H+#*⍨-*AWo\nL~<7A ȁ*ȸE!~pGp(rlvB\0!X4L5_c*\"M^%99q!85 [bm1Q.Fr0ri10)[gTDH8bv0,KadfJd突A.#1H*2njN	ؤqѰf&LA/\nIg%Qxbӏ\rȨyno^F!#-Hb\nfaB!ldR߯1PDK\"B0I\"-'M1qDDJP[SC!x+gV2\\'BB)\0b]-HmJt\"Q%jrP@қ2U+mG'i,7\0b E&&\$\$3Q,cL\$\$ &\";#g֯/.T}C+	N+/bC/24ڪ*'<Q&/\rl\0O\\]B+o\"+qm6,sj}%'Bw3s,\$)p7rq8/8V3:s]39\0hN0\rACR^AI<3q(1ODX!3;?Zvt%zòjhI\"rk2TiBB'yQҎ>/F\"ESEJJf\\tn|p?wET􋲁ts`9tgIb\rI&/7H(c:R.*p<I; *HN\$9bG%IԴ.)N:I9Wz?u	%)tka%P.62f\"Z=\r&~(t=s508\"#Gh\rWEE/\\q\n&\nZ?Cŉ)B)Fԩ5m/GI#Rg#%fdSXux'BD(ˈs S#`B9\rΟ~*%c=c pajy+(*Nq}~v@on\r=ո*tc*7`8be\"ceG4\"[6^Q?7 EEg~F( o931O64k\$Q>viN!6sAP\n`Z)gAgxa?b;/cF,m%%#ddVHGqesDڃ͈ZfN-6B\"5F/(tFLA";break;case"ka":$e="%)RAt5BPt2'K¢:R>5-%A(:<PSsE,I5AdNi=	  2i?cXM\")v@\nFC1l7fT+U	]MJH^x894\${]&?O:o?LLzT]QmQ^dQ%M_ks`v[Hn+e3TӉ%v,V3ARyAi__Wr) QnK[\n֕k34iADo	(1\"AP83t=RdV&Np-N+6PL/kK~ĩ;?<RƗEO,2ϠW&|*Ϥa%AjZ*%1~r¼H8ŉ3̭;@ h7[-#buHJ+S[27\n=:&@!\090z\r8a^\\0Ѵ}\"\rp^8#;أ ^*aQ)x!4AQ~4B|R4Cn]tVK\\J	t-MniE8.hHeZ10\"+<ewN-1QL\nSs%2vHJhI²Y?_njRn%.\"Vd[4ϋ︗5C4ھλTj\rROi~N;-8;dςLH=̟7p>JI,YseZ5AIc:2M({jXڔj-hTSi11ydwm`=!M_ܓ\no1̠27\nO[l3|lWq߄ݾמCAԘEk#huaUuA(Cr!mbC\r3,H9\r=-	xXS	eiU@s\r0%h7chטdmόR*_{́wx&i RVZ@]F46@\0c9\"/\r~ҿMK)t(&4`[KLLA.\$oỘlSTLGP+?dfF#`^Pp&C8g\$dʲ@\nRQnMçlhU-Z\$P@=,NUbV\nZ+epX\n:a,EPda:FִzR!R=KdܽWbrw'։:HfZgri\"&IȻ1}К5fLSgQ1Q(id lV*ZurwWaUV@x\$9唵T ΰ	=\n)YNPc(K^NǤ!NVj4OuZ2*FcbG'z\"[ &I`\$qedGW1?rHSD(v:K*bE12]B\n2+^\"5,!7qf0\0PTIMюfBW`MkrQ4GD?LJ(Cg(Ük(~΢HsjU!	*CliCPylT%+?Cqi1Bm7ރ03\r2JW.m]pҗ[OY{K4xHaĨ2ivui\"Q8dk 2_\\䡰3ɨT͡+COU'Ma'EBz/b(Ȥ]6O5BkAfLBO\naR:(~\"z^vcy1G6;QRʓ@A[7.sή{;PΈNKCӼ\"%\n}zE2ˊ06P(:kS['UYFZa(I)Ycvu'V4A5&M{x{\ne22|1~}ᏥIF-5Ikz=|9ĬM2Ǧt\"յ%2bߛiXmuݹj\0yrie	^#&EciZw w/߶'A_J5?%nV|49&M㷭\$򸧕0u\rHֺ35k^\n 1D:iS/Rڙï_O}B-AUp`oX\0C: 1\nxtqה;Bm+/X{H	!4)!hfA6\"2q28OoGFzq6<FJSJL=&ervq4/w}J~\0PC5P'`eᆷ\0?7;=X@7Oʇ//\0b.4oW־,Ϛ.:}B*'*Z7\n1CNI\0A8@\n 	Lɇ^-LKDPKT0+Z=oPh-,10(ˉHI@ޔDɧN(A~BAB2.:4N\noΖ0l8km⼣XGз00Jͱ\\oDo\"w/&>\r\$OGnMI`puѢJs\rF?\n(.,v\rX>d҈ttH\n\"'M؆FPgDffC\nr)h\$f@*Ƅ_&cC5j.V7|Cbhͤ*3\r	7Q\n5.-{㮟MO\\,jGE~Ǣx%9 t*c0/X-Kf԰j\"H\"\"+rod\$pqfM&Hg6-`Q@D\r&u-D\rycHTn*PL+,,Q*pϒ\0Lg7\na!#%F7B	r⼏r+vQƆt\rsFSqٓ2tl(m8l4~i5[%̠#2.pP&Hɋ'p3Q\0#fӊsflN5&r^zz?-W5F[i\0\"L.oj=3(;3F^s/\"k'i.?i\n\r0\nU-S@J?2Pz6n'4\"34s%A--Bh21T4| ~*C21g-TM.g֯22iE}&tQ qGG=GTBD<TQIm\0i	4Y5))PjF6*Og0so2nNNh21!tN\$/5EuMEMkDch+Vj1J1MIrGOSM;nPBWDuRI4tl{&@AG/UŚ Y @6\0b@\\V(.#WYW`WaVP & X@o1!S7Z1Hm[(ZCBv#hZ9OR7TJf&TF2H'^˲NTp'ZC\\OPxPd -N\0?rTqA!?oIY2|9P@62	bQœTtcF2S3sM]281ULjk^CH(q6MT]9\"I()\0\n\"i7c~؂NH\n5#:1MSo.Ӓ8DTa q[.nPpN#hL4RP\"bfoidlFVN[F>Av057`1mw%Jkj\ngBrSDos;vQymP:\"zzPMՖNNWB7}CHdרjM)8-<|y.}?L&'.ME@r2	Hfi)vƻQ,MUoHU3&O2zJ.SI\\%#[/Ben&;M*mG>w'cnLL,g#N	BLi*nfn\nd|@\"Ｈs8]`uC8V	e&[u{0:";break;case"ko":$e="%b\nv%Ю\nq֓NU)ЈT2;db4V:\0BapbZ;aا;O)Cf4(s2Cs;jGjYJӑiRAU\"K`H:kBuYs!al/\"`kێri؆&XQ]n:[##i.-(\\T\nRO)ifv!s;z}QK d`'cIϞV	ˊ[6KXvEJ7\rcp;9\rVu\rXk򊑔0JDB\"ő	@JH6%4Nu\$!\$AL1r֝2/6Na0@EP'a8^H**uHc k괄 ޷Pc8B381kx\00#1+@@;#7p@8O`@N@2D49Ax^;p.\"3(F|\r>4\"6#H7xBpyBiNE &e\nxv.\"ƱY{!et1W)eseiU/)NF\"%k@#X6ew\$nJ%BDQYG(!LNπJ#3:gPv#NHp2dLUY@V.\$D?ӈJYX͓f\$	ԏ\0Kصcen9c\"cU\"es[!4}\rH\$T;vˎvE!SsÛ=ok߸G{1);AlծrFT^5d7!1}<Y]=5%{_`XB Y|\r3&:NÐ06\r|!03#/'qX4zo0p}!㌣誓d\nV\\KE-dIb)SuSPcȸ%DIؕ;lA{lAPܚSrxϨsQ9C@	}d%ܡC((`	t\nd,!,XAj]DA5aP46 jyI%ȜZTpcA2& RaM)<TNUZb~_*DR>ϞC6!JqwQ Sa5&\\R\\'K)!hqy+	ZÓ40zRjUK6TTqS%PK5X0C^\r:>w6o`A֭\n-*B%d1*eB #e\$JE^ %q[i\rl1+rL`A3KTaʮmnDk\r\r|0Ͱ@\r,25X-`4RiD L>;фBK\r1ZpA5XlA?uAu	*F1Y#HԚ}I9\rBu\r1 [kmo\"@014@<DEqf;rҕV\n@L4GHJdM	FD`TUA1JR|\nx)wu)rT\"a38[RaŒ<@m\r0X~PUDUVxS\n`O(%{	e*:Bl.`;u0 Eu̯\"҂\0H-D#@_/&V&EHZ\"_4JvNF'0P1HJTՎ2.X-3~M`Qˎ`u36kGZ.Hb},a1ɩTGPCtF82\\D2\"ܑQ|G\n3sHFZ| tˏhs~O̔tPa4~۶YV^5sCm/?\$pB	.G`+8<t2v':ӑN΋UB%\$ERE*0uI(Ϛ6&Ku}b6N'j6ڠިdtx6'\0tRZҰC	>;n7pށ\$7W/qfk!ng.?W9m\\q{48Ca3͕aNtts|9'&1:qJ)M*N\"0C>~T\n!A{HiLj.ml.\"*]`&{ufótK[!s[O5\"\n5a3RQsLi+`>`y۱ɏ.ޯVz4h˻F*Ka\$>:ZPv>H5QS#dX=0lbPQ>%-_nj+uQH\">@o\n[hhng!\"=A;^e%^V^( c\"Y,OXx=	@89.B2%.	T\\\r6b o6EN4Lb\\DZDL2h*Zv1Ap=\$x\$ 0srApC ρa\nmFx|^an\rB%\r\0d`چjgJ\$N@P)1MSs\rM8A|3iC,\$1(ԋ^<4{\rWp8sȶF6P|441[L#Fԣ̱q瑡}^9)\n<j!\"\"lba2%Æ&\$BCd\0*I\0*-XlSd>qϺ))*wŭ\r1N?\r\\ܰo\",R2r9	Fw#an]rB&/\0K%4t%a<3B&nd ;\"4cjmâsQkrM&W;+}\rV\r6el\"f9r|e2\0<xf\r\$dD@O\$TL0-~Η0gԡdIjS0H1bV&>L0.Kꑑ+RJ,psRVC},54%M(('gPI.@\$ђї8TiZRS8&ѯ'	`*ҾrㄷLy<neav4c6+=@?b	(9<\"G'% :0uS)!+TCph\rV\rgz`@d&FVy	\r ̆%`Eny+ܲh\nZQ\n>tx\$ul 22rSuMւ8+%\"#xZh\\!)(5\nOJl)|oR5Ԯ^K9jr6ho!KNJ223&\"*橁\0ol^frc~Layʵ\0a6/ReI0!;!Є1T?aC\n}Ho2\r3pp<6Q%uwgmNradf6Eraq5\$B\"@a8_C=b&n(nG!m)EU[eR\"%+t-bbb`UPƀB\\l.0&x\"8 ";break;case"lt":$e="%(e8NǓY@W̦á@f0Mp(a5&	scb!iDS\n:Fe)zQ: #!j6 t7\rLU+	4Y2?F9%A{0e7\"fte2L8)1T'):ubT7Qdu!FQpS, :07a^0N(a:6o݈\r'*2sX*FB'W䱑cY=y#pd݂^xnNG+Tt#`*´c`8	_\rz\n\"(cj`B֑\rC	Ұ;\$@\r1+ȑ\"6X7겂5#:1\"\"l\r0;C XD49Ax^;p#\\z#.h\rS8RHpx!: 8䌐PR.bc,(U2<sp\$P\"7-:\n3`Me-͝dC`འ	c|4ѨӉ#pc\"L2T,01#z\n X#F/h2Hk\ncX,Mf\$5\$hpZC[&\$n*N-(2Hߣ`6L1#s(D&5;'\r,K|:\rcUSCx9v4@/\0QbNN0\r.lD4K5`Q\$#yNán2\rf<;\"UW'_k\nh\r<0nZ9?#H th̶bC/^&iBޣ\"`خ@?+~sy</CrEFoD4hÈt&Oc{(2+t#]+H&3\n870؎TtD3Pq\$\r= Hf^e7פԬ9߬p8eД	BNg@C@,C4}	B8bm_oQfS\"fM	6&Ӓt'<'ρoQ\\#?ƕ\"4%T32Dsgt4:EH>^xp8f8DtƼbRiMi7\"rO)Iq%vUY&#rE:F4HK\ra噕\$E9\$A@Ru\r[Eql%6lL䩇Hid^#		3r7*T50@{a\"T4]I\r%GibFHhmC@\$]:CBPCq<pӢiKwR6!}qbd_\nj%X<Xl~<) %\$#(T8n,)a2&7	Dr!:) Wy-T&zKc:/ͮukXDU΁\nʕ)I\$\$Ġ&]9m8wYI0w46<rXQDJ!QPrÈu43:1kMy	ᔎt`Mq	L*V_Acc\"Ul+4\rdA՞ĳam투ض7	ۢI<+c5\$m9[-@\"z@	Ĥ9NE@\$KR:^N~xw5_gjYV\0(No H5÷5q:<9v+(r1K_\"(E,J[mߵvPx-YdܖK{/0oZbɨ|LHY.7ޒo_&c(!B{\\H0*c\\Bhޑ8ġԦ&_8\\BdUͼ(3q=\0(&`'-Ҫ#Bq`h(wAx]2gQ\r̀+ึPd|:]	'CPZ!AjM<)s\0c\$49N.<űbR׉KjW쭙byʧ 7#:P\"h@!!P*@Y}	o!|*D_<g6v\n\rsIjd,fzz'~PL-@isT>+R=PЯ̡Ԇ\n͹'2<:֍cs{<IX~f|F*DDpwf%]3XNԦ/Ve79gx(\r;%\$i] Hg4	dиZ/^3ra;w(b3i(!=_\\.rw,.d,#dՍ4Dp\0Beæ@,܆`\rc\rBJFF9?w\nclF90@\rX\"!,&4,:͢j<6(|<\r%,>B\r\rL\ri>@S*.*%]̐\0!,;lYLE	mKo/P\0O\ro0DL0NЋ1eJ()a7kR!0\\5^GܲOۍ}8*QrT\n[l-d:B,G\r0f-Tt&'iq(j-Ͱ6|8\\jK'Vouee*l\rG.ࢪؑW~eo Z!flpVlWp,O#CP!2@5z9\"\$\"%DNj=R=B\$Ziè;\0%#5r.j[(f(O&._\0\rC*R=*+*+2&ATâخ+	e\r\rc2@'P[`#RrH(.50/S	ɠn#! -s3\$Ql<@#+4n	%&+U%\$\\A\"(l*no74|#\r+:0)R=ƨL|TC\nY\n*7Tj#(cn\"Ӽ,ӱ3<9<*6Y(b		=E2F%*N?-@2?\n!g0*\rV0EIJt+9;nB9\nw\npy(#OL4b?d\"4d\"\\Dsr@C`@#{b9eRb-B0\$p9RT×C3#Ԥ9DH^*Ս\\Y%\n9dB4\nNA eǆEB'!@O\n*P	H\rZ\"P&DK6RP%!\nG4@1BJ\nm@U1%\"af81ָ%70@Å\"\n]1ΞՂ2u%\rO\$`	XGƐ,, -[P{`iQ,,jX躵wX˵Udbb?@٥-ɜ|B?\"10@\\+И:\0";break;case"lv":$e="%(e4SsLq:I :SHaa@m0fl:ZiBf3AĀJ2WYCf4(:T|i8AEh2q1M~\n7,Em\"NS8'ab:ǥ%#)DeɈ0F!Se6u6YB*ߕuϹq8܄dnʝNV7Uy\\|AЉўm7HDǤz+ad0׼pc)@\0b)V%\"\"H0H*2+Ԃ7+1t<,\0P:i#B\"	ܵ# ڽ\$C͠ʲP\\4C(C@:t㼴1h9p^86xDò89!Z\"7\nj@- ޡx!R\$Hi&#`@1p4Z2C:@&,3F=&5F9X%.zrK!N;-A( _XJa͌	d\nB\n%lʱ0\\k\rհ7hС9)\\sSTbθNx>0&uOc\rC(5WK\n!P8GxCf&2\n*)@3CcLm%R3-@T\nbCҭ\n]m廮m?PҨ!/OTT}cz',[(&++R2Ss^\n+\r#֥ τFm805pbD\$Hݲ.\"@Rxw0k9:n^9gcB2T!3C/N(Iˠ\"\"pý@/x2.2ʙX\"ծHޛ9YjOjl\rWȂCևdBVR@k`d9sU&5&p^s\"ጡ+f3y%\0	퀄Sl S/5 BhIŉ\nА@C`HeP\"P\n8.ttHJ~+\02j*KoəAܔg:%A1\$')\0TsSnl\$ĜTJa-tR`LI38\$YjnfKiO@\"#\$FtoS%*@[15\$-\\\0]#\$rOJ)M*t샓A1T^Xi)9\n;2^(i C3H78sGֱa3Ҡpmd81B`g2ܡLL'Ɖ#6TheBU%F&KMA @P2&Vge\nfhP((`eR\$;<3xr	*d@CS Cd\"\$h]Cs켾cRAjLvr R_O\nm3s0e< G׊\"APIIfɹY`ǲHLw\rYY,Ng3W)܁+8I\$.6 c{<)I@	V^RՊ)4Oq&<@|=g,] PνTˮlgdf)B1Z f܍>HI%\$~M	\rbIY|B)[7\$0Dyygh󾜌C| 0S4ݯ]XZ\$XszB`<y#(*z kΊDD!GIu䣚^{-N 8qj\n\rH*UP]e\"%%;N)C4ƣhȝ᷊;]^K\\:\"eD@/\r>QnT#Dz]3̏Er\nMyaӪQ	4\$B`X޿?!\$72\r1B/D,9Lc[M캑{_1Vjw5ix`=\\,B`0O)d	\rD`6g*ԁjNhTTLAa\"c;*m|G4KZ1w&yRX,UͿf왣`[ܚ(}IUC5Do^b;MA%-qg}uE{i|U,E;?Qq%+x\\,gv!NwE(ת e,#`s0QsxD	\"^ڤ\n?%A;Ts:0^dAT˙64))EFob_ \"I,E*W#D3<L.<@H\r\0fnPhLvjO0\r'/\0	\"L\0J%RQZN,Pg0^),fGFZ\"J\\2]h&?#j/?(Thl]*\$3VnJv,\0x]ލ.Pb-]b\n XgX#ڦd2dk3\nuXYgZCl\n20Ygg'DQkqPpϦfq2%m҆fvL2'\r\" 6/*1^,mqn!1[OZb/\"%>P[\"j0g`e0lѱ:Ȍ#hQ2*ĐI3)\rz]\"ZSEeN%梀ѱ%>ao\rhkF7qaeq\"(rq#Dokp3\$NѶi/q9\$\r*w\$?\$2g&W' NO\"ƣS҄uVhckT#Q'#:S?%dS2dfFn\0^Tji**RS'`n2'NgR*L\"@䥤N(,\\HDQ6\03S/\r)gB}I1R\":@%0yH\0XSJuO\"5SLB2+6.\$NLERTCD&'/)5S893g\$6m2CD[dL!/#..WE su΋ʕ/=*\$&bR	c/b0a޻h;.6_1frke(@+@Tȉ+]Me7}\0V.b&l%ʄࢌ%Ρa@\nZ\"&6PO0e~P)p2cGn@oH,!HXh%GlAj/\"mxOI4Jr	Eܴ\0	\0'=`OK,4R&p\$<YHFQ-bp\"{I\\!%\rJԄ%5e\rs45SQ+g~FcQlcQ:\r-@`,Rq20f\"dpcBx pR޴D(?/If&,:S*G L2BS7-/pi,QlB-5\$RH4Q&ve\\d'a/<";break;case"ms":$e="%(u0	 3CM9*lpB\$ 6Mg3ImL&8i1a#\\@a2M@Js!FHs;MGS\$dX\nFC1l7AD 8Ls0A7Nl~\n\r pa(bAS\\tZ*fjSi*4\rfZe;fS',[\rfvfd5NJpƶiɺa6Ӯ\0Ѻ&\r2#*L;9Bm(eMƳq霍-w(\n(gr9;,)bȳ	hJ𝍈Cv'#&\rkP,kXxʯS80cN%]0H4\r^c`@/@2D49Ax^;ˁrq\rΘ\\zd,9xDk3搨x|J/+&\rm(8R	D7\"K1c+#Z (CˤEUBX\nZL%Hk Cx'PHhA!43?-'!+^%cZU0BqXܽ%\$/#}\0^,\nb8I9,:K]jtBTz9iEX)ZYb-xΤDÊRX\\rhЁWZ9Py/(\"@Pe@Rd'mPC?#:s4~'Y\"\"0Cdw>a{jä7\$按{B9o\"4:1b5^Kb8:,`6r:ҼGMZ72004!xPHz9n.Wc¶㚇j*I\"vw3)v9[0Go5\rPIR3ٱ4Y~4_1%wlcsJɁTJa-%a>3^	\r)7'd!lN	2W_%ȌT\$fOhDrKI=(4[K}&0S;}o&yal1Pbi\r2cMo\ri芛tIvļPahGh<z1!;#>f:AȂTb0u\"a\nz?Ga#Ɠ.o	7\$nP|@P%(0~\nIq^QHbD\nQLPh)L.hՔC-L/&\$8/X2%\rB\r26FIMF2HG42z:T{F9EC_b&@!0P<JДGV#fIg6bҖ31,3?;Ŗ3-P\0A?KE2qx%fB[?wi	cf` 0%<BpMpM0 \n<)I\"	Ӷ&2PxP	;jDĩ%BK:#,c-_G4%MQ:fB0TFY]I,'V	4(12w@PO	*\0BE6L\"Pl?iY{DnAuxeYJ܅Iz:gV/c-\\-!v`\r	H*ŝѼ/23D(I4J&jPl]CcEEgZ6BN\n\nN4tL32RRZ*[Jx(^}S\0ECM'LF2`\nl1	'a#4\"tZʩÂ	NpL@g*4y3q~͂	!9W1<./FOMfU <EU\rWq+䞆f_Cq1@ĹTd)ْ4~r^MGؽW̍R=2w! *1W.<D:0ff!WL,a\nLLtr )VA9++Ni@K/'dndu_a2:]dU\0,jU\"\0XkbrSlZH!]ZlRBka؇%bH!D3yKlƛaoa	(hQ	LLmBӎRhҐ@~Q<5qAG,,t	1SFR	cd<\rm;3xI\"}ߋI閶jSpbeOšL;ICo;A3}rBݲPJ/uL͕DnT+etNY`g>h46I񡛶0cKOm:^w.7_^?,_!\\=	v/,|X/NK؏ʤK\$ޙz~V?/4nK٢{a֕%7.J%3FLʙu'%eQZFj/\n4%)b\"o\$\"tzfjvKn̯Lzr%0Lx}o #-.R\"fP:pZ0>0df]L#,pf\r0fg'`]J*c.Ҋ\$N*RC?DN!rBPlF]dT\rJ\\\"rƈ,V¼\0:%Zb&)E^#,btqQ\n|å tH΍0@PDJcm@1L0I(Z0f#ϡ\$ne]LrXsBLBUޙbUthutA#&Bmno \rVb5v3-\r #>fnzlhƯ\np#-ݯ6\\dD|P㊔CȠ@\rZͨR23-QX΂ťNҼ('7\"Dܑv70p>\\\$cΘigF.OW**2<\$dRbtr[\nrg8\$F|]^b\r*PW/o^\0I<-ڿD`L	,r<X؃t+v<B.s)j *+Q;86u`\r:`)m-Gt8F{+";break;case"nl":$e="%(n6Sak3do0p(a<MSlde1tF'#yNb)̅%!MуqtBK%FC1l7ADs)u4̧)іDf4Xj\\2y8DEs->8 4_F[Q~\n7&{cb#a\nfQR_SH1(՗*͍\nmm0L\\`-`&.O8Qh7'5hj7sy[֦le]gxt*oK59v.cy蒈x\"c(PC +X77Hضcz9TP\rbDHhԁ|Mk9\nZȼc:,3ʀP\"=FΠ2\0x0xMAx^;rC\rX\\ČzFn,5DMh2x\$\"n3,1O{* >-6Ȭ-L4Br:ӣJ57ceR./0JC4d	cz?mJ17rYCp'IvD	jr\n#G4EΧ,I{A-3#.ˮΰAqEo/V*݌L1&F9IE\rsH%<7TȦ@\rCcD\\`P\nC+dBx1Ԛ#G +ՠH8][D\"`vm!C]	])oxI3샘}`ˀϟm򈡮;K+Pٽ4kmh9\\ ށW1#h5C:Bb47 #nUGMJ%rw(?sDcg\$r\"N*Ԉ2I?OEp~D廞UAit2 s;3\"IBh\"8p (UJIP4%d^L1AD8rM)2BfJqе\nEI(USPj*Fߠe{'pLe:F-8\"iM*TI!K18S\nrjqFܚQd\$`D4m~^I\"\n\"n@^Mٱ6+`\"B e7RJCR%]7usMcxD03b)mu˚Gq&22p@@P6H\$CAiHL\nI)O܋j&za;,c8HnH%S1/!dPR1&4,DvIB+\"e@pA&ED2҃#\"McgX aL)b\\vp DQI#J+8=HIA*%l3!=ҢHS~DAYe&/ӕ*A4ub*-iL^Q7'0̑9EPTNEA7b90!WDG'<8.LZ\0px'[3։#ĂSU@@45&MgH13\0bC)&\0.eayT 8PT@-[\nae:RFUOd++]F'ڐiYiG)d #Pm.3͚em΃{DEDP;beAl \$5|QQ?oTA&64K':Ռ/{9d\"t{Zq	>^yq'BGHIM!NPJP`LPtbD\rnqKE2f	Ǣ69a݆P0r0!,L цtr[4!slЩjg%BGB6CCq\n l	\nAAa 4e)5A\$4C!%kք\nVm\"0i!ƈ([%uJ*1q-{}Sn9ѧm86XzL4&.u =y%;;u^	\0Ԡ%Fh&I{.r=#8ǣفE)(R;4A|*MN0rAM~ǯHp^Oh5S.x=LtDn\$e,qC\"G[N{\$'\";ZlО^(Z1~ݽ`F8̄߆eݻ5hRFSGv%m/4&us^jXg1*4 hK\n_'!UewAW#y7>`L껇zx>;# _gq.&4_mnt%ݟOO/+xo Zj0πֺXi)8\n0`ؖ@O^#i,ɖF/x./RbdGp\"0kwP(H! :kT\"͔\0<σ&!-b+Wc<DSl(%8␠S\n,\\挎F.\$t:1\0pPСoР*8l>Z*̮=IeWK\rU/#o=(Q\nMul[\r}EQ4DfC\$Wf NGb qj8l·niy&N Q @C8\n*q\"C\rPFHQqc:%E\rf>é>iq2l0\$:\nN<0F{XQ\\j~Gb(b!o	& @^\r&x-m٫Ҡc\nn^R:[\\rL(rPX\rVa\n&\"phc62/T0J*	b\nZUA&bd<\"J\rDva^ifn4I\rO+Ȫ<!*!jl:fp2x^&b \r`NFr7Rn#bdM*L0vJ&G*!*uOt7_+4&o3N2l:r*2`p\\pN#5\r3-M)\"\"[,3Q\$#)5Ҡ!r %E(RAF@6K5âS\n\\&YeO\\e;4hL*e\$A+9B88nWIDD(\r\r>~Ќ	B`6Bf(iuP@cK7\r<6CLhD g^##D\$`";break;case"no":$e="%(u7I6NgHYp&p(a5&ө@tNHn&\\FSae92t2Y	'8C!X0cAn8G#<t<'\0,uCkQi3M`(n3d8Ke!7ka2`DKAxfrAcsۄ5-d20Y~I<LLbo񎘪*L@W8sU7\nprGJg98;Xu7B\$C#&0\$2@p!Cs6: j䤌x=n:s0cF/\0AH4\rV`@FcBf3Еt㼬29p!|9r\nI|6Z3-̲P7^0謚8c\$j\n2ҫ툭{c%H;Bp\0P0Cr3(C(U%M|0B	mڠ7\r֙&26:c:3B2S0\r:Sø<@4Ck<TH{_\nu.*\"&\$2 O68ؽ`c.\n\"`Z55\".\r!sm5C+,	7d0GH)GÍoܛQ(#hu	Sј3&!P\n0	\"'#3S7CLd#<#D!ΈCX|52T^k(hcL9rK[b\$7NQ\nm*76.FL+F-VajQ	1Ί57PpAV#1\nRDO5C#4x0[S-G(P9(:z>ʖ:#yr:9-'0Ǎ,rJX5'DҪWK,.\$Q	sNa4\"v#La0LB	\$3#IƁI6\"PJIQ+t`b^LQ8DBji!ݍs]1ȜGYᨘ\"trB\r0%d,6QXL2pMHBKV0fAL9Q'!lri.@&0dd\"9Р-bA;%8ɡ#H5>I\r,2\$\r譃8y\rʧф\"KT7HC\rB3i4ppG!\$DpHc\r\rtΝ2=\n~0Y8xC\naH#; ޻%0FZeARHI`d-LPBHLPaK_\\\r0\"D4vqY|3L(Ai4	y'ƨ='Wn0\\gh,l1'4엓g*~5퇷[0M:d@klD\"/j9\nl4QF\nA̐ƔzH\rˀ̀\0O	*\0BEe\"PmʭUV9'Z9@1ϯ]hEl688]B0Fdv[6oKb_\$9)r}z/jf_WDT䢾F(eBj)sـA-̻UXۧHajt#SEiF<Q{K^N\0T6J{.|\r2\r +	&e9GtH6.\\Fjq2\$8bD m}X]s1͚QMj.2B3A{>߇\$TҗA1Tj\03.A^	Sr0y\n!AR#wwZmRWT4DG6.Rc\"T{ fL'̄.D9vu+;Lm]9[soZ^bE\$n2cCMAivhoɵHKС|'`Pܝ6E4S\$RR!ʙ)%2WKKQmv]T	AFǟrV\$36\\I';=,{jv9w8]uPun3_G8eMX5sRy+\\	Yn;שL!cYW4)'xQETH]_fw\"j\rϳpu	A6azKT_kB[HRa-f=ܜF^8x|nu1Mf'!彊ٛ􆝻aFw0v\\).ھ|/\"hO0,J:bZ}[n,D.5tn(B-b4\rčʾ44cX&cPvpN(b(g\0o.<FBAΎUbRjB\$/:njP\"ԫlRh\0+\rq#B	hƢs8]#G	ZOnz`M/;oB#g-N/P!l!g=/0@FH&vV#%#Π1lpШ\"I/C`\rrπт@/BhM:%)*-M}9cE\$;q`bzA+	?s\";Hd_1DzIgC\n\rm\r^S\n#VE⒥CU涨ɷ6R]-\rOOԆ@4`_\rzb(P8@\ndҋ>#jFijs,&M6kC9N 21/H5Rf6nr;r1GF\nix'Ŏ8dtE`b\rpS>#+54;5b\03H\"oV26<1\",%,_戆E⬓u4| j!B<o_B3APRS&d8@dCbL0DW@4\$T/ʾ3]%k6b\rdA\"\$\"9m@S";break;case"pl":$e="%(g9MƓ(l4΢劂7!fSi̢Q4k9Ma ;\rmD\"BdJs!I\n0@i9#f(@\nFC1l7AEC :'Ik0ge =M0Q\nkn!c:DCyÊI#,daL\0p١T 2fLj2BфHof+k9Cqn:Dέm}670y\rGy;¡\\b@t0.E\"D)H)1Ӯ1+`)D9<7Ohzsx17P4½9㣮9#\"7A**7C.:*c#&Ӣ*\r9B(D(A!`@%C(3:x1d4ƃ\\7C8^;̓ ^'bmz7bVՍ!^0޴#22:cꄶ#* /C+IL(N9ԫЂ2 '/<^Z(:5|X5	_#%`6ڻems>@P:[1@Cz#zbN6ZXB07\rm]  (08J1P2Hbh6&,6RRV65	J:1qΚrQK-K`7d;ܕkz/dhul9c]TKHh(P:ͳ8FѴ ;(#@*Rכֿ@)jK-rrʳ Prϣ%.5~;*\r(<յt	#mu1 PrxɰoAB qU\0:r<Čq\"qHBI*O\"3\r1\r&5wAԎXqopy1&rN=niS g.kH^ʶʩ0!-4]1*HؤJ-xM\01F@<zA!62FêHC̽,Q Έx|JÞLo~BBL\$pBtCp7\\4Mp<ÈuaeZ!DFFH,B!b\nBvvFW]@Ny)7Qxx F(§xTjTI],\nc3iB&؛%4:*9eDxw,\r%\"\$:&x,]'J^ȺffUJ.Asa,%bLQ4 ֛Sxl<@܈x`ڱGy/e(0T1P#Wb*OdⒽMqlR`r9dD\"ZBH\nytKEPUJ-%r^F6(xڑ5'0%Rutg\ru8\n1EfFSǾA\nB^{ӈ+>bڡwjS\0POJ6:#v\nUb,\rdFƝجؚSOen2!RDHm6/oA&uCIj]WRSc>f@\nJ%5\\@iR8l)DE@R\$)0rTd9:غKfnE	[\$䥋\nJMP8{\$H5pEa6\n& 	5`O`u\r1KX^epyɒY(L1W_#7)W<R<H6{䈚ֆQWH;g	Arp*[W\ns1HCi\$	k9p#pğ]lR4B6-3u6Z+t]i	kv\$.!H0La6 z)&\03Kny`Ysy!乌0ۢԒ<@]Uۡ?ȼ<-#|jjʹ;Z֏3`ޟCykH4T(WT}#DVvW4P'Q6WPFhFe+f	M)`Ow7e R\\+<Q kg-×sVyTmy!ttT̯-!Sv\\sMK\rR\rXS飓z1EJ(X!8Y6&tp8kVśjY;y΂&0Cyޕ-b_G)`P]ucnDT\n!	<wUGǤ^kL< ^SNəT|2x hC+:Y_>Xo;F5>B7a>XXs?7?o}ϩ'iC7~ŷ~!77\"OdW?yCR*4R:\"KË ʂyJh t(R\$Rd8Zk%CyTˀ'`?a2oϬQx'*&C0	'䀧Ive1`B).Xj4h28	*2E*X\r. V'R\nNIH%^X©p\np\rPp	i,M%͂^wFpN]BjvG<?J'\n[gFoQ29\nLα4g1gQNŤ[@d`,`ZZz,Q_f\$D0\r0\r\rD%A]cu1\0Ԅ2QD>P/u`@ZoRq%.6/OfϚo1Ū(UO/\0 q %q	%Nz.R#~\$̗|U\n\$`K}O>ͬZFu*dfbZj8ĄJE&\"6\r)\"6dX~'4~vY(@U(2]hJW.%%0SD3\"~H=+~\n0UL Y!0n5	S\rEP)1ks<T\$V:q#1ը)4F4#2SBWM0)T4U5B6nsx<m\\cBc8cm4!<Іqdgor! P\n\$ܹ\r5;='2\rr_F4DJl\rlsp3K %.TGd`\0ZYrG\rTN#\rSK2Źs6T3@s%sN²LVE=TcEBYF>o?>N\\|sԁFt-g6*|R\0nl0wEAA#F7IIt%pge!=\"- r\$S>44-- &2\0!8Olt!OO\n,:1c>'G*XG<;4\r38R\r!oxNK26:/v83J(R@nx\"+&Q\"ƞ'&-)u'	n/R!\nZISc/FȱqYY\$ZuHC56eZmZ!~B0p!&J{G쮞pjrī_&9	V+j~z\rlOh\nR\"\\	b^{`8 ZisXp0sY%Ii68c<g\06)Wd_JVdh*2bf)Lm.fc3'0zqca1cHGCv/EQj~YSkgބ	!6Pz-	yNrz4+\nEӐrְlVB1M #eDFaipFe6*%in]\":emmJ~\$GSK)";break;case"pt":$e="%(Q5Ho9jӱ 2Ɠ	A\n3Lf)oihXj\n2H\$RI4* R4K',t2D\0d3\rFqTiC,i؎hQi6OFTe6\"PFi7Mj\\bP&()&̆	:\n\$w624OJK&aaG,lٮ2؎ӁP\rNO)#ckG_\rysl5=,9u;8=:IE= \n\"M'67P95x7#N93{,\02-/4\r+r.\$< T.KRω	<\"2ہB7-CdP@;.S+; X֌D49Ax^;r\"/s3_03#J|30j퇁x%\",2cKC̩<+pl8;@UU6λڟx\nMsRB::\n\0<\0MgZ!`ī}\n7p֍ˆ+t\0\",6Ic:N밍mkkHCNN1l\r6\r'(>\\\n_bm.ߩZZR<X\nX؋\r\rV&LV=đ;[UN9:\0ºcP0IQSXU\\h6\"?ʁB 5{eCh\r֎\\/Pp<ҴS4Vܐ-oJ(إ\"#RC*\n?S#u04TDғ#\$Z!,[Wh(\\T2o8_fڣ3ˌ4h*\r\\<Ra{0ag>/0pݚH2\nT1@9?3vJa̔n#]*\$:x&lrpNI;'O@^NLJD}|~ƜL]\ngI3jA*h8CYT \\ae)9TSBBA׈2QM8w{])yfZ]!ȗ.RK\"L1\rRO_F^!R[.\\I0\nJ!3(GvipHA	bd%)9\rᑒ\$r?(32I\n (\$q(( fÙ,T6TeBU]f4〳\\,H%%0q\\32b3.'EsE(thP-FgN9b\rA02#T(@H\$\nE{<nԇ*()2&ٲL\"XXeq-6ZcxPx1u_	̤	\$<BZR>\r4#ZŜf\$G|FKF(&T@PP	L*%zKd)ֲd̏VL+9=jiufgh='A5D3Ahqp!r0Tfg]r@9T ͹ʔWAW7lP*[u E	%Ҍ[PGFgɕauCam<o&VhЍL0CX\$\"䴅[E2\"RFd`W;\r!F`)\$boTAZ2*jO»' (+B:xGБSO0m҃5^D%epLR<[0bTd̩\ne~*a5|_ozm@\n&QsICl2|jXb%fS2.ZaMsCFֲD#OO%;akmq.MBӒ\rDx!ܔ2iGzd1\n./5Q_Ña7> ϲ4kRDw 1اЉfjN:x\\\r\n!@Ō*I}5	HEA('jMi֒_j-a3UlfH~Q\\r,ܟhM\"#8\"R! ċku̔;łļ<tɪADBosgI4,-SKe<\nD-8{Q*({H\0Nu^~Gq=<S,N5U0BN^`\n	\0Un~|\nf%1<wӹ\"bǬX>I4Čϥ7i{_u\0MОD1F\$ߖ&TAb`y\$Ż\"[wֹ15NjT,[@H v9MT[\rDNeȔ`Ů\"x>&ZA%\$j,2\\8XJbj%ΐ&8*\\N8%?\0L5P,IfjpY-th=l(`Vr\nI	0%2bGjAH)ZV=] &,\0Lc\$/-HnFLlC\r#)*eM#%:P	PXB,A&\"oȺ0w\nχ\0XcQUXk<WC\$?]p,JrR|nqbE\$#\"=fZh~\\&`j&Ůd>\"i\nbmnF	ϴ%1n*3qX欷>Banqq(ܑnb_OF'\"hH8\rcm(\0ؒ&,R*s5\"\r{#H\0׭0͑VP&l#п0rk&F~'\0\\XP.e*\rx2pK)O*x(J	,\rBC	n\"Zlpf\\2fLt8R@cEA#BCeM/z2qΌeE10c\rVbb E!Rx,</H Zc@r䖕f\nZ0\\\\Y.oQҖ.:|Ў\"|!	GS(Q/N̏~@}M@Q/c:% EQe.\"fZat_lC&~X48Ef\\Μ\0PU3*0H\"?hzB2w\n2>;H0qlȅ4*lNB0\$\r-2Fl&EXabgnBF142UXlgG0BL#!FLZ xb	LL0DH#>X3B.j[fc-6 2¥\n*a\0z,,9	\0Dn";break;case"pt-br":$e="%(Q5Ho9jӱ 2Ɠ	A\nN\\\n*MqmaOl( 9Hm4\r3x\\4Js!I3@nB3'h5\rAscIEGSbr4EcyUz0Fa6A1a1E'99A&rBrr2㪧(o:\r>yx6&[Ap2jF.bIylǌCyn:cn\ncn6\n\"E]A'>7`P9\"5x7#h9:Mc0	6PЦ`PͻkR0(M7bzʬ#\"7'H7â:x!#\n\0H\n\\:s69`460z\r8a^]Gi\\z2ܺ9xDɫ`\r3Nx!k91H&>RbMER52|#h\rpOp΂ @1*`v+cx:*f@Cp\r bk3#L:x\nTЈցSe7e\rQ) GbB}\0+U0&&\rޔijlÍ_՝6\"򋄂ie&L@CVFҭ1,PTS@\"OzD(\"飫]'KSX\nH4c\nC{©m#R*hH#?P<n\r#ҋ4Y)K4*8@6B6G%t04}\"}f#HQ|pKo@?\rc1Lb1KRpJR\"][\n\"9R{T «Km-3P۷(70ضN\rzX<%8uTb90EYܰ2Rt	9+\$3\ngI'\nGMG)9&QLF2tҚjoN!9z\ru\n>(9&DLS\$y5 ZI[X6O\npraLpu4&؛rN;\$ݑjYA(FKyѸ3Kpa5\\Q<;I\"Ö,8_E@xbkvL/Jp!(>tctIT:v\"08\r;8wH2 ih\n (\$6rK@((ऌYxgÙ*Pw0ߵŠ TW\$Y)\n-ؘJ\$9!>U+@pKE.%sC(4JK\n>FQPLY<D*P.oR6{De2vɁ2&P\\@(H@rg\0PuQ	. I aH!'4Ub	0pNS@9>΂NxS\nB\0gEEn#]>f2IYĒJxw˛EћjPbDaH)̂dAkn\0&i=#ĄYDU,vEf1%U!	8PT6@-Vrh5\$1DOzc0࿤Z83K&dMTzi9)^5)e2\\'(av<\r'Vz׋#?42\nk\r[{hXBEMcrx+dB8:)S#\"FNeҎ{(㬎\\Q\r& ,\0W³%&g+PzmxY5N_{8bqE6r6RSP^aQ%a:P`ubCFҒ*#OGiqT3%z~۝e3>l35:_<0Ϯ·*	b\0O6}Z829K,ƖGGP*/	Ud4nH8){ ]U2Y\0`l\nX[\\G111Sb\r\r W\rE-\"Nɇ܃'Y_HE=rSw+;4a=-Ēdgzle!@Ac|<DFҙGvDM	܌8bI<R9GpS	k=ݴpr'tIv7&;\\ͱ|#joB%riI̡o\rAmqRM|XPb\$&(({M7 -VF;hL̃=m,7Q'5ПC%!Fb\\#xz_hWsb	FiTTo6(eU1\rY4<\n/OZÌFOXϖDD`A%owH.[o7l\"\\EԂT4&lc(,t0L0z1~0nHpt7NkxEe\nJt(yϕGmUP^ioe###-Bӆ\"=[&,L	;bBNԘbucY/p;⤰m @L|#%*5p򶰪\$(8>vmDŢ`#TUC,og@A'\rbͮ]t/@֏QyO*Xq{``<Q[ͬom\"e@&p!LϼBv	QpC	-oIR#*%P!iA!\"23\"R3QeuDLq#A-Xփt3h	\rMHղZ-3ѷ&f\rro%\r)PnMZ{ ,sMq})ҕ!G/u!y*@ׂ=)~'P5ŧCR\$._ -ˋ.,)+N	6\r\0!00č,5	O/#DZ0eNN<YY2/U6XF40qy\n.144E2d5.c\rV\0a\rP\$4\0ZaBO&VpD\nZV\\>WUoT.S	2P;\$>2bHp.42^b<IY`23O ,n (O^z@Ik1U#7NͅPƄ<\rP>͌&\$bBEL&\08\":-Y;(Ee)TD]\0Lt8Brd\r-4V˔Z1\"2RRg[Fx;tn#(BhFH4ъ+Be=*| 8M ګc˷\0]O!F0a>p/dacBƢCP%.{d5o@#Q)4N4%8t=Få5QY>K@/n)Я(g+1(~";break;case"ro":$e="%(uM0r1DcK!2i2a	!;HE4v?!\ra2M'1\0@%9dtˤ!eұ`(`1ƃQp9\r0ӑ@dC&It7AE3ed&3IrE#Ui7M8 1my1&A.e6edS!&㜄˨A<F&s1d&Yd4e4|2vLa@u8eDxNמob3.:r͝l؍oüp99`P2 P\"5xǤ#'kڹ	d6H赭z\n46 P#KB˵Kԉx\$ÂB*Ԉ){\n\r8.*@1!1:ȵ\0\r\r2`@#CC3:x?u\"Ar30^8M#9xDj12@x!NÒL\"hң/	YVMl>=H{Ƶʖ7H\r@΂ @7(ڶ P7x75+q\r\"\r##;^mV؈(0j@,@.w ~\\H 0*.r07p.4R3׺<!`acbI/(\"27.b8(<Y\0ホWMj,l`ڎ7@ʙoR)z56\n;\\;3ʍrGV)ԩHܼv6Z`H*CR\"鰶>ň;R&C74L}΄UPO)\\J\\cr8>|G۰uA#y~%u\n\r/@敠j-z5u)UlZ]LB8vM&7! -pbE%a\$(yH\n0srX(<epe5	)tJ¡BdMTIPd7wZ\nbp	'TS}O@B\r2b\"tĢt6!֗K1*܆9<aeJgay1T:P:hMI繗{Asi''PI-BxYF/I)G\$\r\n	\"@V&aL\"TqhC3\$Ă\\Vw\rxhY\$39CHf&%6I LrL2IX=dߜzytEY+֔D9A@7\$Yr\r'!^)<J%!i #-E2VBb/SňLT^>\n,01L-jZ괲d_S\$ZJS\nAhcPo/6IYAӚWEɉ3&-%nY4LFӫHp\\C/(,~YJ֣f7KOE( 3!1r^uaː0bxS\n |\$T,fYjHzsYa})g~mg`T<.Rpgy\nmӐF0T\n&&aĜ9\nfNŃt`\"ADiK+c(ESծ˙\"Hn\$LpVPs5^)`nV+f(Mĸ\nAP.`e-cJB%!zF3Z52ӌ\"+\n汀PVm{\0tdh(Pt/1ϜkCTݒ6#bz/*B[X2|݃ځ1!A(QiQ㣝22e\$ 2pWeXSj鑦YUڳjJmrŴֵI,fA/x1ym;T/8*c/8_p--}ÉTJ9%k&Y#pg\nlܛ#E,@BHhSZgb΃z	^1aM-^9*֭̅eTmQAEABXtMwgur\0hHyxw_[Yf\nS4]k\rno\r:a+[{5Fm\rf]V*}RaȡL7C=^\nQ\\26H3\rb[߰HW8C/dk꜊ {Uj.\\t.Q21e.{Usk!!ULZȘ*aWƀ%+K!1V[MHʧG}Í\\L~@*~rII9]\\u#Vi#EpfL(DN]l\\1:/C5 C@x*RчHOn\\bD֢o&z`)WΪ,\"&-}A0^C\0X.Db,@fJ=FL\n#4,hKxKX	n%pɉ	O\nj̧pn\0HCB;	N-CB`n]\nO0\npnUP6Π7e	PKm'b<oȤ\\1#\01@?м/d/q\$\$(>,\n퐐=:f}7`F<f.tJ+H`q<.\r,-\\,:و\\5-PXeIQU+]oa\rVX4>Ń\rX`Hf1	l4gOqr\nZ2',G+=X #1@BX\$>C<pBZ&b%a!1)	W'fUR(Qp`o#2xUG8ƨ6\"*(eHuB\\1>T։dҩD, H@Ȫ\r-#'?-^-R>A`,\"!ȭ1r-\"kd!0\"DMs1DD,G&q>.\nN1W15P6276\\dp}L%`M&Y6 HcLr' N(	DPl[,S~;\\;ŐC9\"/``Euqyx\\H\rV}-/68t\\fHDt3*%bZguBg\nZ\"t@NZŬ'*\\XLPD!\"Hj\0002Ɛ\0=LcAI9BҴ).@pP\"%m(Z,cF4ZDXgF&~\rXf-t?SoxbTONSFOOѺOcCO6TcNCB'8r1|/fkQLor-.@``~\\EDa\nUCU&#Q!3LY.L@,Xw\\AC\\5/vGtcR	@>O/&sWu];޽,n\"!OhԸ\$\0	\0t	@\n`";break;case"ru":$e="%)h-D\rAhX4mEFxAf@C#mE#i{a2fAZH^GWqh.ahhh)-IhyL%0q )̅9h(HRDLD)Cf4Ըh/	4&Y9ڡLQc4.CZJ4B~_wȎ'%CZ|F{|3Se1gb3i,pq<(]HMv;f_r7:)NѠ\$\n(߾/ӬR*B{\$ݳHm@|\rBPbz4\\=nˈfDqd\nERc:ӦnWjt) 4Ѳ*D't-phCԟN\n.,?(dzO.*8DߴKarΗ1=-;l΅cl\"# 4(಍w\$CR!t۷(mpKANa`@!\090z\r8a^\\0U%L\rp^8#;# ^,;꟨R*(.^0CG(rQ@MJFD	8\$tP#c5,R'!r9T<:^NZV<>哘:Z.yk㦃2VM-F&rP)Dct)8嚙/-;>㵭\nGJ^\"hl(P,4M\"FyE5OR,}	_j(Z))Lc~4n<ӥlN槰q`κc>EB&L\"2*'\r{%'М+fDdqC!\n}= c.-@R3l܌r)I\\|f@^v1bM,q@(a\nOZ3m>Ch:JӉAj,HAa[I;\$0ђ3i@̀\"\",REP椇*+7B ѓd;\$W0&NVD\\!UYsdg9&ȎotR~q[i(qrngv?	\0YK@S}\rO4/>\n1Bucqh(Dɱ\$٠dH03u\$|rJ\nWгFFUyG)0&7:ʩe!(+Yy,n_f!\00Ǯ}I.Bݙ:hlE p	M1显=6k/̔MS\rUN9[d!)LHXB	83ֳ4(%Bɰh=Qmo	sg\$tiqʎ`%w\$0uRg\"'>񕍉j(tfO30B(rXL&(,dEYK1g-[Kr-¸(/7lb^Rs;\\s%\"Whz;\n**cQ4T>uI5U\rW-D'@j՝2Z^ZYEiUC[p.%ȹ(x9̼9fD<p*!IHh(\rOKDTGSf/Izf!xm&ɎAѕx^H\"(/B&NRʅM-pPn}#B5e]U3+h.A=Dy#:)X0HO7l*Ɋ CcM\"m<C#fMI/c\"dt.mH9'J,s9Ba'U44ʮhp4FwZNjʞ.k>+@k-300-)Ә9>_D\n24To+% [glٔ-fx	םdWᔡI#B7mSu Wh9p)a=VuZ<PW[inL\$%!\0P	L*=\\m6i^+x2ƉJ(iśiFO6b1!r\rt@+bؾIM}+̈~NDʸ	vV\"I^1Vs<Î='#@NS8TPo\"M4G`ӳSfjTkwJhS0\\Xp	D&d3:\nAg߻~eXFvB=riJM\nP)s f ۱rjxbLi8\rhP6sufB}!.JkDo?W'fIкwt2i퓲5xjdZSfH&.B	\0H\"ĈRlKP.<^j.G\"k^\$ #<g@mJj'6gDnb\"qDp^*ߌW`Y\r\0tR2JFe0Xn\$qp\08_|	 \rL\r `@\r0%w~Oґa0f\$<|~jL:/~DTLΨ#d8(Bbkښk-q(ip\"Mh \$dz3\"n*ntF_,wOޛjOVŤ@\n 	(0Ixʂ؏BN\"^nA~h ^0Fb)B\".f  Ќzς*B[HbnS0r\",ЇHcRꦗ#	\$1\$r'\$/,48#J&K@խLͧOjbs'c&i{Rr,@^2\"a)'&*)*['R*\nV\nN*+gBd!:Mr	#%rhP;/BG2)\":c+)	E,)\"\rH-JR}25!JcU4\$e0FKLF-N2tɱ0&Ri\nyHk:=~;!#5#2+#B\$3.:f;!Xk\rCx-P܉P\r\n[;d=a\r=\"%]-3@S|/܁:FFb@f1\"wT\ny\\foDvd,YGFWft)H1ODr\"/V{ò0VP^2k'| \r\r\n7o]GthKlH\r˼PW?=+2dHl@tMt3A/AsMO@QP2q@T`j	*w/_b Xү'S!%2i5M,A4Au<e@E,s%\n\"j|uY>f*_SVfqVo\$rz<v%RQW*bvuNn(r*5bU[|kuZʙ5AQFNV\"9O\n9uIH8C~njbHFҷ3	A{>+[)(ͪC5BO#-\\9EEamDbC>Tv|^nC'=ZU#XfNVS>X6eilPZBSpVȊ^7V[ϛimMmHBMOmukl28/nOgod|j*\rr\"gh-d3h&oE#4{bU<TtudUkZ5OW+t_QSog>!G5P[lku6H@qyQGh1vג6f#y^jl?>տ3|i6Zu|\"^OAyxI:\$'PQTqX\$j(qk@ՀC~-Sc!ozޮ/q8pѶ1Tmͭ]juOx]-e^6͏B\"hhuLFd5bf0e&*cxXVsk,L:BeUTr%s	Y8BkxAR{'ڠF<&|!3}5S]<ص>5Zrs%raWRXWˎ-2dir\rVS*W^bGC޾'X(-I2N^560_؄b\n qBdVgs n aȇ.p'F!yDOݙMM[<F	\nd=%uBqpQ.3j/_\$bOnYed!f6b\rBCD^GP.+DKS1\$q-PbtR\"9\$\"9v6D\$SaB2済gtB*\"5SC0eZ)5Oi8GoIۧSr	O.w:B2I^~`JHyHchWjOH,%?~&IY\r\$pNh*`.<*PdGCe/?!\$JQ.ͫقiЈxZbaS#aOWZ2G4\rτM8rjyi'j\rmNBrt+;eUNL%\\";break;case"sk":$e="%(](!@n2\rC	l7&P\rl25q\$\"r:\rFQ\0B0y%990cAn8U\rZv0&㙭'(a7&*i3fRSzi0\"	75d%Stiы&aKqqlNFBN26+(;D\rƚ\$@a5Ԍ&IPc4mFd2V,=7gy:Fð0掇IKss\"?vP٬Ff&fs0F\r2%?#:̵*Hj2I\nx,BԛB@9\0PB\"@ؔo[\nvFh# C\nj\$2\"JK2:\0\"8(=DN\0x#(C@:t12: 9Xx0cxD̸1̅N|˜<\"PC|o7(B\ry-9#XXVO:\$4&J&h5\"*-\0ĽMgZͥf#!t8pBXXâQ\r#	#p95)\"\\0s\n&7\r%:8SȌ:[2ȃ=3D	^M@\rc ʜ-`(IҤ8\"\0P\r7o,\"⧸bB\"phʘ\rLc.&J5=/â\\3#̿u̱Ke[ãAЭoNx9%H[{L,ź'c!?915v\$*¢4BH&(@.֌n\"@PO2Z34eCso\"LSIFcx30(HJ2B-7	Bt\rʅGޛ,ףfy)F!)>UF:CBBʏK#j!0W^R#8UCeV\n oB\"@(̳o4-gQ[3kR?Fp-!T[HAQ(,@^*OK:l0I^+>A.q#0BrYrCF+\r;x!5DXQh:XeFDd=B\$)gY&\$TeLz&ڛӊsN<\0kP>Gp@4bѫ&9vS,:ư%tY,DB(pF\0N:2<\$T2AsfVWP\\\$\"jM8'\$蝃xH9>\$Ø/fTPp&I@N(d(%2e#\$U1),uFUzbY^LKy!,KW6NW;p\0eA&Bl^(HfaE%.M\"#\r>\"\$0|JlDQKI Iբ`RHYi\"E\rh2eɀgjOb#/h<P!\"TF\"}02ՈdHbX%ca'.tEi0HxSbk& !0|:\$E&\\!萄\"_@^HIA*H?OXEg/UQD2VWCY&-hrtNs%\\2t}M'm=R]F0Z yd#TK\nf<=_)0;6@ҽigp+mZ3Hԟb6m P(LA<М3a	C\n>nB-\nfGVMޱY''\".TVpg..#b.d_̈́tBzτ](T!ZP.hH%KV;XE͌<#[}䮐=&蘋p0QFN&\01Y枽Vaݴ!]`]9v2h2,̄oubٙJ\nܑHo.הo5+;C&hyĆEI/4=fP\nfqEyRLYE\\UyD#,:|PPlg40\rdMGPPFR`G#hjDTTP}\nP 0Cs!5&*r\nY,v/*LI@ֵ4o2>#m\\hK6widx쥦o֬vCO'kij:\\<.ՆJCWy41	E\r'v1W+mz /֜8ZI]=}	F+HĚU]N'-WNŃ`ӎ';ҹGTC4m!@6yg||CGmP2\"FdNx\r.A\n.\r\$(cH@\$p22,=`>'\$8%fO|@?0j	b!Ж#t\n0XgJwÚEk\n^!4Um9BB\n4\n2>VrP.̼;*9@!-_.Mݣ(\nBcH W~.#Z8砐_.,)[j\nx.V\r\0Bj\0-\n>[gj\r-GlEMDkP\r\rMm(n(Q\n]\$11&Q;_f.oFTAt#0dӫj/B~/Fof/Q%`Y@~qU<0O4q\\χ̄BJ̎!QCh.Y#^C]\$E\$]#\$G7Jxn>\rX!&xoF?xڪR%e'})VjVtR:MMK&Kjゞ=?c()pfA\$9&.`NF-epXq`\r.S(E\\0E%o0z[_\r+%1rhԱ1.pl\\p<17s;%'3k2P,CsH3\0A6j&8\\Ǯ\\@#|TR-\r#gDF31Q:4;SZkxgn:e\\ԍM<8!V:f)f]'\$8Ny]t@s25Ji@enG#\0E4140%+\rD/&FxsrJCs.rnC\$0{}G7c>CD\"-t7:CE0GnGEGNDTD\\#b<.:Sd:_cx2s9fm^ ωLNL'm9-M\\D	b0.Zf\rrBLCL97\"cZ&%V\rV>\rcf5lk\"rLr!dxA5\\3+i(JH\nZnMW`.W!`\"quy,OY2\rl!\"b*IV`:b3M6..N8@[L`yRL<5P.zn(D;n\nqa#\"DP_*F~ka\rXEϗpje5:VW 	[Npd8ӰeÔZD?PmBf\"=w1nn.-pZ\\`ۂq4jBs5r\nHN8VDܶp\$̨&.\nnw@lr3%`6l3\01MLХB#\$±dOo2\\Um^sr`3KY#G ";break;case"sl":$e="%(eM#)@n0\rUi'Cyk2QF\"	1k7Αv?5B25fA2dB\0Pb2ar\n*!fPsSYPaPI6Au)DU,jANS#IDY7Do8cae9#5i:\r:s;\")W6g^]Ѱu5ZHd96[MɺYV|\n\$Ye=KU78r9B&W~:vH2B;@B= P%L2	\nԈ3#L## ڻ2Ҽ1m\0	[N#;C#-Q;c X[d2D49Ax^;ʁsy\\x7} C ^'a926cH7x\$N\nNAz#ٌ޳hlp@Fm´3\"7+#7(J2H:5][W5YW\rHmY4Ύ\r1B8BXJ,.+I2P2˂r@:6\$>B0p-B#ó%0֜I\\h,LH7P\"h7\$0m@P64Mr9k8b&.c\"nZF!1WT]' ІbelYx!^iA[@Cx,L7ixx7;\r=k|:hE4WBv0(`:ыRc;R,!c2|mv5xСam2cDb6a7Kz\nkCJR5PIF_p̃%R0̗(2B(mb7-'>:őppc#8qd:@P|4ʥ{\"	=-\"/U\0ސ\r+F\0\$S&CJKI=(4ZKy0DSgxuP⍃`p AVXv=hM<Hj5#14~\\x,RbNJ	I*t[Iu/:`MqNLt\rp\$䙬 t~-`bkhX,ֻX2.8cjGg`a=[{E#a@`1HA\$0qFKBThDRN 0\r#-p)[0\r	Dō>H9-B%̴C\"yD9\$Zse<\r#،`w5Aa!Γ\$}N_P#041\nLP,B\$T͜z\$dX1DSDV81D4E*ZԲ	\$<36\rW+rć@X3>Npc\"HS\$g߉%j56L&)+\n<)Hbj,\"\nc[f\$OD8DǀBq\"F0LΒ`0T%V \$S,\\Baȓ%p/7mmη#|h'mȜ{JlaA КD1rN9A=0uFL4dRJca|Z{h-J#QN̆>\rx;(\0PV=焕90ui0u?W)r2\0\n	̓(@5BΖv؁\$g}Mx&y7@u{Ara(wP*aO`hI\rGWS:FJ3C[;-qg7N,=#-u%\0(!Ǟta#d\",3ç?ZBצCa9p|x\r\\֮F\n<S~T\n!AV\$xE0HB%eY/)B] ˹6ڪ}WCX+@-O=YCnnSRMj&zS;{OojkUƆ]Cݵw]w	S[ĉfE_oN	FFr<뾃LߜON0Y\"|k(ǹ!7Q\nC:gN#\n˨buDIҬx7f\"&cqyqfah|&p+C*53V1t+(HOþSCPB2X-F\r<.	cwK5PdTJ0D6jxnE0H?t|47V~ZzS_o>Wfu\"Jg\$R:/O2֩R#61E>B.[&.J66`Z\"\\\$\"L*+p\"/0@00,^ E9LCؽr9'\\s\$c^ɪd\rXO\$Dv岑Pb׏pJr	b\\d#c#\rmG.-\rbw\r?\rng.\rP00d1BO\rQKN-M\"P,<81@Q0KJ|QPƾσp7E7piXb+cr\"0>p,b	5T\"~6p\\:CvNb)(0F\$.,,Q[VA\"fKбxXElU\re3KY 	O l[kb? O jƱ\"1r*.\ron/Qifr ?rE\$ZY\$X`P\n6qN\rc\$\r\\\"c=G\"i1(# H7]4fnr#ׂ1* ]+2C*Ҁ#fюX<2BOiv^&X@Ț2djv\"(-ʗor@\\\$Bҭf\r@?Okc\"_)46\r?2!E)Ҫ<RRh-4cF#<:(2-/?҂c56(\$1h`0CnQj7*a,ǖ̼v\"l/:\"CCNsy;4;ӨEH,tLCUra:M)k\rӸ3\rSs@фS0+S|@p#ɡR~g8r\$@t\r@#t\nZ,j:k?8NF(獽PVtQ5Hz J!bJRlzN\nQ+j0Sx<CZ2.@!C\$L!faL0EPWn 8b\$mpBxSԈ&.	QO)Sf<4#(29Ɯ\">\n6&XxRS0H_.f:pB\\&OW|㤼qЮi-\nVV@U>M\0Z,/`j6-c>3Rj7:^,3i8c]piմ.kZ@\0USBu˃)X";break;case"sr":$e="%)h.i4	|Ez\\4S֊\rh/PHPnv0G h\r\n)EȄ:%9>/M}H`(`1ƃQp9C\nD?!G: 'a%e|׺ZΗB1,h,ep܎x 6k贘Ks=&a;Dxr4&)s9St\rbV<LAtt}?7\$!ū=ޑ?\$7	\$ɢm\nn@73\\ԲA0򯯉\npp@2C9=K[9,l6\r&Pt'jT\"hc*BmCQ\"%ƫLX l7 cx;w?#p3˾#;/B9Ԉ;c Xh90z\r8a^\\0γyx75NC ^+P7^0jv)[6蒼L3Г A2qtJ0J1wwo?2٠!M_n̒389\rR\nT\"N!&8>-8:tM\nYf\",L޾!FV(:0ZE1#܏d2=uSr@tflb\"\"z?&ͬD2кIRIJrlu ~]m!\"86	VW\n\"b#B?.h}\$CR&iKnKQ0_7VDͭRm\rC4^_Gu `(1Ay0z:*Uz\"x}>ݱ7kKMl^M\"H7[MhuiPUHQم V%90i\$2|̗CyΤ#Pr,<\0ܢV\$4H{\r'2R҂>*F龑C0EۙrѮ8dC81RBbw+bx'@yY<\0\rêQ\0:j|:(C8aP`O\0(`PJ#)tZFcKFGae(ܢP N)CHdO\n*ELRUY+IHÒW`=B\"g!<V\"#(nۙ4a\\h`ْ- !7%(&'sSjuU dʁQJNUZU;5j.W\n^CHm&\n	!8@ڮäT=K1\0kY)8#D\n؜m92teI16\$\$Y~E҈ڡK3yҦB&APh(` G*);C؈aӝ@G)*w(J#NH a1 Z:b_{Y\n\"e/\nH\nuAX\$y<rq*sĺ\0<3XAD*\0o`}6^>i8Y'aF5|\"<K\$7	gRb!0\0 ҩG6v) FsrRy_(`+ȼ wJ,W:Q1o='FP\n15Íwi)qڶ37J.	\$<Ű*lWtXHZE?ŻF;*gֽ좘`O\naR)KN8VY>ji4R׿dNر+vѽFQvFadukuÀD0Z89eB@)GeQ*WiܧH2G%%o˄&XZtH([S!8p \n@\"l)y5%\nqtAd8X\0D0\"}R5YKsMP^}`,ȋQ&3N-PUo\"Qv_Kx-|͞)\$\$lu-oޫ皫tܾ⌒6qo\$dd٣K7tM'7}弗vJCc/̕Z[%I!٦Ӧk_۵\r8]@\n(N\0<`Fۯ5-d#kQXMjD+Ok44s\n'xS\r!z\"SRYձQ	ZYjut2;FNen4-+F5iX\$rt,#ĭJj| 	P%}x6#Hnפ0A0ABus↾J|υ`\n}JSBj*O<yY'i</yMʺ25*Ws\nP 0@ac9ePkHne*`&^)].@\"v67R6ʇo#h!Bʒ,H]r>bm30@l|I,hD)g֥02uP ,J_l@CbuPp0+0hy#vիpp\\[\r:@]F\nS)P,pA0pY0U\"1F1@E*t\njIy¢R(`H#n#b|B(@R-8&HhU\"J1j*hHgo-p,hb(~MTl-ކlJ\\\$vΏ/EN*낒DHCR.j.sJ0⍌[=Q d @!&d7N+nNЙrr/R:B\$r#\n28Sg#G\$Eڪ~B\$5x[n\$R)1@G@c4(5l(X\"F6L)^|F2n![\"d-ZN@\rGe*\r\0`h چoh.J!VZF'1\"\rI33.rಯ3p!!f!s14yTyrX@](?p=%\$(Pr\r	¿{\nq6cx{A	0;-p8]s7%8\r8pS42)5|)rDʹI'7==ů->S?/=\r5nC!Q6-A\n\$\"%I8bJ5L?\$\\-~r!e?A,9A&c+.e-49o-##DhBfD*0 #\"CT>ok7c%.4D-_}?_6s(\"T-94B@%&mTN,k#<|bcK++NC j6%LT(|w5T5ʃ7\nMOUPgQ*0ҪEAO>&䶦Px_<N4uZ0{\$3KUe:jqnv1igA0_X.\\\n78w:5iZCZNDB0@`\"\0NÌR+Wd*J:O;\n]ƀ]8VC^R]/a!4aba?UbC\rbqTN#'VAZ4VEbvHqHP'QDH/7aIM\"fbqPgS&U{@cztd`|[r101YbO\nuY-cB!v&kj1p\$ɵ:EPbgkG88oG!	\n26\"394h\rVImXK	,̯1 (+@J\$l\nZZ.C:\$\"qywptwε1r'Q0Y#Ȉ~r<~Ѹ	[DI6huyr|azuWBYQ/!B0vK_W\"(bl Ķ.qE}'A2P`3<)'IU%AĜU\$<*A=!`r'D|ZExDo8o,8D6oIpOz+&Co'(\$oS\n؞勵^{/XpTv1-3U2k@0B@P{vp2<nEpc@ՎxR1'sA)''(ݍmocad\r@haT6uPm½PZxcCBR";break;case"sv":$e="%(e:5)@i7	 6ELp&)\\\n\$0s8t!CtrZo9I\rb%9iC7,X\nFC1l7ADqzn\na!CzkSI a6&<b2\$)9Hdٌ7q}_D(ND0Hr4k4U0!1n%(Ɖ:]Id3o\r3Dpt9uQNY!)g*G\\~~kk@Q<_;̴mYoMyH3i7BbT9\"5+{\$B6#rJd\$736\r*`&m* 9L29\\D`@5rC(C \\D45Cx)ȬI\r0{z9cJ\0|&Ljq&x|560h+\r#l:C::Ұ6\r#`; P<+@,6<@M:S\n%\n T\rl7M16OX9-%H#,;\r@P:7?3\niSЕ?l::N;e/cC-uV?;a=[/X57s(h[\0޴jA	D#L33H##{\r\"\rsGBD48D82oڒ\$舣ƌ\\bL7Ȉ!ON)ChȃP܊ll(<O\"ܑ(˴Ûv:+:(;o1r9%#8!\r{iTXe6N\$h4bd:'\0P6\02C@\r3\r*Ohee4\0چ/I0\rǂ6J\\=iXÓ['lN[ȼHe/O\"p?M^Aײ|qmFO<%X^[5,6CpADlr\n6FnSRBR( H\$ҊSV	\\n7>`0CvS7Fm`jä+\\@B8D{\$ :`	ACG#!G	R`tIA)%DaxrKiux\"\r\"fh+\"eljwQi\n4f/PPٻ5Hṥ|c)'_ڛ&ܤHkѻcy/,_R'.\"2\$p0@P!60	i*(\0RO5_eNW2]mBhIy,jțJ2Kv`1H9)#~\r1-ؓ'Ip!,`I d]D'`߂S\nAiIN\r2HQr\$\0Ց&\$̚aHgueu?1Al\n'	bς0(3+J_[ex	%sJrE( Ķ͕#*l!P -G-  	AuV3,c&8)ZH#*2u+GĆMcYFW^.x\0gat=kdBHDT(\0BE\nA\$'trA\0B	H*@uԺʡUpa@`P^}!^cK=ZsHwS5V8`@T:NM2ۄ	qv9,'Ei%\0S5jZXL&t_ܚJj7c\"qFUꤌS@Q?xLYS8\":bc9Ĕ9޸i>):B*,2A.J/f<1f0R\"Nd1w#[hOm\rϬ^Yg;9FvPͬm);>b\$e\rztM#&Rv\",±a\"ӚzYŇE*|3C%f\npATD\\Avh#7m!u7ŵޑ{*C2e&a܉=VsnYxޯQ}Ŷe\$,uϑCjfjU2Fk,\"~%bFnYCyR#9\nG/i/)󔱳aԉC.,s(\"e-)GNN?H,_fgpi}~mOYo|_(6KӖdXxF\\&;\$BX,u	)НO㪮!3@nzs%z#n,7ltlaY	!2`y,o~r0%^*D`{=U/\n`%!ɯM8o	+yb&gouN!ƞnH^xMf7)!83IvC@,`zbCAJ\rrd2hH,G0|D\$YKv0A~QC\$@ҢbOe)/NcDoihN/\rpװh0e6\0hMd\nCl^,CF%`]\00iRs	c\r/4nb8ŘYϛLN-tq\\Y0\n-?C֘l@TGh#\$>3Nv0ѧ0Lv\rN=\0@Ճ!F	iQ\"qS\rV*?\rfXْe\n9\"\"?ծGr4B2r\"2 =N#(#r\$CzA4=N@E	RFx1eF3NLЙ%qg&('QC&t\\:2w&5\"/R<㒢.!I*Y#\0\rV\rgr):&>\$6\"	dXȞ`p팟\"\r+bi'40_(4}-j\rFqd	:0(lZ9>\\r.=p3%+-k2EX#ir-d56\ng81i0%Q3P'bE\$rEab2O8R\$,'&	#;'\0ވ1Pe9RR[L@roo^\n@cXz#c<J1kт/\\c;A81`9_cF9Bl@:JfBxl<w&^,";break;case"ta":$e="%)J::u>8@#\"\0p6&ALQ\\!_ FKh3Xҽ.B!Pt9_`\$RTmq?5MN%urι@WDS\n4;(pP0cAn8UUɼ_ArªZ.(qg+S\\+5IXrO8ꇥՕz*\n@{Mbkeu\n_Q*Adu'c(oFe3NbNd0<CA:#4R_0*F)H\"0a\\XNB\\8S[(\"pl2ܲȲqJ*{(r	*zEDP0lbB4;Bb\")1T2Z(*I[B57P\"\\&\"EGA@<o,(Z+j(4.2l5L4md9'CH4itٹP 7,(|%2tbt4U)]X3O\rDh l4 <x\$i#r`6k\04@;/l=7(;̓ X90z\r8a^(\\CtM8^2xw^K`|6͏,3Mk4px!Nu3)?Nk/*л:zdEl(۪`ƋBWM:.2_X]6<X)5-Z:/Bi)]]kCj%G%+h,7[(J2HJ4x<`ꚜUu]`HDObW%EUb%0e;#`2.\"w\\gzՌ#p:dr\nV|m3>G==ЍZiu<Yu\"s*Jw~ytJqĿJꖜjUDXΉ\\66Oya7\$	sp9ǘu@eR2֬v*m9?KREMRFYB6U4ikCfڛ5r\r?8c\nTU9U؀˙Ptr\"&|=4M_d /wiE\0P3ȳTFRGO9ỡ\"JA~X\$Bхc&sPHڵtS.S\$Wq	ˊ(+\0PDNW}ɌXŰWacK:V;~A<vRRl31,ŬɸR!^&^P~Sg	ekcW!|j]W;\rX:P\r9_%`K+N;D#PC-\r) w~<3`زhgf}ydA<ê[؂R`s^tp=i7S	0SNe̝*xu:}z l CĘϛ Un@Ji^aȳ_~/\0#a-6Vty2lM Wr_SH5di]JYtSJQ2ீ)KRH:,O{bawi_XW_PMaɇ1;؂ݳd9,J-(\rmNP!5MCbѳLe-A.goʴ|,Fpԯ!0mۆ6ʶlg]4#ˀz0k*U̩: \0tiv>I%9%i-ߑ0@PQAZ'9o՝qRFRٔqx(pM0:>|+n3ζ ho):j9gZ(eyaǏlMm	nmv*a^eO:r2F%ܦJLneBVʔnDGQ]H,T	ofK_k4E!3`+X\$\\3=Rv4;Gw\$+; {eŤxH4Kͺe(asT4}46|a:aHy;44LA?|o02k\r8c%+|NJ4H \n<)D.f>!HiJ̝0X:[6%)l)cFX@5f<|gɚ!sf8&9)%k`@ D2pK}<'D\nX8'ς\\U-ݙ@P*_[ E	ڤH{,psQx>M\nEQ(Po򔩇hbu?e'ҷm7w>H5Oy>G=\r@E`xgxH~J.jM1d'VﶉJ\$7V\$03oƊoԌlF{Ow,'|4.\$hVCiZ5pJ̍2Ҕj6\$\$\nJ\nD>E24NNe`*:dN\0NoD- tCM`Xky)1NQ蘧y\"n|:*%\n\0_%`S/P7vmh6jZj\n`Gpi.gpPx\0Ĥ\0%KGl@ʽ Z@Jo=h.O@l:&ϏF2\"R\r[\0g&#\$TBz/	 klPB#FmO\0pHnl\rb\ne?#` 	8\$npȍo>w,J)ly`NGv+F*)!B#W \\j\0d#{0v]P09/h\n`\\M Z\ndZ%\0mȤq/.oBK9'PpyB\$q2)@g\"g-L f,(qU-RP9qR/Ǝ&+M&@\\-07D\0Q8S'/iK/\nQ3m54F,4(J%%V331	mKRҲ-z3S8M1p}5sx?2=4Px0;	{1;j}4C	(] @M`ym*./}\$ѿql\\ȃj2ܵ/ptJ\$QBI2V5ӆU7U7w;,EZٱ\$hwF&\rCohw;j,+E%83~9D\$M~3/9oСd5mF5\"켷m\r=S-|Hu:f8ІԐ)G- )\r7S2+nPSZG\nAFn8UAJ;`OL\$GvN71SUq3GtU3[<kM3VUW4Q/WU*5O>k7uW	EUPy&4z.s<#E'T('\\`vN,~\$	5STKGU#	L=1.\"[2H\"tt7_\"%#C+{YoQu%/\$sjs\0,\0O\rM\r\0͠vu?tgg]'w2E rHQ5Eum3֑^p=\r=ctCj5#ZUpVӱϏS1jVVjj5v㶽&UdKr(Q/,Vv=VQ\\R3cd&'nX3_J4p{PK/qq=<Z&&'+2Kuslmv8ts\r@;o-`MgSQ6p׏0WwXjz14&s)vY[Ed,[\\YFƮ3w6s-bП!HLKyU-vr%g*А9a-Titm{u5}WrrDtu#'8wvA~V\",yDx6X \nЍyl-2't:ȯ?E2Չ|\"t}W}W~kOؖ|\\)oSooju77mTPYoՃWW8Vnm{]lO\$Y7ÐXVƎp%@PȾlVVl7ntsu\$0qWS5p2V&g9+yOYalɕ\r%>\njW3C\nIM9qҧGlDTW\$S8-mOJQP~\rޑ[𜉔|9t2	p!t	iG720myU0Qn6ٗ6nUxxۊe0퇛⹓xÓdo!g;Ow\\i\\.n98r\rc\\`b^l\0!|<Cڄv,yqn2?Zf,_! A7b\0;{I)8a2c߬7zsgZ:#Z뉚{A9;{{~(:SֵU)D|ds'\n&5rwǞLw;5iW[?ߕx2z{1hQ/eo;A2YѮ9?Q\\<M7Wxeg:5i[{BN%8op2>/w;Y{TáuxcC(\$dS\$_.&qT~y\"\\\03m3RwoP<m;yaCY׼{j\rV@ ֙ @vl?j\r\r ̨)\0z<L\np	\$)хđ*v*2&\rt<k`ɵYg0r4+{0tcZyZcTgL-գ		aRU wPN\ryG!D2Js]	DN'uIP KQZf8_@]Ž#Oï\\VEt4Nq͗7{mWE(-@PzvR ɕ:bP%iƐ(D~nՑi\n>c<LYQpHG?ޗ|9;fy'-ЊFʷ9]22i'- K( I(֭=yP~4TB&\0_qv)`\0fy'|i\"\$\n!˂|Wƕgc|TMևr\$]!;Ǚ.([ۭ@0k&6Q >XAuH<CIB]UH4\0	\0t	@\n`";break;case"th":$e="%OZAS0U/Z\$CDAUPȴqp*\n*\nW	lM1\"T!R4\\K3umpPUq\\-c8UR\n%bh9\\EY*uq2[S\ny8\\E1BH#'\0Pb2as=G\nASZg\\Zsf{2q4\rvuTq,..+lţAsԖ\nQ{[w44=eH.N[y3+/YH`iЏH:]PQdu'c(74H2(\08@#)l')pD\nF\\;-\\\\2X;h*T=:7*!e9S\\qp;䡔R[\$RB`P#pΞC.(c4+Rء¨57PC#j-3j|i84N'q)ۙ:'K-Q8ԡAQp&\nYJAEaU:1{ܢS2\r,|\r@9m#s(6%\r#;0p@7h; XH90z\r8a^h\\0@x7|C ^.@?(@\r7^0γosguU,-\\E~>Kb_nZә,1|h1skF6zރ<5:j\r\\\r\n7\\Ø#!z\n=|P\$e !*\"{m˪l*<y/.jtPߧϡ\0P#m:niF)-ʙHϲPlPRIū+Cկ\\jd_1Eln͚g()Dg/Qg=-M{\\זĨ;R\n(PFuA!a\rϩ˔z_8 \naD&5ĦK*())AfxZAl-t*cPYGJӋ!I0+)'W!Stz2tUK)XvV\na8\0ܸ۴-7E\njA'z(k6\n9Fq'dwAa:5Y\0չ܃a,Ce4yd>.h-22x?(TYPrePٚ6'B&NE\$%lј~<&|c\$!i'.@SG+C0f\rIlAKݚ)\rYrWΨ(s_a9P@-P(`zIGƟ=DjYFE(rxwAlZHU}O1˰?,0FSaB10X/Z:20[eIPȶ{q\\W DCVmXjYb5kE͢c}jBrэV8ep\r,\0002c`{\r1F,%,}8mbP+d\r5UrTEd\\IES	%W8]@dG*yla-mЈ\\A=*.s6;)lKĤ6C副O\0p3<\0\0(.ŃSdf	E'`*MGu)@H VrvCxwv6vR!KٛZ}d-t64B7\n@lrZ:A۾P̛GoֶS\nAdN~5Lr=9yrT|VqW8Q)L=Ԗoj4;W:RWQXLsA\$*:[K7[,]AKh3'P-i1|A9؜fZ|Чݼ	N<Us5'5DzJ1PֻqCYa,t\rA^Y}Ȫ'@s]N((\$@#L1i,͜P/\"LLF@rt^'D0P*^ E	u%`zpQ5lRWPܯ66؆!NokBhfo=.Oiu(צ3AcҚ궛CrV#7nBF݅h@Mғ)MA֘?>5t㹟iJ&t3.Ĥa u<\"dpp<:T0.boUrA\rT°&obiAL4bK^bdnM@\r unl`.`[ +)@l.*-v\rp@lv\r~>R\"\"(Z@lNEd\"z-*FXL</ƾj(FGmdlrFNw\0\0\rff\0BLyIq#e%\n\"A`D^0@	-\")QTmIGbPFI'h3E3JN+4逨 	\0@DZ?|\$&ި/J-fo ^08I\\mQ0GdD\nI<j.f=Fv6g-ό:jnP/2%<Z'~!qQflqn*qњ;R	T^ @O(E'p0m+ڕkC!j)qɐrr@S&N\$ZQ%Q]N@ƩG%\"\$g#Ě#n5#\rr6j#<GX7~0h#8n¯ҢQC##!hUd\r;14&B~+\r jqPNLQ/P6\$oldM/T'䶮q\n. :KkD:g-'3Q-C0m-/s6'DDoqhxG*g((LO`~'Q+w\\'r|b9nS`:9:%G	-ɍplLD4=ssx-\" \0^ \rX\r^\rr}N։l)zŭP1\n\$DxsS2(%#A\$x6Mȑ7oE6ccDWЗ=(iDbD?FGrPloD+|It!F6q\$\$l>\$;\no\$\no4.KOO2tPЩKp+pLT\$h?F=tKtMEF(ƚ(yEF#JILNrڮ\$a.n>\0kF58ssl/dl|[RƩSS&kUBSGl~-p\$>pNnoO.u'3\r;U|R3÷\r#Q\"GRFmMN(c35>'q5rN\\ԩOcVS]Ps!81[EZma.C5>%_pޔ[i[NI;`_ugޏ5QyCdjPu`)bI_tS^@D76I8\rjH2J^ޭ5'HE[)bX-Ċfr)`\nEZS_Gb5[No_9i꺴v/249jpaTl@HB;\\\"@\$\\`ȓJkҠ`e>v\rn+3RC.Z`].Zar\$?Dw.ulY's,ڐy?KȈp@0k1iCfkjUycvlGwEjV4Lj?j}xoO[)d)\rb,R;KQc7lcJ|M|ȕc7P|rOIlTP	\r~[fm`IIjtKJUT`6brKy)%-Agj>}8<G1U1_;炦׃m\r7\$\0DeZ<''I*\$\nZ	^LdeJx.-U0<rĘ9.9LU \0nՌr䤘\nfi-~#EmJ4-lS=C/<3=t'FF\"C0LH&2(0 k9e5Ua*)oPĤƩoJe3rR3uBttIqom]@D?Cr.\r૥̈hu1U67ւy@(9k>n\0KE9n}p[7~=GP0JC@\\ UUq(l(a=WR=mHZPX]\"6e<I·fPQKL|wp()`&'/%Ç @bKG.7\$Eeq6nCg} 	\0t	@\n`";break;case"tr":$e="%(o9L\";\rln2NFai<BS`z4hP\"2B!Bu:`Ehr2r	LcAb'\0(`1ƃQp9Φal1N5+b(Bi=QIBa6 CԞ+i5f7D)~,2C2\rvC%<NfFe0\"v0DS#iLdF#]HZWESqo;ȢG(pi9\"CE\n(/b\n(@JhJ&bN\rbȵJ82aǎc8#Lx172B9:\rz;C XX90z\r8a^\\0i\n\$#C8^]\"C ^'aڍ7	̍\rx#*&(,#hƖ,lK.&JBtL68ʤ4,,a\01*\"XMcY-7rU4:P:\r*#.X9jO)4h@P\rkr27U64\0U0CCHSPsQ4bn]|W`ҋbkRӈTb+bn,쳙:pX(5PAT3g?:|4BOҵyO\"֭I唶_J\r+!<\\m47(\$x7*<׉ ɤ!\0:ֹ/ٝ!Qh&&#Ek.`<h6nP4Bӧi˷4ܧ\\<>Crourh_s}C;Q>ՍL2-J6yCh2ki9ᦃ_xl@3#һ6\$dδ-\n\rAbVՐ5;os<^	k걪r#i9~)\$3JiϓC\ra`2\"DjI	-&ҪWK!-F\nc\r*rX>A0LX7\")xc{9@t	K6@8 ~ Ws-dsM,=E \\Xl&1Br<\"9(%\$ZK50\$ętp60|\n):M\nnP\04:!baDY#Ƃjk4K6vFj;}MmkwCX:JS:q\n7,\\A\"\0R@\n	)kxQ\n3*\r,<^Ve\$c1t!pOBځ\"\$4R-ƶXK\"XE%#P4\$`2A3#FL\r\"\0\"(qInaQaL)iIo&\\#'4sOB1\$OaAEFHBaH\"X\$MI)sђ&ɓ#|KbC#Ly{	S&zhO\naPۑ2ܑFKAGQ[p1^yĒ%xNl`ZBR8vAye^L]XA7yB	%\n*4\$K\$_@vdR\\9VE	uX8PT\$t1\")ho\n87Po\0Gc{9\0002vQ?<lQty\"tu0Zǯ(awO\rXH\$J(\n-hd	n[%v̪X;[ Bݪ'!Jd^t;pӀ#t	6qlKdyRU)GSoq]B6KoX0\nP8 5K07î4uΉ4IÚ=`(X:\\lڎb\0(\$:Dâ!%Bݱˆr36VN+ŗlӁ԰Dy70ޗ;NCp59x*0<`^7؛'pM~,ZQbCxO9gLWߐBH92''&!5V\nnLs'f4zK>/*Uge51|y\\MϤyCHiyuЊkcf<op~-D}|ˤq'VWd{B:X?%ug**7r :0#v99n2+}*%C=&e	7H/z\n;j:FS-TRUSt!:aQMhaZIyNr/͌G3͛	ץ\"W&C[tmGMZ%t宭[B(qLTb06v& 8DB\"ڄ:eO*\rX]Ij.xX\nlՀLTc4Ô;nW̸;/dl+L>.&j	Fdge,H).tlN.idh8N\rpļ	bܦ%	{+r:ۦ4W\\F@h,,b3b\"H*I.iX+cꔢr\0?k::	('ۑLaU>9M׭~Sqw,Ѥje.ѧFjPI	Ʀ1ze`LÔD:ua8\"OP!	;K!p8Q\\N債	Rž<QPr8̒J\\,}\$B@ʋ =N:8@ݒhȲ/I'fBk&D\ri(]('2Yr5*62'2\r)A#_,#E\$ E}?h1-.fN@'\\\$!@O\nL,E^VVag0EV1Ș%\r/W`!DY\r;bȂ/tNN\rVP0;%r	4H\$Ct\"g\0x e1%lZ4 gILVPܻ<S+\rhӸ:3b\0@;7O#rfRX0\n[3q.[7h,4Q>7+Şyr B{'K0ಲ;E^:]W~`PM-\"ZkJj22ܷDXS>_FG;*/2+fR'e/f*Q2\"Qp\0	|;l%A>c@sc&\r|ZH%	R7\06l\n|t:g!8%NtEg!q;bj~Ab=4\rOw0gD#@";break;case"uk":$e="%)h-ZƂh. h-mhĆ& h#˘.(.<h#v_Ps94R\\h%p	NmcL4PҒ\0(`1ƃQp9(;Au\r*u`Cd-|EX/5AbQ\",b8\$4漠c<,[\"\\c0qEҚ(-cW;,-c\\Qe-Z)xb}8G!L)5_ODsUڥ¶7J*(r|\0#'iz0)28޷4\")?({bBLbj#|h&)`Ыۢm\"@sZX+M\"6(4<\$*\r%?L▇'b\r(M'rQĮ9s(xp;PGB6#p99 \$,\n\$I)MU8hb[l<ֈa`@!\090z\r8a^(\\0tm\rp^8#;٣ ^+AtͦIT)m)a^0JjXp	@0(8B[hT\n:uZ7*#J@(s!ȃ%T N[Qen`8O+~!1!ZE\$^sqEoD''l>79&2cȥǍʾ¬Kƃi,=ٯ,פZ'!kdZs+ћ2&9Sm،ri1VɯBj4Ί2`Ҫ'h{n0=`P(9\$(3ɔ_Ccn؝b2S{k-lC+\nL]3}oIӟ)5?ORʏ@@upX<~di( &d3īs.HA%ΘQwG1\0^k0Ҵ[Pز&Yw/]!8vEd9VFhfUJȨF\rI6(a\"z댒xa\"`\ntjѺUjnm&MvJ6ęjGh4`rn'ǉ/b5Fgq9LY~jrɑLL:XQJ.#58DY\$:`ͥ4:%)=6+v̇KTJ4jMWlsQ{̆]2N:h6fR3b&%/eB]>Y-,jLF;J|S.yJ	7?\r\\iq\$D(xBdZJ\"\$,(yE(<(<7V]~Vdu7j[ABOlE'4_8Ƚ bGNP-P 7f/Ʌ.Z*]{yמ(cUCwNmeҴV]+|X\",֊h:I&oBNRR\nJUK&\"eDS:l*Cc#JaMG^xnsCdC)A,j+K'^%2HRid-1Wvew/^4i\n5Z؂n5j>@PF۩AZ6ܞ^)JqCtr͑S<2 q'5fFgr<;y62s\0o\n:(ej!3fإTb̒z2Q\n\"┐F=8JP48QIE,:HH\"qiC8(aka#Ld[;)TӨrb7NZknhX4{m*b<f*D+36 5YT:OYbS\".2|%\"Y*+@xS\n9=\nrYYV1qhBsbۡ6EMb'7usT[Y9mCA,X\nL*߼؊U`F\n@7	bҪT_E`x;>.^ki#z6`a@CC\r&#OcBo!ڍDZPW撥[tt6prNh1\"\\sAZ|Y\\QnS2yUJVhMJ=vh7PK?\r󯻵;>XNI+J^+Y܆zޚơɓ4\\~\n!P/τp\n75VcOMr6twP8Hk0A)@wuYg')p^@OHHjoǦ7 ep\r%#L|̙f2<z>owhZB`\rQ\r 4,|\r\$2nGn(Rh\"dGdfd`^4vK΀-hlf1nE'0)D}\n^h|G)jN/'c\$NnO\r'PS`e&JL8E{l2b}%Ԅv&|оxJ\\LlVF\n 	x&y&B(Ĭ^HHȍfڙ&\0cegI;gx<s0<`M\n#R/蔈x1jT%1{ƺT1pfd'b~u\nqJkdQFz\$GeAƅ#%gѴQ{Q(qQ' QRk\"1y!\$i!q4C!dfstLmmB\n\$kxIp\rlvtmorf5L\\?hKr\",!vPb^n)rAB&SN*f\$3+Vzg(kBt+-%27eкp3k\0C`Cf.8!\$h1\0,(&s1zs'&))}2J./Oڅxs%\$JITl)74˱37pHVaߤBPZl͚!12  *@B2VM8,>SSzS*LƻPjq:7k6Z<p\">zp~L `\r\r,Q=#T\rNd<U/4X36+/??t/!NYDSU7ICkETqE]b(K0>曏zdvVR'GDbxq\$ɞ46RBJJs\"KSHKNtI,5LJ#tKl\$(<{\niM#DԊ;\reaQts34?\nQ2QCQ|Oz̥-m˛d2B&̣?ԀT=mH#UUR˜^ԥb{^zS3Gd:\"X,-+U62U\$OU)\n.ՖLa	f*0.5FcuHs5HcB{_JO`p@EGuIHMG*U2&!`_Q5b55?T{c_dGO^#U-ipPP/c)N/3SD⌲uh+(pdJt`4\"[cSRS6VVk&YTgD{2ueb6tlO\rf6%,VoVKn%Xִ|?8(zK&ĕ#cp̯<ԊqkSm8((aQEbfOOr/PP?PSkeuKReWan2+1/fGUf*(3\0k~.r3joGD=zed4k{dxF\\p6!k\0sԺq'&2Vn17kg6)1hi1 \nNW?,J1Ðg悻*rt\0xnX6¹|ֻPtM]vˆ4iw1vMxsOd% phrl+Fk+(UdW1U(rd\0\nq 1wyEt5K8S|Ɏ&\0	#%{TXv:sEI}nuaa8tiF\"\085Q0FoĝDLx-8)\0td2Q&9e(lmf2 TwP1.QI48HC4\rH#_JkD8ٯk2'<xvٟL\$uI7NaĨdbOJ9_̼=`|nP`2Y]٬P'Bֆjs&,w@/1n	1Hao\nҥ0(#q6_'i-~i(c\\/ Ɇ/%3:mr,k4qϨbx9T;I61T(h*|R+0SNˡ";break;case"uz":$e="%(a<\rƑk6LBNl6Lp(a51`u<'Ai6&%4MF`B\"u2Kc'80cAn8!\"n:far Io7X&9 5瑃Ha9DڽiŎ1ҡj`\r\0Y/2~DD#ՅB;F :γI 4N;A)N:aLvCRӤՙq9&sȵF1WͦtOܺ2µ\\L9uh@<3`5F\nc(;AϺ+@7/KX0C{XC-lzF4+̈#\"x7A\0CͪÈM&Q(؈Akv;0\"2\r!`@;x3t#Q38^2|v9c:2|/!81C!x#--S78P:I4<h<P!N6S˝6TET̋-b2(:x7\ng`ÀPJģ5B\rԲζV\0 à޼\"۾RjR13^\$6i`V9#44qZr6-28#̍cM2x%i0˭RpB#xlpȻN3X޹3)Sı;R<9atv~UHH,PjB6h\n2=%Z52!bz6ZH83芐ME+^UIҩ0ZD;]C4MPE9H4M?c~sgG/ȵ.KrMwn4Cstaփ7;S8רw^%hk`nP2Ir~C`zk3\"#ܮ-bRP#XCf&˥~Yqn-)ifH3 Yw Ay %w48Kx2[)09i;\0!%h#xFϿBZ4(4]a1&(4.\rL	2&dКlF7C!p%a'|]\nhbHI\\\0sSr\r IKD斠IPm%aBYF \nAbP16&9 ê5Qa/E*gM)6@rN<DHj~`q.?rPJE*BoA2&TB\$P 2`zCD	H8C\0\$<<\$0Nfi1;AB6GBZt&K)56HJ	H\nuP諝('R;R?( :ߛ+b~rI\$䤕DL#ovqJHʇht M\rrV؈rKAҒJD\$,6@P0!01?r) !V>P0^4&&n҃\0ЁPW]ShD9}?kqU`xhljpu\$xS\nB<s5eM(b2\r4vc4v4k锶p)\"jM0F\nlxCb9 #αD )s1ItyyT,HL@{8C	\$)`rZfR}xt-8\n\nw˥sIZhCtgnk\"UT<3!=3}DQT3F#r\"Do<yNeu˹[)[9ɄaF!N^k>\r(\"ȴWJP㤣4mаRM1Omt>JPޔq	=A\rJҿ8B2adx\$u{\0(951{oDmjftL!yQ̻wO\nh)a\rȕT0jZN{Kh'ƧhP\\Bj+4B:ZS{?w^@%*07Y+AuL4LBouBBT8J!7NJ)Nn;	!RAyNYAo%Ryy@a%4-΀gRU'-c|Δzl*s<u%UM:ZѳRNq4\$uf޲'F}#vA%cF#Y0ę7.,laJ\"Kz]PI\rէ#Zz82L6!.sTIf\n,oQf* _#܅<2TNBC\nHe*Uʻ\rĳOҼ5zTMYOM2_q=~G*wcr\neih%Z\$Vl2PBx/d^WeZ\"Z.@\n%ԢmHB[bb\0芠d<@  >RR?K<Zk\$OH{I\$ph&~r]\$Vm\$aH{3jPPmp;)\rN3VP܂ܿ@Ϲp\rfO8g;2466{hPX\"ZI*@\$E-#n.mqN1R\rcn^<		F3(JƝ@q۱Ze&VFVZE\r,U\rq\n-ϻ1bnHT&oj%#p\"%P#3W,3%._EV&2&\$@5ʂNw&|R#f#Aq`^, 1Ǧ#\rYeW% ^I]rCt>qFR(QM\$-&)/v5u)U%ߤs(+N))\$ߋg,2,s'&g%D\$*r%4&r*/Cd-*o	\0X_'J~33/-&Y!9b,/#219:\0.\r2az\03sHUeWq6/n,lpA\0;/VÀ}`b*<H\nZc\$%zp1{n1\\QOo]I2#m+&	f%G`2cI\0-%69sD<E	s?K.%=xDODnln=c_Â,l@-cI%\$M8hh'3JpV1Fd,\0@FX~-z8FT~3ZCo1I\0`W-	c>'\"v-pTtİ/q%XZ	\$tݒcX)=r?y?GE!Ъq?_Gޒ*uسM\\&R@";break;case"vi":$e="%(ha\rq]Ҍ]c\rTnAjhc,\"	b5H؉q	Nd)	R!/5!PäA&n&0cAn810Lthb*L QCH1b	,Q^c:A A0Az\rs|VʐQ\rB\\nfFd+㕸{-ԊNsMqf!&JN\n¼vkknRw N!o*)'cL,X7 q |9*fyސ2C9\$\"B~0+]P)ZR8\\HZ:\n\n(TbP>-~ᘄAHytV\0P4Igڈ1\"80P2\r,\0(\r\0:#+o*0C2҇\rp;c X90z\r8a^\\0	x7=ϡxDl8<46CH7x\$\"^.J]/{/o5#@edɻP0Ct̂#<(P9 P\" ޷\r7R]\$K	G\" ,E2(:\00SԖR\$\$Q0XnY~1,@1JHeǗEz6<;̔O&iZ/-H@@fBBnr#(S#=%_[3r8&C68P0*b2{]h\"K[Kp߿\raX5n6lM B:JH(apkHedmZ1,ڟ)\\w[Nh9\rIBIDV5CaWHh|/H6\ryJGx2(2qA:\"\$LxhH,QyJobd0PuyI7`̮pe'[JQ}bԂ.	(0D+C+B\n:wW\nx^h7HQ\$^L\ri]U @0 IF\$ߨiM@T:Qj5GԬeaM)ȫjT@?ZB!\n4Bl('䴙\$l/ä?t\rH<&@\$erXHPD(R\0GTښ~*m)FL.\"\" h\$+]3^ȹC2*@ۓas8:p.ʸf\\y-\$!\r('\"IӃBFC20Ch95&\n!qhD]t@@P\$숯 .\r\$M_C0\0O#<%`{baЍ\0*MCyL`PvO	>%dJ!D]oIIu\nA5K*A,ÚBH\"	D( :IeAp Fd.. m,eDOH@9QaJ^HbBHyA5%|@B\$2;KPzoi]<7U/)\$X^xS\n61v&N,܊Iu%B(-mFFDl&|jMDHX^OCf#JTvd;.1tSF`WJŰT/i%,]\"IXnH9ǩ	H骑[pa;#}a%͈ծe+\"G!\ri9iyl#/\0DKdG+a1g	+ZPʹvZfBTvB\$\\#zt,(OL]?PV15)(L&vZCTqĵ۶\0}=/LVUD2焫JT@h!aBLHHBjj@	-]y(w2Lސ\r\n	%mHt86 ,rGEDtUl\\a>3^9p28&A45snmro2RVq q4Ѭ^kMY/|\0At=Ō]ڟ\0jPC @BHm+AA^\\98y\0}5HAx Ng\"%(hi&%Bs\nDI/?AffL1GII.-vJAmbPΤ&w ^Gsځ7>Ę0JXܸt+VFm\"OH3|!\"UB7W{y{L,s4ݕy5¬џ\"V!m2nl! !nB\0olek>lpJmzLJE98:>Dv7\0(.j@@B6'@~BAb<e^&j/eQ:0&p:Cr8\"\r .F\r,zf\rɰHk^0vI\rˈpΰ,6\nΰ\08ct.sdOofC:.}	!\r  E	!#	lN2\"Cb12ɶ]@/ɬ%@@H\$.bdBOjHСNXd@W\$\\4ND:I.QFfLZEZ5ʉoqܬMj'Z-ȓόNt&:rl22j_rxВ\"o_0HH/	JtD.V;eOrŊZ\0@DJR	\0ohHE&0j( ~l(0ߍpb*poЄAb*;j^N(ܞ%6>P`Һm@,&j++-b.I\nJf} zh)P1!n{/\r0R!0>=r12C1VIdYR\"~,h'B@.1-4ĐRi,f\r]hܦ,XB66G\"6\$Hm7'8;ZLF<LH\$r'O9\\Qz  FJ)\0XJ-VIP<@_%12\"s1f5Db\nZR,VE񬢄\",V\re{\"AQ|7KM=)sC|V4#J7G*<k&'b\"Ɨ;6#3jL^װG&.8CoYL@(1,c@dFrT q(0.28ҬE6TYB-O%f Aޯ@ll\0rcX	k-pkj^^-meH!H˃f+væEu\0ŅaVFV^3AԠ@\0FalhCPS,IG_1rE";break;case"zh":$e="%:\$\nr.r/dȻ[8 S8rNT*Ю\\9HHZ1!SVJ@%9Ql]m	FU*qQ;Cf4)ΔT9w:vO\"%CBrix9Q*Y(cȗB/΅F:IIԼM*s#Uԇ5zN\"\\2s&֑E~~&!rskk=͈BQpgLBUB<:B^qTO])Di_Hs{zPS>OinrjW9@@{\"DL*as,\$# 4(tdNR(1(W©1\\_\$\\˯g,	BY2G,\r3:x)=DAp9x79c2p;E1AAN4I |\$4E1 #|srIdrU&S)6_#`re%iLr\$PKR8r,fTNQCG)T=;TI!@TsP^VQ7LB:H9hQ!vszF\\Iud\r쑄4ZS:<V5]3ąh[.6^\nT5g1UH(B]&rҴG)rsydքAQeaLA4ͳV9PEمZV!txjG)]:CJg>MV9h95à9\r\0ø#0!V97HϷ\n-\0qʑ)')bJ}^>sc~U9XS!%X/AtF4ّjJE5r\r䱬3]qC:!btIX11R[mhC\$HӲWD0'@L,:r|¼[\0 @\$ԭA1v+DH!%\$ĜTJ!,xdpa:A4_:X%PQ'En.)=\"&Ѱ:-ߑhipWѺ.&>NEH%%ԞRwJ^\0e/8\\S|	Xĳ+bT\\ 0\\Q#HB¾\$X%\",ehLF8LF~OC9ظ@0F+P\\SBH\0G1!N_Da/%>:2;0̝E\0t.r2*!8E D\\.\r08RA`9K+3U(̡Gb\"[(Y#Zd\nΑ{9sD(4TWŰ&'pZ#\\:EM\n	c@ aL)`@E\$\$m=5D}\$rتvEqIII+UWU	Xya\n\$ڍUbthfH`9S\neňYq(a> (<-`AOR`cVH-rƩPtUػ(ks \"E;P(\"(	b0oVO?'59\$ =ks\n+\n	8PT@-hb^T\0PWe	Q~20؜09d \\\n.XSc)]AJ%C&erkiԃ3d_adaqssD/&м9&(q^*ҷ搎mlpv&K\$+[MKv`oJV\0C: `(94C@oZiH)\nl컐B\"\r!Ѳ`iV\\l	\".W̄t]	&ј쨎r\"ũ`(!CHа2\0ǟ^RT<H~Zاz4C[ǀ1&iCIbVk~QE`]2\n!zNТ2\0W榮zʫUlA0R`9@U<Pɪ%бabXLPDR6ٛ/[KJ7{ݻA{c>KKS'\rΓePr(\\A:)U'G\0Ced6iGUlX-(brq\nT:2#ݰVaI\"z>Su%0N/`&+qoq5}g3)nkZ]%YHoQL|a>޴KK4C+[\rclK:H(ώ2eEx:f!ڽl^\0Dhm#U#}7\$6Ju%ggvvLmiIKLk_rTP̰BBZ#erH,F!pȕ(j(P/R.+NE2SoLfpTx\$e`Fj2ORv'bT0#	%Јi|.&B.Qc6>^f\\`\"J5Od(Oi쐐0̿mBh\r(\rf[*vfp[-d|P4(a=\0ϠLm8\0xoy\$El;.Ѐo,.m\rLam-%cs}*^wPyLno-\0	 pf8.!tcRw#rhw{a\\'*w뭾Ϭ܇aag\r 5.wc(na/°\nZ|p۰ȢCZR;N0w0F!(5!^À<\n,~0H!^Lz[D|pa!A)(~\\<\$#\n<aj\nb2rfAx(!-XeXl\0cV%2&Fp+O#1˞KgF'lTGah l\n`ڈB/,#G,\$\$A,ؼ`-k6;!L@6ò2A|bA._";break;case"zh-tw":$e="%:\$\ns.eUȸE9PK72(Ph)ʅ@:i	aJe R)ܫ{	Nd(vQDCѮUjaʜTOABPb2ar\nr/WtЀBT)*yX^%ӕ\\r~<OTw2\$N\"]4;,t(i1B޼W*=`0XL6!B9J\"XQ2M2neʀE|N.:B,S9+::2^ʧzέCV:[D*@ST -I8sԮbR)M:rEYYg9jXt(dPL)^C-e0!V%>REpr\$)P2\rH2GI@H\$EjsaZ\$EQJ+5\rC@Q\n\r3:x3iGp9x79c2tJ(AALEAFPx)GI\\ę( RW!u2sL7%LT1-TuesV)\"EA(C2R\"FKʳESoi#d\$2w%JR^Md1H N&k9]g1Gg9{[q%]ijCA\0Qm7cz\n(:I*[2=l\$<B<Gb&{{1I\$:!_ԤODUVT1UEtVQ5؊Tx\"<])KӸ]Y]#iϧT*Cף@61+O:Cp@0C9#GW97H|ѷIʜ1 @sOw`Kvęh1PPD#BJ\n&s+\0OhZKK'#VZ<\\*\r4gI6Q:״C)Q|MąB&Jj&i*NUbäHa|#HSKSF\rЈA>:`+'T#4jÔnQ\\Mx&Hd^L	2&dК:mM9t\r.m>#UDY#]K)AL2(G<T ~HLiqN	{\r[K}04ʙúiMp7'\r3ZwbJ'l%W	2ʑR,KF8%1PEQD*ݛ4\"R)QI(X3`oHL90Ri?q(\$BӼw\0ZC0iJo \$!hID  \n (:!]x1PF.\n 5QJ؅2M@HSh	+DI4gIQK<b!n\"8A^%EjL\nf#@wi L^(zZ&I\0C\naH#\0Zs'b&E\$&(ra\\Ea|:@0\\Ak3&@ʦQL 0Ts2`fɰ9\" 	OAF%9#^E'EJ\n<)@@E\"F&\$gE3+W]<o\\4hTS~\0!*VDsY&bG\"B	Sxc	jd\0&k0'@BD!P\" E	,/Jʞ\"w1tǗ2BXcwN%d]qJ>TZ!@-Ǧz\0001Ӛ6Q\$\\`+{!,@a\nY\" \n&IyOIx.xaU2gHDxoJC*(lq3ъ`L\r2gF0Ɩs\r:*eb(X\nZ)~>n(\$ЎHto9B]/r9N+ps BS:S`Y%ڻ\0kЁ\r-D\rgSunMjt%4Xj`Vh\"=L/JS´-KC	(Bc8 8	QWzSs`@ZTsp	q/E|\$Ylͳ?_cR:]#Hq?㢧|#.lBێd\"~J2}NO(=DǨ\$DNK/E	Ÿ(\rAlux(]p (E6{?׈#2Bc\$\"\r\nޭtz2p,eU־ze9n5կ3m\\Wj*#<ps]7Ȭ/s|=]Hh\nXjx%_刲}:o!S\0\r&SF6c<ks@B@lJOr/NLfL/NLalDD\"DkkND>nN.W/J+kOnk/rhx\$9rllaʖdt>4I0Jtǋ\n	jpCpV9V\$h\nBj0p؋ИiH5bò5YXU{1/mM27M-|jlmohQ:^?fЎB1Pm1 iZSFt/BiA:.֘b`%8#pN`@lQ\\hrGB^(Ѵ8q\"\"pKX\0N`@J\0ϧ+q\rQqGͥꍜ*MQ!HZm\r%M\"ͽm#%7\$-^72L\$yǠl=\"q6r5M&&'c	kpP]fɃ\\n!DÎ&ԠƕPRnAK\0d.az!p]\n.7f!2PNX!z|:;^7{B\"О'!P\nZ;&֣΀ !bŅ,P!dp<SK022}2Z!jq1C̄N(spH;f̊0&Qa\\Ov#lp.j*p2_<Q(nL)B^<=2	\r\0l?R, \$\n`ڌ++=\r*NKZRsn:l2>NN;r=Lb`PN#B_`";break;}$ki=array();foreach(explode("\n",lzw_decompress($e))as$X)$ki[]=(strpos($X,"\t")?explode("\t",$X):$X);return$ki;}abstract
class
SqlDb{static$instance;var$extension;var$flavor='';var$server_info;var$affected_rows=0;var$info='';var$errno=0;var$error='';protected$multi;abstract
function
attach($P,$V,$H);abstract
function
quote($zh);abstract
function
select_db($Db);abstract
function
query($J,$ri=false);function
multi_query($J){return$this->multi=$this->query($J);}function
store_result(){return$this->multi;}function
next_result(){return
false;}}if(extension_loaded('pdo')){abstract
class
PdoDb
extends
SqlDb{protected$pdo;function
dsn($bc,$V,$H,array$xf=array()){$xf[\PDO::ATTR_ERRMODE]=\PDO::ERRMODE_SILENT;$xf[\PDO::ATTR_STATEMENT_CLASS]=array('Adminer\PdoResult');try{$this->pdo=new
\PDO($bc,$V,$H,$xf);}catch(\Exception$wc){return$wc->getMessage();}$this->server_info=@$this->pdo->getAttribute(\PDO::ATTR_SERVER_VERSION);return'';}function
quote($zh){return$this->pdo->quote($zh);}function
query($J,$ri=false){$K=$this->pdo->query($J);$this->error="";if(!$K){list(,$this->errno,$this->error)=$this->pdo->errorInfo();if(!$this->error)$this->error=lang(21);return
false;}$this->store_result($K);return$K;}function
store_result($K=null){if(!$K){$K=$this->multi;if(!$K)return
false;}if($K->columnCount()){$K->num_rows=$K->rowCount();return$K;}$this->affected_rows=$K->rowCount();return
true;}function
next_result(){$K=$this->multi;if(!is_object($K))return
false;$K->_offset=0;return@$K->nextRowset();}}class
PdoResult
extends
\PDOStatement{var$_offset=0,$num_rows;function
fetch_assoc(){return$this->fetch_array(\PDO::FETCH_ASSOC);}function
fetch_row(){return$this->fetch_array(\PDO::FETCH_NUM);}private
function
fetch_array($Ue){$L=$this->fetch($Ue);return($L?array_map(array($this,'unresource'),$L):$L);}private
function
unresource($X){return(is_resource($X)?stream_get_contents($X):$X);}function
fetch_field(){$M=(object)$this->getColumnMeta($this->_offset++);$U=$M->pdo_type;$M->type=($U==\PDO::PARAM_INT?0:15);$M->charsetnr=($U==\PDO::PARAM_LOB||(isset($M->flags)&&in_array("blob",(array)$M->flags))?63:0);return$M;}function
seek($kf){for($t=0;$t<$kf;$t++)$this->fetch();}}}function
add_driver($u,$D){SqlDriver::$drivers[$u]=$D;}function
get_driver($u){return
SqlDriver::$drivers[$u];}abstract
class
SqlDriver{static$instance;static$drivers=array();static$extensions=array();static$jush;protected$conn;protected$types=array();var$insertFunctions=array();var$editFunctions=array();var$unsigned=array();var$operators=array();var$functions=array();var$grouping=array();var$onActions="RESTRICT|NO ACTION|CASCADE|SET NULL|SET DEFAULT";var$partitionBy=array();var$inout="IN|OUT|INOUT";var$enumLength="'(?:''|[^'\\\\]|\\\\.)*'";var$generated=array();static
function
connect($P,$V,$H){$f=new
Db;return($f->attach($P,$V,$H)?:$f);}function
__construct(Db$f){$this->conn=$f;}function
types(){return
call_user_func_array('array_merge',array_values($this->types));}function
structuredTypes(){return
array_map('array_keys',$this->types);}function
enumLength(array$m){}function
unconvertFunction(array$m){}function
select($R,array$O,array$Z,array$s,array$zf=array(),$z=1,$F=0,$og=false){$Xd=(count($s)<count($O));$J=adminer()->selectQueryBuild($O,$Z,$s,$zf,$z,$F);if(!$J)$J="SELECT".limit(($_GET["page"]!="last"&&$z&&$s&&$Xd&&JUSH=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$O)."\nFROM ".table($R),($Z?"\nWHERE ".implode(" AND ",$Z):"").($s&&$Xd?"\nGROUP BY ".implode(", ",$s):"").($zf?"\nORDER BY ".implode(", ",$zf):""),$z,($F?$z*$F:0),"\n");$vh=microtime(true);$L=$this->conn->query($J);if($og)echo
adminer()->selectQuery($J,$vh,!$L);return$L;}function
delete($R,$wg,$z=0){$J="FROM ".table($R);return
queries("DELETE".($z?limit1($R,$J,$wg):" $J$wg"));}function
update($R,array$Q,$wg,$z=0,$dh="\n"){$Gi=array();foreach($Q
as$y=>$X)$Gi[]="$y = $X";$J=table($R)." SET$dh".implode(",$dh",$Gi);return
queries("UPDATE".($z?limit1($R,$J,$wg,$dh):" $J$wg"));}function
insert($R,array$Q){return
queries("INSERT INTO ".table($R).($Q?" (".implode(", ",array_keys($Q)).")\nVALUES (".implode(", ",$Q).")":" DEFAULT VALUES").$this->insertReturning($R));}function
insertReturning($R){return"";}function
insertUpdate($R,array$N,array$ng){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($J,$Wh){}function
convertSearch($v,array$X,array$m){return$v;}function
value($X,array$m){return(method_exists($this->conn,'value')?$this->conn->value($X,$m):$X);}function
quoteBinary($Rg){return
q($Rg);}function
warnings(){}function
tableHelp($D,$be=false){}function
inheritsFrom($R){return
array();}function
inheritedTables($R){return
array();}function
partitionsInfo($R){return
array();}function
hasCStyleEscapes(){return
false;}function
engines(){return
array();}function
supportsIndex(array$S){return!is_view($S);}function
indexAlgorithms(array$Gh){return
array();}function
checkConstraints($R){return
get_key_vals("SELECT c.CONSTRAINT_NAME, CHECK_CLAUSE
FROM INFORMATION_SCHEMA.CHECK_CONSTRAINTS c
JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS t ON c.CONSTRAINT_SCHEMA = t.CONSTRAINT_SCHEMA AND c.CONSTRAINT_NAME = t.CONSTRAINT_NAME
WHERE c.CONSTRAINT_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
AND t.TABLE_NAME = ".q($R)."
AND CHECK_CLAUSE NOT LIKE '% IS NOT NULL'",$this->conn);}function
allFields(){$L=array();if(DB!=""){foreach(get_rows("SELECT TABLE_NAME AS tab, COLUMN_NAME AS field, IS_NULLABLE AS nullable, DATA_TYPE AS type, CHARACTER_MAXIMUM_LENGTH AS length".(JUSH=='sql'?", COLUMN_KEY = 'PRI' AS `primary`":"")."
FROM INFORMATION_SCHEMA.COLUMNS
WHERE TABLE_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
ORDER BY TABLE_NAME, ORDINAL_POSITION",$this->conn)as$M){$M["null"]=($M["nullable"]=="YES");$L[$M["tab"]][]=$M;}}return$L;}}class
Adminer{static$instance;var$error='';function
name(){return"<a href='https://www.adminer.org/'".target_blank()." id='h1'><img src='".h(preg_replace("~\\?.*~","",ME)."?file=logo.png&version=5.4.0")."' width='24' height='24' alt='' id='logo'>Adminer</a>";}function
credentials(){return
array(SERVER,$_GET["username"],get_password());}function
connectSsl(){}function
permanentLogin($h=false){return
password_file($h);}function
bruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
serverName($P){return
h($P);}function
database(){return
DB;}function
databases($Rc=true){return
get_databases($Rc);}function
pluginsLinks(){}function
operators(){return
driver()->operators;}function
schemas(){return
schemas();}function
queryTimeout(){return
2;}function
afterConnect(){}function
headers(){}function
csp(array$xb){return$xb;}function
head($Ab=null){return
true;}function
bodyClass(){echo" adminer";}function
css(){$L=array();foreach(array("","-dark")as$Ue){$o="adminer$Ue.css";if(file_exists($o)){$Mc=file_get_contents($o);$L["$o?v=".crc32($Mc)]=($Ue?"dark":(preg_match('~prefers-color-scheme:\s*dark~',$Mc)?'':'light'));}}return$L;}function
loginForm(){echo"<table class='layout'>\n",adminer()->loginFormField('driver','<tr><th>'.lang(22).'<td>',input_hidden("auth[driver]","server")."MySQL / MariaDB"),adminer()->loginFormField('server','<tr><th>'.lang(23).'<td>','<input name="auth[server]" value="'.h(SERVER).'" title="hostname[:port]" placeholder="localhost" autocapitalize="off">'),adminer()->loginFormField('username','<tr><th>'.lang(24).'<td>','<input name="auth[username]" id="username" autofocus value="'.h($_GET["username"]).'" autocomplete="username" autocapitalize="off">'),adminer()->loginFormField('password','<tr><th>'.lang(25).'<td>','<input type="password" name="auth[password]" autocomplete="current-password">'),adminer()->loginFormField('db','<tr><th>'.lang(26).'<td>','<input name="auth[db]" value="'.h($_GET["db"]).'" autocapitalize="off">'),"</table>\n","<p><input type='submit' value='".lang(27)."'>\n",checkbox("auth[permanent]",1,$_COOKIE["adminer_permanent"],lang(28))."\n";}function
loginFormField($D,$qd,$Y){return$qd.$Y."\n";}function
login($xe,$H){if($H=="")return
lang(29,target_blank());return
true;}function
tableName(array$Gh){return
h($Gh["Name"]);}function
fieldName(array$m,$zf=0){$U=$m["full_type"];$hb=$m["comment"];return'<span title="'.h($U.($hb!=""?($U?": ":"").$hb:'')).'">'.h($m["field"]).'</span>';}function
selectLinks(array$Gh,$Q=""){$D=$Gh["Name"];echo'<p class="links">';$we=array("select"=>lang(30));if(support("table")||support("indexes"))$we["table"]=lang(31);$be=false;if(support("table")){$be=is_view($Gh);if(!$be)$we["create"]=lang(32);elseif(support("view"))$we["view"]=lang(33);}if($Q!==null)$we["edit"]=lang(34);foreach($we
as$y=>$X)echo" <a href='".h(ME)."$y=".urlencode($D).($y=="edit"?$Q:"")."'".bold(isset($_GET[$y])).">$X</a>";echo
doc_link(array(JUSH=>driver()->tableHelp($D,$be)),"?"),"\n";}function
foreignKeys($R){return
foreign_keys($R);}function
backwardKeys($R,$Fh){return
array();}function
backwardKeysPrint(array$Ba,array$M){}function
selectQuery($J,$vh,$Gc=false){$L="</p>\n";if(!$Gc&&($Oi=driver()->warnings())){$u="warnings";$L=", <a href='#$u'>".lang(35)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."$L<div id='$u' class='hidden'>\n$Oi</div>\n";}return"<p><code class='jush-".JUSH."'>".h(str_replace("\n"," ",$J))."</code> <span class='time'>(".format_time($vh).")</span>".(support("sql")?" <a href='".h(ME)."sql=".urlencode($J)."'>".lang(10)."</a>":"").$L;}function
sqlCommandQuery($J){return
shorten_utf8(trim($J),1000);}function
sqlPrintAfter(){}function
rowDescription($R){return"";}function
rowDescriptions(array$N,array$Uc){return$N;}function
selectLink($X,array$m){}function
selectVal($X,$_,array$m,$If){$L=($X===null?"<i>NULL</i>":(preg_match("~char|binary|boolean~",$m["type"])&&!preg_match("~var~",$m["type"])?"<code>$X</code>":(preg_match('~json~',$m["type"])?"<code class='jush-js'>$X</code>":$X)));if(is_blob($m)&&!is_utf8($X))$L="<i>".lang(36,strlen($If))."</i>";return($_?"<a href='".h($_)."'".(is_url($_)?target_blank():"").">$L</a>":$L);}function
editVal($X,array$m){return$X;}function
config(){return
array();}function
tableStructurePrint(array$n,$Gh=null){echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr><th>".lang(37)."<td>".lang(38).(support("comment")?"<td>".lang(39):"")."</thead>\n";$_h=driver()->structuredTypes();foreach($n
as$m){echo"<tr><th>".h($m["field"]);$U=h($m["full_type"]);$db=h($m["collation"]);echo"<td><span title='$db'>".(in_array($U,(array)$_h[lang(6)])?"<a href='".h(ME.'type='.urlencode($U))."'>$U</a>":$U.($db&&isset($Gh["Collation"])&&$db!=$Gh["Collation"]?" $db":""))."</span>",($m["null"]?" <i>NULL</i>":""),($m["auto_increment"]?" <i>".lang(40)."</i>":"");$k=h($m["default"]);echo(isset($m["default"])?" <span title='".lang(41)."'>[<b>".($m["generated"]?"<code class='jush-".JUSH."'>$k</code>":$k)."</b>]</span>":""),(support("comment")?"<td>".h($m["comment"]):""),"\n";}echo"</table>\n","</div>\n";}function
tableIndexesPrint(array$x,array$Gh){$Qf=false;foreach($x
as$D=>$w)$Qf|=!!$w["partial"];echo"<table>\n";$Ib=first(driver()->indexAlgorithms($Gh));foreach($x
as$D=>$w){ksort($w["columns"]);$og=array();foreach($w["columns"]as$y=>$X)$og[]="<i>".h($X)."</i>".($w["lengths"][$y]?"(".$w["lengths"][$y].")":"").($w["descs"][$y]?" DESC":"");echo"<tr title='".h($D)."'>","<th>$w[type]".($Ib&&$w['algorithm']!=$Ib?" ($w[algorithm])":""),"<td>".implode(", ",$og);if($Qf)echo"<td>".($w['partial']?"<code class='jush-".JUSH."'>WHERE ".h($w['partial']):"");echo"\n";}echo"</table>\n";}function
selectColumnsPrint(array$O,array$d){print_fieldset("select",lang(42),$O);$t=0;$O[""]=array();foreach($O
as$y=>$X){$X=idx($_GET["columns"],$y,array());$c=select_input(" name='columns[$t][col]'",$d,$X["col"],($y!==""?"selectFieldChange":"selectAddRow"));echo"<div>".(driver()->functions||driver()->grouping?html_select("columns[$t][fun]",array(-1=>"")+array_filter(array(lang(43)=>driver()->functions,lang(44)=>driver()->grouping)),$X["fun"]).on_help("event.target.value && event.target.value.replace(/ |\$/, '(') + ')'",1).script("qsl('select').onchange = function () { helpClose();".($y!==""?"":" qsl('select, input', this.parentNode).onchange();")." };","")."($c)":$c)."</div>\n";$t++;}echo"</div></fieldset>\n";}function
selectSearchPrint(array$Z,array$d,array$x){print_fieldset("search",lang(45),$Z);foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT")echo"<div>(<i>".implode("</i>, <i>",array_map('Adminer\h',$w["columns"]))."</i>) AGAINST"," <input type='search' name='fulltext[$t]' value='".h(idx($_GET["fulltext"],$t))."'>",script("qsl('input').oninput = selectFieldChange;",""),checkbox("boolean[$t]",1,isset($_GET["boolean"][$t]),"BOOL"),"</div>\n";}$Pa="this.parentNode.firstChild.onchange();";foreach(array_merge((array)$_GET["where"],array(array()))as$t=>$X){if(!$X||("$X[col]$X[val]"!=""&&in_array($X["op"],adminer()->operators())))echo"<div>".select_input(" name='where[$t][col]'",$d,$X["col"],($X?"selectFieldChange":"selectAddRow"),"(".lang(46).")"),html_select("where[$t][op]",adminer()->operators(),$X["op"],$Pa),"<input type='search' name='where[$t][val]' value='".h($X["val"])."'>",script("mixin(qsl('input'), {oninput: function () { $Pa }, onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});",""),"</div>\n";}echo"</div></fieldset>\n";}function
selectOrderPrint(array$zf,array$d,array$x){print_fieldset("sort",lang(47),$zf);$t=0;foreach((array)$_GET["order"]as$y=>$X){if($X!=""){echo"<div>".select_input(" name='order[$t]'",$d,$X,"selectFieldChange"),checkbox("desc[$t]",1,isset($_GET["desc"][$y]),lang(48))."</div>\n";$t++;}}echo"<div>".select_input(" name='order[$t]'",$d,"","selectAddRow"),checkbox("desc[$t]",1,false,lang(48))."</div>\n","</div></fieldset>\n";}function
selectLimitPrint($z){echo"<fieldset><legend>".lang(49)."</legend><div>","<input type='number' name='limit' class='size' value='".intval($z)."'>",script("qsl('input').oninput = selectFieldChange;",""),"</div></fieldset>\n";}function
selectLengthPrint($Uh){if($Uh!==null)echo"<fieldset><legend>".lang(50)."</legend><div>","<input type='number' name='text_length' class='size' value='".h($Uh)."'>","</div></fieldset>\n";}function
selectActionPrint(array$x){echo"<fieldset><legend>".lang(51)."</legend><div>","<input type='submit' value='".lang(42)."'>"," <span id='noindex' title='".lang(52)."'></span>","<script".nonce().">\n","const indexColumns = ";$d=array();foreach($x
as$w){$_b=reset($w["columns"]);if($w["type"]!="FULLTEXT"&&$_b)$d[$_b]=1;}$d[""]=1;foreach($d
as$y=>$X)json_row($y);echo";\n","selectFieldChange.call(qs('#form')['select']);\n","</script>\n","</div></fieldset>\n";}function
selectCommandPrint(){return!information_schema(DB);}function
selectImportPrint(){return!information_schema(DB);}function
selectEmailPrint(array$ic,array$d){}function
selectColumnsProcess(array$d,array$x){$O=array();$s=array();foreach((array)$_GET["columns"]as$y=>$X){if($X["fun"]=="count"||($X["col"]!=""&&(!$X["fun"]||in_array($X["fun"],driver()->functions)||in_array($X["fun"],driver()->grouping)))){$O[$y]=apply_sql_function($X["fun"],($X["col"]!=""?idf_escape($X["col"]):"*"));if(!in_array($X["fun"],driver()->grouping))$s[]=$O[$y];}}return
array($O,$s);}function
selectSearchProcess(array$n,array$x){$L=array();foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT"&&idx($_GET["fulltext"],$t)!="")$L[]="MATCH (".implode(", ",array_map('Adminer\idf_escape',$w["columns"])).") AGAINST (".q($_GET["fulltext"][$t]).(isset($_GET["boolean"][$t])?" IN BOOLEAN MODE":"").")";}foreach((array)$_GET["where"]as$y=>$X){$bb=$X["col"];if("$bb$X[val]"!=""&&in_array($X["op"],adminer()->operators())){$lb=array();foreach(($bb!=""?array($bb=>$n[$bb]):$n)as$D=>$m){$lg="";$kb=" $X[op]";if(preg_match('~IN$~',$X["op"])){$Dd=process_length($X["val"]);$kb
.=" ".($Dd!=""?$Dd:"(NULL)");}elseif($X["op"]=="SQL")$kb=" $X[val]";elseif(preg_match('~^(I?LIKE) %%$~',$X["op"],$B))$kb=" $B[1] ".adminer()->processInput($m,"%$X[val]%");elseif($X["op"]=="FIND_IN_SET"){$lg="$X[op](".q($X["val"]).", ";$kb=")";}elseif(!preg_match('~NULL$~',$X["op"]))$kb
.=" ".adminer()->processInput($m,$X["val"]);if($bb!=""||(isset($m["privileges"]["where"])&&(preg_match('~^[-\d.'.(preg_match('~IN$~',$X["op"])?',':'').']+$~',$X["val"])||!preg_match('~'.number_type().'|bit~',$m["type"]))&&(!preg_match("~[\x80-\xFF]~",$X["val"])||preg_match('~char|text|enum|set~',$m["type"]))&&(!preg_match('~date|timestamp~',$m["type"])||preg_match('~^\d+-\d+-\d+~',$X["val"]))))$lb[]=$lg.driver()->convertSearch(idf_escape($D),$X,$m).$kb;}$L[]=(count($lb)==1?$lb[0]:($lb?"(".implode(" OR ",$lb).")":"1 = 0"));}}return$L;}function
selectOrderProcess(array$n,array$x){$L=array();foreach((array)$_GET["order"]as$y=>$X){if($X!="")$L[]=(preg_match('~^((COUNT\(DISTINCT |[A-Z0-9_]+\()(`(?:[^`]|``)+`|"(?:[^"]|"")+")\)|COUNT\(\*\))$~',$X)?$X:idf_escape($X)).(isset($_GET["desc"][$y])?" DESC":"");}return$L;}function
selectLimitProcess(){return(isset($_GET["limit"])?intval($_GET["limit"]):50);}function
selectLengthProcess(){return(isset($_GET["text_length"])?"$_GET[text_length]":"100");}function
selectEmailProcess(array$Z,array$Uc){return
false;}function
selectQueryBuild(array$O,array$Z,array$s,array$zf,$z,$F){return"";}function
messageQuery($J,$Vh,$Gc=false){restart_session();$sd=&get_session("queries");if(!idx($sd,$_GET["db"]))$sd[$_GET["db"]]=array();if(strlen($J)>1e6)$J=preg_replace('~[\x80-\xFF]+$~','',substr($J,0,1e6))."\n…";$sd[$_GET["db"]][]=array($J,time(),$Vh);$sh="sql-".count($sd[$_GET["db"]]);$L="<a href='#$sh' class='toggle'>".lang(53)."</a> <a href='' class='jsonly copy'>🗐</a>\n";if(!$Gc&&($Oi=driver()->warnings())){$u="warnings-".count($sd[$_GET["db"]]);$L="<a href='#$u' class='toggle'>".lang(35)."</a>, $L<div id='$u' class='hidden'>\n$Oi</div>\n";}return" <span class='time'>".@date("H:i:s")."</span>"." $L<div id='$sh' class='hidden'><pre><code class='jush-".JUSH."'>".shorten_utf8($J,1000)."</code></pre>".($Vh?" <span class='time'>($Vh)</span>":'').(support("sql")?'<p><a href="'.h(str_replace("db=".urlencode(DB),"db=".urlencode($_GET["db"]),ME).'sql=&history='.(count($sd[$_GET["db"]])-1)).'">'.lang(10).'</a>':'').'</div>';}function
editRowPrint($R,array$n,$M,$yi){}function
editFunctions(array$m){$L=($m["null"]?"NULL/":"");$yi=isset($_GET["select"])||where($_GET);foreach(array(driver()->insertFunctions,driver()->editFunctions)as$y=>$bd){if(!$y||(!isset($_GET["call"])&&$yi)){foreach($bd
as$Zf=>$X){if(!$Zf||preg_match("~$Zf~",$m["type"]))$L
.="/$X";}}if($y&&$bd&&!preg_match('~set|bool~',$m["type"])&&!is_blob($m))$L
.="/SQL";}if($m["auto_increment"]&&!$yi)$L=lang(40);return
explode("/",$L);}function
editInput($R,array$m,$wa,$Y){if($m["type"]=="enum")return(isset($_GET["select"])?"<label><input type='radio'$wa value='orig' checked><i>".lang(8)."</i></label> ":"").enum_input("radio",$wa,$m,$Y,"NULL");return"";}function
editHint($R,array$m,$Y){return"";}function
processInput(array$m,$Y,$r=""){if($r=="SQL")return$Y;$D=$m["field"];$L=q($Y);if(preg_match('~^(now|getdate|uuid)$~',$r))$L="$r()";elseif(preg_match('~^current_(date|timestamp)$~',$r))$L=$r;elseif(preg_match('~^([+-]|\|\|)$~',$r))$L=idf_escape($D)." $r $L";elseif(preg_match('~^[+-] interval$~',$r))$L=idf_escape($D)." $r ".(preg_match("~^(\\d+|'[0-9.: -]') [A-Z_]+\$~i",$Y)&&JUSH!="pgsql"?$Y:$L);elseif(preg_match('~^(addtime|subtime|concat)$~',$r))$L="$r(".idf_escape($D).", $L)";elseif(preg_match('~^(md5|sha1|password|encrypt)$~',$r))$L="$r($L)";return
unconvert_field($m,$L);}function
dumpOutput(){$L=array('text'=>lang(54),'file'=>lang(55));if(function_exists('gzencode'))$L['gz']='gzip';return$L;}function
dumpFormat(){return(support("dump")?array('sql'=>'SQL'):array())+array('csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV');}function
dumpDatabase($j){}function
dumpTable($R,$Ah,$be=0){if($_POST["format"]!="sql"){echo"\xef\xbb\xbf";if($Ah)dump_csv(array_keys(fields($R)));}else{if($be==2){$n=array();foreach(fields($R)as$D=>$m)$n[]=idf_escape($D)." $m[full_type]";$h="CREATE TABLE ".table($R)." (".implode(", ",$n).")";}else$h=create_sql($R,$_POST["auto_increment"],$Ah);set_utf8mb4($h);if($Ah&&$h){if($Ah=="DROP+CREATE"||$be==1)echo"DROP ".($be==2?"VIEW":"TABLE")." IF EXISTS ".table($R).";\n";if($be==1)$h=remove_definer($h);echo"$h;\n\n";}}}function
dumpData($R,$Ah,$J){if($Ah){$Fe=(JUSH=="sqlite"?0:1048576);$n=array();$_d=false;if($_POST["format"]=="sql"){if($Ah=="TRUNCATE+INSERT")echo
truncate_sql($R).";\n";$n=fields($R);if(JUSH=="mssql"){foreach($n
as$m){if($m["auto_increment"]){echo"SET IDENTITY_INSERT ".table($R)." ON;\n";$_d=true;break;}}}}$K=connection()->query($J,1);if($K){$Qd="";$La="";$fe=array();$cd=array();$Ch="";$Jc=($R!=''?'fetch_assoc':'fetch_row');$tb=0;while($M=$K->$Jc()){if(!$fe){$Gi=array();foreach($M
as$X){$m=$K->fetch_field();if(idx($n[$m->name],'generated')){$cd[$m->name]=true;continue;}$fe[]=$m->name;$y=idf_escape($m->name);$Gi[]="$y = VALUES($y)";}$Ch=($Ah=="INSERT+UPDATE"?"\nON DUPLICATE KEY UPDATE ".implode(", ",$Gi):"").";\n";}if($_POST["format"]!="sql"){if($Ah=="table"){dump_csv($fe);$Ah="INSERT";}dump_csv($M);}else{if(!$Qd)$Qd="INSERT INTO ".table($R)." (".implode(", ",array_map('Adminer\idf_escape',$fe)).") VALUES";foreach($M
as$y=>$X){if($cd[$y]){unset($M[$y]);continue;}$m=$n[$y];$M[$y]=($X!==null?unconvert_field($m,preg_match(number_type(),$m["type"])&&!preg_match('~\[~',$m["full_type"])&&is_numeric($X)?$X:q(($X===false?0:$X))):"NULL");}$Rg=($Fe?"\n":" ")."(".implode(",\t",$M).")";if(!$La)$La=$Qd.$Rg;elseif(JUSH=='mssql'?$tb%1000!=0:strlen($La)+4+strlen($Rg)+strlen($Ch)<$Fe)$La
.=",$Rg";else{echo$La.$Ch;$La=$Qd.$Rg;}}$tb++;}if($La)echo$La.$Ch;}elseif($_POST["format"]=="sql")echo"-- ".str_replace("\n"," ",connection()->error)."\n";if($_d)echo"SET IDENTITY_INSERT ".table($R)." OFF;\n";}}function
dumpFilename($zd){return
friendly_url($zd!=""?$zd:(SERVER?:"localhost"));}function
dumpHeaders($zd,$We=false){$Kf=$_POST["output"];$Bc=(preg_match('~sql~',$_POST["format"])?"sql":($We?"tar":"csv"));header("Content-Type: ".($Kf=="gz"?"application/x-gzip":($Bc=="tar"?"application/x-tar":($Bc=="sql"||$Kf!="file"?"text/plain":"text/csv")."; charset=utf-8")));if($Kf=="gz"){ob_start(function($zh){return
gzencode($zh);},1e6);}return$Bc;}function
dumpFooter(){if($_POST["format"]=="sql")echo"-- ".gmdate("Y-m-d H:i:s e")."\n";}function
importServerPath(){return"adminer.sql";}function
homepage(){echo'<p class="links">'.($_GET["ns"]==""&&support("database")?'<a href="'.h(ME).'database=">'.lang(56)."</a>\n":""),(support("scheme")?"<a href='".h(ME)."scheme='>".($_GET["ns"]!=""?lang(57):lang(58))."</a>\n":""),($_GET["ns"]!==""?'<a href="'.h(ME).'schema=">'.lang(59)."</a>\n":""),(support("privileges")?"<a href='".h(ME)."privileges='>".lang(60)."</a>\n":"");if($_GET["ns"]!=="")echo(support("routine")?"<a href='#routines'>".lang(61)."</a>\n":""),(support("sequence")?"<a href='#sequences'>".lang(62)."</a>\n":""),(support("type")?"<a href='#user-types'>".lang(6)."</a>\n":""),(support("event")?"<a href='#events'>".lang(63)."</a>\n":"");return
true;}function
navigation($Te){echo"<h1>".adminer()->name()." <span class='version'>".VERSION;$ef=$_COOKIE["adminer_version"];echo" <a href='https://www.adminer.org/#download'".target_blank()." id='version'>".(version_compare(VERSION,$ef)<0?h($ef):"")."</a>","</span></h1>\n";switch_lang();if($Te=="auth"){$Kf="";foreach((array)$_SESSION["pwds"]as$Ii=>$fh){foreach($fh
as$P=>$Ei){$D=h(get_setting("vendor-$Ii-$P")?:get_driver($Ii));foreach($Ei
as$V=>$H){if($H!==null){$Gb=$_SESSION["db"][$Ii][$P][$V];foreach(($Gb?array_keys($Gb):array(""))as$j)$Kf
.="<li><a href='".h(auth_url($Ii,$P,$V,$j))."'>($D) ".h("$V@".($P!=""?adminer()->serverName($P):"").($j!=""?" - $j":""))."</a>\n";}}}}if($Kf)echo"<ul id='logins'>\n$Kf</ul>\n".script("mixin(qs('#logins'), {onmouseover: menuOver, onmouseout: menuOut});");}else{$T=array();if($_GET["ns"]!==""&&!$Te&&DB!=""){connection()->select_db(DB);$T=table_status('',true);}adminer()->syntaxHighlighting($T);adminer()->databasesPrint($Te);$ha=array();if(DB==""||!$Te){if(support("sql")){$ha[]="<a href='".h(ME)."sql='".bold(isset($_GET["sql"])&&!isset($_GET["import"])).">".lang(53)."</a>";$ha[]="<a href='".h(ME)."import='".bold(isset($_GET["import"])).">".lang(64)."</a>";}$ha[]="<a href='".h(ME)."dump=".urlencode(isset($_GET["table"])?$_GET["table"]:$_GET["select"])."' id='dump'".bold(isset($_GET["dump"])).">".lang(65)."</a>";}$Ed=$_GET["ns"]!==""&&!$Te&&DB!="";if($Ed)$ha[]='<a href="'.h(ME).'create="'.bold($_GET["create"]==="").">".lang(66)."</a>";echo($ha?"<p class='links'>\n".implode("\n",$ha)."\n":"");if($Ed){if($T)adminer()->tablesPrint($T);else
echo"<p class='message'>".lang(9)."</p>\n";}}}function
syntaxHighlighting(array$T){echo
script_src(preg_replace("~\\?.*~","",ME)."?file=jush.js&version=5.4.0",true);if(support("sql")){echo"<script".nonce().">\n";if($T){$we=array();foreach($T
as$R=>$U)$we[]=preg_quote($R,'/');echo"var jushLinks = { ".JUSH.":";json_row(js_escape(ME).(support("table")?"table":"select").'=$&','/\b('.implode('|',$we).')\b/g',false);if(support('routine')){foreach(routines()as$M)json_row(js_escape(ME).'function='.urlencode($M["SPECIFIC_NAME"]).'&name=$&','/\b'.preg_quote($M["ROUTINE_NAME"],'/').'(?=["`]?\()/g',false);}json_row('');echo"};\n";foreach(array("bac","bra","sqlite_quo","mssql_bra")as$X)echo"jushLinks.$X = jushLinks.".JUSH.";\n";if(isset($_GET["sql"])||isset($_GET["trigger"])||isset($_GET["check"])){$Lh=array_fill_keys(array_keys($T),array());foreach(driver()->allFields()as$R=>$n){foreach($n
as$m)$Lh[$R][]=$m["field"];}echo"addEventListener('DOMContentLoaded', () => { autocompleter = jush.autocompleteSql('".idf_escape("")."', ".json_encode($Lh)."); });\n";}}echo"</script>\n";}echo
script("syntaxHighlighting('".preg_replace('~^(\d\.?\d).*~s','\1',connection()->server_info)."', '".connection()->flavor."');");}function
databasesPrint($Te){$i=adminer()->databases();if(DB&&$i&&!in_array(DB,$i))array_unshift($i,DB);echo"<form action=''>\n<p id='dbs'>\n";hidden_fields_get();$Eb=script("mixin(qsl('select'), {onmousedown: dbMouseDown, onchange: dbChange});");echo"<label title='".lang(26)."'>".lang(67).": ".($i?html_select("db",array(""=>"")+$i,DB).$Eb:"<input name='db' value='".h(DB)."' autocapitalize='off' size='19'>\n")."</label>","<input type='submit' value='".lang(20)."'".($i?" class='hidden'":"").">\n";foreach(array("import","sql","schema","dump","privileges")as$X){if(isset($_GET[$X])){echo
input_hidden($X);break;}}echo"</p></form>\n";}function
tablesPrint(array$T){echo"<ul id='tables'>".script("mixin(qs('#tables'), {onmouseover: menuOver, onmouseout: menuOut});");foreach($T
as$R=>$wh){$R="$R";$D=adminer()->tableName($wh);if($D!=""&&!$wh["partition"])echo'<li><a href="'.h(ME).'select='.urlencode($R).'"'.bold($_GET["select"]==$R||$_GET["edit"]==$R,"select")." title='".lang(30)."'>".lang(68)."</a> ",(support("table")||support("indexes")?'<a href="'.h(ME).'table='.urlencode($R).'"'.bold(in_array($R,array($_GET["table"],$_GET["create"],$_GET["indexes"],$_GET["foreign"],$_GET["trigger"],$_GET["check"],$_GET["view"])),(is_view($wh)?"view":"structure"))." title='".lang(31)."'>$D</a>":"<span>$D</span>")."\n";}echo"</ul>\n";}function
processList(){return
process_list();}function
killProcess($u){return
kill_process($u);}}class
Plugins{private
static$append=array('dumpFormat'=>true,'dumpOutput'=>true,'editRowPrint'=>true,'editFunctions'=>true,'config'=>true);var$plugins;var$error='';private$hooks=array();function
__construct($eg){if($eg===null){$eg=array();$Fa="adminer-plugins";if(is_dir($Fa)){foreach(glob("$Fa/*.php")as$o)$Fd=include_once"./$o";}$rd=" href='https://www.adminer.org/plugins/#use'".target_blank();if(file_exists("$Fa.php")){$Fd=include_once"./$Fa.php";if(is_array($Fd)){foreach($Fd
as$dg)$eg[get_class($dg)]=$dg;}else$this->error
.=lang(69,"<b>$Fa.php</b>",$rd)."<br>";}foreach(get_declared_classes()as$Ya){if(!$eg[$Ya]&&preg_match('~^Adminer\w~i',$Ya)){$Eg=new
\ReflectionClass($Ya);$nb=$Eg->getConstructor();if($nb&&$nb->getNumberOfRequiredParameters())$this->error
.=lang(70,$rd,"<b>$Ya</b>","<b>$Fa.php</b>")."<br>";else$eg[$Ya]=new$Ya;}}}$this->plugins=$eg;$ia=new
Adminer;$eg[]=$ia;$Eg=new
\ReflectionObject($ia);foreach($Eg->getMethods()as$Re){foreach($eg
as$dg){$D=$Re->getName();if(method_exists($dg,$D))$this->hooks[$D][]=$dg;}}}function
__call($D,array$Of){$sa=array();foreach($Of
as$y=>$X)$sa[]=&$Of[$y];$L=null;foreach($this->hooks[$D]as$dg){$Y=call_user_func_array(array($dg,$D),$sa);if($Y!==null){if(!self::$append[$D])return$Y;$L=$Y+(array)$L;}}return$L;}}abstract
class
Plugin{protected$translations=array();function
description(){return$this->lang('');}function
screenshot(){return"";}protected
function
lang($v,$E=null){$sa=func_get_args();$sa[0]=idx($this->translations[LANG],$v)?:$v;return
call_user_func_array('Adminer\lang_format',$sa);}}Adminer::$instance=(function_exists('adminer_object')?adminer_object():(is_dir("adminer-plugins")||file_exists("adminer-plugins.php")?new
Plugins(null):new
Adminer));SqlDriver::$drivers=array("server"=>"MySQL / MariaDB")+SqlDriver::$drivers;if(!defined('Adminer\DRIVER')){define('Adminer\DRIVER',"server");if(extension_loaded("mysqli")&&$_GET["ext"]!="pdo"){class
Db
extends
\MySQLi{static$instance;var$extension="MySQLi",$flavor='';function
__construct(){parent::init();}function
attach($P,$V,$H){mysqli_report(MYSQLI_REPORT_OFF);list($vd,$fg)=host_port($P);$uh=adminer()->connectSsl();if($uh)$this->ssl_set($uh['key'],$uh['cert'],$uh['ca'],'','');$L=@$this->real_connect(($P!=""?$vd:ini_get("mysqli.default_host")),($P.$V!=""?$V:ini_get("mysqli.default_user")),($P.$V.$H!=""?$H:ini_get("mysqli.default_pw")),null,(is_numeric($fg)?intval($fg):ini_get("mysqli.default_port")),(is_numeric($fg)?null:$fg),($uh?($uh['verify']!==false?2048:64):0));$this->options(MYSQLI_OPT_LOCAL_INFILE,0);return($L?'':$this->error);}function
set_charset($Ra){if(parent::set_charset($Ra))return
true;parent::set_charset('utf8');return$this->query("SET NAMES $Ra");}function
next_result(){return
self::more_results()&&parent::next_result();}function
quote($zh){return"'".$this->escape_string($zh)."'";}}}elseif(extension_loaded("mysql")&&!((ini_bool("sql.safe_mode")||ini_bool("mysql.allow_local_infile"))&&extension_loaded("pdo_mysql"))){class
Db
extends
SqlDb{private$link;function
attach($P,$V,$H){if(ini_bool("mysql.allow_local_infile"))return
lang(71,"'mysql.allow_local_infile'","MySQLi","PDO_MySQL");$this->link=@mysql_connect(($P!=""?$P:ini_get("mysql.default_host")),($P.$V!=""?$V:ini_get("mysql.default_user")),($P.$V.$H!=""?$H:ini_get("mysql.default_password")),true,131072);if(!$this->link)return
mysql_error();$this->server_info=mysql_get_server_info($this->link);return'';}function
set_charset($Ra){if(function_exists('mysql_set_charset')){if(mysql_set_charset($Ra,$this->link))return
true;mysql_set_charset('utf8',$this->link);}return$this->query("SET NAMES $Ra");}function
quote($zh){return"'".mysql_real_escape_string($zh,$this->link)."'";}function
select_db($Db){return
mysql_select_db($Db,$this->link);}function
query($J,$ri=false){$K=@($ri?mysql_unbuffered_query($J,$this->link):mysql_query($J,$this->link));$this->error="";if(!$K){$this->errno=mysql_errno($this->link);$this->error=mysql_error($this->link);return
false;}if($K===true){$this->affected_rows=mysql_affected_rows($this->link);$this->info=mysql_info($this->link);return
true;}return
new
Result($K);}}class
Result{var$num_rows;private$result;private$offset=0;function
__construct($K){$this->result=$K;$this->num_rows=mysql_num_rows($K);}function
fetch_assoc(){return
mysql_fetch_assoc($this->result);}function
fetch_row(){return
mysql_fetch_row($this->result);}function
fetch_field(){$L=mysql_fetch_field($this->result,$this->offset++);$L->orgtable=$L->table;$L->charsetnr=($L->blob?63:0);return$L;}function
__destruct(){mysql_free_result($this->result);}}}elseif(extension_loaded("pdo_mysql")){class
Db
extends
PdoDb{var$extension="PDO_MySQL";function
attach($P,$V,$H){$xf=array(\PDO::MYSQL_ATTR_LOCAL_INFILE=>false);$uh=adminer()->connectSsl();if($uh){if($uh['key'])$xf[\PDO::MYSQL_ATTR_SSL_KEY]=$uh['key'];if($uh['cert'])$xf[\PDO::MYSQL_ATTR_SSL_CERT]=$uh['cert'];if($uh['ca'])$xf[\PDO::MYSQL_ATTR_SSL_CA]=$uh['ca'];if(isset($uh['verify']))$xf[\PDO::MYSQL_ATTR_SSL_VERIFY_SERVER_CERT]=$uh['verify'];}list($vd,$fg)=host_port($P);return$this->dsn("mysql:charset=utf8;host=$vd".($fg?(is_numeric($fg)?";port=":";unix_socket=").$fg:""),$V,$H,$xf);}function
set_charset($Ra){return$this->query("SET NAMES $Ra");}function
select_db($Db){return$this->query("USE ".idf_escape($Db));}function
query($J,$ri=false){$this->pdo->setAttribute(\PDO::MYSQL_ATTR_USE_BUFFERED_QUERY,!$ri);return
parent::query($J,$ri);}}}class
Driver
extends
SqlDriver{static$extensions=array("MySQLi","MySQL","PDO_MySQL");static$jush="sql";var$unsigned=array("unsigned","zerofill","unsigned zerofill");var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","REGEXP","IN","FIND_IN_SET","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL");var$functions=array("char_length","date","from_unixtime","lower","round","floor","ceil","sec_to_time","time_to_sec","upper");var$grouping=array("avg","count","count distinct","group_concat","max","min","sum");static
function
connect($P,$V,$H){$f=parent::connect($P,$V,$H);if(is_string($f)){if(function_exists('iconv')&&!is_utf8($f)&&strlen($Rg=iconv("windows-1250","utf-8",$f))>strlen($f))$f=$Rg;return$f;}$f->set_charset(charset($f));$f->query("SET sql_quote_show_create = 1, autocommit = 1");$f->flavor=(preg_match('~MariaDB~',$f->server_info)?'maria':'mysql');add_driver(DRIVER,($f->flavor=='maria'?"MariaDB":"MySQL"));return$f;}function
__construct(Db$f){parent::__construct($f);$this->types=array(lang(72)=>array("tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21),lang(73)=>array("date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4),lang(74)=>array("char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295),lang(75)=>array("enum"=>65535,"set"=>64),lang(76)=>array("bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295),lang(77)=>array("geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0),);$this->insertFunctions=array("char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",);$this->editFunctions=array(number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",);if(min_version('5.7.8',10.2,$f))$this->types[lang(74)]["json"]=4294967295;if(min_version('',10.7,$f)){$this->types[lang(74)]["uuid"]=128;$this->insertFunctions['uuid']='uuid';}if(min_version(9,'',$f)){$this->types[lang(72)]["vector"]=16383;$this->insertFunctions['vector']='string_to_vector';}if(min_version(5.1,'',$f))$this->partitionBy=array("HASH","LINEAR HASH","KEY","LINEAR KEY","RANGE","LIST");if(min_version(5.7,10.2,$f))$this->generated=array("STORED","VIRTUAL");}function
unconvertFunction(array$m){return(preg_match("~binary~",$m["type"])?"<code class='jush-sql'>UNHEX</code>":($m["type"]=="bit"?doc_link(array('sql'=>'bit-value-literals.html'),"<code>b''</code>"):(preg_match("~geometry|point|linestring|polygon~",$m["type"])?"<code class='jush-sql'>GeomFromText</code>":"")));}function
insert($R,array$Q){return($Q?parent::insert($R,$Q):queries("INSERT INTO ".table($R)." ()\nVALUES ()"));}function
insertUpdate($R,array$N,array$ng){$d=array_keys(reset($N));$lg="INSERT INTO ".table($R)." (".implode(", ",$d).") VALUES\n";$Gi=array();foreach($d
as$y)$Gi[$y]="$y = VALUES($y)";$Ch="\nON DUPLICATE KEY UPDATE ".implode(", ",$Gi);$Gi=array();$se=0;foreach($N
as$Q){$Y="(".implode(", ",$Q).")";if($Gi&&(strlen($lg)+$se+strlen($Y)+strlen($Ch)>1e6)){if(!queries($lg.implode(",\n",$Gi).$Ch))return
false;$Gi=array();$se=0;}$Gi[]=$Y;$se+=strlen($Y)+2;}return
queries($lg.implode(",\n",$Gi).$Ch);}function
slowQuery($J,$Wh){if(min_version('5.7.8','10.1.2')){if($this->conn->flavor=='maria')return"SET STATEMENT max_statement_time=$Wh FOR $J";elseif(preg_match('~^(SELECT\b)(.+)~is',$J,$B))return"$B[1] /*+ MAX_EXECUTION_TIME(".($Wh*1000).") */ $B[2]";}}function
convertSearch($v,array$X,array$m){return(preg_match('~char|text|enum|set~',$m["type"])&&!preg_match("~^utf8~",$m["collation"])&&preg_match('~[\x80-\xFF]~',$X['val'])?"CONVERT($v USING ".charset($this->conn).")":$v);}function
warnings(){$K=$this->conn->query("SHOW WARNINGS");if($K&&$K->num_rows){ob_start();print_select_result($K);return
ob_get_clean();}}function
tableHelp($D,$be=false){$ze=($this->conn->flavor=='maria');if(information_schema(DB))return
strtolower("information-schema-".($ze?"$D-table/":str_replace("_","-",$D)."-table.html"));if(DB=="mysql")return($ze?"mysql$D-table/":"system-schema.html");}function
partitionsInfo($R){$Zc="FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA = ".q(DB)." AND TABLE_NAME = ".q($R);$K=$this->conn->query("SELECT PARTITION_METHOD, PARTITION_EXPRESSION, PARTITION_ORDINAL_POSITION $Zc ORDER BY PARTITION_ORDINAL_POSITION DESC LIMIT 1");$L=array();list($L["partition_by"],$L["partition"],$L["partitions"])=$K->fetch_row();$Vf=get_key_vals("SELECT PARTITION_NAME, PARTITION_DESCRIPTION $Zc AND PARTITION_NAME != '' ORDER BY PARTITION_ORDINAL_POSITION");$L["partition_names"]=array_keys($Vf);$L["partition_values"]=array_values($Vf);return$L;}function
hasCStyleEscapes(){static$Ma;if($Ma===null){$th=get_val("SHOW VARIABLES LIKE 'sql_mode'",1,$this->conn);$Ma=(strpos($th,'NO_BACKSLASH_ESCAPES')===false);}return$Ma;}function
engines(){$L=array();foreach(get_rows("SHOW ENGINES")as$M){if(preg_match("~YES|DEFAULT~",$M["Support"]))$L[]=$M["Engine"];}return$L;}function
indexAlgorithms(array$Gh){return(preg_match('~^(MEMORY|NDB)$~',$Gh["Engine"])?array("HASH","BTREE"):array());}}function
idf_escape($v){return"`".str_replace("`","``",$v)."`";}function
table($v){return
idf_escape($v);}function
get_databases($Rc){$L=get_session("dbs");if($L===null){$J="SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME";$L=($Rc?slow_query($J):get_vals($J));restart_session();set_session("dbs",$L);stop_session();}return$L;}function
limit($J,$Z,$z,$kf=0,$dh=" "){return" $J$Z".($z?$dh."LIMIT $z".($kf?" OFFSET $kf":""):"");}function
limit1($R,$J,$Z,$dh="\n"){return
limit($J,$Z,1,0,$dh);}function
db_collation($j,array$b){$L=null;$h=get_val("SHOW CREATE DATABASE ".idf_escape($j),1);if(preg_match('~ COLLATE ([^ ]+)~',$h,$B))$L=$B[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$h,$B))$L=$b[$B[1]][-1];return$L;}function
logged_user(){return
get_val("SELECT USER()");}function
tables_list(){return
get_key_vals("SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME");}function
count_tables(array$i){$L=array();foreach($i
as$j)$L[$j]=count(get_vals("SHOW TABLES IN ".idf_escape($j)));return$L;}function
table_status($D="",$Hc=false){$L=array();foreach(get_rows($Hc?"SELECT TABLE_NAME AS Name, ENGINE AS Engine, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($D!=""?"AND TABLE_NAME = ".q($D):"ORDER BY Name"):"SHOW TABLE STATUS".($D!=""?" LIKE ".q(addcslashes($D,"%_\\")):""))as$M){if($M["Engine"]=="InnoDB")$M["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$M["Comment"]);if(!isset($M["Engine"]))$M["Comment"]="";if($D!="")$M["Name"]=$D;$L[$M["Name"]]=$M;}return$L;}function
is_view(array$S){return$S["Engine"]===null;}function
fk_support(array$S){return
preg_match('~InnoDB|IBMDB2I'.(min_version(5.6)?'|NDB':'').'~i',$S["Engine"]);}function
fields($R){$ze=(connection()->flavor=='maria');$L=array();foreach(get_rows("SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ".q($R)." ORDER BY ORDINAL_POSITION")as$M){$m=$M["COLUMN_NAME"];$U=$M["COLUMN_TYPE"];$dd=$M["GENERATION_EXPRESSION"];$Ec=$M["EXTRA"];preg_match('~^(VIRTUAL|PERSISTENT|STORED)~',$Ec,$cd);preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$U,$Ae);$k=$M["COLUMN_DEFAULT"];if($k!=""){$ae=preg_match('~text|json~',$Ae[1]);if(!$ze&&$ae)$k=preg_replace("~^(_\w+)?('.*')$~",'\2',stripslashes($k));if($ze||$ae){$k=($k=="NULL"?null:preg_replace_callback("~^'(.*)'$~",function($B){return
stripslashes(str_replace("''","'",$B[1]));},$k));}if(!$ze&&preg_match('~binary~',$Ae[1])&&preg_match('~^0x(\w*)$~',$k,$B))$k=pack("H*",$B[1]);}$L[$m]=array("field"=>$m,"full_type"=>$U,"type"=>$Ae[1],"length"=>$Ae[2],"unsigned"=>ltrim($Ae[3].$Ae[4]),"default"=>($cd?($ze?$dd:stripslashes($dd)):$k),"null"=>($M["IS_NULLABLE"]=="YES"),"auto_increment"=>($Ec=="auto_increment"),"on_update"=>(preg_match('~\bon update (\w+)~i',$Ec,$B)?$B[1]:""),"collation"=>$M["COLLATION_NAME"],"privileges"=>array_flip(explode(",","$M[PRIVILEGES],where,order")),"comment"=>$M["COLUMN_COMMENT"],"primary"=>($M["COLUMN_KEY"]=="PRI"),"generated"=>($cd[1]=="PERSISTENT"?"STORED":$cd[1]),);}return$L;}function
indexes($R,$g=null){$L=array();foreach(get_rows("SHOW INDEX FROM ".table($R),$g)as$M){$D=$M["Key_name"];$L[$D]["type"]=($D=="PRIMARY"?"PRIMARY":($M["Index_type"]=="FULLTEXT"?"FULLTEXT":($M["Non_unique"]?($M["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$L[$D]["columns"][]=$M["Column_name"];$L[$D]["lengths"][]=($M["Index_type"]=="SPATIAL"?null:$M["Sub_part"]);$L[$D]["descs"][]=null;$L[$D]["algorithm"]=$M["Index_type"];}return$L;}function
foreign_keys($R){static$Zf='(?:`(?:[^`]|``)+`|"(?:[^"]|"")+")';$L=array();$ub=get_val("SHOW CREATE TABLE ".table($R),1);if($ub){preg_match_all("~CONSTRAINT ($Zf) FOREIGN KEY ?\\(((?:$Zf,? ?)+)\\) REFERENCES ($Zf)(?:\\.($Zf))? \\(((?:$Zf,? ?)+)\\)(?: ON DELETE (".driver()->onActions."))?(?: ON UPDATE (".driver()->onActions."))?~",$ub,$Be,PREG_SET_ORDER);foreach($Be
as$B){preg_match_all("~$Zf~",$B[2],$oh);preg_match_all("~$Zf~",$B[5],$Ph);$L[idf_unescape($B[1])]=array("db"=>idf_unescape($B[4]!=""?$B[3]:$B[4]),"table"=>idf_unescape($B[4]!=""?$B[4]:$B[3]),"source"=>array_map('Adminer\idf_unescape',$oh[0]),"target"=>array_map('Adminer\idf_unescape',$Ph[0]),"on_delete"=>($B[6]?:"RESTRICT"),"on_update"=>($B[7]?:"RESTRICT"),);}}return$L;}function
view($D){return
array("select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',get_val("SHOW CREATE VIEW ".table($D),1)));}function
collations(){$L=array();foreach(get_rows("SHOW COLLATION")as$M){if($M["Default"])$L[$M["Charset"]][-1]=$M["Collation"];else$L[$M["Charset"]][]=$M["Collation"];}ksort($L);foreach($L
as$y=>$X)sort($L[$y]);return$L;}function
information_schema($j){return($j=="information_schema")||(min_version(5.5)&&$j=="performance_schema");}function
error(){return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",connection()->error));}function
create_database($j,$db){return
queries("CREATE DATABASE ".idf_escape($j).($db?" COLLATE ".q($db):""));}function
drop_databases(array$i){$L=apply_queries("DROP DATABASE",$i,'Adminer\idf_escape');restart_session();set_session("dbs",null);return$L;}function
rename_database($D,$db){$L=false;if(create_database($D,$db)){$T=array();$Li=array();foreach(tables_list()as$R=>$U){if($U=='VIEW')$Li[]=$R;else$T[]=$R;}$L=(!$T&&!$Li)||move_tables($T,$Li,$D);drop_databases($L?array(DB):array());}return$L;}function
auto_increment(){$za=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$w){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$w["columns"],true)){$za="";break;}if($w["type"]=="PRIMARY")$za=" UNIQUE";}}return" AUTO_INCREMENT$za";}function
alter_table($R,$D,array$n,array$Tc,$hb,$lc,$db,$ya,$G){$qa=array();foreach($n
as$m){if($m[1]){$k=$m[1][3];if(preg_match('~ GENERATED~',$k)){$m[1][3]=(connection()->flavor=='maria'?"":$m[1][2]);$m[1][2]=$k;}$qa[]=($R!=""?($m[0]!=""?"CHANGE ".idf_escape($m[0]):"ADD"):" ")." ".implode($m[1]).($R!=""?$m[2]:"");}else$qa[]="DROP ".idf_escape($m[0]);}$qa=array_merge($qa,$Tc);$wh=($hb!==null?" COMMENT=".q($hb):"").($lc?" ENGINE=".q($lc):"").($db?" COLLATE ".q($db):"").($ya!=""?" AUTO_INCREMENT=$ya":"");if($G){$Vf=array();if($G["partition_by"]=='RANGE'||$G["partition_by"]=='LIST'){foreach($G["partition_names"]as$y=>$X){$Y=$G["partition_values"][$y];$Vf[]="\n  PARTITION ".idf_escape($X)." VALUES ".($G["partition_by"]=='RANGE'?"LESS THAN":"IN").($Y!=""?" ($Y)":" MAXVALUE");}}$wh
.="\nPARTITION BY $G[partition_by]($G[partition])";if($Vf)$wh
.=" (".implode(",",$Vf)."\n)";elseif($G["partitions"])$wh
.=" PARTITIONS ".(+$G["partitions"]);}elseif($G===null)$wh
.="\nREMOVE PARTITIONING";if($R=="")return
queries("CREATE TABLE ".table($D)." (\n".implode(",\n",$qa)."\n)$wh");if($R!=$D)$qa[]="RENAME TO ".table($D);if($wh)$qa[]=ltrim($wh);return($qa?queries("ALTER TABLE ".table($R)."\n".implode(",\n",$qa)):true);}function
alter_indexes($R,$qa){$Qa=array();foreach($qa
as$X)$Qa[]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($R).implode(",",$Qa));}function
truncate_tables(array$T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views(array$Li){return
queries("DROP VIEW ".implode(", ",array_map('Adminer\table',$Li)));}function
drop_tables(array$T){return
queries("DROP TABLE ".implode(", ",array_map('Adminer\table',$T)));}function
move_tables(array$T,array$Li,$Ph){$Hg=array();foreach($T
as$R)$Hg[]=table($R)." TO ".idf_escape($Ph).".".table($R);if(!$Hg||queries("RENAME TABLE ".implode(", ",$Hg))){$Mb=array();foreach($Li
as$R)$Mb[table($R)]=view($R);connection()->select_db($Ph);$j=idf_escape(DB);foreach($Mb
as$D=>$Ki){if(!queries("CREATE VIEW $D AS ".str_replace(" $j."," ",$Ki["select"]))||!queries("DROP VIEW $j.$D"))return
false;}return
true;}return
false;}function
copy_tables(array$T,array$Li,$Ph){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($T
as$R){$D=($Ph==DB?table("copy_$R"):idf_escape($Ph).".".table($R));if(($_POST["overwrite"]&&!queries("\nDROP TABLE IF EXISTS $D"))||!queries("CREATE TABLE $D LIKE ".table($R))||!queries("INSERT INTO $D SELECT * FROM ".table($R)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$M){$li=$M["Trigger"];if(!queries("CREATE TRIGGER ".($Ph==DB?idf_escape("copy_$li"):idf_escape($Ph).".".idf_escape($li))." $M[Timing] $M[Event] ON $D FOR EACH ROW\n$M[Statement];"))return
false;}}foreach($Li
as$R){$D=($Ph==DB?table("copy_$R"):idf_escape($Ph).".".table($R));$Ki=view($R);if(($_POST["overwrite"]&&!queries("DROP VIEW IF EXISTS $D"))||!queries("CREATE VIEW $D AS $Ki[select]"))return
false;}return
true;}function
trigger($D,$R){if($D=="")return
array();$N=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($D));return
reset($N);}function
triggers($R){$L=array();foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$M)$L[$M["Trigger"]]=array($M["Timing"],$M["Event"]);return$L;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
routine($D,$U){$oa=array("bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar");$ph="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$nc=driver()->enumLength;$pi="((".implode("|",array_merge(array_keys(driver()->types()),$oa)).")\\b(?:\\s*\\(((?:[^'\")]|$nc)++)\\))?"."\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?(?:\\s*COLLATE\\s*['\"]?([^'\"\\s,]+)['\"]?)?";$Zf="$ph*(".($U=="FUNCTION"?"":driver()->inout).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$pi";$h=get_val("SHOW CREATE $U ".idf_escape($D),2);preg_match("~\\(((?:$Zf\\s*,?)*)\\)\\s*".($U=="FUNCTION"?"RETURNS\\s+$pi\\s+":"")."(.*)~is",$h,$B);$n=array();preg_match_all("~$Zf\\s*,?~is",$B[1],$Be,PREG_SET_ORDER);foreach($Be
as$Nf)$n[]=array("field"=>str_replace("``","`",$Nf[2]).$Nf[3],"type"=>strtolower($Nf[5]),"length"=>preg_replace_callback("~$nc~s",'Adminer\normalize_enum',$Nf[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$Nf[8] $Nf[7]"))),"null"=>true,"full_type"=>$Nf[4],"inout"=>strtoupper($Nf[1]),"collation"=>strtolower($Nf[9]),);return
array("fields"=>$n,"comment"=>get_val("SELECT ROUTINE_COMMENT FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE() AND ROUTINE_NAME = ".q($D)),)+($U!="FUNCTION"?array("definition"=>$B[11]):array("returns"=>array("type"=>$B[12],"length"=>$B[13],"unsigned"=>$B[15],"collation"=>$B[16]),"definition"=>$B[17],"language"=>"SQL",));}function
routines(){return
get_rows("SELECT SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE()");}function
routine_languages(){return
array();}function
routine_id($D,array$M){return
idf_escape($D);}function
last_id($K){return
get_val("SELECT LAST_INSERT_ID()");}function
explain(Db$f,$J){return$f->query("EXPLAIN ".(min_version(5.1)&&!min_version(5.7)?"PARTITIONS ":"").$J);}function
found_rows(array$S,array$Z){return($Z||$S["Engine"]!="InnoDB"?null:$S["Rows"]);}function
create_sql($R,$ya,$Ah){$L=get_val("SHOW CREATE TABLE ".table($R),1);if(!$ya)$L=preg_replace('~ AUTO_INCREMENT=\d+~','',$L);return$L;}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
use_sql($Db,$Ah=""){$D=idf_escape($Db);$L="";if(preg_match('~CREATE~',$Ah)&&($h=get_val("SHOW CREATE DATABASE $D",1))){set_utf8mb4($h);if($Ah=="DROP+CREATE")$L="DROP DATABASE IF EXISTS $D;\n";$L
.="$h;\n";}return$L."USE $D";}function
trigger_sql($R){$L="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")),null,"-- ")as$M)$L
.="\nCREATE TRIGGER ".idf_escape($M["Trigger"])." $M[Timing] $M[Event] ON ".table($M["Table"])." FOR EACH ROW\n$M[Statement];;\n";return$L;}function
show_variables(){return
get_rows("SHOW VARIABLES");}function
show_status(){return
get_rows("SHOW STATUS");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
convert_field(array$m){if(preg_match("~binary~",$m["type"]))return"HEX(".idf_escape($m["field"]).")";if($m["type"]=="bit")return"BIN(".idf_escape($m["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$m["type"]))return(min_version(8)?"ST_":"")."AsWKT(".idf_escape($m["field"]).")";}function
unconvert_field(array$m,$L){if(preg_match("~binary~",$m["type"]))$L="UNHEX($L)";if($m["type"]=="bit")$L="CONVERT(b$L, UNSIGNED)";if(preg_match("~geometry|point|linestring|polygon~",$m["type"])){$lg=(min_version(8)?"ST_":"");$L=$lg."GeomFromText($L, $lg"."SRID($m[field]))";}return$L;}function
support($Ic){return
preg_match('~^(comment|columns|copy|database|drop_col|dump|indexes|kill|privileges|move_col|procedure|processlist|routine|sql|status|table|trigger|variables|view'.(min_version(5.1)?'|event':'').(min_version(8)?'|descidx':'').(min_version('8.0.16','10.2.1')?'|check':'').')$~',$Ic);}function
kill_process($u){return
queries("KILL ".number($u));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){return
get_val("SELECT @@max_connections");}function
types(){return
array();}function
type_values($u){return"";}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($Tg,$g=null){return
true;}}define('Adminer\JUSH',Driver::$jush);define('Adminer\SERVER',"".$_GET[DRIVER]);define('Adminer\DB',"$_GET[db]");define('Adminer\ME',preg_replace('~\?.*~','',relative_uri()).'?'.(sid()?SID.'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').($_GET["ext"]?"ext=".urlencode($_GET["ext"]).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));function
page_header($Yh,$l="",$Ka=array(),$Zh=""){page_headers();if(is_ajax()&&$l){page_messages($l);exit;}if(!ob_get_level())ob_start('ob_gzhandler',4096);$ai=$Yh.($Zh!=""?": $Zh":"");$bi=strip_tags($ai.(SERVER!=""&&SERVER!="localhost"?h(" - ".SERVER):"")." - ".adminer()->name());echo'<!DOCTYPE html>
<html lang="',LANG,'" dir="',lang(78),'">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>',$bi,'</title>
<link rel="stylesheet" href="',h(preg_replace("~\\?.*~","",ME)."?file=default.css&version=5.4.0"),'">
';$yb=adminer()->css();if(is_int(key($yb)))$yb=array_fill_keys($yb,'light');$od=in_array('light',$yb)||in_array('',$yb);$md=in_array('dark',$yb)||in_array('',$yb);$Ab=($od?($md?null:false):($md?:null));$Le=" media='(prefers-color-scheme: dark)'";if($Ab!==false)echo"<link rel='stylesheet'".($Ab?"":$Le)." href='".h(preg_replace("~\\?.*~","",ME)."?file=dark.css&version=5.4.0")."'>\n";echo"<meta name='color-scheme' content='".($Ab===null?"light dark":($Ab?"dark":"light"))."'>\n",script_src(preg_replace("~\\?.*~","",ME)."?file=functions.js&version=5.4.0");if(adminer()->head($Ab))echo"<link rel='icon' href='data:image/gif;base64,R0lGODlhEAAQAJEAAAQCBPz+/PwCBAROZCH5BAEAAAAALAAAAAAQABAAAAI2hI+pGO1rmghihiUdvUBnZ3XBQA7f05mOak1RWXrNq5nQWHMKvuoJ37BhVEEfYxQzHjWQ5qIAADs='>\n","<link rel='apple-touch-icon' href='".h(preg_replace("~\\?.*~","",ME)."?file=logo.png&version=5.4.0")."'>\n";foreach($yb
as$_i=>$Ue){$wa=($Ue=='dark'&&!$Ab?$Le:($Ue=='light'&&$md?" media='(prefers-color-scheme: light)'":""));echo"<link rel='stylesheet'$wa href='".h($_i)."'>\n";}echo"\n<body class='".lang(78)." nojs";adminer()->bodyClass();echo"'>\n";$o=get_temp_dir()."/adminer.version";if(!$_COOKIE["adminer_version"]&&function_exists('openssl_verify')&&file_exists($o)&&filemtime($o)+86400>time()){$Ji=unserialize(file_get_contents($o));$ug="-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwqWOVuF5uw7/+Z70djoK
RlHIZFZPO0uYRezq90+7Amk+FDNd7KkL5eDve+vHRJBLAszF/7XKXe11xwliIsFs
DFWQlsABVZB3oisKCBEuI71J4kPH8dKGEWR9jDHFw3cWmoH3PmqImX6FISWbG3B8
h7FIx3jEaw5ckVPVTeo5JRm/1DZzJxjyDenXvBQ/6o9DgZKeNDgxwKzH+sw9/YCO
jHnq1cFpOIISzARlrHMa/43YfeNRAm/tsBXjSxembBPo7aQZLAWHmaj5+K19H10B
nCpz9Y++cipkVEiKRGih4ZEvjoFysEOdRLj6WiD/uUNky4xGeA6LaJqh5XpkFkcQ
fQIDAQAB
-----END PUBLIC KEY-----
";if(openssl_verify($Ji["version"],base64_decode($Ji["signature"]),$ug)==1)$_COOKIE["adminer_version"]=$Ji["version"];}echo
script("mixin(document.body, {onkeydown: bodyKeydown, onclick: bodyClick".(isset($_COOKIE["adminer_version"])?"":", onload: partial(verifyVersion, '".VERSION."', '".js_escape(ME)."', '".get_token()."')")."});
document.body.classList.replace('nojs', 'js');
const offlineMessage = '".js_escape(lang(79))."';
const thousandsSeparator = '".js_escape(lang(4))."';"),"<div id='help' class='jush-".JUSH." jsonly hidden'></div>\n",script("mixin(qs('#help'), {onmouseover: () => { helpOpen = 1; }, onmouseout: helpMouseout});"),"<div id='content'>\n","<span id='menuopen' class='jsonly'>".icon("move","","menu","")."</span>".script("qs('#menuopen').onclick = event => { qs('#foot').classList.toggle('foot'); event.stopPropagation(); }");if($Ka!==null){$_=substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1);echo'<p id="breadcrumb"><a href="'.h($_?:".").'">'.get_driver(DRIVER).'</a> » ';$_=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);$P=adminer()->serverName(SERVER);$P=($P!=""?$P:lang(23));if($Ka===false)echo"$P\n";else{echo"<a href='".h($_)."' accesskey='1' title='Alt+Shift+1'>$P</a> » ";if($_GET["ns"]!=""||(DB!=""&&is_array($Ka)))echo'<a href="'.h($_."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a> » ';if(is_array($Ka)){if($_GET["ns"]!="")echo'<a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a> » ';foreach($Ka
as$y=>$X){$Ob=(is_array($X)?$X[1]:h($X));if($Ob!="")echo"<a href='".h(ME."$y=").urlencode(is_array($X)?$X[0]:$X)."'>$Ob</a> » ";}}echo"$Yh\n";}}echo"<h2>$ai</h2>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages($l);$i=&get_session("dbs");if(DB!=""&&$i&&!in_array(DB,$i,true))$i=null;stop_session();define('Adminer\PAGE_HEADER',1);}function
page_headers(){header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-Frame-Options: deny");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");foreach(adminer()->csp(csp())as$xb){$pd=array();foreach($xb
as$y=>$X)$pd[]="$y $X";header("Content-Security-Policy: ".implode("; ",$pd));}adminer()->headers();}function
csp(){return
array(array("script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self'","frame-src"=>"https://www.adminer.org","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",),);}function
get_nonce(){static$gf;if(!$gf)$gf=base64_encode(rand_string());return$gf;}function
page_messages($l){$zi=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$Qe=idx($_SESSION["messages"],$zi);if($Qe){echo"<div class='message'>".implode("</div>\n<div class='message'>",$Qe)."</div>".script("messagesPrint();");unset($_SESSION["messages"][$zi]);}if($l)echo"<div class='error'>$l</div>\n";if(adminer()->error)echo"<div class='error'>".adminer()->error."</div>\n";}function
page_footer($Te=""){echo"</div>\n\n<div id='foot' class='foot'>\n<div id='menu'>\n";adminer()->navigation($Te);echo"</div>\n";if($Te!="auth")echo'<form action="" method="post">
<p class="logout">
<span>',h($_GET["username"])."\n",'</span>
<input type="submit" name="logout" value="',lang(80),'" id="logout">
',input_token(),'</form>
';echo"</div>\n\n",script("setupSubmitHighlight(document);");}function
int32($Ye){while($Ye>=2147483648)$Ye-=4294967296;while($Ye<=-2147483649)$Ye+=4294967296;return(int)$Ye;}function
long2str(array$W,$Ni){$Rg='';foreach($W
as$X)$Rg
.=pack('V',$X);if($Ni)return
substr($Rg,0,end($W));return$Rg;}function
str2long($Rg,$Ni){$W=array_values(unpack('V*',str_pad($Rg,4*ceil(strlen($Rg)/4),"\0")));if($Ni)$W[]=strlen($Rg);return$W;}function
xxtea_mx($Ui,$Ti,$Dh,$ee){return
int32((($Ui>>5&0x7FFFFFF)^$Ti<<2)+(($Ti>>3&0x1FFFFFFF)^$Ui<<4))^int32(($Dh^$Ti)+($ee^$Ui));}function
encrypt_string($yh,$y){if($yh=="")return"";$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($yh,true);$Ye=count($W)-1;$Ui=$W[$Ye];$Ti=$W[0];$I=floor(6+52/($Ye+1));$Dh=0;while($I-->0){$Dh=int32($Dh+0x9E3779B9);$cc=$Dh>>2&3;for($Lf=0;$Lf<$Ye;$Lf++){$Ti=$W[$Lf+1];$Xe=xxtea_mx($Ui,$Ti,$Dh,$y[$Lf&3^$cc]);$Ui=int32($W[$Lf]+$Xe);$W[$Lf]=$Ui;}$Ti=$W[0];$Xe=xxtea_mx($Ui,$Ti,$Dh,$y[$Lf&3^$cc]);$Ui=int32($W[$Ye]+$Xe);$W[$Ye]=$Ui;}return
long2str($W,false);}function
decrypt_string($yh,$y){if($yh=="")return"";if(!$y)return
false;$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($yh,false);$Ye=count($W)-1;$Ui=$W[$Ye];$Ti=$W[0];$I=floor(6+52/($Ye+1));$Dh=int32($I*0x9E3779B9);while($Dh){$cc=$Dh>>2&3;for($Lf=$Ye;$Lf>0;$Lf--){$Ui=$W[$Lf-1];$Xe=xxtea_mx($Ui,$Ti,$Dh,$y[$Lf&3^$cc]);$Ti=int32($W[$Lf]-$Xe);$W[$Lf]=$Ti;}$Ui=$W[$Ye];$Xe=xxtea_mx($Ui,$Ti,$Dh,$y[$Lf&3^$cc]);$Ti=int32($W[0]-$Xe);$W[0]=$Ti;$Dh=int32($Dh-0x9E3779B9);}return
long2str($W,true);}$bg=array();if($_COOKIE["adminer_permanent"]){foreach(explode(" ",$_COOKIE["adminer_permanent"])as$X){list($y)=explode(":",$X);$bg[$y]=$X;}}function
add_invalid_login(){$Da=get_temp_dir()."/adminer.invalid";foreach(glob("$Da*")?:array($Da)as$o){$q=file_open_lock($o);if($q)break;}if(!$q)$q=file_open_lock("$Da-".rand_string());if(!$q)return;$Vd=unserialize(stream_get_contents($q));$Vh=time();if($Vd){foreach($Vd
as$Wd=>$X){if($X[0]<$Vh)unset($Vd[$Wd]);}}$Ud=&$Vd[adminer()->bruteForceKey()];if(!$Ud)$Ud=array($Vh+30*60,0);$Ud[1]++;file_write_unlock($q,serialize($Vd));}function
check_invalid_login(array&$bg){$Vd=array();foreach(glob(get_temp_dir()."/adminer.invalid*")as$o){$q=file_open_lock($o);if($q){$Vd=unserialize(stream_get_contents($q));file_unlock($q);break;}}$Ud=idx($Vd,adminer()->bruteForceKey(),array());$ff=($Ud[1]>29?$Ud[0]-time():0);if($ff>0)auth_error(lang(81,ceil($ff/60)),$bg);}$xa=$_POST["auth"];if($xa){session_regenerate_id();$Ii=$xa["driver"];$P=$xa["server"];$V=$xa["username"];$H=(string)$xa["password"];$j=$xa["db"];set_password($Ii,$P,$V,$H);$_SESSION["db"][$Ii][$P][$V][$j]=true;if($xa["permanent"]){$y=implode("-",array_map('base64_encode',array($Ii,$P,$V,$j)));$pg=adminer()->permanentLogin(true);$bg[$y]="$y:".base64_encode($pg?encrypt_string($H,$pg):"");cookie("adminer_permanent",implode(" ",$bg));}if(count($_POST)==1||DRIVER!=$Ii||SERVER!=$P||$_GET["username"]!==$V||DB!=$j)redirect(auth_url($Ii,$P,$V,$j));}elseif($_POST["logout"]&&(!$_SESSION["token"]||verify_token())){foreach(array("pwds","db","dbs","queries")as$y)set_session($y,null);unset_permanent($bg);redirect(substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1),lang(82).' '.lang(83));}elseif($bg&&!$_SESSION["pwds"]){session_regenerate_id();$pg=adminer()->permanentLogin();foreach($bg
as$y=>$X){list(,$Xa)=explode(":",$X);list($Ii,$P,$V,$j)=array_map('base64_decode',explode("-",$y));set_password($Ii,$P,$V,decrypt_string(base64_decode($Xa),$pg));$_SESSION["db"][$Ii][$P][$V][$j]=true;}}function
unset_permanent(array&$bg){foreach($bg
as$y=>$X){list($Ii,$P,$V,$j)=array_map('base64_decode',explode("-",$y));if($Ii==DRIVER&&$P==SERVER&&$V==$_GET["username"]&&$j==DB)unset($bg[$y]);}cookie("adminer_permanent",implode(" ",$bg));}function
auth_error($l,array&$bg){$gh=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$gh]||$_GET[$gh])&&!$_SESSION["token"])$l=lang(84);else{restart_session();add_invalid_login();$H=get_password();if($H!==null){if($H===false)$l
.=($l?'<br>':'').lang(85,target_blank(),'<code>permanentLogin()</code>');set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent($bg);}}if(!$_COOKIE[$gh]&&$_GET[$gh]&&ini_bool("session.use_only_cookies"))$l=lang(86);$Of=session_get_cookie_params();cookie("adminer_key",($_COOKIE["adminer_key"]?:rand_string()),$Of["lifetime"]);if(!$_SESSION["token"])$_SESSION["token"]=rand(1,1e6);page_header(lang(27),$l,null);echo"<form action='' method='post'>\n","<div>";if(hidden_fields($_POST,array("auth")))echo"<p class='message'>".lang(87)."\n";echo"</div>\n";adminer()->loginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!class_exists('Adminer\Db')){unset($_SESSION["pwds"][DRIVER]);unset_permanent($bg);page_header(lang(88),lang(89,implode(", ",Driver::$extensions)),false);page_footer("auth");exit;}$f='';if(isset($_GET["username"])&&is_string(get_password())){list(,$fg)=host_port(SERVER);if(preg_match('~^\s*([-+]?\d+)~',$fg,$B)&&($B[1]<1024||$B[1]>65535))auth_error(lang(90),$bg);check_invalid_login($bg);$wb=adminer()->credentials();$f=Driver::connect($wb[0],$wb[1],$wb[2]);if(is_object($f)){Db::$instance=$f;Driver::$instance=new
Driver($f);if($f->flavor)save_settings(array("vendor-".DRIVER."-".SERVER=>get_driver(DRIVER)));}}$xe=null;if(!is_object($f)||($xe=adminer()->login($_GET["username"],get_password()))!==true){$l=(is_string($f)?nl_br(h($f)):(is_string($xe)?$xe:lang(91))).(preg_match('~^ | $~',get_password())?'<br>'.lang(92):'');auth_error($l,$bg);}if($_POST["logout"]&&$_SESSION["token"]&&!verify_token()){page_header(lang(80),lang(93));page_footer("db");exit;}if(!$_SESSION["token"])$_SESSION["token"]=rand(1,1e6);stop_session(true);if($xa&&$_POST["token"])$_POST["token"]=get_token();$l='';if($_POST){if(!verify_token()){$Nd="max_input_vars";$Je=ini_get($Nd);if(extension_loaded("suhosin")){foreach(array("suhosin.request.max_vars","suhosin.post.max_vars")as$y){$X=ini_get($y);if($X&&(!$Je||$X<$Je)){$Nd=$y;$Je=$X;}}}$l=(!$_POST["token"]&&$Je?lang(94,"'$Nd'"):lang(93).' '.lang(95));}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$l=lang(96,"'post_max_size'");if(isset($_GET["sql"]))$l
.=' '.lang(97);}function
print_select_result($K,$g=null,array$Cf=array(),$z=0){$we=array();$x=array();$d=array();$Ia=array();$qi=array();$L=array();for($t=0;(!$z||$t<$z)&&($M=$K->fetch_row());$t++){if(!$t){echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr>";for($ce=0;$ce<count($M);$ce++){$m=$K->fetch_field();$D=$m->name;$Bf=(isset($m->orgtable)?$m->orgtable:"");$Af=(isset($m->orgname)?$m->orgname:$D);if($Cf&&JUSH=="sql")$we[$ce]=($D=="table"?"table=":($D=="possible_keys"?"indexes=":null));elseif($Bf!=""){if(isset($m->table))$L[$m->table]=$Bf;if(!isset($x[$Bf])){$x[$Bf]=array();foreach(indexes($Bf,$g)as$w){if($w["type"]=="PRIMARY"){$x[$Bf]=array_flip($w["columns"]);break;}}$d[$Bf]=$x[$Bf];}if(isset($d[$Bf][$Af])){unset($d[$Bf][$Af]);$x[$Bf][$Af]=$ce;$we[$ce]=$Bf;}}if($m->charsetnr==63)$Ia[$ce]=true;$qi[$ce]=$m->type;echo"<th".($Bf!=""||$m->name!=$Af?" title='".h(($Bf!=""?"$Bf.":"").$Af)."'":"").">".h($D).($Cf?doc_link(array('sql'=>"explain-output.html#explain_".strtolower($D),'mariadb'=>"explain/#the-columns-in-explain-select",)):"");}echo"</thead>\n";}echo"<tr>";foreach($M
as$y=>$X){$_="";if(isset($we[$y])&&!$d[$we[$y]]){if($Cf&&JUSH=="sql"){$R=$M[array_search("table=",$we)];$_=ME.$we[$y].urlencode($Cf[$R]!=""?$Cf[$R]:$R);}else{$_=ME."edit=".urlencode($we[$y]);foreach($x[$we[$y]]as$bb=>$ce)$_
.="&where".urlencode("[".bracket_escape($bb)."]")."=".urlencode($M[$ce]);}}elseif(is_url($X))$_=$X;if($X===null)$X="<i>NULL</i>";elseif($Ia[$y]&&!is_utf8($X))$X="<i>".lang(36,strlen($X))."</i>";else{$X=h($X);if($qi[$y]==254)$X="<code>$X</code>";}if($_)$X="<a href='".h($_)."'".(is_url($_)?target_blank():'').">$X</a>";echo"<td".($qi[$y]<=9||$qi[$y]==246?" class='number'":"").">$X";}}echo($t?"</table>\n</div>":"<p class='message'>".lang(12))."\n";return$L;}function
referencable_primary($bh){$L=array();foreach(table_status('',true)as$Hh=>$R){if($Hh!=$bh&&fk_support($R)){foreach(fields($Hh)as$m){if($m["primary"]){if($L[$Hh]){unset($L[$Hh]);break;}$L[$Hh]=$m;}}}}return$L;}function
textarea($D,$Y,$N=10,$eb=80){echo"<textarea name='".h($D)."' rows='$N' cols='$eb' class='sqlarea jush-".JUSH."' spellcheck='false' wrap='off'>";if(is_array($Y)){foreach($Y
as$X)echo
h($X[0])."\n\n\n";}else
echo
h($Y);echo"</textarea>";}function
select_input($wa,array$xf,$Y="",$sf="",$cg=""){$Oh=($xf?"select":"input");return"<$Oh$wa".($xf?"><option value=''>$cg".optionlist($xf,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$cg'>").($sf?script("qsl('$Oh').onchange = $sf;",""):"");}function
json_row($y,$X=null,$uc=true){static$Oc=true;if($Oc)echo"{";if($y!=""){echo($Oc?"":",")."\n\t\"".addcslashes($y,"\r\n\t\"\\/").'": '.($X!==null?($uc?'"'.addcslashes($X,"\r\n\"\\/").'"':$X):'null');$Oc=false;}else{echo"\n}\n";$Oc=true;}}function
edit_type($y,array$m,array$b,array$Vc=array(),array$Fc=array()){$U=$m["type"];echo"<td><select name='".h($y)."[type]' class='type' aria-labelledby='label-type'>";if($U&&!array_key_exists($U,driver()->types())&&!isset($Vc[$U])&&!in_array($U,$Fc))$Fc[]=$U;$_h=driver()->structuredTypes();if($Vc)$_h[lang(98)]=$Vc;echo
optionlist(array_merge($Fc,$_h),$U),"</select><td>","<input name='".h($y)."[length]' value='".h($m["length"])."' size='3'".(!$m["length"]&&preg_match('~var(char|binary)$~',$U)?" class='required'":"")." aria-labelledby='label-length'>","<td class='options'>",($b?"<input list='collations' name='".h($y)."[collation]'".(preg_match('~(char|text|enum|set)$~',$U)?"":" class='hidden'")." value='".h($m["collation"])."' placeholder='(".lang(99).")'>":''),(driver()->unsigned?"<select name='".h($y)."[unsigned]'".(!$U||preg_match(number_type(),$U)?"":" class='hidden'").'><option>'.optionlist(driver()->unsigned,$m["unsigned"]).'</select>':''),(isset($m['on_update'])?"<select name='".h($y)."[on_update]'".(preg_match('~timestamp|datetime~',$U)?"":" class='hidden'").'>'.optionlist(array(""=>"(".lang(100).")","CURRENT_TIMESTAMP"),(preg_match('~^CURRENT_TIMESTAMP~i',$m["on_update"])?"CURRENT_TIMESTAMP":$m["on_update"])).'</select>':''),($Vc?"<select name='".h($y)."[on_delete]'".(preg_match("~`~",$U)?"":" class='hidden'")."><option value=''>(".lang(101).")".optionlist(explode("|",driver()->onActions),$m["on_delete"])."</select> ":" ");}function
process_length($se){$pc=driver()->enumLength;return(preg_match("~^\\s*\\(?\\s*$pc(?:\\s*,\\s*$pc)*+\\s*\\)?\\s*\$~",$se)&&preg_match_all("~$pc~",$se,$Be)?"(".implode(",",$Be[0]).")":preg_replace('~^[0-9].*~','(\0)',preg_replace('~[^-0-9,+()[\]]~','',$se)));}function
process_type(array$m,$cb="COLLATE"){return" $m[type]".process_length($m["length"]).(preg_match(number_type(),$m["type"])&&in_array($m["unsigned"],driver()->unsigned)?" $m[unsigned]":"").(preg_match('~char|text|enum|set~',$m["type"])&&$m["collation"]?" $cb ".(JUSH=="mssql"?$m["collation"]:q($m["collation"])):"");}function
process_field(array$m,array$oi){if($m["on_update"])$m["on_update"]=str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",$m["on_update"]);return
array(idf_escape(trim($m["field"])),process_type($oi),($m["null"]?" NULL":" NOT NULL"),default_value($m),(preg_match('~timestamp|datetime~',$m["type"])&&$m["on_update"]?" ON UPDATE $m[on_update]":""),(support("comment")&&$m["comment"]!=""?" COMMENT ".q($m["comment"]):""),($m["auto_increment"]?auto_increment():null),);}function
default_value(array$m){$k=$m["default"];$cd=$m["generated"];return($k===null?"":(in_array($cd,driver()->generated)?(JUSH=="mssql"?" AS ($k)".($cd=="VIRTUAL"?"":" $cd")."":" GENERATED ALWAYS AS ($k) $cd"):" DEFAULT ".(!preg_match('~^GENERATED ~i',$k)&&(preg_match('~char|binary|text|json|enum|set~',$m["type"])||preg_match('~^(?![a-z])~i',$k))?(JUSH=="sql"&&preg_match('~text|json~',$m["type"])?"(".q($k).")":q($k)):str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",(JUSH=="sqlite"?"($k)":$k)))));}function
type_class($U){foreach(array('char'=>'text','date'=>'time|year','binary'=>'blob','enum'=>'set',)as$y=>$X){if(preg_match("~$y|$X~",$U))return" class='$y'";}}function
edit_fields(array$n,array$b,$U="TABLE",array$Vc=array()){$n=array_values($n);$Jb=(($_POST?$_POST["defaults"]:get_setting("defaults"))?"":" class='hidden'");$ib=(($_POST?$_POST["comments"]:get_setting("comments"))?"":" class='hidden'");echo"<thead><tr>\n",($U=="PROCEDURE"?"<td>":""),"<th id='label-name'>".($U=="TABLE"?lang(102):lang(103)),"<td id='label-type'>".lang(38)."<textarea id='enum-edit' rows='4' cols='12' wrap='off' style='display: none;'></textarea>".script("qs('#enum-edit').onblur = editingLengthBlur;"),"<td id='label-length'>".lang(104),"<td>".lang(105);if($U=="TABLE")echo"<td id='label-null'>NULL\n","<td><input type='radio' name='auto_increment_col' value=''><abbr id='label-ai' title='".lang(40)."'>AI</abbr>",doc_link(array('sql'=>"example-auto-increment.html",'mariadb'=>"auto_increment/",)),"<td id='label-default'$Jb>".lang(41),(support("comment")?"<td id='label-comment'$ib>".lang(39):"");echo"<td>".icon("plus","add[".(support("move_col")?0:count($n))."]","+",lang(106)),"</thead>\n<tbody>\n",script("mixin(qsl('tbody'), {onclick: editingClick, onkeydown: editingKeydown, oninput: editingInput});");foreach($n
as$t=>$m){$t++;$Df=$m[($_POST?"orig":"field")];$Ub=(isset($_POST["add"][$t-1])||(isset($m["field"])&&!idx($_POST["drop_col"],$t)))&&(support("drop_col")||$Df=="");echo"<tr".($Ub?"":" style='display: none;'").">\n",($U=="PROCEDURE"?"<td>".html_select("fields[$t][inout]",explode("|",driver()->inout),$m["inout"]):"")."<th>";if($Ub)echo"<input name='fields[$t][field]' value='".h($m["field"])."' data-maxlength='64' autocapitalize='off' aria-labelledby='label-name'".(isset($_POST["add"][$t-1])?" autofocus":"").">";echo
input_hidden("fields[$t][orig]",$Df);edit_type("fields[$t]",$m,$b,$Vc);if($U=="TABLE")echo"<td>".checkbox("fields[$t][null]",1,$m["null"],"","","block","label-null"),"<td><label class='block'><input type='radio' name='auto_increment_col' value='$t'".($m["auto_increment"]?" checked":"")." aria-labelledby='label-ai'></label>","<td$Jb>".(driver()->generated?html_select("fields[$t][generated]",array_merge(array("","DEFAULT"),driver()->generated),$m["generated"])." ":checkbox("fields[$t][generated]",1,$m["generated"],"","","","label-default")),"<input name='fields[$t][default]' value='".h($m["default"])."' aria-labelledby='label-default'>",(support("comment")?"<td$ib><input name='fields[$t][comment]' value='".h($m["comment"])."' data-maxlength='".(min_version(5.5)?1024:255)."' aria-labelledby='label-comment'>":"");echo"<td>",(support("move_col")?icon("plus","add[$t]","+",lang(106))." ".icon("up","up[$t]","↑",lang(107))." ".icon("down","down[$t]","↓",lang(108))." ":""),($Df==""||support("drop_col")?icon("cross","drop_col[$t]","x",lang(109)):"");}}function
process_fields(array&$n){$kf=0;if($_POST["up"]){$me=0;foreach($n
as$y=>$m){if(key($_POST["up"])==$y){unset($n[$y]);array_splice($n,$me,0,array($m));break;}if(isset($m["field"]))$me=$kf;$kf++;}}elseif($_POST["down"]){$Xc=false;foreach($n
as$y=>$m){if(isset($m["field"])&&$Xc){unset($n[key($_POST["down"])]);array_splice($n,$kf,0,array($Xc));break;}if(key($_POST["down"])==$y)$Xc=$m;$kf++;}}elseif($_POST["add"]){$n=array_values($n);array_splice($n,key($_POST["add"]),0,array(array()));}elseif(!$_POST["drop_col"])return
false;return
true;}function
normalize_enum(array$B){$X=$B[0];return"'".str_replace("'","''",addcslashes(stripcslashes(str_replace($X[0].$X[0],$X[0],substr($X,1,-1))),'\\'))."'";}function
grant($ed,array$rg,$d,$qf){if(!$rg)return
true;if($rg==array("ALL PRIVILEGES","GRANT OPTION"))return($ed=="GRANT"?queries("$ed ALL PRIVILEGES$qf WITH GRANT OPTION"):queries("$ed ALL PRIVILEGES$qf")&&queries("$ed GRANT OPTION$qf"));return
queries("$ed ".preg_replace('~(GRANT OPTION)\([^)]*\)~','\1',implode("$d, ",$rg).$d).$qf);}function
drop_create($Yb,$h,$Zb,$Sh,$ac,$A,$Pe,$Ne,$Oe,$nf,$cf){if($_POST["drop"])query_redirect($Yb,$A,$Pe);elseif($nf=="")query_redirect($h,$A,$Oe);elseif($nf!=$cf){$vb=queries($h);queries_redirect($A,$Ne,$vb&&queries($Yb));if($vb)queries($Zb);}else
queries_redirect($A,$Ne,queries($Sh)&&queries($ac)&&queries($Yb)&&queries($h));}function
create_trigger($qf,array$M){$Xh=" $M[Timing] $M[Event]".(preg_match('~ OF~',$M["Event"])?" $M[Of]":"");return"CREATE TRIGGER ".idf_escape($M["Trigger"]).(JUSH=="mssql"?$qf.$Xh:$Xh.$qf).rtrim(" $M[Type]\n$M[Statement]",";").";";}function
create_routine($Og,array$M){$Q=array();$n=(array)$M["fields"];ksort($n);foreach($n
as$m){if($m["field"]!="")$Q[]=(preg_match("~^(".driver()->inout.")\$~",$m["inout"])?"$m[inout] ":"").idf_escape($m["field"]).process_type($m,"CHARACTER SET");}$Lb=rtrim($M["definition"],";");return"CREATE $Og ".idf_escape(trim($M["name"]))." (".implode(", ",$Q).")".($Og=="FUNCTION"?" RETURNS".process_type($M["returns"],"CHARACTER SET"):"").($M["language"]?" LANGUAGE $M[language]":"").(JUSH=="pgsql"?" AS ".q($Lb):"\n$Lb;");}function
remove_definer($J){return
preg_replace('~^([A-Z =]+) DEFINER=`'.preg_replace('~@(.*)~','`@`(%|\1)',logged_user()).'`~','\1',$J);}function
format_foreign_key(array$p){$j=$p["db"];$hf=$p["ns"];return" FOREIGN KEY (".implode(", ",array_map('Adminer\idf_escape',$p["source"])).") REFERENCES ".($j!=""&&$j!=$_GET["db"]?idf_escape($j).".":"").($hf!=""&&$hf!=$_GET["ns"]?idf_escape($hf).".":"").idf_escape($p["table"])." (".implode(", ",array_map('Adminer\idf_escape',$p["target"])).")".(preg_match("~^(".driver()->onActions.")\$~",$p["on_delete"])?" ON DELETE $p[on_delete]":"").(preg_match("~^(".driver()->onActions.")\$~",$p["on_update"])?" ON UPDATE $p[on_update]":"");}function
tar_file($o,$ci){$L=pack("a100a8a8a8a12a12",$o,644,0,0,decoct($ci->size),decoct(time()));$Wa=8*32;for($t=0;$t<strlen($L);$t++)$Wa+=ord($L[$t]);$L
.=sprintf("%06o",$Wa)."\0 ";echo$L,str_repeat("\0",512-strlen($L));$ci->send();echo
str_repeat("\0",511-($ci->size+511)%512);}function
ini_bytes($Nd){$X=ini_get($Nd);switch(strtolower(substr($X,-1))){case'g':$X=(int)$X*1024;case'm':$X=(int)$X*1024;case'k':$X=(int)$X*1024;}return$X;}function
doc_link(array$Yf,$Th="<sup>?</sup>"){$eh=connection()->server_info;$Ji=preg_replace('~^(\d\.?\d).*~s','\1',$eh);$Ai=array('sql'=>"https://dev.mysql.com/doc/refman/$Ji/en/",'sqlite'=>"https://www.sqlite.org/",'pgsql'=>"https://www.postgresql.org/docs/".(connection()->flavor=='cockroach'?"current":$Ji)."/",'mssql'=>"https://learn.microsoft.com/en-us/sql/",'oracle'=>"https://www.oracle.com/pls/topic/lookup?ctx=db".preg_replace('~^.* (\d+)\.(\d+)\.\d+\.\d+\.\d+.*~s','\1\2',$eh)."&id=",);if(connection()->flavor=='maria'){$Ai['sql']="https://mariadb.com/kb/en/";$Yf['sql']=(isset($Yf['mariadb'])?$Yf['mariadb']:str_replace(".html","/",$Yf['sql']));}return($Yf[JUSH]?"<a href='".h($Ai[JUSH].$Yf[JUSH].(JUSH=='mssql'?"?view=sql-server-ver$Ji":""))."'".target_blank().">$Th</a>":"");}function
db_size($j){if(!connection()->select_db($j))return"?";$L=0;foreach(table_status()as$S)$L+=$S["Data_length"]+$S["Index_length"];return
format_number($L);}function
set_utf8mb4($h){static$Q=false;if(!$Q&&preg_match('~\butf8mb4~i',$h)){$Q=true;echo"SET NAMES ".charset(connection()).";\n\n";}}if(isset($_GET["status"]))$_GET["variables"]=$_GET["status"];if(isset($_GET["import"]))$_GET["sql"]=$_GET["import"];if(!(DB!=""?connection()->select_db(DB):isset($_GET["sql"])||isset($_GET["dump"])||isset($_GET["database"])||isset($_GET["processlist"])||isset($_GET["privileges"])||isset($_GET["user"])||isset($_GET["variables"])||$_GET["script"]=="connect"||$_GET["script"]=="kill")){if(DB!=""||$_GET["refresh"]){restart_session();set_session("dbs",null);}if(DB!=""){header("HTTP/1.1 404 Not Found");page_header(lang(26).": ".h(DB),lang(110),true);}else{if($_POST["db"]&&!$l)queries_redirect(substr(ME,0,-1),lang(111),drop_databases($_POST["db"]));page_header(lang(112),$l,false);echo"<p class='links'>\n";foreach(array('database'=>lang(113),'privileges'=>lang(60),'processlist'=>lang(114),'variables'=>lang(115),'status'=>lang(116),)as$y=>$X){if(support($y))echo"<a href='".h(ME)."$y='>$X</a>\n";}echo"<p>".lang(117,get_driver(DRIVER),"<b>".h(connection()->server_info)."</b>","<b>".connection()->extension."</b>")."\n","<p>".lang(118,"<b>".h(logged_user())."</b>")."\n";$i=adminer()->databases();if($i){$Ug=support("scheme");$b=collations();echo"<form action='' method='post'>\n","<table class='checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),"<thead><tr>".(support("database")?"<td>":"")."<th>".lang(26).(get_session("dbs")!==null?" - <a href='".h(ME)."refresh=1'>".lang(119)."</a>":"")."<td>".lang(120)."<td>".lang(121)."<td>".lang(122)." - <a href='".h(ME)."dbsize=1'>".lang(123)."</a>".script("qsl('a').onclick = partial(ajaxSetHtml, '".js_escape(ME)."script=connect');","")."</thead>\n";$i=($_GET["dbsize"]?count_tables($i):array_flip($i));foreach($i
as$j=>$T){$Ng=h(ME)."db=".urlencode($j);$u=h("Db-".$j);echo"<tr>".(support("database")?"<td>".checkbox("db[]",$j,in_array($j,(array)$_POST["db"]),"","","",$u):""),"<th><a href='$Ng' id='$u'>".h($j)."</a>";$db=h(db_collation($j,$b));echo"<td>".(support("database")?"<a href='$Ng".($Ug?"&amp;ns=":"")."&amp;database=' title='".lang(56)."'>$db</a>":$db),"<td align='right'><a href='$Ng&amp;schema=' id='tables-".h($j)."' title='".lang(59)."'>".($_GET["dbsize"]?$T:"?")."</a>","<td align='right' id='size-".h($j)."'>".($_GET["dbsize"]?db_size($j):"?"),"\n";}echo"</table>\n",(support("database")?"<div class='footer'><div>\n"."<fieldset><legend>".lang(124)." <span id='selected'></span></legend><div>\n".input_hidden("all").script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^db/)); };")."<input type='submit' name='drop' value='".lang(125)."'>".confirm()."\n"."</div></fieldset>\n"."</div></div>\n":""),input_token(),"</form>\n",script("tableCheck();");}if(!empty(adminer()->plugins)){echo"<div class='plugins'>\n","<h3>".lang(126)."</h3>\n<ul>\n";foreach(adminer()->plugins
as$dg){$Pb=(method_exists($dg,'description')?$dg->description():"");if(!$Pb){$Eg=new
\ReflectionObject($dg);if(preg_match('~^/[\s*]+(.+)~',$Eg->getDocComment(),$B))$Pb=$B[1];}$Vg=(method_exists($dg,'screenshot')?$dg->screenshot():"");echo"<li><b>".get_class($dg)."</b>".h($Pb?": $Pb":"").($Vg?" (<a href='".h($Vg)."'".target_blank().">".lang(127)."</a>)":"")."\n";}echo"</ul>\n";adminer()->pluginsLinks();echo"</div>\n";}}page_footer("db");exit;}adminer()->afterConnect();class
TmpFile{private$handler;var$size;function
__construct(){$this->handler=tmpfile();}function
write($pb){$this->size+=strlen($pb);fwrite($this->handler,$pb);}function
send(){fseek($this->handler,0);fpassthru($this->handler);fclose($this->handler);}}if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["callf"]))$_GET["call"]=$_GET["callf"];if(isset($_GET["function"]))$_GET["procedure"]=$_GET["function"];if(isset($_GET["download"])){$a=$_GET["download"];$n=fields($a);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$a-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$O=array(idf_escape($_GET["field"]));$K=driver()->select($a,$O,array(where($_GET,$n)),$O);$M=($K?$K->fetch_row():array());echo
driver()->value($M[0],$n[$_GET["field"]]);exit;}elseif(isset($_GET["table"])){$a=$_GET["table"];$n=fields($a);if(!$n)$l=error()?:lang(9);$S=table_status1($a);$D=adminer()->tableName($S);page_header(($n&&is_view($S)?$S['Engine']=='materialized view'?lang(128):lang(129):lang(130)).": ".($D!=""?$D:h($a)),$l);$Mg=array();foreach($n
as$y=>$m)$Mg+=$m["privileges"];adminer()->selectLinks($S,(isset($Mg["insert"])||!support("table")?"":null));$hb=$S["Comment"];if($hb!="")echo"<p class='nowrap'>".lang(39).": ".h($hb)."\n";if($n)adminer()->tableStructurePrint($n,$S);function
tables_links(array$T){echo"<ul>\n";foreach($T
as$R)echo"<li><a href='".h(ME."table=".urlencode($R))."'>".h($R)."</a>";echo"</ul>\n";}$Md=driver()->inheritsFrom($a);if($Md){echo"<h3>".lang(131)."</h3>\n";tables_links($Md);}if(support("indexes")&&driver()->supportsIndex($S)){echo"<h3 id='indexes'>".lang(132)."</h3>\n";$x=indexes($a);if($x)adminer()->tableIndexesPrint($x,$S);echo'<p class="links"><a href="'.h(ME).'indexes='.urlencode($a).'">'.lang(133)."</a>\n";}if(!is_view($S)){if(fk_support($S)){echo"<h3 id='foreign-keys'>".lang(98)."</h3>\n";$Vc=foreign_keys($a);if($Vc){echo"<table>\n","<thead><tr><th>".lang(134)."<td>".lang(135)."<td>".lang(101)."<td>".lang(100)."<td></thead>\n";foreach($Vc
as$D=>$p){echo"<tr title='".h($D)."'>","<th><i>".implode("</i>, <i>",array_map('Adminer\h',$p["source"]))."</i>";$_=($p["db"]!=""?preg_replace('~db=[^&]*~',"db=".urlencode($p["db"]),ME):($p["ns"]!=""?preg_replace('~ns=[^&]*~',"ns=".urlencode($p["ns"]),ME):ME));echo"<td><a href='".h($_."table=".urlencode($p["table"]))."'>".($p["db"]!=""&&$p["db"]!=DB?"<b>".h($p["db"])."</b>.":"").($p["ns"]!=""&&$p["ns"]!=$_GET["ns"]?"<b>".h($p["ns"])."</b>.":"").h($p["table"])."</a>","(<i>".implode("</i>, <i>",array_map('Adminer\h',$p["target"]))."</i>)","<td>".h($p["on_delete"]),"<td>".h($p["on_update"]),'<td><a href="'.h(ME.'foreign='.urlencode($a).'&name='.urlencode($D)).'">'.lang(136).'</a>',"\n";}echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'foreign='.urlencode($a).'">'.lang(137)."</a>\n";}if(support("check")){echo"<h3 id='checks'>".lang(138)."</h3>\n";$Ta=driver()->checkConstraints($a);if($Ta){echo"<table>\n";foreach($Ta
as$y=>$X)echo"<tr title='".h($y)."'>","<td><code class='jush-".JUSH."'>".h($X),"<td><a href='".h(ME.'check='.urlencode($a).'&name='.urlencode($y))."'>".lang(136)."</a>","\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'check='.urlencode($a).'">'.lang(139)."</a>\n";}}if(support(is_view($S)?"view_trigger":"trigger")){echo"<h3 id='triggers'>".lang(140)."</h3>\n";$ni=triggers($a);if($ni){echo"<table>\n";foreach($ni
as$y=>$X)echo"<tr valign='top'><td>".h($X[0])."<td>".h($X[1])."<th>".h($y)."<td><a href='".h(ME.'trigger='.urlencode($a).'&name='.urlencode($y))."'>".lang(136)."</a>\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'trigger='.urlencode($a).'">'.lang(141)."</a>\n";}$Ld=driver()->inheritedTables($a);if($Ld){echo"<h3 id='partitions'>".lang(142)."</h3>\n";$Rf=driver()->partitionsInfo($a);if($Rf)echo"<p><code class='jush-".JUSH."'>BY ".h("$Rf[partition_by]($Rf[partition])")."</code>\n";tables_links($Ld);}}elseif(isset($_GET["schema"])){page_header(lang(59),"",array(),h(DB.($_GET["ns"]?".$_GET[ns]":"")));$Ih=array();$Jh=array();$da=($_GET["schema"]?:$_COOKIE["adminer_schema-".str_replace(".","_",DB)]);preg_match_all('~([^:]+):([-0-9.]+)x([-0-9.]+)(_|$)~',$da,$Be,PREG_SET_ORDER);foreach($Be
as$t=>$B){$Ih[$B[1]]=array($B[2],$B[3]);$Jh[]="\n\t'".js_escape($B[1])."': [ $B[2], $B[3] ]";}$fi=0;$Ea=-1;$Tg=array();$Dg=array();$qe=array();$pa=driver()->allFields();foreach(table_status('',true)as$R=>$S){if(is_view($S))continue;$gg=0;$Tg[$R]["fields"]=array();foreach($pa[$R]as$m){$gg+=1.25;$m["pos"]=$gg;$Tg[$R]["fields"][$m["field"]]=$m;}$Tg[$R]["pos"]=($Ih[$R]?:array($fi,0));foreach(adminer()->foreignKeys($R)as$X){if(!$X["db"]){$oe=$Ea;if(idx($Ih[$R],1)||idx($Ih[$X["table"]],1))$oe=min(idx($Ih[$R],1,0),idx($Ih[$X["table"]],1,0))-1;else$Ea-=.1;while($qe[(string)$oe])$oe-=.0001;$Tg[$R]["references"][$X["table"]][(string)$oe]=array($X["source"],$X["target"]);$Dg[$X["table"]][$R][(string)$oe]=$X["target"];$qe[(string)$oe]=true;}}$fi=max($fi,$Tg[$R]["pos"][0]+2.5+$gg);}echo'<div id="schema" style="height: ',$fi,'em;">
<script',nonce(),'>
qs(\'#schema\').onselectstart = () => false;
const tablePos = {',implode(",",$Jh)."\n",'};
const em = qs(\'#schema\').offsetHeight / ',$fi,';
document.onmousemove = schemaMousemove;
document.onmouseup = partialArg(schemaMouseup, \'',js_escape(DB),'\');
</script>
';foreach($Tg
as$D=>$R){echo"<div class='table' style='top: ".$R["pos"][0]."em; left: ".$R["pos"][1]."em;'>",'<a href="'.h(ME).'table='.urlencode($D).'"><b>'.h($D)."</b></a>",script("qsl('div').onmousedown = schemaMousedown;");foreach($R["fields"]as$m){$X='<span'.type_class($m["type"]).' title="'.h($m["type"].($m["length"]?"($m[length])":"").($m["null"]?" NULL":'')).'">'.h($m["field"]).'</span>';echo"<br>".($m["primary"]?"<i>$X</i>":$X);}foreach((array)$R["references"]as$Qh=>$Fg){foreach($Fg
as$oe=>$Ag){$pe=$oe-idx($Ih[$D],1);$t=0;foreach($Ag[0]as$oh)echo"\n<div class='references' title='".h($Qh)."' id='refs$oe-".($t++)."' style='left: $pe"."em; top: ".$R["fields"][$oh]["pos"]."em; padding-top: .5em;'>"."<div style='border-top: 1px solid gray; width: ".(-$pe)."em;'></div></div>";}}foreach((array)$Dg[$D]as$Qh=>$Fg){foreach($Fg
as$oe=>$d){$pe=$oe-idx($Ih[$D],1);$t=0;foreach($d
as$Ph)echo"\n<div class='references arrow' title='".h($Qh)."' id='refd$oe-".($t++)."' style='left: $pe"."em; top: ".$R["fields"][$Ph]["pos"]."em;'>"."<div style='height: .5em; border-bottom: 1px solid gray; width: ".(-$pe)."em;'></div>"."</div>";}}echo"\n</div>\n";}foreach($Tg
as$D=>$R){foreach((array)$R["references"]as$Qh=>$Fg){foreach($Fg
as$oe=>$Ag){$Se=$fi;$He=-10;foreach($Ag[0]as$y=>$oh){$hg=$R["pos"][0]+$R["fields"][$oh]["pos"];$ig=$Tg[$Qh]["pos"][0]+$Tg[$Qh]["fields"][$Ag[1][$y]]["pos"];$Se=min($Se,$hg,$ig);$He=max($He,$hg,$ig);}echo"<div class='references' id='refl$oe' style='left: $oe"."em; top: $Se"."em; padding: .5em 0;'><div style='border-right: 1px solid gray; margin-top: 1px; height: ".($He-$Se)."em;'></div></div>\n";}}}echo'</div>
<p class="links"><a href="',h(ME."schema=".urlencode($da)),'" id="schema-link">',lang(143),'</a>
';}elseif(isset($_GET["dump"])){$a=$_GET["dump"];if($_POST&&!$l){save_settings(array_intersect_key($_POST,array_flip(array("output","format","db_style","types","routines","events","table_style","auto_increment","triggers","data_style"))),"adminer_export");$T=array_flip((array)$_POST["tables"])+array_flip((array)$_POST["data"]);$Bc=dump_headers((count($T)==1?key($T):DB),(DB==""||count($T)>1));$Zd=preg_match('~sql~',$_POST["format"]);if($Zd){echo"-- Adminer ".VERSION." ".get_driver(DRIVER)." ".str_replace("\n"," ",connection()->server_info)." dump\n\n";if(JUSH=="sql"){echo"SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
".($_POST["data_style"]?"SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
":"")."
";connection()->query("SET time_zone = '+00:00'");connection()->query("SET sql_mode = ''");}}$Ah=$_POST["db_style"];$i=array(DB);if(DB==""){$i=$_POST["databases"];if(is_string($i))$i=explode("\n",rtrim(str_replace("\r","",$i),"\n"));}foreach((array)$i
as$j){adminer()->dumpDatabase($j);if(connection()->select_db($j)){if($Zd){if($Ah)echo
use_sql($j,$Ah).";\n\n";$Jf="";if($_POST["types"]){foreach(types()as$u=>$U){$qc=type_values($u);if($qc)$Jf
.=($Ah!='DROP+CREATE'?"DROP TYPE IF EXISTS ".idf_escape($U).";;\n":"")."CREATE TYPE ".idf_escape($U)." AS ENUM ($qc);\n\n";else$Jf
.="-- Could not export type $U\n\n";}}if($_POST["routines"]){foreach(routines()as$M){$D=$M["ROUTINE_NAME"];$Og=$M["ROUTINE_TYPE"];$h=create_routine($Og,array("name"=>$D)+routine($M["SPECIFIC_NAME"],$Og));set_utf8mb4($h);$Jf
.=($Ah!='DROP+CREATE'?"DROP $Og IF EXISTS ".idf_escape($D).";;\n":"")."$h;\n\n";}}if($_POST["events"]){foreach(get_rows("SHOW EVENTS",null,"-- ")as$M){$h=remove_definer(get_val("SHOW CREATE EVENT ".idf_escape($M["Name"]),3));set_utf8mb4($h);$Jf
.=($Ah!='DROP+CREATE'?"DROP EVENT IF EXISTS ".idf_escape($M["Name"]).";;\n":"")."$h;;\n\n";}}echo($Jf&&JUSH=='sql'?"DELIMITER ;;\n\n$Jf"."DELIMITER ;\n\n":$Jf);}if($_POST["table_style"]||$_POST["data_style"]){$Li=array();foreach(table_status('',true)as$D=>$S){$R=(DB==""||in_array($D,(array)$_POST["tables"]));$Bb=(DB==""||in_array($D,(array)$_POST["data"]));if($R||$Bb){$ci=null;if($Bc=="tar"){$ci=new
TmpFile;ob_start(array($ci,'write'),1e5);}adminer()->dumpTable($D,($R?$_POST["table_style"]:""),(is_view($S)?2:0));if(is_view($S))$Li[]=$D;elseif($Bb){$n=fields($D);adminer()->dumpData($D,$_POST["data_style"],"SELECT *".convert_fields($n,$n)." FROM ".table($D));}if($Zd&&$_POST["triggers"]&&$R&&($ni=trigger_sql($D)))echo"\nDELIMITER ;;\n$ni\nDELIMITER ;\n";if($Bc=="tar"){ob_end_flush();tar_file((DB!=""?"":"$j/")."$D.csv",$ci);}elseif($Zd)echo"\n";}}if(function_exists('Adminer\foreign_keys_sql')){foreach(table_status('',true)as$D=>$S){$R=(DB==""||in_array($D,(array)$_POST["tables"]));if($R&&!is_view($S))echo
foreign_keys_sql($D);}}foreach($Li
as$Ki)adminer()->dumpTable($Ki,$_POST["table_style"],1);if($Bc=="tar")echo
pack("x512");}}}adminer()->dumpFooter();exit;}page_header(lang(65),$l,($_GET["export"]!=""?array("table"=>$_GET["export"]):array()),h(DB));echo'
<form action="" method="post">
<table class="layout">
';$Fb=array('','USE','DROP+CREATE','CREATE');$Kh=array('','DROP+CREATE','CREATE');$Cb=array('','TRUNCATE+INSERT','INSERT');if(JUSH=="sql")$Cb[]='INSERT+UPDATE';$M=get_settings("adminer_export");if(!$M)$M=array("output"=>"text","format"=>"sql","db_style"=>(DB!=""?"":"CREATE"),"table_style"=>"DROP+CREATE","data_style"=>"INSERT");if(!isset($M["events"])){$M["routines"]=$M["events"]=($_GET["dump"]=="");$M["triggers"]=$M["table_style"];}echo"<tr><th>".lang(144)."<td>".html_radios("output",adminer()->dumpOutput(),$M["output"])."\n","<tr><th>".lang(145)."<td>".html_radios("format",adminer()->dumpFormat(),$M["format"])."\n",(JUSH=="sqlite"?"":"<tr><th>".lang(26)."<td>".html_select('db_style',$Fb,$M["db_style"]).(support("type")?checkbox("types",1,$M["types"],lang(6)):"").(support("routine")?checkbox("routines",1,$M["routines"],lang(61)):"").(support("event")?checkbox("events",1,$M["events"],lang(63)):"")),"<tr><th>".lang(121)."<td>".html_select('table_style',$Kh,$M["table_style"]).checkbox("auto_increment",1,$M["auto_increment"],lang(40)).(support("trigger")?checkbox("triggers",1,$M["triggers"],lang(140)):""),"<tr><th>".lang(146)."<td>".html_select('data_style',$Cb,$M["data_style"]),'</table>
<p><input type="submit" value="',lang(65),'">
',input_token(),'
<table>
',script("qsl('table').onclick = dumpClick;");$mg=array();if(DB!=""){$Ua=($a!=""?"":" checked");echo"<thead><tr>","<th style='text-align: left;'><label class='block'><input type='checkbox' id='check-tables'$Ua>".lang(121)."</label>".script("qs('#check-tables').onclick = partial(formCheck, /^tables\\[/);",""),"<th style='text-align: right;'><label class='block'>".lang(146)."<input type='checkbox' id='check-data'$Ua></label>".script("qs('#check-data').onclick = partial(formCheck, /^data\\[/);",""),"</thead>\n";$Li="";$Mh=tables_list();foreach($Mh
as$D=>$U){$lg=preg_replace('~_.*~','',$D);$Ua=($a==""||$a==(substr($a,-1)=="%"?"$lg%":$D));$og="<tr><td>".checkbox("tables[]",$D,$Ua,$D,"","block");if($U!==null&&!preg_match('~table~i',$U))$Li
.="$og\n";else
echo"$og<td align='right'><label class='block'><span id='Rows-".h($D)."'></span>".checkbox("data[]",$D,$Ua)."</label>\n";$mg[$lg]++;}echo$Li;if($Mh)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}else{echo"<thead><tr><th style='text-align: left;'>","<label class='block'><input type='checkbox' id='check-databases'".($a==""?" checked":"").">".lang(26)."</label>",script("qs('#check-databases').onclick = partial(formCheck, /^databases\\[/);",""),"</thead>\n";$i=adminer()->databases();if($i){foreach($i
as$j){if(!information_schema($j)){$lg=preg_replace('~_.*~','',$j);echo"<tr><td>".checkbox("databases[]",$j,$a==""||$a=="$lg%",$j,"","block")."\n";$mg[$lg]++;}}}else
echo"<tr><td><textarea name='databases' rows='10' cols='20'></textarea>";}echo'</table>
</form>
';$Oc=true;foreach($mg
as$y=>$X){if($y!=""&&$X>1){echo($Oc?"<p>":" ")."<a href='".h(ME)."dump=".urlencode("$y%")."'>".h($y)."</a>";$Oc=false;}}}elseif(isset($_GET["privileges"])){page_header(lang(60));echo'<p class="links"><a href="'.h(ME).'user=">'.lang(147)."</a>";$K=connection()->query("SELECT User, Host FROM mysql.".(DB==""?"user":"db WHERE ".q(DB)." LIKE Db")." ORDER BY Host, User");$ed=$K;if(!$K)$K=connection()->query("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1) AS User, SUBSTRING_INDEX(CURRENT_USER, '@', -1) AS Host");echo"<form action=''><p>\n";hidden_fields_get();echo
input_hidden("db",DB),($ed?"":input_hidden("grant")),"<table class='odds'>\n","<thead><tr><th>".lang(24)."<th>".lang(23)."<th></thead>\n";while($M=$K->fetch_assoc())echo'<tr><td>'.h($M["User"])."<td>".h($M["Host"]).'<td><a href="'.h(ME.'user='.urlencode($M["User"]).'&host='.urlencode($M["Host"])).'">'.lang(10)."</a>\n";if(!$ed||DB!="")echo"<tr><td><input name='user' autocapitalize='off'><td><input name='host' value='localhost' autocapitalize='off'><td><input type='submit' value='".lang(10)."'>\n";echo"</table>\n","</form>\n";}elseif(isset($_GET["sql"])){if(!$l&&$_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers("sql");if($_POST["format"]=="sql")echo"$_POST[query]\n";else{adminer()->dumpTable("","");adminer()->dumpData("","table",$_POST["query"]);adminer()->dumpFooter();}exit;}restart_session();$td=&get_session("queries");$sd=&$td[DB];if(!$l&&$_POST["clear"]){$sd=array();redirect(remove_from_uri("history"));}stop_session();page_header((isset($_GET["import"])?lang(64):lang(53)),$l);$ve='--'.(JUSH=='sql'?' ':'');if(!$l&&$_POST){$q=false;if(!isset($_GET["import"]))$J=$_POST["query"];elseif($_POST["webfile"]){$rh=adminer()->importServerPath();$q=@fopen((file_exists($rh)?$rh:"compress.zlib://$rh.gz"),"rb");$J=($q?fread($q,1e6):false);}else$J=get_file("sql_file",true,";");if(is_string($J)){if(function_exists('memory_get_usage')&&($Me=ini_bytes("memory_limit"))!="-1")@ini_set("memory_limit",max($Me,strval(2*strlen($J)+memory_get_usage()+8e6)));if($J!=""&&strlen($J)<1e6){$I=$J.(preg_match("~;[ \t\r\n]*\$~",$J)?"":";");if(!$sd||first(end($sd))!=$I){restart_session();$sd[]=array($I,time());set_session("queries",$td);stop_session();}}$ph="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|$ve)[^\n]*\n?|--\r?\n)";$Nb=";";$kf=0;$kc=true;$g=connect();if($g&&DB!=""){$g->select_db(DB);if($_GET["ns"]!="")set_schema($_GET["ns"],$g);}$gb=0;$sc=array();$Pf='[\'"'.(JUSH=="sql"?'`#':(JUSH=="sqlite"?'`[':(JUSH=="mssql"?'[':''))).']|/\*|'.$ve.'|$'.(JUSH=="pgsql"?'|\$([a-zA-Z]\w*)?\$':'');$gi=microtime(true);$ja=get_settings("adminer_import");while($J!=""){if(!$kf&&preg_match("~^$ph*+DELIMITER\\s+(\\S+)~i",$J,$B)){$Nb=preg_quote($B[1]);$J=substr($J,strlen($B[0]));}elseif(!$kf&&JUSH=='pgsql'&&preg_match("~^($ph*+COPY\\s+)[^;]+\\s+FROM\\s+stdin;~i",$J,$B)){$Nb="\n\\\\\\.\r?\n";$kf=strlen($B[0]);}else{preg_match("($Nb\\s*|$Pf)",$J,$B,PREG_OFFSET_CAPTURE,$kf);list($Xc,$gg)=$B[0];if(!$Xc&&$q&&!feof($q))$J
.=fread($q,1e5);else{if(!$Xc&&rtrim($J)=="")break;$kf=$gg+strlen($Xc);if($Xc&&!preg_match("(^$Nb)",$Xc)){$Na=driver()->hasCStyleEscapes()||(JUSH=="pgsql"&&($gg>0&&strtolower($J[$gg-1])=="e"));$Zf=($Xc=='/*'?'\*/':($Xc=='['?']':(preg_match("~^$ve|^#~",$Xc)?"\n":preg_quote($Xc).($Na?'|\\\\.':''))));while(preg_match("($Zf|\$)s",$J,$B,PREG_OFFSET_CAPTURE,$kf)){$Rg=$B[0][0];if(!$Rg&&$q&&!feof($q))$J
.=fread($q,1e5);else{$kf=$B[0][1]+strlen($Rg);if(!$Rg||$Rg[0]!="\\")break;}}}else{$kc=false;$I=substr($J,0,$gg+($Nb[0]=="\n"?3:0));$gb++;$og="<pre id='sql-$gb'><code class='jush-".JUSH."'>".adminer()->sqlCommandQuery($I)."</code></pre>\n";if(JUSH=="sqlite"&&preg_match("~^$ph*+ATTACH\\b~i",$I,$B)){echo$og,"<p class='error'>".lang(148)."\n";$sc[]=" <a href='#sql-$gb'>$gb</a>";if($_POST["error_stops"])break;}else{if(!$_POST["only_errors"]){echo$og;ob_flush();flush();}$vh=microtime(true);if(connection()->multi_query($I)&&$g&&preg_match("~^$ph*+USE\\b~i",$I))$g->query($I);do{$K=connection()->store_result();if(connection()->error){echo($_POST["only_errors"]?$og:""),"<p class='error'>".lang(149).(connection()->errno?" (".connection()->errno.")":"").": ".error()."\n";$sc[]=" <a href='#sql-$gb'>$gb</a>";if($_POST["error_stops"])break
2;}else{$Vh=" <span class='time'>(".format_time($vh).")</span>".(strlen($I)<1000?" <a href='".h(ME)."sql=".urlencode(trim($I))."'>".lang(10)."</a>":"");$la=connection()->affected_rows;$Oi=($_POST["only_errors"]?"":driver()->warnings());$Pi="warnings-$gb";if($Oi)$Vh
.=", <a href='#$Pi'>".lang(35)."</a>".script("qsl('a').onclick = partial(toggle, '$Pi');","");$_c=null;$Cf=null;$Ac="explain-$gb";if(is_object($K)){$z=$_POST["limit"];$Cf=print_select_result($K,$g,array(),$z);if(!$_POST["only_errors"]){echo"<form action='' method='post'>\n";$if=$K->num_rows;echo"<p class='sql-footer'>".($if?($z&&$if>$z?lang(150,$z):"").lang(151,$if):""),$Vh;if($g&&preg_match("~^($ph|\\()*+SELECT\\b~i",$I)&&($_c=explain($g,$I)))echo", <a href='#$Ac'>Explain</a>".script("qsl('a').onclick = partial(toggle, '$Ac');","");$u="export-$gb";echo", <a href='#$u'>".lang(65)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."<span id='$u' class='hidden'>: ".html_select("output",adminer()->dumpOutput(),$ja["output"])." ".html_select("format",adminer()->dumpFormat(),$ja["format"]).input_hidden("query",$I)."<input type='submit' name='export' value='".lang(65)."'>".input_token()."</span>\n"."</form>\n";}}else{if(preg_match("~^$ph*+(CREATE|DROP|ALTER)$ph++(DATABASE|SCHEMA)\\b~i",$I)){restart_session();set_session("dbs",null);stop_session();}if(!$_POST["only_errors"])echo"<p class='message' title='".h(connection()->info)."'>".lang(152,$la)."$Vh\n";}echo($Oi?"<div id='$Pi' class='hidden'>\n$Oi</div>\n":"");if($_c){echo"<div id='$Ac' class='hidden explain'>\n";print_select_result($_c,$g,$Cf);echo"</div>\n";}}$vh=microtime(true);}while(connection()->next_result());}$J=substr($J,$kf);$kf=0;}}}}if($kc)echo"<p class='message'>".lang(153)."\n";elseif($_POST["only_errors"])echo"<p class='message'>".lang(154,$gb-count($sc))," <span class='time'>(".format_time($gi).")</span>\n";elseif($sc&&$gb>1)echo"<p class='error'>".lang(149).": ".implode("",$sc)."\n";}else
echo"<p class='error'>".upload_error($J)."\n";}echo'
<form action="" method="post" enctype="multipart/form-data" id="form">
';$yc="<input type='submit' value='".lang(155)."' title='Ctrl+Enter'>";if(!isset($_GET["import"])){$I=$_GET["sql"];if($_POST)$I=$_POST["query"];elseif($_GET["history"]=="all")$I=$sd;elseif($_GET["history"]!="")$I=idx($sd[$_GET["history"]],0);echo"<p>";textarea("query",$I,20);echo
script(($_POST?"":"qs('textarea').focus();\n")."qs('#form').onsubmit = partial(sqlSubmit, qs('#form'), '".js_escape(remove_from_uri("sql|limit|error_stops|only_errors|history"))."');"),"<p>";adminer()->sqlPrintAfter();echo"$yc\n",lang(156).": <input type='number' name='limit' class='size' value='".h($_POST?$_POST["limit"]:$_GET["limit"])."'>\n";}else{echo"<fieldset><legend>".lang(157)."</legend><div>";$jd=(extension_loaded("zlib")?"[.gz]":"");$De="max_file_uploads";$Ee=ini_get($De);echo(ini_bool("file_uploads")?"SQL$jd (&lt; ".ini_get("upload_max_filesize")."B): <input type='file' name='sql_file[]' multiple>\n".script("qsl('input').onchange = partialArg(fileChange, $Ee, '".lang(158,"$De = $Ee")."')").$yc:lang(159)),"</div></fieldset>\n";$Cd=adminer()->importServerPath();if($Cd)echo"<fieldset><legend>".lang(160)."</legend><div>",lang(161,"<code>".h($Cd)."$jd</code>"),' <input type="submit" name="webfile" value="'.lang(162).'">',"</div></fieldset>\n";echo"<p>";}echo
checkbox("error_stops",1,($_POST?$_POST["error_stops"]:isset($_GET["import"])||$_GET["error_stops"]),lang(163))."\n",checkbox("only_errors",1,($_POST?$_POST["only_errors"]:isset($_GET["import"])||$_GET["only_errors"]),lang(164))."\n",input_token();if(!isset($_GET["import"])&&$sd){print_fieldset("history",lang(165),$_GET["history"]!="");for($X=end($sd);$X;$X=prev($sd)){$y=key($sd);list($I,$Vh,$fc)=$X;echo'<a href="'.h(ME."sql=&history=$y").'">'.lang(10)."</a>"." <span class='time' title='".@date('Y-m-d',$Vh)."'>".@date("H:i:s",$Vh)."</span>"." <code class='jush-".JUSH."'>".shorten_utf8(ltrim(str_replace("\n"," ",str_replace("\r","",preg_replace("~^(#|$ve).*~m",'',$I)))),80,"</code>").($fc?" <span class='time'>($fc)</span>":"")."<br>\n";}echo"<input type='submit' name='clear' value='".lang(166)."'>\n","<a href='".h(ME."sql=&history=all")."'>".lang(167)."</a>\n","</div></fieldset>\n";}echo'</form>
';}elseif(isset($_GET["edit"])){$a=$_GET["edit"];$n=fields($a);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$n):""):where($_GET,$n));$yi=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($n
as$D=>$m){if(!isset($m["privileges"][$yi?"update":"insert"])||adminer()->fieldName($m)==""||$m["generated"])unset($n[$D]);}if($_POST&&!$l&&!isset($_GET["select"])){$A=$_POST["referer"];if($_POST["insert"])$A=($yi?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$A))$A=ME."select=".urlencode($a);$x=indexes($a);$ti=unique_array($_GET["where"],$x);$xg="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($A,lang(168),driver()->delete($a,$xg,$ti?0:1));else{$Q=array();foreach($n
as$D=>$m){$X=process_input($m);if($X!==false&&$X!==null)$Q[idf_escape($D)]=$X;}if($yi){if(!$Q)redirect($A);queries_redirect($A,lang(169),driver()->update($a,$Q,$xg,$ti?0:1));if(is_ajax()){page_headers();page_messages($l);exit;}}else{$K=driver()->insert($a,$Q);$ne=($K?last_id($K):0);queries_redirect($A,lang(170,($ne?" $ne":"")),$K);}}}$M=null;if($_POST["save"])$M=(array)$_POST["fields"];elseif($Z){$O=array();foreach($n
as$D=>$m){if(isset($m["privileges"]["select"])){$ua=($_POST["clone"]&&$m["auto_increment"]?"''":convert_field($m));$O[]=($ua?"$ua AS ":"").idf_escape($D);}}$M=array();if(!support("table"))$O=array("*");if($O){$K=driver()->select($a,$O,array($Z),$O,array(),(isset($_GET["select"])?2:1));if(!$K)$l=error();else{$M=$K->fetch_assoc();if(!$M)$M=false;}if(isset($_GET["select"])&&(!$M||$K->fetch_assoc()))$M=null;}}if(!support("table")&&!$n){if(!$Z){$K=driver()->select($a,array("*"),array(),array("*"));$M=($K?$K->fetch_assoc():false);if(!$M)$M=array(driver()->primary=>"");}if($M){foreach($M
as$y=>$X){if(!$Z)$M[$y]=null;$n[$y]=array("field"=>$y,"null"=>($y!=driver()->primary),"auto_increment"=>($y==driver()->primary));}}}edit_form($a,$n,$M,$yi,$l);}elseif(isset($_GET["create"])){$a=$_GET["create"];$Tf=driver()->partitionBy;$Wf=($Tf?driver()->partitionsInfo($a):array());$Cg=referencable_primary($a);$Vc=array();foreach($Cg
as$Hh=>$m)$Vc[str_replace("`","``",$Hh)."`".str_replace("`","``",$m["field"])]=$Hh;$Ff=array();$S=array();if($a!=""){$Ff=fields($a);$S=table_status1($a);if(count($S)<2)$l=lang(9);}$M=$_POST;$M["fields"]=(array)$M["fields"];if($M["auto_increment_col"])$M["fields"][$M["auto_increment_col"]]["auto_increment"]=true;if($_POST)save_settings(array("comments"=>$_POST["comments"],"defaults"=>$_POST["defaults"]));if($_POST&&!process_fields($M["fields"])&&!$l){if($_POST["drop"])queries_redirect(substr(ME,0,-1),lang(171),drop_tables(array($a)));else{$n=array();$pa=array();$Bi=false;$Tc=array();$Ef=reset($Ff);$na=" FIRST";foreach($M["fields"]as$y=>$m){$p=$Vc[$m["type"]];$oi=($p!==null?$Cg[$p]:$m);if($m["field"]!=""){if(!$m["generated"])$m["default"]=null;$tg=process_field($m,$oi);$pa[]=array($m["orig"],$tg,$na);if(!$Ef||$tg!==process_field($Ef,$Ef)){$n[]=array($m["orig"],$tg,$na);if($m["orig"]!=""||$na)$Bi=true;}if($p!==null)$Tc[idf_escape($m["field"])]=($a!=""&&JUSH!="sqlite"?"ADD":" ").format_foreign_key(array('table'=>$Vc[$m["type"]],'source'=>array($m["field"]),'target'=>array($oi["field"]),'on_delete'=>$m["on_delete"],));$na=" AFTER ".idf_escape($m["field"]);}elseif($m["orig"]!=""){$Bi=true;$n[]=array($m["orig"]);}if($m["orig"]!=""){$Ef=next($Ff);if(!$Ef)$na="";}}$G=array();if(in_array($M["partition_by"],$Tf)){foreach($M
as$y=>$X){if(preg_match('~^partition~',$y))$G[$y]=$X;}foreach($G["partition_names"]as$y=>$D){if($D==""){unset($G["partition_names"][$y]);unset($G["partition_values"][$y]);}}$G["partition_names"]=array_values($G["partition_names"]);$G["partition_values"]=array_values($G["partition_values"]);if($G==$Wf)$G=array();}elseif(preg_match("~partitioned~",$S["Create_options"]))$G=null;$C=lang(172);if($a==""){cookie("adminer_engine",$M["Engine"]);$C=lang(173);}$D=trim($M["name"]);queries_redirect(ME.(support("table")?"table=":"select=").urlencode($D),$C,alter_table($a,$D,(JUSH=="sqlite"&&($Bi||$Tc)?$pa:$n),$Tc,($M["Comment"]!=$S["Comment"]?$M["Comment"]:null),($M["Engine"]&&$M["Engine"]!=$S["Engine"]?$M["Engine"]:""),($M["Collation"]&&$M["Collation"]!=$S["Collation"]?$M["Collation"]:""),($M["Auto_increment"]!=""?number($M["Auto_increment"]):""),$G));}}page_header(($a!=""?lang(32):lang(66)),$l,array("table"=>$a),h($a));if(!$_POST){$qi=driver()->types();$M=array("Engine"=>$_COOKIE["adminer_engine"],"fields"=>array(array("field"=>"","type"=>(isset($qi["int"])?"int":(isset($qi["integer"])?"integer":"")),"on_update"=>"")),"partition_names"=>array(""),);if($a!=""){$M=$S;$M["name"]=$a;$M["fields"]=array();if(!$_GET["auto_increment"])$M["Auto_increment"]="";foreach($Ff
as$m){$m["generated"]=$m["generated"]?:(isset($m["default"])?"DEFAULT":"");$M["fields"][]=$m;}if($Tf){$M+=$Wf;$M["partition_names"][]="";$M["partition_values"][]="";}}}$b=collations();if(is_array(reset($b)))$b=call_user_func_array('array_merge',array_values($b));$mc=driver()->engines();foreach($mc
as$lc){if(!strcasecmp($lc,$M["Engine"])){$M["Engine"]=$lc;break;}}echo'
<form action="" method="post" id="form">
<p>
';if(support("columns")||$a==""){echo
lang(174).": <input name='name'".($a==""&&!$_POST?" autofocus":"")." data-maxlength='64' value='".h($M["name"])."' autocapitalize='off'>\n",($mc?html_select("Engine",array(""=>"(".lang(175).")")+$mc,$M["Engine"]).on_help("event.target.value",1).script("qsl('select').onchange = helpClose;")."\n":"");if($b)echo"<datalist id='collations'>".optionlist($b)."</datalist>\n",(preg_match("~sqlite|mssql~",JUSH)?"":"<input list='collations' name='Collation' value='".h($M["Collation"])."' placeholder='(".lang(99).")'>\n");echo"<input type='submit' value='".lang(14)."'>\n";}if(support("columns")){echo"<div class='scrollable'>\n","<table id='edit-fields' class='nowrap'>\n";edit_fields($M["fields"],$b,"TABLE",$Vc);echo"</table>\n",script("editFields();"),"</div>\n<p>\n",lang(40).": <input type='number' name='Auto_increment' class='size' value='".h($M["Auto_increment"])."'>\n",checkbox("defaults",1,($_POST?$_POST["defaults"]:get_setting("defaults")),lang(176),"columnShow(this.checked, 5)","jsonly");$jb=($_POST?$_POST["comments"]:get_setting("comments"));echo(support("comment")?checkbox("comments",1,$jb,lang(39),"editingCommentsClick(this, true);","jsonly").' '.(preg_match('~\n~',$M["Comment"])?"<textarea name='Comment' rows='2' cols='20'".($jb?"":" class='hidden'").">".h($M["Comment"])."</textarea>":'<input name="Comment" value="'.h($M["Comment"]).'" data-maxlength="'.(min_version(5.5)?2048:60).'"'.($jb?"":" class='hidden'").'>'):''),'<p>
<input type="submit" value="',lang(14),'">
';}echo'
';if($a!="")echo'<input type="submit" name="drop" value="',lang(125),'">',confirm(lang(177,$a));if($Tf&&(JUSH=='sql'||$a=="")){$Uf=preg_match('~RANGE|LIST~',$M["partition_by"]);print_fieldset("partition",lang(178),$M["partition_by"]);echo"<p>".html_select("partition_by",array_merge(array(""),$Tf),$M["partition_by"]).on_help("event.target.value.replace(/./, 'PARTITION BY \$&')",1).script("qsl('select').onchange = partitionByChange;"),"(<input name='partition' value='".h($M["partition"])."'>)\n",lang(179).": <input type='number' name='partitions' class='size".($Uf||!$M["partition_by"]?" hidden":"")."' value='".h($M["partitions"])."'>\n","<table id='partition-table'".($Uf?"":" class='hidden'").">\n","<thead><tr><th>".lang(180)."<th>".lang(181)."</thead>\n";foreach($M["partition_names"]as$y=>$X)echo'<tr>','<td><input name="partition_names[]" value="'.h($X).'" autocapitalize="off">',($y==count($M["partition_names"])-1?script("qsl('input').oninput = partitionNameChange;"):''),'<td><input name="partition_values[]" value="'.h(idx($M["partition_values"],$y)).'">';echo"</table>\n</div></fieldset>\n";}echo
input_token(),'</form>
';}elseif(isset($_GET["indexes"])){$a=$_GET["indexes"];$Jd=array("PRIMARY","UNIQUE","INDEX");$S=table_status1($a,true);$Hd=driver()->indexAlgorithms($S);if(preg_match('~MyISAM|M?aria'.(min_version(5.6,'10.0.5')?'|InnoDB':'').'~i',$S["Engine"]))$Jd[]="FULLTEXT";if(preg_match('~MyISAM|M?aria'.(min_version(5.7,'10.2.2')?'|InnoDB':'').'~i',$S["Engine"]))$Jd[]="SPATIAL";$x=indexes($a);$n=fields($a);$ng=array();if(JUSH=="mongo"){$ng=$x["_id_"];unset($Jd[0]);unset($x["_id_"]);}$M=$_POST;if($M)save_settings(array("index_options"=>$M["options"]));if($_POST&&!$l&&!$_POST["add"]&&!$_POST["drop_col"]){$qa=array();foreach($M["indexes"]as$w){$D=$w["name"];if(in_array($w["type"],$Jd)){$d=array();$te=array();$Qb=array();$Id=(support("partial_indexes")?$w["partial"]:"");$Gd=(in_array($w["algorithm"],$Hd)?$w["algorithm"]:"");$Q=array();ksort($w["columns"]);foreach($w["columns"]as$y=>$c){if($c!=""){$se=idx($w["lengths"],$y);$Ob=idx($w["descs"],$y);$Q[]=($n[$c]?idf_escape($c):$c).($se?"(".(+$se).")":"").($Ob?" DESC":"");$d[]=$c;$te[]=($se?:null);$Qb[]=$Ob;}}$zc=$x[$D];if($zc){ksort($zc["columns"]);ksort($zc["lengths"]);ksort($zc["descs"]);if($w["type"]==$zc["type"]&&array_values($zc["columns"])===$d&&(!$zc["lengths"]||array_values($zc["lengths"])===$te)&&array_values($zc["descs"])===$Qb&&$zc["partial"]==$Id&&(!$Hd||$zc["algorithm"]==$Gd)){unset($x[$D]);continue;}}if($d)$qa[]=array($w["type"],$D,$Q,$Gd,$Id);}}foreach($x
as$D=>$zc)$qa[]=array($zc["type"],$D,"DROP");if(!$qa)redirect(ME."table=".urlencode($a));queries_redirect(ME."table=".urlencode($a),lang(182),alter_indexes($a,$qa));}page_header(lang(132),$l,array("table"=>$a),h($a));$Lc=array_keys($n);if($_POST["add"]){foreach($M["indexes"]as$y=>$w){if($w["columns"][count($w["columns"])]!="")$M["indexes"][$y]["columns"][]="";}$w=end($M["indexes"]);if($w["type"]||array_filter($w["columns"],'strlen'))$M["indexes"][]=array("columns"=>array(1=>""));}if(!$M){foreach($x
as$y=>$w){$x[$y]["name"]=$y;$x[$y]["columns"][]="";}$x[]=array("columns"=>array(1=>""));$M["indexes"]=$x;}$te=(JUSH=="sql"||JUSH=="mssql");$jh=($_POST?$_POST["options"]:get_setting("index_options"));echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap">
<thead><tr>
<th id="label-type">',lang(183);$Ad=" class='idxopts".($jh?"":" hidden")."'";if($Hd)echo"<th id='label-algorithm'$Ad>".lang(184).doc_link(array('sql'=>'create-index.html#create-index-storage-engine-index-types','mariadb'=>'storage-engine-index-types/',));echo'<th><input type="submit" class="wayoff">',lang(185).($te?"<span$Ad> (".lang(186).")</span>":"");if($te||support("descidx"))echo
checkbox("options",1,$jh,lang(105),"indexOptionsShow(this.checked)","jsonly")."\n";echo'<th id="label-name">',lang(187);if(support("partial_indexes"))echo"<th id='label-condition'$Ad>".lang(188);echo'<th><noscript>',icon("plus","add[0]","+",lang(106)),'</noscript>
</thead>
';if($ng){echo"<tr><td>PRIMARY<td>";foreach($ng["columns"]as$y=>$c)echo
select_input(" disabled",$Lc,$c),"<label><input disabled type='checkbox'>".lang(48)."</label> ";echo"<td><td>\n";}$ce=1;foreach($M["indexes"]as$w){if(!$_POST["drop_col"]||$ce!=key($_POST["drop_col"])){echo"<tr><td>".html_select("indexes[$ce][type]",array(-1=>"")+$Jd,$w["type"],($ce==count($M["indexes"])?"indexesAddRow.call(this);":""),"label-type");if($Hd)echo"<td$Ad>".html_select("indexes[$ce][algorithm]",array_merge(array(""),$Hd),$w['algorithm'],"label-algorithm");echo"<td>";ksort($w["columns"]);$t=1;foreach($w["columns"]as$y=>$c){echo"<span>".select_input(" name='indexes[$ce][columns][$t]' title='".lang(37)."'",($n&&($c==""||$n[$c])?array_combine($Lc,$Lc):array()),$c,"partial(".($t==count($w["columns"])?"indexesAddColumn":"indexesChangeColumn").", '".js_escape(JUSH=="sql"?"":$_GET["indexes"]."_")."')"),"<span$Ad>",($te?"<input type='number' name='indexes[$ce][lengths][$t]' class='size' value='".h(idx($w["lengths"],$y))."' title='".lang(104)."'>":""),(support("descidx")?checkbox("indexes[$ce][descs][$t]",1,idx($w["descs"],$y),lang(48)):""),"</span> </span>";$t++;}echo"<td><input name='indexes[$ce][name]' value='".h($w["name"])."' autocapitalize='off' aria-labelledby='label-name'>\n";if(support("partial_indexes"))echo"<td$Ad><input name='indexes[$ce][partial]' value='".h($w["partial"])."' autocapitalize='off' aria-labelledby='label-condition'>\n";echo"<td>".icon("cross","drop_col[$ce]","x",lang(109)).script("qsl('button').onclick = partial(editingRemoveRow, 'indexes\$1[type]');");}$ce++;}echo'</table>
</div>
<p>
<input type="submit" value="',lang(14),'">
',input_token(),'</form>
';}elseif(isset($_GET["database"])){$M=$_POST;if($_POST&&!$l&&!$_POST["add"]){$D=trim($M["name"]);if($_POST["drop"]){$_GET["db"]="";queries_redirect(remove_from_uri("db|database"),lang(189),drop_databases(array(DB)));}elseif(DB!==$D){if(DB!=""){$_GET["db"]=$D;queries_redirect(preg_replace('~\bdb=[^&]*&~','',ME)."db=".urlencode($D),lang(190),rename_database($D,$M["collation"]));}else{$i=explode("\n",str_replace("\r","",$D));$Bh=true;$me="";foreach($i
as$j){if(count($i)==1||$j!=""){if(!create_database($j,$M["collation"]))$Bh=false;$me=$j;}}restart_session();set_session("dbs",null);queries_redirect(ME."db=".urlencode($me),lang(191),$Bh);}}else{if(!$M["collation"])redirect(substr(ME,0,-1));query_redirect("ALTER DATABASE ".idf_escape($D).(preg_match('~^[a-z0-9_]+$~i',$M["collation"])?" COLLATE $M[collation]":""),substr(ME,0,-1),lang(192));}}page_header(DB!=""?lang(56):lang(113),$l,array(),h(DB));$b=collations();$D=DB;if($_POST)$D=$M["name"];elseif(DB!="")$M["collation"]=db_collation(DB,$b);elseif(JUSH=="sql"){foreach(get_vals("SHOW GRANTS")as$ed){if(preg_match('~ ON (`(([^\\\\`]|``|\\\\.)*)%`\.\*)?~',$ed,$B)&&$B[1]){$D=stripcslashes(idf_unescape("`$B[2]`"));break;}}}echo'
<form action="" method="post">
<p>
',($_POST["add"]||strpos($D,"\n")?'<textarea autofocus name="name" rows="10" cols="40">'.h($D).'</textarea><br>':'<input name="name" autofocus value="'.h($D).'" data-maxlength="64" autocapitalize="off">')."\n".($b?html_select("collation",array(""=>"(".lang(99).")")+$b,$M["collation"]).doc_link(array('sql'=>"charset-charsets.html",'mariadb'=>"supported-character-sets-and-collations/",)):""),'<input type="submit" value="',lang(14),'">
';if(DB!="")echo"<input type='submit' name='drop' value='".lang(125)."'>".confirm(lang(177,DB))."\n";elseif(!$_POST["add"]&&$_GET["db"]=="")echo
icon("plus","add[0]","+",lang(106))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["call"])){$ca=($_GET["name"]?:$_GET["call"]);page_header(lang(193).": ".h($ca),$l);$Og=routine($_GET["call"],(isset($_GET["callf"])?"FUNCTION":"PROCEDURE"));$Dd=array();$Jf=array();foreach($Og["fields"]as$t=>$m){if(substr($m["inout"],-3)=="OUT"&&JUSH=='sql')$Jf[$t]="@".idf_escape($m["field"])." AS ".idf_escape($m["field"]);if(!$m["inout"]||substr($m["inout"],0,2)=="IN")$Dd[]=$t;}if(!$l&&$_POST){$Oa=array();foreach($Og["fields"]as$y=>$m){$X="";if(in_array($y,$Dd)){$X=process_input($m);if($X===false)$X="''";if(isset($Jf[$y]))connection()->query("SET @".idf_escape($m["field"])." = $X");}if(isset($Jf[$y]))$Oa[]="@".idf_escape($m["field"]);elseif(in_array($y,$Dd))$Oa[]=$X;}$J=(isset($_GET["callf"])?"SELECT ":"CALL ").($Og["returns"]["type"]=="record"?"* FROM ":"").table($ca)."(".implode(", ",$Oa).")";$vh=microtime(true);$K=connection()->multi_query($J);$la=connection()->affected_rows;echo
adminer()->selectQuery($J,$vh,!$K);if(!$K)echo"<p class='error'>".error()."\n";else{$g=connect();if($g)$g->select_db(DB);do{$K=connection()->store_result();if(is_object($K))print_select_result($K,$g);else
echo"<p class='message'>".lang(194,$la)." <span class='time'>".@date("H:i:s")."</span>\n";}while(connection()->next_result());if($Jf)print_select_result(connection()->query("SELECT ".implode(", ",$Jf)));}}echo'
<form action="" method="post">
';if($Dd){echo"<table class='layout'>\n";foreach($Dd
as$y){$m=$Og["fields"][$y];$D=$m["field"];echo"<tr><th>".adminer()->fieldName($m);$Y=idx($_POST["fields"],$D);if($Y!=""){if($m["type"]=="set")$Y=implode(",",$Y);}input($m,$Y,idx($_POST["function"],$D,""));echo"\n";}echo"</table>\n";}echo'<p>
<input type="submit" value="',lang(193),'">
',input_token(),'</form>

<pre>
';function
pre_tr($Rg){return
preg_replace('~^~m','<tr>',preg_replace('~\|~','<td>',preg_replace('~\|$~m',"",rtrim($Rg))));}$R='(\+--[-+]+\+\n)';$M='(\| .* \|\n)';echo
preg_replace_callback("~^$R?$M$R?($M*)$R?~m",function($B){$Pc=pre_tr($B[2]);return"<table>\n".($B[1]?"<thead>$Pc</thead>\n":$Pc).pre_tr($B[4])."\n</table>";},preg_replace('~(\n(    -|mysql)&gt; )(.+)~',"\\1<code class='jush-sql'>\\3</code>",preg_replace('~(.+)\n---+\n~',"<b>\\1</b>\n",h($Og['comment']))));echo'</pre>
';}elseif(isset($_GET["foreign"])){$a=$_GET["foreign"];$D=$_GET["name"];$M=$_POST;if($_POST&&!$l&&!$_POST["add"]&&!$_POST["change"]&&!$_POST["change-js"]){if(!$_POST["drop"]){$M["source"]=array_filter($M["source"],'strlen');ksort($M["source"]);$Ph=array();foreach($M["source"]as$y=>$X)$Ph[$y]=$M["target"][$y];$M["target"]=$Ph;}if(JUSH=="sqlite")$K=recreate_table($a,$a,array(),array(),array(" $D"=>($M["drop"]?"":" ".format_foreign_key($M))));else{$qa="ALTER TABLE ".table($a);$K=($D==""||queries("$qa DROP ".(JUSH=="sql"?"FOREIGN KEY ":"CONSTRAINT ").idf_escape($D)));if(!$M["drop"])$K=queries("$qa ADD".format_foreign_key($M));}queries_redirect(ME."table=".urlencode($a),($M["drop"]?lang(195):($D!=""?lang(196):lang(197))),$K);if(!$M["drop"])$l=lang(198);}page_header(lang(199),$l,array("table"=>$a),h($a));if($_POST){ksort($M["source"]);if($_POST["add"])$M["source"][]="";elseif($_POST["change"]||$_POST["change-js"])$M["target"]=array();}elseif($D!=""){$Vc=foreign_keys($a);$M=$Vc[$D];$M["source"][]="";}else{$M["table"]=$a;$M["source"]=array("");}echo'
<form action="" method="post">
';$oh=array_keys(fields($a));if($M["db"]!="")connection()->select_db($M["db"]);if($M["ns"]!=""){$Gf=get_schema();set_schema($M["ns"]);}$Bg=array_keys(array_filter(table_status('',true),'Adminer\fk_support'));$Ph=array_keys(fields(in_array($M["table"],$Bg)?$M["table"]:reset($Bg)));$sf="this.form['change-js'].value = '1'; this.form.submit();";echo"<p><label>".lang(200).": ".html_select("table",$Bg,$M["table"],$sf)."</label>\n";if(JUSH!="sqlite"){$Gb=array();foreach(adminer()->databases()as$j){if(!information_schema($j))$Gb[]=$j;}echo"<label>".lang(67).": ".html_select("db",$Gb,$M["db"]!=""?$M["db"]:$_GET["db"],$sf)."</label>";}echo
input_hidden("change-js"),'<noscript><p><input type="submit" name="change" value="',lang(201),'"></noscript>
<table>
<thead><tr><th id="label-source">',lang(134),'<th id="label-target">',lang(135),'</thead>
';$ce=0;foreach($M["source"]as$y=>$X){echo"<tr>","<td>".html_select("source[".(+$y)."]",array(-1=>"")+$oh,$X,($ce==count($M["source"])-1?"foreignAddRow.call(this);":""),"label-source"),"<td>".html_select("target[".(+$y)."]",$Ph,idx($M["target"],$y),"","label-target");$ce++;}echo'</table>
<p>
<label>',lang(101),': ',html_select("on_delete",array(-1=>"")+explode("|",driver()->onActions),$M["on_delete"]),'</label>
<label>',lang(100),': ',html_select("on_update",array(-1=>"")+explode("|",driver()->onActions),$M["on_update"]),'</label>
',doc_link(array('sql'=>"innodb-foreign-key-constraints.html",'mariadb'=>"foreign-keys/",)),'<p>
<input type="submit" value="',lang(14),'">
<noscript><p><input type="submit" name="add" value="',lang(202),'"></noscript>
';if($D!="")echo'<input type="submit" name="drop" value="',lang(125),'">',confirm(lang(177,$D));echo
input_token(),'</form>
';}elseif(isset($_GET["view"])){$a=$_GET["view"];$M=$_POST;$Hf="VIEW";if(JUSH=="pgsql"&&$a!=""){$wh=table_status1($a);$Hf=strtoupper($wh["Engine"]);}if($_POST&&!$l){$D=trim($M["name"]);$ua=" AS\n$M[select]";$A=ME."table=".urlencode($D);$C=lang(203);$U=($_POST["materialized"]?"MATERIALIZED VIEW":"VIEW");if(!$_POST["drop"]&&$a==$D&&JUSH!="sqlite"&&$U=="VIEW"&&$Hf=="VIEW")query_redirect((JUSH=="mssql"?"ALTER":"CREATE OR REPLACE")." VIEW ".table($D).$ua,$A,$C);else{$Rh=$D."_adminer_".uniqid();drop_create("DROP $Hf ".table($a),"CREATE $U ".table($D).$ua,"DROP $U ".table($D),"CREATE $U ".table($Rh).$ua,"DROP $U ".table($Rh),($_POST["drop"]?substr(ME,0,-1):$A),lang(204),$C,lang(205),$a,$D);}}if(!$_POST&&$a!=""){$M=view($a);$M["name"]=$a;$M["materialized"]=($Hf!="VIEW");if(!$l)$l=error();}page_header(($a!=""?lang(33):lang(206)),$l,array("table"=>$a),h($a));echo'
<form action="" method="post">
<p>',lang(187),': <input name="name" value="',h($M["name"]),'" data-maxlength="64" autocapitalize="off">
',(support("materializedview")?" ".checkbox("materialized",1,$M["materialized"],lang(128)):""),'<p>';textarea("select",$M["select"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($a!="")echo'<input type="submit" name="drop" value="',lang(125),'">',confirm(lang(177,$a));echo
input_token(),'</form>
';}elseif(isset($_GET["event"])){$aa=$_GET["event"];$Td=array("YEAR","QUARTER","MONTH","DAY","HOUR","MINUTE","WEEK","SECOND","YEAR_MONTH","DAY_HOUR","DAY_MINUTE","DAY_SECOND","HOUR_MINUTE","HOUR_SECOND","MINUTE_SECOND");$xh=array("ENABLED"=>"ENABLE","DISABLED"=>"DISABLE","SLAVESIDE_DISABLED"=>"DISABLE ON SLAVE");$M=$_POST;if($_POST&&!$l){if($_POST["drop"])query_redirect("DROP EVENT ".idf_escape($aa),substr(ME,0,-1),lang(207));elseif(in_array($M["INTERVAL_FIELD"],$Td)&&isset($xh[$M["STATUS"]])){$Sg="\nON SCHEDULE ".($M["INTERVAL_VALUE"]?"EVERY ".q($M["INTERVAL_VALUE"])." $M[INTERVAL_FIELD]".($M["STARTS"]?" STARTS ".q($M["STARTS"]):"").($M["ENDS"]?" ENDS ".q($M["ENDS"]):""):"AT ".q($M["STARTS"]))." ON COMPLETION".($M["ON_COMPLETION"]?"":" NOT")." PRESERVE";queries_redirect(substr(ME,0,-1),($aa!=""?lang(208):lang(209)),queries(($aa!=""?"ALTER EVENT ".idf_escape($aa).$Sg.($aa!=$M["EVENT_NAME"]?"\nRENAME TO ".idf_escape($M["EVENT_NAME"]):""):"CREATE EVENT ".idf_escape($M["EVENT_NAME"]).$Sg)."\n".$xh[$M["STATUS"]]." COMMENT ".q($M["EVENT_COMMENT"]).rtrim(" DO\n$M[EVENT_DEFINITION]",";").";"));}}page_header(($aa!=""?lang(210).": ".h($aa):lang(211)),$l);if(!$M&&$aa!=""){$N=get_rows("SELECT * FROM information_schema.EVENTS WHERE EVENT_SCHEMA = ".q(DB)." AND EVENT_NAME = ".q($aa));$M=reset($N);}echo'
<form action="" method="post">
<table class="layout">
<tr><th>',lang(187),'<td><input name="EVENT_NAME" value="',h($M["EVENT_NAME"]),'" data-maxlength="64" autocapitalize="off">
<tr><th title="datetime">',lang(212),'<td><input name="STARTS" value="',h("$M[EXECUTE_AT]$M[STARTS]"),'">
<tr><th title="datetime">',lang(213),'<td><input name="ENDS" value="',h($M["ENDS"]),'">
<tr><th>',lang(214),'<td><input type="number" name="INTERVAL_VALUE" value="',h($M["INTERVAL_VALUE"]),'" class="size"> ',html_select("INTERVAL_FIELD",$Td,$M["INTERVAL_FIELD"]),'<tr><th>',lang(116),'<td>',html_select("STATUS",$xh,$M["STATUS"]),'<tr><th>',lang(39),'<td><input name="EVENT_COMMENT" value="',h($M["EVENT_COMMENT"]),'" data-maxlength="64">
<tr><th><td>',checkbox("ON_COMPLETION","PRESERVE",$M["ON_COMPLETION"]=="PRESERVE",lang(215)),'</table>
<p>';textarea("EVENT_DEFINITION",$M["EVENT_DEFINITION"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($aa!="")echo'<input type="submit" name="drop" value="',lang(125),'">',confirm(lang(177,$aa));echo
input_token(),'</form>
';}elseif(isset($_GET["procedure"])){$ca=($_GET["name"]?:$_GET["procedure"]);$Og=(isset($_GET["function"])?"FUNCTION":"PROCEDURE");$M=$_POST;$M["fields"]=(array)$M["fields"];if($_POST&&!process_fields($M["fields"])&&!$l){$Df=routine($_GET["procedure"],$Og);$Rh="$M[name]_adminer_".uniqid();foreach($M["fields"]as$y=>$m){if($m["field"]=="")unset($M["fields"][$y]);}drop_create("DROP $Og ".routine_id($ca,$Df),create_routine($Og,$M),"DROP $Og ".routine_id($M["name"],$M),create_routine($Og,array("name"=>$Rh)+$M),"DROP $Og ".routine_id($Rh,$M),substr(ME,0,-1),lang(216),lang(217),lang(218),$ca,$M["name"]);}page_header(($ca!=""?(isset($_GET["function"])?lang(219):lang(220)).": ".h($ca):(isset($_GET["function"])?lang(221):lang(222))),$l);if(!$_POST){if($ca=="")$M["language"]="sql";else{$M=routine($_GET["procedure"],$Og);$M["name"]=$ca;}}$b=get_vals("SHOW CHARACTER SET");sort($b);$Pg=routine_languages();echo($b?"<datalist id='collations'>".optionlist($b)."</datalist>":""),'
<form action="" method="post" id="form">
<p>',lang(187),': <input name="name" value="',h($M["name"]),'" data-maxlength="64" autocapitalize="off">
',($Pg?"<label>".lang(19).": ".html_select("language",$Pg,$M["language"])."</label>\n":""),'<input type="submit" value="',lang(14),'">
<div class="scrollable">
<table class="nowrap">
';edit_fields($M["fields"],$b,$Og);if(isset($_GET["function"])){echo"<tr><td>".lang(223);edit_type("returns",(array)$M["returns"],$b,array(),(JUSH=="pgsql"?array("void","trigger"):array()));}echo'</table>
',script("editFields();"),'</div>
<p>';textarea("definition",$M["definition"],20);echo'<p>
<input type="submit" value="',lang(14),'">
';if($ca!="")echo'<input type="submit" name="drop" value="',lang(125),'">',confirm(lang(177,$ca));echo
input_token(),'</form>
';}elseif(isset($_GET["check"])){$a=$_GET["check"];$D=$_GET["name"];$M=$_POST;if($M&&!$l){if(JUSH=="sqlite")$K=recreate_table($a,$a,array(),array(),array(),"",array(),"$D",($M["drop"]?"":$M["clause"]));else{$K=($D==""||queries("ALTER TABLE ".table($a)." DROP CONSTRAINT ".idf_escape($D)));if(!$M["drop"])$K=queries("ALTER TABLE ".table($a)." ADD".($M["name"]!=""?" CONSTRAINT ".idf_escape($M["name"]):"")." CHECK ($M[clause])");}queries_redirect(ME."table=".urlencode($a),($M["drop"]?lang(224):($D!=""?lang(225):lang(226))),$K);}page_header(($D!=""?lang(227).": ".h($D):lang(139)),$l,array("table"=>$a));if(!$M){$Va=driver()->checkConstraints($a);$M=array("name"=>$D,"clause"=>$Va[$D]);}echo'
<form action="" method="post">
<p>';if(JUSH!="sqlite")echo
lang(187).': <input name="name" value="'.h($M["name"]).'" data-maxlength="64" autocapitalize="off"> ';echo
doc_link(array('sql'=>"create-table-check-constraints.html",'mariadb'=>"constraint/",),"?"),'<p>';textarea("clause",$M["clause"]);echo'<p><input type="submit" value="',lang(14),'">
';if($D!="")echo'<input type="submit" name="drop" value="',lang(125),'">',confirm(lang(177,$D));echo
input_token(),'</form>
';}elseif(isset($_GET["trigger"])){$a=$_GET["trigger"];$D="$_GET[name]";$mi=trigger_options();$M=(array)trigger($D,$a)+array("Trigger"=>$a."_bi");if($_POST){if(!$l&&in_array($_POST["Timing"],$mi["Timing"])&&in_array($_POST["Event"],$mi["Event"])&&in_array($_POST["Type"],$mi["Type"])){$qf=" ON ".table($a);$Yb="DROP TRIGGER ".idf_escape($D).(JUSH=="pgsql"?$qf:"");$A=ME."table=".urlencode($a);if($_POST["drop"])query_redirect($Yb,$A,lang(228));else{if($D!="")queries($Yb);queries_redirect($A,($D!=""?lang(229):lang(230)),queries(create_trigger($qf,$_POST)));if($D!="")queries(create_trigger($qf,$M+array("Type"=>reset($mi["Type"]))));}}$M=$_POST;}page_header(($D!=""?lang(231).": ".h($D):lang(232)),$l,array("table"=>$a));echo'
<form action="" method="post" id="form">
<table class="layout">
<tr><th>',lang(233),'<td>',html_select("Timing",$mi["Timing"],$M["Timing"],"triggerChange(/^".preg_quote($a,"/")."_[ba][iud]$/, '".js_escape($a)."', this.form);"),'<tr><th>',lang(234),'<td>',html_select("Event",$mi["Event"],$M["Event"],"this.form['Timing'].onchange();"),(in_array("UPDATE OF",$mi["Event"])?" <input name='Of' value='".h($M["Of"])."' class='hidden'>":""),'<tr><th>',lang(38),'<td>',html_select("Type",$mi["Type"],$M["Type"]),'</table>
<p>',lang(187),': <input name="Trigger" value="',h($M["Trigger"]),'" data-maxlength="64" autocapitalize="off">
',script("qs('#form')['Timing'].onchange();"),'<p>';textarea("Statement",$M["Statement"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($D!="")echo'<input type="submit" name="drop" value="',lang(125),'">',confirm(lang(177,$D));echo
input_token(),'</form>
';}elseif(isset($_GET["user"])){$ea=$_GET["user"];$rg=array(""=>array("All privileges"=>""));foreach(get_rows("SHOW PRIVILEGES")as$M){foreach(explode(",",($M["Privilege"]=="Grant option"?"":$M["Context"]))as$qb)$rg[$qb][$M["Privilege"]]=$M["Comment"];}$rg["Server Admin"]+=$rg["File access on server"];$rg["Databases"]["Create routine"]=$rg["Procedures"]["Create routine"];unset($rg["Procedures"]["Create routine"]);$rg["Columns"]=array();foreach(array("Select","Insert","Update","References")as$X)$rg["Columns"][$X]=$rg["Tables"][$X];unset($rg["Server Admin"]["Usage"]);foreach($rg["Tables"]as$y=>$X)unset($rg["Databases"][$y]);$bf=array();if($_POST){foreach($_POST["objects"]as$y=>$X)$bf[$X]=(array)$bf[$X]+idx($_POST["grants"],$y,array());}$fd=array();$of="";if(isset($_GET["host"])&&($K=connection()->query("SHOW GRANTS FOR ".q($ea)."@".q($_GET["host"])))){while($M=$K->fetch_row()){if(preg_match('~GRANT (.*) ON (.*) TO ~',$M[0],$B)&&preg_match_all('~ *([^(,]*[^ ,(])( *\([^)]+\))?~',$B[1],$Be,PREG_SET_ORDER)){foreach($Be
as$X){if($X[1]!="USAGE")$fd["$B[2]$X[2]"][$X[1]]=true;if(preg_match('~ WITH GRANT OPTION~',$M[0]))$fd["$B[2]$X[2]"]["GRANT OPTION"]=true;}}if(preg_match("~ IDENTIFIED BY PASSWORD '([^']+)~",$M[0],$B))$of=$B[1];}}if($_POST&&!$l){$pf=(isset($_GET["host"])?q($ea)."@".q($_GET["host"]):"''");if($_POST["drop"])query_redirect("DROP USER $pf",ME."privileges=",lang(235));else{$df=q($_POST["user"])."@".q($_POST["host"]);$Xf=$_POST["pass"];if($Xf!=''&&!$_POST["hashed"]&&!min_version(8)){$Xf=get_val("SELECT PASSWORD(".q($Xf).")");$l=!$Xf;}$vb=false;if(!$l){if($pf!=$df){$vb=queries((min_version(5)?"CREATE USER":"GRANT USAGE ON *.* TO")." $df IDENTIFIED BY ".(min_version(8)?"":"PASSWORD ").q($Xf));$l=!$vb;}elseif($Xf!=$of)queries("SET PASSWORD FOR $df = ".q($Xf));}if(!$l){$Lg=array();foreach($bf
as$jf=>$ed){if(isset($_GET["grant"]))$ed=array_filter($ed);$ed=array_keys($ed);if(isset($_GET["grant"]))$Lg=array_diff(array_keys(array_filter($bf[$jf],'strlen')),$ed);elseif($pf==$df){$mf=array_keys((array)$fd[$jf]);$Lg=array_diff($mf,$ed);$ed=array_diff($ed,$mf);unset($fd[$jf]);}if(preg_match('~^(.+)\s*(\(.*\))?$~U',$jf,$B)&&(!grant("REVOKE",$Lg,$B[2]," ON $B[1] FROM $df")||!grant("GRANT",$ed,$B[2]," ON $B[1] TO $df"))){$l=true;break;}}}if(!$l&&isset($_GET["host"])){if($pf!=$df)queries("DROP USER $pf");elseif(!isset($_GET["grant"])){foreach($fd
as$jf=>$Lg){if(preg_match('~^(.+)(\(.*\))?$~U',$jf,$B))grant("REVOKE",array_keys($Lg),$B[2]," ON $B[1] FROM $df");}}}queries_redirect(ME."privileges=",(isset($_GET["host"])?lang(236):lang(237)),!$l);if($vb)connection()->query("DROP USER $df");}}page_header((isset($_GET["host"])?lang(24).": ".h("$ea@$_GET[host]"):lang(147)),$l,array("privileges"=>array('',lang(60))));$M=$_POST;if($M)$fd=$bf;else{$M=$_GET+array("host"=>get_val("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', -1)"));$M["pass"]=$of;if($of!="")$M["hashed"]=true;$fd[(DB==""||$fd?"":idf_escape(addcslashes(DB,"%_\\"))).".*"]=array();}echo'<form action="" method="post">
<table class="layout">
<tr><th>',lang(23),'<td><input name="host" data-maxlength="60" value="',h($M["host"]),'" autocapitalize="off">
<tr><th>',lang(24),'<td><input name="user" data-maxlength="80" value="',h($M["user"]),'" autocapitalize="off">
<tr><th>',lang(25),'<td><input name="pass" id="pass" value="',h($M["pass"]),'" autocomplete="new-password">
',($M["hashed"]?"":script("typePassword(qs('#pass'));")),(min_version(8)?"":checkbox("hashed",1,$M["hashed"],lang(238),"typePassword(this.form['pass'], this.checked);")),'</table>

',"<table class='odds'>\n","<thead><tr><th colspan='2'>".lang(60).doc_link(array('sql'=>"grant.html#priv_level"));$t=0;foreach($fd
as$jf=>$ed){echo'<th>'.($jf!="*.*"?"<input name='objects[$t]' value='".h($jf)."' size='10' autocapitalize='off'>":input_hidden("objects[$t]","*.*")."*.*");$t++;}echo"</thead>\n";foreach(array(""=>"","Server Admin"=>lang(23),"Databases"=>lang(26),"Tables"=>lang(130),"Columns"=>lang(37),"Procedures"=>lang(239),)as$qb=>$Ob){foreach((array)$rg[$qb]as$qg=>$hb){echo"<tr><td".($Ob?">$Ob<td":" colspan='2'").' lang="en" title="'.h($hb).'">'.h($qg);$t=0;foreach($fd
as$jf=>$ed){$D="'grants[$t][".h(strtoupper($qg))."]'";$Y=$ed[strtoupper($qg)];if($qb=="Server Admin"&&$jf!=(isset($fd["*.*"])?"*.*":".*"))echo"<td>";elseif(isset($_GET["grant"]))echo"<td><select name=$D><option><option value='1'".($Y?" selected":"").">".lang(240)."<option value='0'".($Y=="0"?" selected":"").">".lang(241)."</select>";else
echo"<td align='center'><label class='block'>","<input type='checkbox' name=$D value='1'".($Y?" checked":"").($qg=="All privileges"?" id='grants-$t-all'>":">".($qg=="Grant option"?"":script("qsl('input').onclick = function () { if (this.checked) formUncheck('grants-$t-all'); };"))),"</label>";$t++;}}}echo"</table>\n",'<p>
<input type="submit" value="',lang(14),'">
';if(isset($_GET["host"]))echo'<input type="submit" name="drop" value="',lang(125),'">',confirm(lang(177,"$ea@$_GET[host]"));echo
input_token(),'</form>
';}elseif(isset($_GET["processlist"])){if(support("kill")){if($_POST&&!$l){$he=0;foreach((array)$_POST["kill"]as$X){if(adminer()->killProcess($X))$he++;}queries_redirect(ME."processlist=",lang(242,$he),$he||!$_POST["kill"]);}}page_header(lang(114),$l);echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap checkable odds">
',script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});");$t=-1;foreach(adminer()->processList()as$t=>$M){if(!$t){echo"<thead><tr lang='en'>".(support("kill")?"<th>":"");foreach($M
as$y=>$X)echo"<th>$y".doc_link(array('sql'=>"show-processlist.html#processlist_".strtolower($y),));echo"</thead>\n";}echo"<tr>".(support("kill")?"<td>".checkbox("kill[]",$M[JUSH=="sql"?"Id":"pid"],0):"");foreach($M
as$y=>$X)echo"<td>".((JUSH=="sql"&&$y=="Info"&&preg_match("~Query|Killed~",$M["Command"])&&$X!="")||(JUSH=="pgsql"&&$y=="current_query"&&$X!="<IDLE>")||(JUSH=="oracle"&&$y=="sql_text"&&$X!="")?"<code class='jush-".JUSH."'>".shorten_utf8($X,100,"</code>").' <a href="'.h(ME.($M["db"]!=""?"db=".urlencode($M["db"])."&":"")."sql=".urlencode($X)).'">'.lang(243).'</a>':h($X));echo"\n";}echo'</table>
</div>
<p>
';if(support("kill"))echo($t+1)."/".lang(244,max_connections()),"<p><input type='submit' value='".lang(245)."'>\n";echo
input_token(),'</form>
',script("tableCheck();");}elseif(isset($_GET["select"])){$a=$_GET["select"];$S=table_status1($a);$x=indexes($a);$n=fields($a);$Vc=column_foreign_keys($a);$lf=$S["Oid"];$ka=get_settings("adminer_import");$Mg=array();$d=array();$Xg=array();$_f=array();$Uh="";foreach($n
as$y=>$m){$D=adminer()->fieldName($m);$Ze=html_entity_decode(strip_tags($D),ENT_QUOTES);if(isset($m["privileges"]["select"])&&$D!=""){$d[$y]=$Ze;if(is_shortable($m))$Uh=adminer()->selectLengthProcess();}if(isset($m["privileges"]["where"])&&$D!="")$Xg[$y]=$Ze;if(isset($m["privileges"]["order"])&&$D!="")$_f[$y]=$Ze;$Mg+=$m["privileges"];}list($O,$s)=adminer()->selectColumnsProcess($d,$x);$O=array_unique($O);$s=array_unique($s);$Xd=count($s)<count($O);$Z=adminer()->selectSearchProcess($n,$x);$zf=adminer()->selectOrderProcess($n,$x);$z=adminer()->selectLimitProcess();if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$ui=>$M){$ua=convert_field($n[key($M)]);$O=array($ua?:idf_escape(key($M)));$Z[]=where_check($ui,$n);$L=driver()->select($a,$O,$Z,$O);if($L)echo
first($L->fetch_row());}exit;}$ng=$wi=array();foreach($x
as$w){if($w["type"]=="PRIMARY"){$ng=array_flip($w["columns"]);$wi=($O?$ng:array());foreach($wi
as$y=>$X){if(in_array(idf_escape($y),$O))unset($wi[$y]);}break;}}if($lf&&!$ng){$ng=$wi=array($lf=>0);$x[]=array("type"=>"PRIMARY","columns"=>array($lf));}if($_POST&&!$l){$Ri=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$Va=array();foreach($_POST["check"]as$Sa)$Va[]=where_check($Sa,$n);$Ri[]="((".implode(") OR (",$Va)."))";}$Ri=($Ri?"\nWHERE ".implode(" AND ",$Ri):"");if($_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers($a);adminer()->dumpTable($a,"");$Zc=($O?implode(", ",$O):"*").convert_fields($d,$n,$O)."\nFROM ".table($a);$hd=($s&&$Xd?"\nGROUP BY ".implode(", ",$s):"").($zf?"\nORDER BY ".implode(", ",$zf):"");$J="SELECT $Zc$Ri$hd";if(is_array($_POST["check"])&&!$ng){$si=array();foreach($_POST["check"]as$X)$si[]="(SELECT".limit($Zc,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$n).$hd,1).")";$J=implode(" UNION ALL ",$si);}adminer()->dumpData($a,"table",$J);adminer()->dumpFooter();exit;}if(!adminer()->selectEmailProcess($Z,$Vc)){if($_POST["save"]||$_POST["delete"]){$K=true;$la=0;$Q=array();if(!$_POST["delete"]){foreach($_POST["fields"]as$D=>$X){$X=process_input($n[$D]);if($X!==null&&($_POST["clone"]||$X!==false))$Q[idf_escape($D)]=($X!==false?$X:idf_escape($D));}}if($_POST["delete"]||$Q){$J=($_POST["clone"]?"INTO ".table($a)." (".implode(", ",array_keys($Q)).")\nSELECT ".implode(", ",$Q)."\nFROM ".table($a):"");if($_POST["all"]||($ng&&is_array($_POST["check"]))||$Xd){$K=($_POST["delete"]?driver()->delete($a,$Ri):($_POST["clone"]?queries("INSERT $J$Ri".driver()->insertReturning($a)):driver()->update($a,$Q,$Ri)));$la=connection()->affected_rows;if(is_object($K))$la+=$K->num_rows;}else{foreach((array)$_POST["check"]as$X){$Qi="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$n);$K=($_POST["delete"]?driver()->delete($a,$Qi,1):($_POST["clone"]?queries("INSERT".limit1($a,$J,$Qi)):driver()->update($a,$Q,$Qi,1)));if(!$K)break;$la+=connection()->affected_rows;}}}$C=lang(246,$la);if($_POST["clone"]&&$K&&$la==1){$ne=last_id($K);if($ne)$C=lang(170," $ne");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$C,$K);if(!$_POST["delete"]){$jg=(array)$_POST["fields"];edit_form($a,array_intersect_key($n,$jg),$jg,!$_POST["clone"],$l);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])$l=lang(247);else{$K=true;$la=0;foreach($_POST["val"]as$ui=>$M){$Q=array();foreach($M
as$y=>$X){$y=bracket_escape($y,true);$Q[idf_escape($y)]=(preg_match('~char|text~',$n[$y]["type"])||$X!=""?adminer()->processInput($n[$y],$X):"NULL");}$K=driver()->update($a,$Q," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($ui,$n),($Xd||$ng?0:1)," ");if(!$K)break;$la+=connection()->affected_rows;}queries_redirect(remove_from_uri(),lang(246,$la),$K);}}elseif(!is_string($Mc=get_file("csv_file",true)))$l=upload_error($Mc);elseif(!preg_match('~~u',$Mc))$l=lang(248);else{save_settings(array("output"=>$ka["output"],"format"=>$_POST["separator"]),"adminer_import");$K=true;$eb=array_keys($n);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$Mc,$Be);$la=count($Be[0]);driver()->begin();$dh=($_POST["separator"]=="csv"?",":($_POST["separator"]=="tsv"?"\t":";"));$N=array();foreach($Be[0]as$y=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$dh]*)$dh~",$X.$dh,$Ce);if(!$y&&!array_diff($Ce[1],$eb)){$eb=$Ce[1];$la--;}else{$Q=array();foreach($Ce[1]as$t=>$bb)$Q[idf_escape($eb[$t])]=($bb==""&&$n[$eb[$t]]["null"]?"NULL":q(preg_match('~^".*"$~s',$bb)?str_replace('""','"',substr($bb,1,-1)):$bb));$N[]=$Q;}}$K=(!$N||driver()->insertUpdate($a,$N,$ng));if($K)driver()->commit();queries_redirect(remove_from_uri("page"),lang(249,$la),$K);driver()->rollback();}}}$Hh=adminer()->tableName($S);if(is_ajax()){page_headers();ob_start();}else
page_header(lang(42).": $Hh",$l);$Q=null;if(isset($Mg["insert"])||!support("table")){$Of=array();foreach((array)$_GET["where"]as$X){if(isset($Vc[$X["col"]])&&count($Vc[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&(is_array($X["val"])||!preg_match('~[_%]~',$X["val"])))))$Of["set"."[".bracket_escape($X["col"])."]"]=$X["val"];}$Q=$Of?"&".http_build_query($Of):"";}adminer()->selectLinks($S,$Q);if(!$d&&support("table"))echo"<p class='error'>".lang(250).($n?".":": ".error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();echo(DB!=""?input_hidden("db",DB).(isset($_GET["ns"])?input_hidden("ns",$_GET["ns"]):""):""),input_hidden("select",$a),"</div>\n";adminer()->selectColumnsPrint($O,$d);adminer()->selectSearchPrint($Z,$Xg,$x);adminer()->selectOrderPrint($zf,$_f,$x);adminer()->selectLimitPrint($z);adminer()->selectLengthPrint($Uh);adminer()->selectActionPrint($x);echo"</form>\n";$F=$_GET["page"];$Yc=null;if($F=="last"){$Yc=get_val(count_rows($a,$Z,$Xd,$s));$F=floor(max(0,intval($Yc)-1)/$z);}$Yg=$O;$gd=$s;if(!$Yg){$Yg[]="*";$rb=convert_fields($d,$n,$O);if($rb)$Yg[]=substr($rb,2);}foreach($O
as$y=>$X){$m=$n[idf_unescape($X)];if($m&&($ua=convert_field($m)))$Yg[$y]="$ua AS $X";}if(!$Xd&&$wi){foreach($wi
as$y=>$X){$Yg[]=idf_escape($y);if($gd)$gd[]=idf_escape($y);}}$K=driver()->select($a,$Yg,$Z,$gd,$zf,$z,$F,true);if(!$K)echo"<p class='error'>".error()."\n";else{if(JUSH=="mssql"&&$F)$K->seek($z*$F);$jc=array();echo"<form action='' method='post' enctype='multipart/form-data'>\n";$N=array();while($M=$K->fetch_assoc()){if($F&&JUSH=="oracle")unset($M["RNUM"]);$N[]=$M;}if($_GET["page"]!="last"&&$z&&$s&&$Xd&&JUSH=="sql")$Yc=get_val(" SELECT FOUND_ROWS()");if(!$N)echo"<p class='message'>".lang(12)."\n";else{$Ca=adminer()->backwardKeys($a,$Hh);echo"<div class='scrollable'>","<table id='table' class='nowrap checkable odds'>",script("mixin(qs('#table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true), onkeydown: editingKeydown});"),"<thead><tr>".(!$s&&$O?"":"<td><input type='checkbox' id='all-page' class='jsonly'>".script("qs('#all-page').onclick = partial(formCheck, /check/);","")." <a href='".h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."'>".lang(251)."</a>");$af=array();$bd=array();reset($O);$zg=1;foreach($N[0]as$y=>$X){if(!isset($wi[$y])){$X=idx($_GET["columns"],key($O))?:array();$m=$n[$O?($X?$X["col"]:current($O)):$y];$D=($m?adminer()->fieldName($m,$zg):($X["fun"]?"*":h($y)));if($D!=""){$zg++;$af[$y]=$D;$c=idf_escape($y);$wd=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($y);$Ob="&desc%5B0%5D=1";echo"<th id='th[".h(bracket_escape($y))."]'>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});","");$ad=apply_sql_function($X["fun"],$D);$nh=isset($m["privileges"]["order"])||$ad;echo($nh?"<a href='".h($wd.($zf[0]==$c||$zf[0]==$y?$Ob:''))."'>$ad</a>":$ad),"<span class='column hidden'>";if($nh)echo"<a href='".h($wd.$Ob)."' title='".lang(48)."' class='text'> ↓</a>";if(!$X["fun"]&&isset($m["privileges"]["where"]))echo'<a href="#fieldset-search" title="'.lang(45).'" class="text jsonly"> =</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($y)."');");echo"</span>";}$bd[$y]=$X["fun"];next($O);}}$te=array();if($_GET["modify"]){foreach($N
as$M){foreach($M
as$y=>$X)$te[$y]=max($te[$y],min(40,strlen(utf8_decode($X))));}}echo($Ca?"<th>".lang(252):"")."</thead>\n";if(is_ajax())ob_end_clean();foreach(adminer()->rowDescriptions($N,$Vc)as$Ye=>$M){$ti=unique_array($N[$Ye],$x);if(!$ti){$ti=array();reset($O);foreach($N[$Ye]as$y=>$X){if(!preg_match('~^(COUNT|AVG|GROUP_CONCAT|MAX|MIN|SUM)\(~',current($O)))$ti[$y]=$X;next($O);}}$ui="";foreach($ti
as$y=>$X){$m=(array)$n[$y];if((JUSH=="sql"||JUSH=="pgsql")&&preg_match('~char|text|enum|set~',$m["type"])&&strlen($X)>64){$y=(strpos($y,'(')?$y:idf_escape($y));$y="MD5(".(JUSH!='sql'||preg_match("~^utf8~",$m["collation"])?$y:"CONVERT($y USING ".charset(connection()).")").")";$X=md5($X);}$ui
.="&".($X!==null?urlencode("where[".bracket_escape($y)."]")."=".urlencode($X===false?"f":$X):"null%5B%5D=".urlencode($y));}echo"<tr>".(!$s&&$O?"":"<td>".checkbox("check[]",substr($ui,1),in_array(substr($ui,1),(array)$_POST["check"])).($Xd||information_schema(DB)?"":" <a href='".h(ME."edit=".urlencode($a).$ui)."' class='edit'>".lang(253)."</a>"));reset($O);foreach($M
as$y=>$X){if(isset($af[$y])){$c=current($O);$m=(array)$n[$y];$X=driver()->value($X,$m);if($X!=""&&(!isset($jc[$y])||$jc[$y]!=""))$jc[$y]=(is_mail($X)?$af[$y]:"");$_="";if(is_blob($m)&&$X!="")$_=ME.'download='.urlencode($a).'&field='.urlencode($y).$ui;if(!$_&&$X!==null){foreach((array)$Vc[$y]as$p){if(count($Vc[$y])==1||end($p["source"])==$y){$_="";foreach($p["source"]as$t=>$oh)$_
.=where_link($t,$p["target"][$t],$N[$Ye][$oh]);$_=($p["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($p["db"]),ME):ME).'select='.urlencode($p["table"]).$_;if($p["ns"])$_=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($p["ns"]),$_);if(count($p["source"])==1)break;}}}if($c=="COUNT(*)"){$_=ME."select=".urlencode($a);$t=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$ti))$_
.=where_link($t++,$W["col"],$W["val"],$W["op"]);}foreach($ti
as$ee=>$W)$_
.=where_link($t++,$ee,$W);}$xd=select_value($X,$_,$m,$Uh);$u=h("val[$ui][".bracket_escape($y)."]");$kg=idx(idx($_POST["val"],$ui),bracket_escape($y));$ec=!is_array($M[$y])&&is_utf8($xd)&&$N[$Ye][$y]==$M[$y]&&!$bd[$y]&&!$m["generated"];$U=(preg_match('~^(AVG|MIN|MAX)\((.+)\)~',$c,$B)?$n[idf_unescape($B[2])]["type"]:$m["type"]);$Th=preg_match('~text|json|lob~',$U);$Yd=preg_match(number_type(),$U)||preg_match('~^(CHAR_LENGTH|ROUND|FLOOR|CEIL|TIME_TO_SEC|COUNT|SUM)\(~',$c);echo"<td id='$u'".($Yd&&($X===null||is_numeric(strip_tags($xd))||$U=="money")?" class='number'":"");if(($_GET["modify"]&&$ec&&$X!==null)||$kg!==null){$kd=h($kg!==null?$kg:$M[$y]);echo">".($Th?"<textarea name='$u' cols='30' rows='".(substr_count($M[$y],"\n")+1)."'>$kd</textarea>":"<input name='$u' value='$kd' size='$te[$y]'>");}else{$ye=strpos($xd,"<i>…</i>");echo" data-text='".($ye?2:($Th?1:0))."'".($ec?"":" data-warning='".h(lang(254))."'").">$xd";}}next($O);}if($Ca)echo"<td>";adminer()->backwardKeysPrint($Ca,$N[$Ye]);echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n","</div>\n";}if(!is_ajax()){if($N||$F){$xc=true;if($_GET["page"]!="last"){if(!$z||(count($N)<$z&&($N||!$F)))$Yc=($F?$F*$z:0)+count($N);elseif(JUSH!="sql"||!$Xd){$Yc=($Xd?false:found_rows($S,$Z));if(intval($Yc)<max(1e4,2*($F+1)*$z))$Yc=first(slow_query(count_rows($a,$Z,$Xd,$s)));else$xc=false;}}$Mf=($z&&($Yc===false||$Yc>$z||$F));if($Mf)echo(($Yc===false?count($N)+1:$Yc-$F*$z)>$z?'<p><a href="'.h(remove_from_uri("page")."&page=".($F+1)).'" class="loadmore">'.lang(255).'</a>'.script("qsl('a').onclick = partial(selectLoadMore, $z, '".lang(256)."…');",""):''),"\n";echo"<div class='footer'><div>\n";if($Mf){$Ge=($Yc===false?$F+(count($N)>=$z?2:1):floor(($Yc-1)/$z));echo"<fieldset>";if(JUSH!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".lang(257)."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".lang(257)."', '".($F+1)."')); return false; };"),pagination(0,$F).($F>5?" …":"");for($t=max(1,$F-4);$t<min($Ge,$F+5);$t++)echo
pagination($t,$F);if($Ge>0)echo($F+5<$Ge?" …":""),($xc&&$Yc!==false?pagination($Ge,$F):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$Ge'>".lang(258)."</a>");}else
echo"<legend>".lang(257)."</legend>",pagination(0,$F).($F>1?" …":""),($F?pagination($F,$F):""),($Ge>$F?pagination($F+1,$F).($Ge>$F+1?" …":""):"");echo"</fieldset>\n";}echo"<fieldset>","<legend>".lang(259)."</legend>";$Vb=($xc?"":"~ ").$Yc;$tf="const checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$Vb' : checked); selectCount('selected2', this.checked || !checked ? '$Vb' : checked);";echo
checkbox("all",1,0,($Yc!==false?($xc?"":"~ ").lang(151,$Yc):""),$tf)."\n","</fieldset>\n";if(adminer()->selectCommandPrint())echo'<fieldset',($_GET["modify"]?'':' class="jsonly"'),'><legend>',lang(251),'</legend><div>
<input type="submit" value="',lang(14),'"',($_GET["modify"]?'':' title="'.lang(247).'"'),'>
</div></fieldset>
<fieldset><legend>',lang(124),' <span id="selected"></span></legend><div>
<input type="submit" name="edit" value="',lang(10),'">
<input type="submit" name="clone" value="',lang(243),'">
<input type="submit" name="delete" value="',lang(18),'">',confirm(),'</div></fieldset>
';$Wc=adminer()->dumpFormat();foreach((array)$_GET["columns"]as$c){if($c["fun"]){unset($Wc['sql']);break;}}if($Wc){print_fieldset("export",lang(65)." <span id='selected2'></span>");$Kf=adminer()->dumpOutput();echo($Kf?html_select("output",$Kf,$ka["output"])." ":""),html_select("format",$Wc,$ka["format"])," <input type='submit' name='export' value='".lang(65)."'>\n","</div></fieldset>\n";}adminer()->selectEmailPrint(array_filter($jc,'strlen'),$d);echo"</div></div>\n";}if(adminer()->selectImportPrint())echo"<p>","<a href='#import'>".lang(64)."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"<span id='import'".($_POST["import"]?"":" class='hidden'").">: ","<input type='file' name='csv_file'> ",html_select("separator",array("csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"),$ka["format"])," <input type='submit' name='import' value='".lang(64)."'>","</span>";echo
input_token(),"</form>\n",(!$s&&$O?"":script("tableCheck();"));}}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["variables"])){$wh=isset($_GET["status"]);page_header($wh?lang(116):lang(115));$Hi=($wh?show_status():show_variables());if(!$Hi)echo"<p class='message'>".lang(12)."\n";else{echo"<table>\n";foreach($Hi
as$M){echo"<tr>";$y=array_shift($M);echo"<th><code class='jush-".JUSH.($wh?"status":"set")."'>".h($y)."</code>";foreach($M
as$X)echo"<td>".nl_br(h($X));}echo"</table>\n";}}elseif(isset($_GET["script"])){header("Content-Type: text/javascript; charset=utf-8");if($_GET["script"]=="db"){$Eh=array("Data_length"=>0,"Index_length"=>0,"Data_free"=>0);foreach(table_status()as$D=>$S){json_row("Comment-$D",h($S["Comment"]));if(!is_view($S)||preg_match('~materialized~i',$S["Engine"])){foreach(array("Engine","Collation")as$y)json_row("$y-$D",h($S[$y]));foreach($Eh+array("Auto_increment"=>0,"Rows"=>0)as$y=>$X){if($S[$y]!=""){$X=format_number($S[$y]);if($X>=0)json_row("$y-$D",($y=="Rows"&&$X&&$S["Engine"]==(JUSH=="pgsql"?"table":"InnoDB")?"~ $X":$X));if(isset($Eh[$y]))$Eh[$y]+=($S["Engine"]!="InnoDB"||$y!="Data_free"?$S[$y]:0);}elseif(array_key_exists($y,$S))json_row("$y-$D","?");}}}foreach($Eh
as$y=>$X)json_row("sum-$y",format_number($X));json_row("");}elseif($_GET["script"]=="kill")connection()->query("KILL ".number($_POST["kill"]));else{foreach(count_tables(adminer()->databases())as$j=>$X){json_row("tables-$j",$X);json_row("size-$j",db_size($j));}json_row("");}exit;}else{$Nh=array_merge((array)$_POST["tables"],(array)$_POST["views"]);if($Nh&&!$l&&!$_POST["search"]){$K=true;$C="";if(JUSH=="sql"&&$_POST["tables"]&&count($_POST["tables"])>1&&($_POST["drop"]||$_POST["truncate"]||$_POST["copy"]))queries("SET foreign_key_checks = 0");if($_POST["truncate"]){if($_POST["tables"])$K=truncate_tables($_POST["tables"]);$C=lang(260);}elseif($_POST["move"]){$K=move_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$C=lang(261);}elseif($_POST["copy"]){$K=copy_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$C=lang(262);}elseif($_POST["drop"]){if($_POST["views"])$K=drop_views($_POST["views"]);if($K&&$_POST["tables"])$K=drop_tables($_POST["tables"]);$C=lang(263);}elseif(JUSH=="sqlite"&&$_POST["check"]){foreach((array)$_POST["tables"]as$R){foreach(get_rows("PRAGMA integrity_check(".q($R).")")as$M)$C
.="<b>".h($R)."</b>: ".h($M["integrity_check"])."<br>";}}elseif(JUSH!="sql"){$K=(JUSH=="sqlite"?queries("VACUUM"):apply_queries("VACUUM".($_POST["optimize"]?"":" ANALYZE"),$_POST["tables"]));$C=lang(264);}elseif(!$_POST["tables"])$C=lang(9);elseif($K=queries(($_POST["optimize"]?"OPTIMIZE":($_POST["check"]?"CHECK":($_POST["repair"]?"REPAIR":"ANALYZE")))." TABLE ".implode(", ",array_map('Adminer\idf_escape',$_POST["tables"])))){while($M=$K->fetch_assoc())$C
.="<b>".h($M["Table"])."</b>: ".h($M["Msg_text"])."<br>";}queries_redirect(substr(ME,0,-1),$C,$K);}page_header(($_GET["ns"]==""?lang(26).": ".h(DB):lang(265).": ".h($_GET["ns"])),$l,true);if(adminer()->homepage()){if($_GET["ns"]!==""){echo"<h3 id='tables-views'>".lang(266)."</h3>\n";$Mh=tables_list();if(!$Mh)echo"<p class='message'>".lang(9)."\n";else{echo"<form action='' method='post'>\n";if(support("table")){echo"<fieldset><legend>".lang(267)." <span id='selected2'></span></legend><div>",html_select("op",adminer()->operators(),idx($_POST,"op",JUSH=="elastic"?"should":"LIKE %%"))," <input type='search' name='query' value='".h($_POST["query"])."'>",script("qsl('input').onkeydown = partialArg(bodyKeydown, 'search');","")," <input type='submit' name='search' value='".lang(45)."'>\n","</div></fieldset>\n";if($_POST["search"]&&$_POST["query"]!=""){$_GET["where"][0]["op"]=$_POST["op"];search_tables();}}echo"<div class='scrollable'>\n","<table class='nowrap checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td><input id="check-all" type="checkbox" class="jsonly">'.script("qs('#check-all').onclick = partial(formCheck, /^(tables|views)\[/);",""),'<th>'.lang(130),'<td>'.lang(268).doc_link(array('sql'=>'storage-engines.html')),'<td>'.lang(120).doc_link(array('sql'=>'charset-charsets.html','mariadb'=>'supported-character-sets-and-collations/')),'<td>'.lang(269).doc_link(array('sql'=>'show-table-status.html',)),'<td>'.lang(270).doc_link(array('sql'=>'show-table-status.html',)),'<td>'.lang(271).doc_link(array('sql'=>'show-table-status.html')),'<td>'.lang(40).doc_link(array('sql'=>'example-auto-increment.html','mariadb'=>'auto_increment/')),'<td>'.lang(272).doc_link(array('sql'=>'show-table-status.html',)),(support("comment")?'<td>'.lang(39).doc_link(array('sql'=>'show-table-status.html',)):''),"</thead>\n";$T=0;foreach($Mh
as$D=>$U){$Ki=($U!==null&&!preg_match('~table|sequence~i',$U));$u=h("Table-".$D);echo'<tr><td>'.checkbox(($Ki?"views[]":"tables[]"),$D,in_array("$D",$Nh,true),"","","",$u),'<th>'.(support("table")||support("indexes")?"<a href='".h(ME)."table=".urlencode($D)."' title='".lang(31)."' id='$u'>".h($D).'</a>':h($D));if($Ki&&!preg_match('~materialized~i',$U)){$Yh=lang(129);echo'<td colspan="6">'.(support("view")?"<a href='".h(ME)."view=".urlencode($D)."' title='".lang(33)."'>$Yh</a>":$Yh),'<td align="right"><a href="'.h(ME)."select=".urlencode($D).'" title="'.lang(30).'">?</a>';}else{foreach(array("Engine"=>array(),"Collation"=>array(),"Data_length"=>array("create",lang(32)),"Index_length"=>array("indexes",lang(133)),"Data_free"=>array("edit",lang(34)),"Auto_increment"=>array("auto_increment=1&create",lang(32)),"Rows"=>array("select",lang(30)),)as$y=>$_){$u=" id='$y-".h($D)."'";echo($_?"<td align='right'>".(support("table")||$y=="Rows"||(support("indexes")&&$y!="Data_length")?"<a href='".h(ME."$_[0]=").urlencode($D)."'$u title='$_[1]'>?</a>":"<span$u>?</span>"):"<td id='$y-".h($D)."'>");}$T++;}echo(support("comment")?"<td id='Comment-".h($D)."'>":""),"\n";}echo"<tr><td><th>".lang(244,count($Mh)),"<td>".h(JUSH=="sql"?get_val("SELECT @@default_storage_engine"):""),"<td>".h(db_collation(DB,collations()));foreach(array("Data_length","Index_length","Data_free")as$y)echo"<td align='right' id='sum-$y'>";echo"\n","</table>\n",script("ajaxSetHtml('".js_escape(ME)."script=db');"),"</div>\n";if(!information_schema(DB)){echo"<div class='footer'><div>\n";$Fi="<input type='submit' value='".lang(273)."'> ".on_help("'VACUUM'");$wf="<input type='submit' name='optimize' value='".lang(274)."'> ".on_help(JUSH=="sql"?"'OPTIMIZE TABLE'":"'VACUUM OPTIMIZE'");echo"<fieldset><legend>".lang(124)." <span id='selected'></span></legend><div>".(JUSH=="sqlite"?$Fi."<input type='submit' name='check' value='".lang(275)."'> ".on_help("'PRAGMA integrity_check'"):(JUSH=="pgsql"?$Fi.$wf:(JUSH=="sql"?"<input type='submit' value='".lang(276)."'> ".on_help("'ANALYZE TABLE'").$wf."<input type='submit' name='check' value='".lang(275)."'> ".on_help("'CHECK TABLE'")."<input type='submit' name='repair' value='".lang(277)."'> ".on_help("'REPAIR TABLE'"):"")))."<input type='submit' name='truncate' value='".lang(278)."'> ".on_help(JUSH=="sqlite"?"'DELETE'":"'TRUNCATE".(JUSH=="pgsql"?"'":" TABLE'")).confirm()."<input type='submit' name='drop' value='".lang(125)."'>".on_help("'DROP TABLE'").confirm()."\n";$i=(support("scheme")?adminer()->schemas():adminer()->databases());echo"</div></fieldset>\n";$Wg="";if(count($i)!=1&&JUSH!="sqlite"){echo"<fieldset><legend>".lang(279)." <span id='selected3'></span></legend><div>";$j=(isset($_POST["target"])?$_POST["target"]:(support("scheme")?$_GET["ns"]:DB));echo($i?html_select("target",$i,$j):'<input name="target" value="'.h($j).'" autocapitalize="off">'),"</label> <input type='submit' name='move' value='".lang(280)."'>",(support("copy")?" <input type='submit' name='copy' value='".lang(281)."'> ".checkbox("overwrite",1,$_POST["overwrite"],lang(282)):""),"</div></fieldset>\n";$Wg=" selectCount('selected3', formChecked(this, /^(tables|views)\[/));";}echo"<input type='hidden' name='all' value=''>",script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^(tables|views)\[/));".(support("table")?" selectCount('selected2', formChecked(this, /^tables\[/) || $T);":"")."$Wg }"),input_token(),"</div></div>\n";}echo"</form>\n",script("tableCheck();");}echo"<p class='links'><a href='".h(ME)."create='>".lang(66)."</a>\n",(support("view")?"<a href='".h(ME)."view='>".lang(206)."</a>\n":"");if(support("routine")){echo"<h3 id='routines'>".lang(61)."</h3>\n";$Qg=routines();if($Qg){echo"<table class='odds'>\n",'<thead><tr><th>'.lang(187).'<td>'.lang(38).'<td>'.lang(223)."<td></thead>\n";foreach($Qg
as$M){$D=($M["SPECIFIC_NAME"]==$M["ROUTINE_NAME"]?"":"&name=".urlencode($M["ROUTINE_NAME"]));echo'<tr>','<th><a href="'.h(ME.($M["ROUTINE_TYPE"]!="PROCEDURE"?'callf=':'call=').urlencode($M["SPECIFIC_NAME"]).$D).'">'.h($M["ROUTINE_NAME"]).'</a>','<td>'.h($M["ROUTINE_TYPE"]),'<td>'.h($M["DTD_IDENTIFIER"]),'<td><a href="'.h(ME.($M["ROUTINE_TYPE"]!="PROCEDURE"?'function=':'procedure=').urlencode($M["SPECIFIC_NAME"]).$D).'">'.lang(136)."</a>";}echo"</table>\n";}echo'<p class="links">'.(support("procedure")?'<a href="'.h(ME).'procedure=">'.lang(222).'</a>':'').'<a href="'.h(ME).'function=">'.lang(221)."</a>\n";}if(support("event")){echo"<h3 id='events'>".lang(63)."</h3>\n";$N=get_rows("SHOW EVENTS");if($N){echo"<table>\n","<thead><tr><th>".lang(187)."<td>".lang(283)."<td>".lang(212)."<td>".lang(213)."<td></thead>\n";foreach($N
as$M)echo"<tr>","<th>".h($M["Name"]),"<td>".($M["Execute at"]?lang(284)."<td>".$M["Execute at"]:lang(214)." ".$M["Interval value"]." ".$M["Interval field"]."<td>$M[Starts]"),"<td>$M[Ends]",'<td><a href="'.h(ME).'event='.urlencode($M["Name"]).'">'.lang(136).'</a>';echo"</table>\n";$vc=get_val("SELECT @@event_scheduler");if($vc&&$vc!="ON")echo"<p class='error'><code class='jush-sqlset'>event_scheduler</code>: ".h($vc)."\n";}echo'<p class="links"><a href="'.h(ME).'event=">'.lang(211)."</a>\n";}}}}page_footer();